/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import java.util.Properties;
import java.util.UUID;
import org.apache.spark.ExceptionFailure;
import org.apache.spark.ExceptionFailure$;
import org.apache.spark.ExecutorLostFailure;
import org.apache.spark.ExecutorLostFailure$;
import org.apache.spark.FetchFailed;
import org.apache.spark.FetchFailed$;
import org.apache.spark.InternalAccumulator$;
import org.apache.spark.Resubmitted$;
import org.apache.spark.Success$;
import org.apache.spark.TaskCommitDenied;
import org.apache.spark.TaskCommitDenied$;
import org.apache.spark.TaskEndReason;
import org.apache.spark.TaskKilled$;
import org.apache.spark.TaskResultLost$;
import org.apache.spark.ThrowableSerializationWrapper;
import org.apache.spark.UnknownReason$;
import org.apache.spark.executor.InputMetrics;
import org.apache.spark.executor.OutputMetrics;
import org.apache.spark.executor.ShuffleWriteMetrics;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.executor.TaskMetrics$;
import org.apache.spark.executor.TempShuffleReadMetrics;
import org.apache.spark.package$;
import org.apache.spark.rdd.RDDOperationScope;
import org.apache.spark.rdd.RDDOperationScope$;
import org.apache.spark.scheduler.AccumulableInfo;
import org.apache.spark.scheduler.JobFailed;
import org.apache.spark.scheduler.JobFailed$;
import org.apache.spark.scheduler.JobResult;
import org.apache.spark.scheduler.JobSucceeded$;
import org.apache.spark.scheduler.SparkListenerApplicationEnd;
import org.apache.spark.scheduler.SparkListenerApplicationEnd$;
import org.apache.spark.scheduler.SparkListenerApplicationStart;
import org.apache.spark.scheduler.SparkListenerApplicationStart$;
import org.apache.spark.scheduler.SparkListenerBlockManagerAdded;
import org.apache.spark.scheduler.SparkListenerBlockManagerAdded$;
import org.apache.spark.scheduler.SparkListenerBlockManagerRemoved;
import org.apache.spark.scheduler.SparkListenerBlockManagerRemoved$;
import org.apache.spark.scheduler.SparkListenerBlockUpdated;
import org.apache.spark.scheduler.SparkListenerEnvironmentUpdate;
import org.apache.spark.scheduler.SparkListenerEnvironmentUpdate$;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerExecutorAdded;
import org.apache.spark.scheduler.SparkListenerExecutorAdded$;
import org.apache.spark.scheduler.SparkListenerExecutorMetricsUpdate;
import org.apache.spark.scheduler.SparkListenerExecutorMetricsUpdate$;
import org.apache.spark.scheduler.SparkListenerExecutorRemoved;
import org.apache.spark.scheduler.SparkListenerExecutorRemoved$;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.scheduler.SparkListenerJobEnd$;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.SparkListenerJobStart$;
import org.apache.spark.scheduler.SparkListenerLogStart;
import org.apache.spark.scheduler.SparkListenerLogStart$;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.scheduler.SparkListenerStageCompleted$;
import org.apache.spark.scheduler.SparkListenerStageSubmitted;
import org.apache.spark.scheduler.SparkListenerStageSubmitted$;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import org.apache.spark.scheduler.SparkListenerTaskEnd$;
import org.apache.spark.scheduler.SparkListenerTaskGettingResult;
import org.apache.spark.scheduler.SparkListenerTaskGettingResult$;
import org.apache.spark.scheduler.SparkListenerTaskStart;
import org.apache.spark.scheduler.SparkListenerTaskStart$;
import org.apache.spark.scheduler.SparkListenerUnpersistRDD;
import org.apache.spark.scheduler.SparkListenerUnpersistRDD$;
import org.apache.spark.scheduler.StageInfo;
import org.apache.spark.scheduler.StageInfo$;
import org.apache.spark.scheduler.TaskInfo;
import org.apache.spark.scheduler.TaskLocality$;
import org.apache.spark.scheduler.cluster.ExecutorInfo;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockId$;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockManagerId$;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.RDDInfo;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.AccumulatorV2;
import org.apache.spark.util.Utils$;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import org.json4s.jackson.JsonMethods$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Null$;

public final class JsonProtocol$ {
    public static final JsonProtocol$ MODULE$;
    private final DefaultFormats$ org$apache$spark$util$JsonProtocol$$format;
    private final ObjectMapper mapper;

    static {
        new JsonProtocol$();
    }

    public DefaultFormats$ org$apache$spark$util$JsonProtocol$$format() {
        return this.org$apache$spark$util$JsonProtocol$$format;
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    public JsonAST.JValue sparkEventToJson(SparkListenerEvent event) {
        JsonAST.JValue jValue;
        SparkListenerEvent sparkListenerEvent = event;
        if (sparkListenerEvent instanceof SparkListenerStageSubmitted) {
            SparkListenerStageSubmitted sparkListenerStageSubmitted = (SparkListenerStageSubmitted)sparkListenerEvent;
            jValue = this.stageSubmittedToJson(sparkListenerStageSubmitted);
        } else if (sparkListenerEvent instanceof SparkListenerStageCompleted) {
            SparkListenerStageCompleted sparkListenerStageCompleted = (SparkListenerStageCompleted)sparkListenerEvent;
            jValue = this.stageCompletedToJson(sparkListenerStageCompleted);
        } else if (sparkListenerEvent instanceof SparkListenerTaskStart) {
            SparkListenerTaskStart sparkListenerTaskStart = (SparkListenerTaskStart)sparkListenerEvent;
            jValue = this.taskStartToJson(sparkListenerTaskStart);
        } else if (sparkListenerEvent instanceof SparkListenerTaskGettingResult) {
            SparkListenerTaskGettingResult sparkListenerTaskGettingResult = (SparkListenerTaskGettingResult)sparkListenerEvent;
            jValue = this.taskGettingResultToJson(sparkListenerTaskGettingResult);
        } else if (sparkListenerEvent instanceof SparkListenerTaskEnd) {
            SparkListenerTaskEnd sparkListenerTaskEnd = (SparkListenerTaskEnd)sparkListenerEvent;
            jValue = this.taskEndToJson(sparkListenerTaskEnd);
        } else if (sparkListenerEvent instanceof SparkListenerJobStart) {
            SparkListenerJobStart sparkListenerJobStart = (SparkListenerJobStart)sparkListenerEvent;
            jValue = this.jobStartToJson(sparkListenerJobStart);
        } else if (sparkListenerEvent instanceof SparkListenerJobEnd) {
            SparkListenerJobEnd sparkListenerJobEnd = (SparkListenerJobEnd)sparkListenerEvent;
            jValue = this.jobEndToJson(sparkListenerJobEnd);
        } else if (sparkListenerEvent instanceof SparkListenerEnvironmentUpdate) {
            SparkListenerEnvironmentUpdate sparkListenerEnvironmentUpdate = (SparkListenerEnvironmentUpdate)sparkListenerEvent;
            jValue = this.environmentUpdateToJson(sparkListenerEnvironmentUpdate);
        } else if (sparkListenerEvent instanceof SparkListenerBlockManagerAdded) {
            SparkListenerBlockManagerAdded sparkListenerBlockManagerAdded = (SparkListenerBlockManagerAdded)sparkListenerEvent;
            jValue = this.blockManagerAddedToJson(sparkListenerBlockManagerAdded);
        } else if (sparkListenerEvent instanceof SparkListenerBlockManagerRemoved) {
            SparkListenerBlockManagerRemoved sparkListenerBlockManagerRemoved = (SparkListenerBlockManagerRemoved)sparkListenerEvent;
            jValue = this.blockManagerRemovedToJson(sparkListenerBlockManagerRemoved);
        } else if (sparkListenerEvent instanceof SparkListenerUnpersistRDD) {
            SparkListenerUnpersistRDD sparkListenerUnpersistRDD = (SparkListenerUnpersistRDD)sparkListenerEvent;
            jValue = this.unpersistRDDToJson(sparkListenerUnpersistRDD);
        } else if (sparkListenerEvent instanceof SparkListenerApplicationStart) {
            SparkListenerApplicationStart sparkListenerApplicationStart = (SparkListenerApplicationStart)sparkListenerEvent;
            jValue = this.applicationStartToJson(sparkListenerApplicationStart);
        } else if (sparkListenerEvent instanceof SparkListenerApplicationEnd) {
            SparkListenerApplicationEnd sparkListenerApplicationEnd = (SparkListenerApplicationEnd)sparkListenerEvent;
            jValue = this.applicationEndToJson(sparkListenerApplicationEnd);
        } else if (sparkListenerEvent instanceof SparkListenerExecutorAdded) {
            SparkListenerExecutorAdded sparkListenerExecutorAdded = (SparkListenerExecutorAdded)sparkListenerEvent;
            jValue = this.executorAddedToJson(sparkListenerExecutorAdded);
        } else if (sparkListenerEvent instanceof SparkListenerExecutorRemoved) {
            SparkListenerExecutorRemoved sparkListenerExecutorRemoved = (SparkListenerExecutorRemoved)sparkListenerEvent;
            jValue = this.executorRemovedToJson(sparkListenerExecutorRemoved);
        } else if (sparkListenerEvent instanceof SparkListenerLogStart) {
            SparkListenerLogStart sparkListenerLogStart = (SparkListenerLogStart)sparkListenerEvent;
            jValue = this.logStartToJson(sparkListenerLogStart);
        } else if (sparkListenerEvent instanceof SparkListenerExecutorMetricsUpdate) {
            SparkListenerExecutorMetricsUpdate sparkListenerExecutorMetricsUpdate = (SparkListenerExecutorMetricsUpdate)sparkListenerEvent;
            jValue = this.executorMetricsUpdateToJson(sparkListenerExecutorMetricsUpdate);
        } else {
            if (sparkListenerEvent instanceof SparkListenerBlockUpdated) {
                SparkListenerBlockUpdated sparkListenerBlockUpdated = (SparkListenerBlockUpdated)sparkListenerEvent;
                throw new MatchError((Object)sparkListenerBlockUpdated);
            }
            jValue = JsonMethods$.MODULE$.parse(org.json4s.package$.MODULE$.string2JsonInput(this.mapper().writeValueAsString((Object)event)), JsonMethods$.MODULE$.parse$default$2());
        }
        return jValue;
    }

    public JsonAST.JValue stageSubmittedToJson(SparkListenerStageSubmitted stageSubmitted) {
        JsonAST.JValue stageInfo = this.stageInfoToJson(stageSubmitted.stageInfo());
        JsonAST.JValue properties = this.propertiesToJson(stageSubmitted.properties());
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Event"), (Object)Utils$.MODULE$.getFormattedClassName(stageSubmitted)), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Stage Info"), (Object)stageInfo), (Function1)Predef$.MODULE$.conforms())).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Properties"), (Object)properties));
    }

    public JsonAST.JValue stageCompletedToJson(SparkListenerStageCompleted stageCompleted) {
        JsonAST.JValue stageInfo = this.stageInfoToJson(stageCompleted.stageInfo());
        return JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Event"), (Object)Utils$.MODULE$.getFormattedClassName(stageCompleted)), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Stage Info"), (Object)stageInfo), (Function1)Predef$.MODULE$.conforms());
    }

    public JsonAST.JValue taskStartToJson(SparkListenerTaskStart taskStart) {
        TaskInfo taskInfo = taskStart.taskInfo();
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Event"), (Object)Utils$.MODULE$.getFormattedClassName(taskStart)), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Stage ID"), (Object)BoxesRunTime.boxToInteger((int)taskStart.stageId())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(int x) {
                return JsonDSL$.MODULE$.int2jvalue(x);
            }
        })).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Stage Attempt ID"), (Object)BoxesRunTime.boxToInteger((int)taskStart.stageAttemptId())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(int x) {
                return JsonDSL$.MODULE$.int2jvalue(x);
            }
        }))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Task Info"), (Object)this.taskInfoToJson(taskInfo)));
    }

    public JsonAST.JValue taskGettingResultToJson(SparkListenerTaskGettingResult taskGettingResult) {
        TaskInfo taskInfo = taskGettingResult.taskInfo();
        return JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Event"), (Object)Utils$.MODULE$.getFormattedClassName(taskGettingResult)), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Task Info"), (Object)this.taskInfoToJson(taskInfo)), (Function1)Predef$.MODULE$.conforms());
    }

    public JsonAST.JValue taskEndToJson(SparkListenerTaskEnd taskEnd) {
        JsonAST.JValue taskEndReason = this.taskEndReasonToJson(taskEnd.reason());
        TaskInfo taskInfo = taskEnd.taskInfo();
        TaskMetrics taskMetrics = taskEnd.taskMetrics();
        JsonAST.JNothing$ taskMetricsJson = taskMetrics == null ? JsonAST.JNothing$.MODULE$ : this.taskMetricsToJson(taskMetrics);
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Event"), (Object)Utils$.MODULE$.getFormattedClassName(taskEnd)), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Stage ID"), (Object)BoxesRunTime.boxToInteger((int)taskEnd.stageId())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(int x) {
                return JsonDSL$.MODULE$.int2jvalue(x);
            }
        })).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Stage Attempt ID"), (Object)BoxesRunTime.boxToInteger((int)taskEnd.stageAttemptId())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(int x) {
                return JsonDSL$.MODULE$.int2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Task Type"), (Object)taskEnd.taskType()), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Task End Reason"), (Object)taskEndReason))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Task Info"), (Object)this.taskInfoToJson(taskInfo)))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Task Metrics"), (Object)taskMetricsJson));
    }

    public JsonAST.JValue jobStartToJson(SparkListenerJobStart jobStart) {
        JsonAST.JValue properties = this.propertiesToJson(jobStart.properties());
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Event"), (Object)Utils$.MODULE$.getFormattedClassName(jobStart)), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Job ID"), (Object)BoxesRunTime.boxToInteger((int)jobStart.jobId())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(int x) {
                return JsonDSL$.MODULE$.int2jvalue(x);
            }
        })).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Submission Time"), (Object)BoxesRunTime.boxToLong((long)jobStart.time())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Stage Infos"), jobStart.stageInfos().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(StageInfo stageInfo) {
                return JsonProtocol$.MODULE$.stageInfoToJson(stageInfo);
            }
        }, Seq$.MODULE$.canBuildFrom())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JArray apply(Traversable<JsonAST.JValue> s) {
                return JsonDSL$.MODULE$.seq2jvalue(s, (Function1)Predef$.MODULE$.conforms());
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Stage IDs"), jobStart.stageIds()), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JArray apply(Traversable<Object> s) {
                return JsonDSL$.MODULE$.seq2jvalue(s, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final JsonAST.JValue apply(int x) {
                        return JsonDSL$.MODULE$.int2jvalue(x);
                    }
                });
            }
        }))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Properties"), (Object)properties));
    }

    public JsonAST.JValue jobEndToJson(SparkListenerJobEnd jobEnd) {
        JsonAST.JValue jobResult = this.jobResultToJson(jobEnd.jobResult());
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Event"), (Object)Utils$.MODULE$.getFormattedClassName(jobEnd)), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Job ID"), (Object)BoxesRunTime.boxToInteger((int)jobEnd.jobId())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(int x) {
                return JsonDSL$.MODULE$.int2jvalue(x);
            }
        })).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Completion Time"), (Object)BoxesRunTime.boxToLong((long)jobEnd.time())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        }))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Job Result"), (Object)jobResult));
    }

    public JsonAST.JValue environmentUpdateToJson(SparkListenerEnvironmentUpdate environmentUpdate) {
        Map<String, Seq<Tuple2<String, String>>> environmentDetails = environmentUpdate.environmentDetails();
        JsonAST.JValue jvmInformation = this.mapToJson((Map<String, String>)((TraversableOnce)environmentDetails.apply((Object)"JVM Information")).toMap(Predef$.MODULE$.conforms()));
        JsonAST.JValue sparkProperties = this.mapToJson((Map<String, String>)((TraversableOnce)environmentDetails.apply((Object)"Spark Properties")).toMap(Predef$.MODULE$.conforms()));
        JsonAST.JValue systemProperties = this.mapToJson((Map<String, String>)((TraversableOnce)environmentDetails.apply((Object)"System Properties")).toMap(Predef$.MODULE$.conforms()));
        JsonAST.JValue classpathEntries = this.mapToJson((Map<String, String>)((TraversableOnce)environmentDetails.apply((Object)"Classpath Entries")).toMap(Predef$.MODULE$.conforms()));
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Event"), (Object)Utils$.MODULE$.getFormattedClassName(environmentUpdate)), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"JVM Information"), (Object)jvmInformation), (Function1)Predef$.MODULE$.conforms())).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Spark Properties"), (Object)sparkProperties))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"System Properties"), (Object)systemProperties))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Classpath Entries"), (Object)classpathEntries));
    }

    public JsonAST.JValue blockManagerAddedToJson(SparkListenerBlockManagerAdded blockManagerAdded) {
        JsonAST.JValue blockManagerId = this.blockManagerIdToJson(blockManagerAdded.blockManagerId());
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Event"), (Object)Utils$.MODULE$.getFormattedClassName(blockManagerAdded)), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Block Manager ID"), (Object)blockManagerId), (Function1)Predef$.MODULE$.conforms())).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Maximum Memory"), (Object)BoxesRunTime.boxToLong((long)blockManagerAdded.maxMem())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Timestamp"), (Object)BoxesRunTime.boxToLong((long)blockManagerAdded.time())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        }));
    }

    public JsonAST.JValue blockManagerRemovedToJson(SparkListenerBlockManagerRemoved blockManagerRemoved) {
        JsonAST.JValue blockManagerId = this.blockManagerIdToJson(blockManagerRemoved.blockManagerId());
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Event"), (Object)Utils$.MODULE$.getFormattedClassName(blockManagerRemoved)), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Block Manager ID"), (Object)blockManagerId), (Function1)Predef$.MODULE$.conforms())).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Timestamp"), (Object)BoxesRunTime.boxToLong((long)blockManagerRemoved.time())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        }));
    }

    public JsonAST.JValue unpersistRDDToJson(SparkListenerUnpersistRDD unpersistRDD) {
        return JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Event"), (Object)Utils$.MODULE$.getFormattedClassName(unpersistRDD)), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"RDD ID"), (Object)BoxesRunTime.boxToInteger((int)unpersistRDD.rddId())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(int x) {
                return JsonDSL$.MODULE$.int2jvalue(x);
            }
        });
    }

    public JsonAST.JValue applicationStartToJson(SparkListenerApplicationStart applicationStart) {
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Event"), (Object)Utils$.MODULE$.getFormattedClassName(applicationStart)), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"App Name"), (Object)applicationStart.appName()), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        })).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"App ID"), applicationStart.appId().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JString apply(String x$1) {
                return new JsonAST.JString(x$1);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JNothing$ apply() {
                return JsonAST.JNothing$.MODULE$;
            }
        })))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Timestamp"), (Object)BoxesRunTime.boxToLong((long)applicationStart.time())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"User"), (Object)applicationStart.sparkUser()), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"App Attempt ID"), applicationStart.appAttemptId().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JString apply(String x$2) {
                return new JsonAST.JString(x$2);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JNothing$ apply() {
                return JsonAST.JNothing$.MODULE$;
            }
        })))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Driver Logs"), applicationStart.driverLogs().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(Map<String, String> m) {
                return JsonProtocol$.MODULE$.mapToJson(m);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JNothing$ apply() {
                return JsonAST.JNothing$.MODULE$;
            }
        })));
    }

    public JsonAST.JValue applicationEndToJson(SparkListenerApplicationEnd applicationEnd) {
        return JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Event"), (Object)Utils$.MODULE$.getFormattedClassName(applicationEnd)), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Timestamp"), (Object)BoxesRunTime.boxToLong((long)applicationEnd.time())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        });
    }

    public JsonAST.JValue executorAddedToJson(SparkListenerExecutorAdded executorAdded2) {
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Event"), (Object)Utils$.MODULE$.getFormattedClassName(executorAdded2)), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Timestamp"), (Object)BoxesRunTime.boxToLong((long)executorAdded2.time())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        })).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Executor ID"), (Object)executorAdded2.executorId()), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Executor Info"), (Object)this.executorInfoToJson(executorAdded2.executorInfo())));
    }

    public JsonAST.JValue executorRemovedToJson(SparkListenerExecutorRemoved executorRemoved2) {
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Event"), (Object)Utils$.MODULE$.getFormattedClassName(executorRemoved2)), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Timestamp"), (Object)BoxesRunTime.boxToLong((long)executorRemoved2.time())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        })).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Executor ID"), (Object)executorRemoved2.executorId()), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Removed Reason"), (Object)executorRemoved2.reason()), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }));
    }

    public JsonAST.JValue logStartToJson(SparkListenerLogStart logStart) {
        return JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Event"), (Object)Utils$.MODULE$.getFormattedClassName(logStart)), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Spark Version"), (Object)package$.MODULE$.SPARK_VERSION()), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        });
    }

    public JsonAST.JValue executorMetricsUpdateToJson(SparkListenerExecutorMetricsUpdate metricsUpdate) {
        String execId = metricsUpdate.execId();
        Seq<Tuple4<Object, Object, Object, Seq<AccumulableInfo>>> accumUpdates = metricsUpdate.accumUpdates();
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Event"), (Object)Utils$.MODULE$.getFormattedClassName(metricsUpdate)), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Executor ID"), (Object)execId), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        })).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Metrics Updated"), accumUpdates.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JObject apply(Tuple4<Object, Object, Object, Seq<AccumulableInfo>> x0$1) {
                Tuple4<Object, Object, Object, Seq<AccumulableInfo>> tuple4 = x0$1;
                if (tuple4 != null) {
                    long taskId = BoxesRunTime.unboxToLong((Object)tuple4._1());
                    int stageId = BoxesRunTime.unboxToInt((Object)tuple4._2());
                    int stageAttemptId = BoxesRunTime.unboxToInt((Object)tuple4._3());
                    Seq updates = (Seq)tuple4._4();
                    JsonAST.JObject jObject = JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Task ID"), (Object)BoxesRunTime.boxToLong((long)taskId)), (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final JsonAST.JValue apply(long x) {
                            return JsonDSL$.MODULE$.long2jvalue(x);
                        }
                    }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Stage ID"), (Object)BoxesRunTime.boxToInteger((int)stageId)), (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final JsonAST.JValue apply(int x) {
                            return JsonDSL$.MODULE$.int2jvalue(x);
                        }
                    })).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Stage Attempt ID"), (Object)BoxesRunTime.boxToInteger((int)stageAttemptId)), (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final JsonAST.JValue apply(int x) {
                            return JsonDSL$.MODULE$.int2jvalue(x);
                        }
                    }))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Accumulator Updates"), (Object)new JsonAST.JArray(((TraversableOnce)updates.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final JsonAST.JValue apply(AccumulableInfo accumulableInfo) {
                            return JsonProtocol$.MODULE$.accumulableInfoToJson(accumulableInfo);
                        }
                    }, Seq$.MODULE$.canBuildFrom())).toList())));
                    return jObject;
                }
                throw new MatchError(tuple4);
            }
        }, Seq$.MODULE$.canBuildFrom())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JArray apply(Traversable<JsonAST.JObject> s) {
                return JsonDSL$.MODULE$.seq2jvalue(s, (Function1)Predef$.MODULE$.conforms());
            }
        }));
    }

    public JsonAST.JValue stageInfoToJson(StageInfo stageInfo) {
        JsonAST.JArray rddInfo = new JsonAST.JArray(((TraversableOnce)stageInfo.rddInfos().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(RDDInfo rddInfo) {
                return JsonProtocol$.MODULE$.rddInfoToJson(rddInfo);
            }
        }, Seq$.MODULE$.canBuildFrom())).toList());
        JsonAST.JArray parentIds = new JsonAST.JArray(((TraversableOnce)stageInfo.parentIds().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JInt apply(int x$3) {
                return new JsonAST.JInt(BigInt$.MODULE$.int2bigInt(x$3));
            }
        }, Seq$.MODULE$.canBuildFrom())).toList());
        JsonAST.JValue submissionTime = (JsonAST.JValue)stageInfo.submissionTime().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JInt apply(long x$4) {
                return new JsonAST.JInt(BigInt$.MODULE$.long2bigInt(x$4));
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JNothing$ apply() {
                return JsonAST.JNothing$.MODULE$;
            }
        });
        JsonAST.JValue completionTime = (JsonAST.JValue)stageInfo.completionTime().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JInt apply(long x$5) {
                return new JsonAST.JInt(BigInt$.MODULE$.long2bigInt(x$5));
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JNothing$ apply() {
                return JsonAST.JNothing$.MODULE$;
            }
        });
        JsonAST.JValue failureReason = (JsonAST.JValue)stageInfo.failureReason().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JString apply(String x$6) {
                return new JsonAST.JString(x$6);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JNothing$ apply() {
                return JsonAST.JNothing$.MODULE$;
            }
        });
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Stage ID"), (Object)BoxesRunTime.boxToInteger((int)stageInfo.stageId())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(int x) {
                return JsonDSL$.MODULE$.int2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Stage Attempt ID"), (Object)BoxesRunTime.boxToInteger((int)stageInfo.attemptId())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(int x) {
                return JsonDSL$.MODULE$.int2jvalue(x);
            }
        })).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Stage Name"), (Object)stageInfo.name()), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Number of Tasks"), (Object)BoxesRunTime.boxToInteger((int)stageInfo.numTasks())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(int x) {
                return JsonDSL$.MODULE$.int2jvalue(x);
            }
        }))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"RDD Info"), (Object)rddInfo))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Parent IDs"), (Object)parentIds))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Details"), (Object)stageInfo.details()), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Submission Time"), (Object)submissionTime))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Completion Time"), (Object)completionTime))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Failure Reason"), (Object)failureReason))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Accumulables"), (Object)new JsonAST.JArray(((TraversableOnce)stageInfo.accumulables().values().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(AccumulableInfo accumulableInfo) {
                return JsonProtocol$.MODULE$.accumulableInfoToJson(accumulableInfo);
            }
        }, Iterable$.MODULE$.canBuildFrom())).toList())));
    }

    public JsonAST.JValue taskInfoToJson(TaskInfo taskInfo) {
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Task ID"), (Object)BoxesRunTime.boxToLong((long)taskInfo.taskId())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Index"), (Object)BoxesRunTime.boxToInteger((int)taskInfo.index())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(int x) {
                return JsonDSL$.MODULE$.int2jvalue(x);
            }
        })).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Attempt"), (Object)BoxesRunTime.boxToInteger((int)taskInfo.attemptNumber())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(int x) {
                return JsonDSL$.MODULE$.int2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Launch Time"), (Object)BoxesRunTime.boxToLong((long)taskInfo.launchTime())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Executor ID"), (Object)taskInfo.executorId()), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Host"), (Object)taskInfo.host()), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Locality"), (Object)taskInfo.taskLocality().toString()), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Speculative"), (Object)BoxesRunTime.boxToBoolean((boolean)taskInfo.speculative())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(boolean x) {
                return JsonDSL$.MODULE$.boolean2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Getting Result Time"), (Object)BoxesRunTime.boxToLong((long)taskInfo.gettingResultTime())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Finish Time"), (Object)BoxesRunTime.boxToLong((long)taskInfo.finishTime())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Failed"), (Object)BoxesRunTime.boxToBoolean((boolean)taskInfo.failed())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(boolean x) {
                return JsonDSL$.MODULE$.boolean2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Killed"), (Object)BoxesRunTime.boxToBoolean((boolean)taskInfo.killed())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(boolean x) {
                return JsonDSL$.MODULE$.boolean2jvalue(x);
            }
        }))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Accumulables"), (Object)new JsonAST.JArray((List)taskInfo.accumulables().toList().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(AccumulableInfo accumulableInfo) {
                return JsonProtocol$.MODULE$.accumulableInfoToJson(accumulableInfo);
            }
        }, List$.MODULE$.canBuildFrom()))));
    }

    public JsonAST.JValue accumulableInfoToJson(AccumulableInfo accumulableInfo) {
        Option<String> name = accumulableInfo.name();
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"ID"), (Object)BoxesRunTime.boxToLong((long)accumulableInfo.id())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Name"), name), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(Option<String> opt) {
                return JsonDSL$.MODULE$.option2jvalue(opt, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final JsonAST.JValue apply(String x) {
                        return JsonDSL$.MODULE$.string2jvalue(x);
                    }
                });
            }
        })).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Update"), (Object)accumulableInfo.update().map((Function1)new Serializable(name){
            public static final long serialVersionUID = 0L;
            private final Option name$1;

            public final JsonAST.JValue apply(Object v) {
                return JsonProtocol$.MODULE$.accumValueToJson((Option<String>)this.name$1, v);
            }
            {
                this.name$1 = name$1;
            }
        })), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(Option<JsonAST.JValue> opt) {
                return JsonDSL$.MODULE$.option2jvalue(opt, (Function1)Predef$.MODULE$.conforms());
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Value"), (Object)accumulableInfo.value().map((Function1)new Serializable(name){
            public static final long serialVersionUID = 0L;
            private final Option name$1;

            public final JsonAST.JValue apply(Object v) {
                return JsonProtocol$.MODULE$.accumValueToJson((Option<String>)this.name$1, v);
            }
            {
                this.name$1 = name$1;
            }
        })), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(Option<JsonAST.JValue> opt) {
                return JsonDSL$.MODULE$.option2jvalue(opt, (Function1)Predef$.MODULE$.conforms());
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Internal"), (Object)BoxesRunTime.boxToBoolean((boolean)accumulableInfo.internal())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(boolean x) {
                return JsonDSL$.MODULE$.boolean2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Count Failed Values"), (Object)BoxesRunTime.boxToBoolean((boolean)accumulableInfo.countFailedValues())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(boolean x) {
                return JsonDSL$.MODULE$.boolean2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Metadata"), accumulableInfo.metadata()), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(Option<String> opt) {
                return JsonDSL$.MODULE$.option2jvalue(opt, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final JsonAST.JValue apply(String x) {
                        return JsonDSL$.MODULE$.string2jvalue(x);
                    }
                });
            }
        }));
    }

    public JsonAST.JValue accumValueToJson(Option<String> name, Object value2) {
        JsonAST.JString jString;
        if (name.exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$7) {
                return x$7.startsWith(InternalAccumulator$.MODULE$.METRICS_PREFIX());
            }
        })) {
            JsonAST.JInt jInt;
            Object object = value2;
            if (object instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)object);
                jInt = new JsonAST.JInt(BigInt$.MODULE$.int2bigInt(n));
            } else if (object instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object);
                jInt = new JsonAST.JInt(BigInt$.MODULE$.long2bigInt(l));
            } else {
                jInt = new JsonAST.JArray((List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)object).asScala()).toList().map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final JsonAST.JObject apply(Tuple2<BlockId, BlockStatus> x0$2) {
                        Tuple2<BlockId, BlockStatus> tuple2 = x0$2;
                        if (tuple2 != null) {
                            BlockId id = (BlockId)tuple2._1();
                            BlockStatus status = (BlockStatus)tuple2._2();
                            JsonAST.JObject jObject = JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Block ID"), (Object)id.toString()), (Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final JsonAST.JValue apply(String x) {
                                    return JsonDSL$.MODULE$.string2jvalue(x);
                                }
                            }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Status"), (Object)JsonProtocol$.MODULE$.blockStatusToJson(status)), (Function1)Predef$.MODULE$.conforms());
                            return jObject;
                        }
                        throw new MatchError(tuple2);
                    }
                }, List$.MODULE$.canBuildFrom()));
            }
            jString = jInt;
        } else {
            jString = new JsonAST.JString(value2.toString());
        }
        return jString;
    }

    public JsonAST.JValue taskMetricsToJson(TaskMetrics taskMetrics) {
        JsonAST.JObject shuffleReadMetrics = JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Remote Blocks Fetched"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.shuffleReadMetrics().remoteBlocksFetched())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Local Blocks Fetched"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.shuffleReadMetrics().localBlocksFetched())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        })).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Fetch Wait Time"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.shuffleReadMetrics().fetchWaitTime())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Remote Bytes Read"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.shuffleReadMetrics().remoteBytesRead())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Local Bytes Read"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.shuffleReadMetrics().localBytesRead())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Total Records Read"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.shuffleReadMetrics().recordsRead())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        }));
        JsonAST.JObject shuffleWriteMetrics = JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Shuffle Bytes Written"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.shuffleWriteMetrics().bytesWritten())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Shuffle Write Time"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.shuffleWriteMetrics().writeTime())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        })).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Shuffle Records Written"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.shuffleWriteMetrics().recordsWritten())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        }));
        JsonAST.JObject inputMetrics = JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Bytes Read"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.inputMetrics().bytesRead())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Records Read"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.inputMetrics().recordsRead())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        });
        JsonAST.JObject outputMetrics = JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Bytes Written"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.outputMetrics().bytesWritten())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Records Written"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.outputMetrics().recordsWritten())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        });
        JsonAST.JArray updatedBlocks = new JsonAST.JArray((List)taskMetrics.updatedBlockStatuses().toList().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JObject apply(Tuple2<BlockId, BlockStatus> x0$3) {
                Tuple2<BlockId, BlockStatus> tuple2 = x0$3;
                if (tuple2 != null) {
                    BlockId id = (BlockId)tuple2._1();
                    BlockStatus status = (BlockStatus)tuple2._2();
                    JsonAST.JObject jObject = JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Block ID"), (Object)id.toString()), (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final JsonAST.JValue apply(String x) {
                            return JsonDSL$.MODULE$.string2jvalue(x);
                        }
                    }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Status"), (Object)JsonProtocol$.MODULE$.blockStatusToJson(status)), (Function1)Predef$.MODULE$.conforms());
                    return jObject;
                }
                throw new MatchError(tuple2);
            }
        }, List$.MODULE$.canBuildFrom()));
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Executor Deserialize Time"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.executorDeserializeTime())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Executor Deserialize CPU Time"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.executorDeserializeCpuTime())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        })).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Executor Run Time"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.executorRunTime())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Executor CPU Time"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.executorCpuTime())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Result Size"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.resultSize())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"JVM GC Time"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.jvmGCTime())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Result Serialization Time"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.resultSerializationTime())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Memory Bytes Spilled"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.memoryBytesSpilled())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Disk Bytes Spilled"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.diskBytesSpilled())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        }))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Shuffle Read Metrics"), (Object)shuffleReadMetrics))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Shuffle Write Metrics"), (Object)shuffleWriteMetrics))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Input Metrics"), (Object)inputMetrics))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Output Metrics"), (Object)outputMetrics))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Updated Blocks"), (Object)updatedBlocks));
    }

    public JsonAST.JValue taskEndReasonToJson(TaskEndReason taskEndReason) {
        JsonAST.JObject jObject;
        String reason = Utils$.MODULE$.getFormattedClassName(taskEndReason);
        TaskEndReason taskEndReason2 = taskEndReason;
        if (taskEndReason2 instanceof FetchFailed) {
            FetchFailed fetchFailed = (FetchFailed)taskEndReason2;
            JsonAST.JValue blockManagerAddress = (JsonAST.JValue)Option$.MODULE$.apply((Object)fetchFailed.bmAddress()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final JsonAST.JValue apply(BlockManagerId blockManagerId) {
                    return JsonProtocol$.MODULE$.blockManagerIdToJson(blockManagerId);
                }
            }).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final JsonAST.JNothing$ apply() {
                    return JsonAST.JNothing$.MODULE$;
                }
            });
            jObject = JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Block Manager Address"), (Object)blockManagerAddress), (Function1)Predef$.MODULE$.conforms()).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Shuffle ID"), (Object)BoxesRunTime.boxToInteger((int)fetchFailed.shuffleId())), (Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final JsonAST.JValue apply(int x) {
                    return JsonDSL$.MODULE$.int2jvalue(x);
                }
            })).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Map ID"), (Object)BoxesRunTime.boxToInteger((int)fetchFailed.mapId())), (Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final JsonAST.JValue apply(int x) {
                    return JsonDSL$.MODULE$.int2jvalue(x);
                }
            }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Reduce ID"), (Object)BoxesRunTime.boxToInteger((int)fetchFailed.reduceId())), (Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final JsonAST.JValue apply(int x) {
                    return JsonDSL$.MODULE$.int2jvalue(x);
                }
            }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Message"), (Object)fetchFailed.message()), (Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final JsonAST.JValue apply(String x) {
                    return JsonDSL$.MODULE$.string2jvalue(x);
                }
            }));
        } else if (taskEndReason2 instanceof ExceptionFailure) {
            ExceptionFailure exceptionFailure = (ExceptionFailure)taskEndReason2;
            JsonAST.JValue stackTrace = this.stackTraceToJson(exceptionFailure.stackTrace());
            JsonAST.JArray accumUpdates = new JsonAST.JArray(((TraversableOnce)exceptionFailure.accumUpdates().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final JsonAST.JValue apply(AccumulableInfo accumulableInfo) {
                    return JsonProtocol$.MODULE$.accumulableInfoToJson(accumulableInfo);
                }
            }, Seq$.MODULE$.canBuildFrom())).toList());
            jObject = JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Class Name"), (Object)exceptionFailure.className()), (Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final JsonAST.JValue apply(String x) {
                    return JsonDSL$.MODULE$.string2jvalue(x);
                }
            }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Description"), (Object)exceptionFailure.description()), (Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final JsonAST.JValue apply(String x) {
                    return JsonDSL$.MODULE$.string2jvalue(x);
                }
            })).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Stack Trace"), (Object)stackTrace))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Full Stack Trace"), (Object)exceptionFailure.fullStackTrace()), (Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final JsonAST.JValue apply(String x) {
                    return JsonDSL$.MODULE$.string2jvalue(x);
                }
            }))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Accumulator Updates"), (Object)accumUpdates));
        } else if (taskEndReason2 instanceof TaskCommitDenied) {
            TaskCommitDenied taskCommitDenied = (TaskCommitDenied)taskEndReason2;
            jObject = JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Job ID"), (Object)BoxesRunTime.boxToInteger((int)taskCommitDenied.jobID())), (Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final JsonAST.JValue apply(int x) {
                    return JsonDSL$.MODULE$.int2jvalue(x);
                }
            }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Partition ID"), (Object)BoxesRunTime.boxToInteger((int)taskCommitDenied.partitionID())), (Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final JsonAST.JValue apply(int x) {
                    return JsonDSL$.MODULE$.int2jvalue(x);
                }
            })).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Attempt Number"), (Object)BoxesRunTime.boxToInteger((int)taskCommitDenied.attemptNumber())), (Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final JsonAST.JValue apply(int x) {
                    return JsonDSL$.MODULE$.int2jvalue(x);
                }
            }));
        } else if (taskEndReason2 instanceof ExecutorLostFailure) {
            ExecutorLostFailure executorLostFailure = (ExecutorLostFailure)taskEndReason2;
            String executorId = executorLostFailure.execId();
            boolean exitCausedByApp = executorLostFailure.exitCausedByApp();
            Option<String> reason2 = executorLostFailure.reason();
            jObject = JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Executor ID"), (Object)executorId), (Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final JsonAST.JValue apply(String x) {
                    return JsonDSL$.MODULE$.string2jvalue(x);
                }
            }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Exit Caused By App"), (Object)BoxesRunTime.boxToBoolean((boolean)exitCausedByApp)), (Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final JsonAST.JValue apply(boolean x) {
                    return JsonDSL$.MODULE$.boolean2jvalue(x);
                }
            })).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Loss Reason"), (Object)reason2.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String x$8) {
                    return x$8.toString();
                }
            })), (Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final JsonAST.JValue apply(Option<String> opt) {
                    return JsonDSL$.MODULE$.option2jvalue(opt, (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final JsonAST.JValue apply(String x) {
                            return JsonDSL$.MODULE$.string2jvalue(x);
                        }
                    });
                }
            }));
        } else {
            jObject = Utils$.MODULE$.emptyJson();
        }
        JsonAST.JObject json = jObject;
        return JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Reason"), (Object)reason), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }).$tilde(json);
    }

    public JsonAST.JValue blockManagerIdToJson(BlockManagerId blockManagerId) {
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Executor ID"), (Object)blockManagerId.executorId()), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Host"), (Object)blockManagerId.host()), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        })).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Port"), (Object)BoxesRunTime.boxToInteger((int)blockManagerId.port())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(int x) {
                return JsonDSL$.MODULE$.int2jvalue(x);
            }
        }));
    }

    public JsonAST.JValue jobResultToJson(JobResult jobResult) {
        JobResult jobResult2;
        block4: {
            JsonAST.JObject jObject;
            String result2;
            block3: {
                block2: {
                    result2 = Utils$.MODULE$.getFormattedClassName(jobResult);
                    jobResult2 = jobResult;
                    JobSucceeded$ jobSucceeded$ = JobSucceeded$.MODULE$;
                    JobResult jobResult3 = jobResult2;
                    if (jobSucceeded$ != null ? !jobSucceeded$.equals(jobResult3) : jobResult3 != null) break block2;
                    jObject = Utils$.MODULE$.emptyJson();
                    break block3;
                }
                if (!(jobResult2 instanceof JobFailed)) break block4;
                JobFailed jobFailed2 = (JobFailed)jobResult2;
                jObject = JsonAST.JObject$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Exception"), (Object)this.exceptionToJson(jobFailed2.exception()))}));
            }
            JsonAST.JObject json = jObject;
            return JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Result"), (Object)result2), (Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final JsonAST.JValue apply(String x) {
                    return JsonDSL$.MODULE$.string2jvalue(x);
                }
            }).$tilde(json);
        }
        throw new MatchError((Object)jobResult2);
    }

    public JsonAST.JValue rddInfoToJson(RDDInfo rddInfo) {
        JsonAST.JValue storageLevel = this.storageLevelToJson(rddInfo.storageLevel());
        JsonAST.JArray parentIds = new JsonAST.JArray(((TraversableOnce)rddInfo.parentIds().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JInt apply(int x$9) {
                return new JsonAST.JInt(BigInt$.MODULE$.int2bigInt(x$9));
            }
        }, Seq$.MODULE$.canBuildFrom())).toList());
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"RDD ID"), (Object)BoxesRunTime.boxToInteger((int)rddInfo.id())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(int x) {
                return JsonDSL$.MODULE$.int2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Name"), (Object)rddInfo.name()), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        })).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Scope"), (Object)rddInfo.scope().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(RDDOperationScope x$10) {
                return x$10.toJson();
            }
        })), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(Option<String> opt) {
                return JsonDSL$.MODULE$.option2jvalue(opt, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final JsonAST.JValue apply(String x) {
                        return JsonDSL$.MODULE$.string2jvalue(x);
                    }
                });
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Callsite"), (Object)rddInfo.callSite()), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Parent IDs"), (Object)parentIds))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Storage Level"), (Object)storageLevel))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Number of Partitions"), (Object)BoxesRunTime.boxToInteger((int)rddInfo.numPartitions())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(int x) {
                return JsonDSL$.MODULE$.int2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Number of Cached Partitions"), (Object)BoxesRunTime.boxToInteger((int)rddInfo.numCachedPartitions())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(int x) {
                return JsonDSL$.MODULE$.int2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Memory Size"), (Object)BoxesRunTime.boxToLong((long)rddInfo.memSize())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Disk Size"), (Object)BoxesRunTime.boxToLong((long)rddInfo.diskSize())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        }));
    }

    public JsonAST.JValue storageLevelToJson(StorageLevel storageLevel) {
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Use Disk"), (Object)BoxesRunTime.boxToBoolean((boolean)storageLevel.useDisk())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(boolean x) {
                return JsonDSL$.MODULE$.boolean2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Use Memory"), (Object)BoxesRunTime.boxToBoolean((boolean)storageLevel.useMemory())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(boolean x) {
                return JsonDSL$.MODULE$.boolean2jvalue(x);
            }
        })).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Deserialized"), (Object)BoxesRunTime.boxToBoolean((boolean)storageLevel.deserialized())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(boolean x) {
                return JsonDSL$.MODULE$.boolean2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Replication"), (Object)BoxesRunTime.boxToInteger((int)storageLevel.replication())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(int x) {
                return JsonDSL$.MODULE$.int2jvalue(x);
            }
        }));
    }

    public JsonAST.JValue blockStatusToJson(BlockStatus blockStatus2) {
        JsonAST.JValue storageLevel = this.storageLevelToJson(blockStatus2.storageLevel());
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Storage Level"), (Object)storageLevel), (Function1)Predef$.MODULE$.conforms()).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Memory Size"), (Object)BoxesRunTime.boxToLong((long)blockStatus2.memSize())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        })).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Disk Size"), (Object)BoxesRunTime.boxToLong((long)blockStatus2.diskSize())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        }));
    }

    public JsonAST.JValue executorInfoToJson(ExecutorInfo executorInfo) {
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Host"), (Object)executorInfo.executorHost()), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Total Cores"), (Object)BoxesRunTime.boxToInteger((int)executorInfo.totalCores())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(int x) {
                return JsonDSL$.MODULE$.int2jvalue(x);
            }
        })).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Log Urls"), (Object)this.mapToJson((Map<String, String>)executorInfo.logUrlMap())));
    }

    public JsonAST.JValue mapToJson(Map<String, String> m) {
        Map jsonFields = (Map)m.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, JsonAST.JValue> apply(Tuple2<String, String> x0$4) {
                Tuple2<String, String> tuple2 = x0$4;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    Tuple2 tuple22 = JsonAST.JField$.MODULE$.apply(k, (JsonAST.JValue)new JsonAST.JString(v));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom());
        return new JsonAST.JObject(jsonFields.toList());
    }

    public JsonAST.JValue propertiesToJson(Properties properties) {
        return (JsonAST.JValue)Option$.MODULE$.apply((Object)properties).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(Properties p) {
                return JsonProtocol$.MODULE$.mapToJson((Map<String, String>)((Map)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(p).asScala()));
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JNothing$ apply() {
                return JsonAST.JNothing$.MODULE$;
            }
        });
    }

    public JsonAST.JValue UUIDToJson(UUID id) {
        return JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Least Significant Bits"), (Object)BoxesRunTime.boxToLong((long)id.getLeastSignificantBits())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Most Significant Bits"), (Object)BoxesRunTime.boxToLong((long)id.getMostSignificantBits())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(long x) {
                return JsonDSL$.MODULE$.long2jvalue(x);
            }
        });
    }

    public JsonAST.JValue stackTraceToJson(StackTraceElement[] stackTrace) {
        return new JsonAST.JArray(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])stackTrace).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JObject apply(StackTraceElement x0$5) {
                StackTraceElement stackTraceElement = x0$5;
                JsonAST.JObject jObject = JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Declaring Class"), (Object)stackTraceElement.getClassName()), (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final JsonAST.JValue apply(String x) {
                        return JsonDSL$.MODULE$.string2jvalue(x);
                    }
                }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Method Name"), (Object)stackTraceElement.getMethodName()), (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final JsonAST.JValue apply(String x) {
                        return JsonDSL$.MODULE$.string2jvalue(x);
                    }
                })).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"File Name"), (Object)stackTraceElement.getFileName()), (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final JsonAST.JValue apply(String x) {
                        return JsonDSL$.MODULE$.string2jvalue(x);
                    }
                }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Line Number"), (Object)BoxesRunTime.boxToInteger((int)stackTraceElement.getLineNumber())), (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final JsonAST.JValue apply(int x) {
                        return JsonDSL$.MODULE$.int2jvalue(x);
                    }
                }));
                return jObject;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(JsonAST.JObject.class)))).toList());
    }

    public JsonAST.JValue exceptionToJson(Exception exception2) {
        return JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Message"), (Object)exception2.getMessage()), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Stack Trace"), (Object)this.stackTraceToJson(exception2.getStackTrace())), (Function1)Predef$.MODULE$.conforms());
    }

    public SparkListenerEvent sparkEventFromJson(JsonAST.JValue json) {
        SparkListenerEvent sparkListenerEvent;
        String stageSubmitted = Utils$.MODULE$.getFormattedClassName((Object)SparkListenerStageSubmitted$.MODULE$);
        String stageCompleted = Utils$.MODULE$.getFormattedClassName((Object)SparkListenerStageCompleted$.MODULE$);
        String taskStart = Utils$.MODULE$.getFormattedClassName((Object)SparkListenerTaskStart$.MODULE$);
        String taskGettingResult = Utils$.MODULE$.getFormattedClassName((Object)SparkListenerTaskGettingResult$.MODULE$);
        String taskEnd = Utils$.MODULE$.getFormattedClassName((Object)SparkListenerTaskEnd$.MODULE$);
        String jobStart = Utils$.MODULE$.getFormattedClassName((Object)SparkListenerJobStart$.MODULE$);
        String jobEnd = Utils$.MODULE$.getFormattedClassName((Object)SparkListenerJobEnd$.MODULE$);
        String environmentUpdate = Utils$.MODULE$.getFormattedClassName((Object)SparkListenerEnvironmentUpdate$.MODULE$);
        String blockManagerAdded = Utils$.MODULE$.getFormattedClassName((Object)SparkListenerBlockManagerAdded$.MODULE$);
        String blockManagerRemoved = Utils$.MODULE$.getFormattedClassName((Object)SparkListenerBlockManagerRemoved$.MODULE$);
        String unpersistRDD = Utils$.MODULE$.getFormattedClassName((Object)SparkListenerUnpersistRDD$.MODULE$);
        String applicationStart = Utils$.MODULE$.getFormattedClassName((Object)SparkListenerApplicationStart$.MODULE$);
        String applicationEnd = Utils$.MODULE$.getFormattedClassName((Object)SparkListenerApplicationEnd$.MODULE$);
        String executorAdded2 = Utils$.MODULE$.getFormattedClassName((Object)SparkListenerExecutorAdded$.MODULE$);
        String executorRemoved2 = Utils$.MODULE$.getFormattedClassName((Object)SparkListenerExecutorRemoved$.MODULE$);
        String logStart = Utils$.MODULE$.getFormattedClassName((Object)SparkListenerLogStart$.MODULE$);
        String metricsUpdate = Utils$.MODULE$.getFormattedClassName((Object)SparkListenerExecutorMetricsUpdate$.MODULE$);
        String string = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Event")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class));
        String string2 = stageSubmitted;
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            sparkListenerEvent = this.stageSubmittedFromJson(json);
        } else {
            String string4 = stageCompleted;
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                sparkListenerEvent = this.stageCompletedFromJson(json);
            } else {
                String string6 = taskStart;
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    sparkListenerEvent = this.taskStartFromJson(json);
                } else {
                    String string8 = taskGettingResult;
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        sparkListenerEvent = this.taskGettingResultFromJson(json);
                    } else {
                        String string10 = taskEnd;
                        String string11 = string;
                        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                            sparkListenerEvent = this.taskEndFromJson(json);
                        } else {
                            String string12 = jobStart;
                            String string13 = string;
                            if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
                                sparkListenerEvent = this.jobStartFromJson(json);
                            } else {
                                String string14 = jobEnd;
                                String string15 = string;
                                if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
                                    sparkListenerEvent = this.jobEndFromJson(json);
                                } else {
                                    String string16 = environmentUpdate;
                                    String string17 = string;
                                    if (!(string16 != null ? !string16.equals(string17) : string17 != null)) {
                                        sparkListenerEvent = this.environmentUpdateFromJson(json);
                                    } else {
                                        String string18 = blockManagerAdded;
                                        String string19 = string;
                                        if (!(string18 != null ? !string18.equals(string19) : string19 != null)) {
                                            sparkListenerEvent = this.blockManagerAddedFromJson(json);
                                        } else {
                                            String string20 = blockManagerRemoved;
                                            String string21 = string;
                                            if (!(string20 != null ? !string20.equals(string21) : string21 != null)) {
                                                sparkListenerEvent = this.blockManagerRemovedFromJson(json);
                                            } else {
                                                String string22 = unpersistRDD;
                                                String string23 = string;
                                                if (!(string22 != null ? !string22.equals(string23) : string23 != null)) {
                                                    sparkListenerEvent = this.unpersistRDDFromJson(json);
                                                } else {
                                                    String string24 = applicationStart;
                                                    String string25 = string;
                                                    if (!(string24 != null ? !string24.equals(string25) : string25 != null)) {
                                                        sparkListenerEvent = this.applicationStartFromJson(json);
                                                    } else {
                                                        String string26 = applicationEnd;
                                                        String string27 = string;
                                                        if (!(string26 != null ? !string26.equals(string27) : string27 != null)) {
                                                            sparkListenerEvent = this.applicationEndFromJson(json);
                                                        } else {
                                                            String string28 = executorAdded2;
                                                            String string29 = string;
                                                            if (!(string28 != null ? !string28.equals(string29) : string29 != null)) {
                                                                sparkListenerEvent = this.executorAddedFromJson(json);
                                                            } else {
                                                                String string30 = executorRemoved2;
                                                                String string31 = string;
                                                                if (!(string30 != null ? !string30.equals(string31) : string31 != null)) {
                                                                    sparkListenerEvent = this.executorRemovedFromJson(json);
                                                                } else {
                                                                    String string32 = logStart;
                                                                    String string33 = string;
                                                                    if (!(string32 != null ? !string32.equals(string33) : string33 != null)) {
                                                                        sparkListenerEvent = this.logStartFromJson(json);
                                                                    } else {
                                                                        String string34 = metricsUpdate;
                                                                        String string35 = string;
                                                                        sparkListenerEvent = !(string34 != null ? !string34.equals(string35) : string35 != null) ? this.executorMetricsUpdateFromJson(json) : (SparkListenerEvent)this.mapper().readValue(JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render(json, (Formats)this.org$apache$spark$util$JsonProtocol$$format())), Utils$.MODULE$.classForName(string));
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return sparkListenerEvent;
    }

    public SparkListenerStageSubmitted stageSubmittedFromJson(JsonAST.JValue json) {
        StageInfo stageInfo = this.stageInfoFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Stage Info"));
        Properties properties = this.propertiesFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Properties"));
        return new SparkListenerStageSubmitted(stageInfo, properties);
    }

    public SparkListenerStageCompleted stageCompletedFromJson(JsonAST.JValue json) {
        StageInfo stageInfo = this.stageInfoFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Stage Info"));
        return new SparkListenerStageCompleted(stageInfo);
    }

    public SparkListenerTaskStart taskStartFromJson(JsonAST.JValue json) {
        int stageId = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Stage ID")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Int()));
        int stageAttemptId = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Stage Attempt ID")).extractOpt((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Int()).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 0;
            }
        }));
        TaskInfo taskInfo = this.taskInfoFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Task Info"));
        return new SparkListenerTaskStart(stageId, stageAttemptId, taskInfo);
    }

    public SparkListenerTaskGettingResult taskGettingResultFromJson(JsonAST.JValue json) {
        TaskInfo taskInfo = this.taskInfoFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Task Info"));
        return new SparkListenerTaskGettingResult(taskInfo);
    }

    public SparkListenerTaskEnd taskEndFromJson(JsonAST.JValue json) {
        int stageId = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Stage ID")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Int()));
        int stageAttemptId = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Stage Attempt ID")).extractOpt((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Int()).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 0;
            }
        }));
        String taskType = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Task Type")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class));
        TaskEndReason taskEndReason = this.taskEndReasonFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Task End Reason"));
        TaskInfo taskInfo = this.taskInfoFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Task Info"));
        TaskMetrics taskMetrics = this.taskMetricsFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Task Metrics"));
        return new SparkListenerTaskEnd(stageId, stageAttemptId, taskType, taskEndReason, taskInfo, taskMetrics);
    }

    public SparkListenerJobStart jobStartFromJson(JsonAST.JValue json) {
        int jobId = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Job ID")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Int()));
        long submissionTime = BoxesRunTime.unboxToLong((Object)Utils$.MODULE$.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Submission Time")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(JsonAST.JValue x$11) {
                return BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$11).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long()));
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return -1L;
            }
        }));
        List stageIds = (List)((TraversableLike)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Stage IDs")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(JsonAST.JValue.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(JsonAST.JValue x$12) {
                return BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$12).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Int()));
            }
        }, List$.MODULE$.canBuildFrom());
        Properties properties = this.propertiesFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Properties"));
        Seq stageInfos = (Seq)Utils$.MODULE$.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Stage Infos")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<StageInfo> apply(JsonAST.JValue x$13) {
                return (Seq)((TraversableLike)org.json4s.package$.MODULE$.jvalue2extractable(x$13).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(Seq.class, ManifestFactory$.MODULE$.classType(JsonAST.JValue.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final StageInfo apply(JsonAST.JValue json) {
                        return JsonProtocol$.MODULE$.stageInfoFromJson(json);
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        }).getOrElse((Function0)new Serializable(stageIds){
            public static final long serialVersionUID = 0L;
            private final List stageIds$1;

            public final List<StageInfo> apply() {
                return (List)this.stageIds$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final StageInfo apply(int id) {
                        return new StageInfo(id, 0, "unknown", 0, (Seq<RDDInfo>)((Seq)Seq$.MODULE$.empty()), (Seq<Object>)((Seq)Seq$.MODULE$.empty()), "unknown", StageInfo$.MODULE$.$lessinit$greater$default$8(), StageInfo$.MODULE$.$lessinit$greater$default$9());
                    }
                }, List$.MODULE$.canBuildFrom());
            }
            {
                this.stageIds$1 = stageIds$1;
            }
        });
        return new SparkListenerJobStart(jobId, submissionTime, (Seq<StageInfo>)stageInfos, properties);
    }

    public SparkListenerJobEnd jobEndFromJson(JsonAST.JValue json) {
        int jobId = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Job ID")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Int()));
        long completionTime = BoxesRunTime.unboxToLong((Object)Utils$.MODULE$.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Completion Time")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(JsonAST.JValue x$14) {
                return BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$14).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long()));
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return -1L;
            }
        }));
        JobResult jobResult = this.jobResultFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Job Result"));
        return new SparkListenerJobEnd(jobId, completionTime, jobResult);
    }

    public SparkListenerEnvironmentUpdate environmentUpdateFromJson(JsonAST.JValue json) {
        Map environmentDetails = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"JVM Information"), (Object)this.mapFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("JVM Information")).toSeq()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Spark Properties"), (Object)this.mapFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Spark Properties")).toSeq()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"System Properties"), (Object)this.mapFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("System Properties")).toSeq()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Classpath Entries"), (Object)this.mapFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Classpath Entries")).toSeq())}));
        return new SparkListenerEnvironmentUpdate((Map<String, Seq<Tuple2<String, String>>>)environmentDetails);
    }

    public SparkListenerBlockManagerAdded blockManagerAddedFromJson(JsonAST.JValue json) {
        BlockManagerId blockManagerId = this.blockManagerIdFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Block Manager ID"));
        long maxMem = BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Maximum Memory")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long()));
        long time = BoxesRunTime.unboxToLong((Object)Utils$.MODULE$.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Timestamp")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(JsonAST.JValue x$15) {
                return BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$15).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long()));
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return -1L;
            }
        }));
        return new SparkListenerBlockManagerAdded(time, blockManagerId, maxMem);
    }

    public SparkListenerBlockManagerRemoved blockManagerRemovedFromJson(JsonAST.JValue json) {
        BlockManagerId blockManagerId = this.blockManagerIdFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Block Manager ID"));
        long time = BoxesRunTime.unboxToLong((Object)Utils$.MODULE$.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Timestamp")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(JsonAST.JValue x$16) {
                return BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$16).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long()));
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return -1L;
            }
        }));
        return new SparkListenerBlockManagerRemoved(time, blockManagerId);
    }

    public SparkListenerUnpersistRDD unpersistRDDFromJson(JsonAST.JValue json) {
        return new SparkListenerUnpersistRDD(BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("RDD ID")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Int())));
    }

    public SparkListenerApplicationStart applicationStartFromJson(JsonAST.JValue json) {
        String appName = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("App Name")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class));
        Option appId = Utils$.MODULE$.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("App ID")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(JsonAST.JValue x$17) {
                return (String)org.json4s.package$.MODULE$.jvalue2extractable(x$17).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class));
            }
        });
        long time = BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Timestamp")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long()));
        String sparkUser = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("User")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class));
        Option appAttemptId = Utils$.MODULE$.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("App Attempt ID")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(JsonAST.JValue x$18) {
                return (String)org.json4s.package$.MODULE$.jvalue2extractable(x$18).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class));
            }
        });
        Option driverLogs = Utils$.MODULE$.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Driver Logs")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Map<String, String> apply(JsonAST.JValue json) {
                return JsonProtocol$.MODULE$.mapFromJson(json);
            }
        });
        return new SparkListenerApplicationStart(appName, (Option<String>)appId, time, sparkUser, (Option<String>)appAttemptId, (Option<Map<String, String>>)driverLogs);
    }

    public SparkListenerApplicationEnd applicationEndFromJson(JsonAST.JValue json) {
        return new SparkListenerApplicationEnd(BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Timestamp")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long())));
    }

    public SparkListenerExecutorAdded executorAddedFromJson(JsonAST.JValue json) {
        long time = BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Timestamp")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long()));
        String executorId = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Executor ID")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class));
        ExecutorInfo executorInfo = this.executorInfoFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Executor Info"));
        return new SparkListenerExecutorAdded(time, executorId, executorInfo);
    }

    public SparkListenerExecutorRemoved executorRemovedFromJson(JsonAST.JValue json) {
        long time = BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Timestamp")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long()));
        String executorId = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Executor ID")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class));
        String reason = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Removed Reason")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class));
        return new SparkListenerExecutorRemoved(time, executorId, reason);
    }

    public SparkListenerLogStart logStartFromJson(JsonAST.JValue json) {
        String sparkVersion = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Spark Version")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class));
        return new SparkListenerLogStart(sparkVersion);
    }

    public SparkListenerExecutorMetricsUpdate executorMetricsUpdateFromJson(JsonAST.JValue json) {
        String execInfo = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Executor ID")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class));
        List accumUpdates = (List)((TraversableLike)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Metrics Updated")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(JsonAST.JValue.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple4<Object, Object, Object, List<AccumulableInfo>> apply(JsonAST.JValue json) {
                long taskId = BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Task ID")).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long()));
                int stageId = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Stage ID")).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Int()));
                int stageAttemptId = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Stage Attempt ID")).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Int()));
                List updates = (List)((TraversableLike)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Accumulator Updates")).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(JsonAST.JValue.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final AccumulableInfo apply(JsonAST.JValue json) {
                        return JsonProtocol$.MODULE$.accumulableInfoFromJson(json);
                    }
                }, List$.MODULE$.canBuildFrom());
                return new Tuple4((Object)BoxesRunTime.boxToLong((long)taskId), (Object)BoxesRunTime.boxToInteger((int)stageId), (Object)BoxesRunTime.boxToInteger((int)stageAttemptId), (Object)updates);
            }
        }, List$.MODULE$.canBuildFrom());
        return new SparkListenerExecutorMetricsUpdate(execInfo, (Seq<Tuple4<Object, Object, Object, Seq<AccumulableInfo>>>)accumUpdates);
    }

    public StageInfo stageInfoFromJson(JsonAST.JValue json) {
        Option option;
        block4: {
            Seq seq;
            Option failureReason;
            Option completionTime;
            Option submissionTime;
            String details;
            Seq parentIds;
            List rddInfos;
            int numTasks;
            String stageName;
            int attemptId;
            int stageId;
            block3: {
                block2: {
                    stageId = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Stage ID")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Int()));
                    attemptId = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Stage Attempt ID")).extractOpt((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Int()).getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final int apply() {
                            return this.apply$mcI$sp();
                        }

                        public int apply$mcI$sp() {
                            return 0;
                        }
                    }));
                    stageName = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Stage Name")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class));
                    numTasks = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Number of Tasks")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Int()));
                    rddInfos = (List)((TraversableLike)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("RDD Info")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(JsonAST.JValue.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final RDDInfo apply(JsonAST.JValue json) {
                            return JsonProtocol$.MODULE$.rddInfoFromJson(json);
                        }
                    }, List$.MODULE$.canBuildFrom());
                    parentIds = (Seq)Utils$.MODULE$.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Parent IDs")).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final List<Object> apply(JsonAST.JValue l) {
                            return (List)((TraversableLike)org.json4s.package$.MODULE$.jvalue2extractable(l).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(JsonAST.JValue.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final int apply(JsonAST.JValue x$19) {
                                    return BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$19).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Int()));
                                }
                            }, List$.MODULE$.canBuildFrom());
                        }
                    }).getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Seq<Nothing$> apply() {
                            return (Seq)Seq$.MODULE$.empty();
                        }
                    });
                    details = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Details")).extractOpt((Formats)this.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class)).getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "";
                        }
                    });
                    submissionTime = Utils$.MODULE$.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Submission Time")).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final long apply(JsonAST.JValue x$20) {
                            return BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$20).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long()));
                        }
                    });
                    completionTime = Utils$.MODULE$.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Completion Time")).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final long apply(JsonAST.JValue x$21) {
                            return BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$21).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long()));
                        }
                    });
                    failureReason = Utils$.MODULE$.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Failure Reason")).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(JsonAST.JValue x$22) {
                            return (String)org.json4s.package$.MODULE$.jvalue2extractable(x$22).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class));
                        }
                    });
                    option = org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Accumulables")).extractOpt((Formats)this.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(JsonAST.JValue.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    List values2 = (List)some.x();
                    seq = (Seq)values2.map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final AccumulableInfo apply(JsonAST.JValue json) {
                            return JsonProtocol$.MODULE$.accumulableInfoFromJson(json);
                        }
                    }, List$.MODULE$.canBuildFrom());
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                seq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
            Seq accumulatedValues = seq;
            StageInfo stageInfo = new StageInfo(stageId, attemptId, stageName, numTasks, (Seq<RDDInfo>)rddInfos, (Seq<Object>)parentIds, details, StageInfo$.MODULE$.$lessinit$greater$default$8(), StageInfo$.MODULE$.$lessinit$greater$default$9());
            stageInfo.submissionTime_$eq((Option<Object>)submissionTime);
            stageInfo.completionTime_$eq((Option<Object>)completionTime);
            stageInfo.failureReason_$eq((Option<String>)failureReason);
            accumulatedValues.foreach((Function1)new Serializable(stageInfo){
                public static final long serialVersionUID = 0L;
                private final StageInfo stageInfo$1;

                public final void apply(AccumulableInfo accInfo) {
                    this.stageInfo$1.accumulables().update((Object)BoxesRunTime.boxToLong((long)accInfo.id()), (Object)accInfo);
                }
                {
                    this.stageInfo$1 = stageInfo$1;
                }
            });
            return stageInfo;
        }
        throw new MatchError((Object)option);
    }

    public TaskInfo taskInfoFromJson(JsonAST.JValue json) {
        Option option;
        block4: {
            Seq seq;
            boolean killed;
            boolean failed;
            long finishTime;
            long gettingResultTime;
            boolean speculative;
            Enumeration.Value taskLocality;
            String host;
            String executorId;
            long launchTime;
            int attempt;
            int index;
            long taskId;
            block3: {
                block2: {
                    taskId = BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Task ID")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long()));
                    index = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Index")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Int()));
                    attempt = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Attempt")).extractOpt((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Int()).getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final int apply() {
                            return this.apply$mcI$sp();
                        }

                        public int apply$mcI$sp() {
                            return 1;
                        }
                    }));
                    launchTime = BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Launch Time")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long()));
                    executorId = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Executor ID")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class));
                    host = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Host")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class));
                    taskLocality = TaskLocality$.MODULE$.withName((String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Locality")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class)));
                    speculative = BoxesRunTime.unboxToBoolean((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Speculative")).extractOpt((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Boolean()).getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply() {
                            return this.apply$mcZ$sp();
                        }

                        public boolean apply$mcZ$sp() {
                            return false;
                        }
                    }));
                    gettingResultTime = BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Getting Result Time")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long()));
                    finishTime = BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Finish Time")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long()));
                    failed = BoxesRunTime.unboxToBoolean((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Failed")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Boolean()));
                    killed = BoxesRunTime.unboxToBoolean((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Killed")).extractOpt((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Boolean()).getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply() {
                            return this.apply$mcZ$sp();
                        }

                        public boolean apply$mcZ$sp() {
                            return false;
                        }
                    }));
                    option = org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Accumulables")).extractOpt((Formats)this.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(Seq.class, ManifestFactory$.MODULE$.classType(JsonAST.JValue.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Seq values2 = (Seq)some.x();
                    seq = (Seq)values2.map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final AccumulableInfo apply(JsonAST.JValue json) {
                            return JsonProtocol$.MODULE$.accumulableInfoFromJson(json);
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                seq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
            Seq accumulables = seq;
            TaskInfo taskInfo = new TaskInfo(taskId, index, attempt, launchTime, executorId, host, taskLocality, speculative);
            taskInfo.gettingResultTime_$eq(gettingResultTime);
            taskInfo.finishTime_$eq(finishTime);
            taskInfo.failed_$eq(failed);
            taskInfo.killed_$eq(killed);
            accumulables.foreach((Function1)new Serializable(taskInfo){
                public static final long serialVersionUID = 0L;
                private final TaskInfo taskInfo$1;

                public final ListBuffer<AccumulableInfo> apply(AccumulableInfo x$23) {
                    return this.taskInfo$1.accumulables().$plus$eq((Object)x$23);
                }
                {
                    this.taskInfo$1 = taskInfo$1;
                }
            });
            return taskInfo;
        }
        throw new MatchError((Object)option);
    }

    public AccumulableInfo accumulableInfoFromJson(JsonAST.JValue json) {
        long id = BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("ID")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long()));
        Option name = org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Name")).extractOpt((Formats)this.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class));
        Option update2 = Utils$.MODULE$.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Update")).map((Function1)new Serializable(name){
            public static final long serialVersionUID = 0L;
            private final Option name$2;

            public final Object apply(JsonAST.JValue v) {
                return JsonProtocol$.MODULE$.accumValueFromJson((Option<String>)this.name$2, v);
            }
            {
                this.name$2 = name$2;
            }
        });
        Option value2 = Utils$.MODULE$.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Value")).map((Function1)new Serializable(name){
            public static final long serialVersionUID = 0L;
            private final Option name$2;

            public final Object apply(JsonAST.JValue v) {
                return JsonProtocol$.MODULE$.accumValueFromJson((Option<String>)this.name$2, v);
            }
            {
                this.name$2 = name$2;
            }
        });
        boolean internal = BoxesRunTime.unboxToBoolean((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Internal")).extractOpt((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Boolean()).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }));
        boolean countFailedValues = BoxesRunTime.unboxToBoolean((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Count Failed Values")).extractOpt((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Boolean()).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }));
        Option metadata = org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Metadata")).extractOpt((Formats)this.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class));
        return new AccumulableInfo(id, (Option<String>)name, (Option<Object>)update2, (Option<Object>)value2, internal, countFailedValues, (Option<String>)metadata);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object accumValueFromJson(Option<String> name, JsonAST.JValue value2) {
        Object object;
        if (name.exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$24) {
                return x$24.startsWith(InternalAccumulator$.MODULE$.METRICS_PREFIX());
            }
        })) {
            Object object2;
            JsonAST.JValue jValue = value2;
            if (jValue instanceof JsonAST.JInt) {
                JsonAST.JInt jInt = (JsonAST.JInt)jValue;
                BigInt v = jInt.num();
                object2 = BoxesRunTime.boxToLong((long)v.toLong());
            } else {
                if (!(jValue instanceof JsonAST.JArray)) throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unexpected json value ", " for "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value2}))).append((Object)"accumulator ").append(name.get()).toString());
                JsonAST.JArray jArray = (JsonAST.JArray)jValue;
                List v = jArray.arr();
                object2 = JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)v.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<BlockId, BlockStatus> apply(JsonAST.JValue blockJson) {
                        BlockId id = BlockId$.MODULE$.apply((String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(blockJson).$bslash("Block ID")).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class)));
                        BlockStatus status = JsonProtocol$.MODULE$.blockStatusFromJson(org.json4s.package$.MODULE$.jvalue2monadic(blockJson).$bslash("Status"));
                        return new Tuple2((Object)id, (Object)status);
                    }
                }, List$.MODULE$.canBuildFrom())).asJava();
            }
            object = object2;
            return object;
        } else {
            object = org.json4s.package$.MODULE$.jvalue2extractable(value2).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class));
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public TaskMetrics taskMetricsFromJson(JsonAST.JValue json) {
        void var2_2;
        TaskMetrics metrics = TaskMetrics$.MODULE$.empty();
        JsonAST.JValue jValue = json;
        JsonAST.JNothing$ jNothing$ = JsonAST.JNothing$.MODULE$;
        if (!(jValue != null ? !jValue.equals(jNothing$) : jNothing$ != null)) {
            return metrics;
        }
        metrics.setExecutorDeserializeTime(BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Executor Deserialize Time")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long())));
        JsonAST.JValue jValue2 = org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Executor Deserialize CPU Time");
        JsonAST.JNothing$ jNothing$2 = JsonAST.JNothing$.MODULE$;
        JsonAST.JValue jValue3 = jValue2;
        long l = !(jNothing$2 != null ? !jNothing$2.equals(jValue3) : jValue3 != null) ? 0L : BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(jValue2).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long()));
        metrics.setExecutorDeserializeCpuTime(l);
        metrics.setExecutorRunTime(BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Executor Run Time")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long())));
        JsonAST.JValue jValue4 = org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Executor CPU Time");
        JsonAST.JNothing$ jNothing$3 = JsonAST.JNothing$.MODULE$;
        JsonAST.JValue jValue5 = jValue4;
        long l2 = !(jNothing$3 != null ? !jNothing$3.equals(jValue5) : jValue5 != null) ? 0L : BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(jValue4).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long()));
        metrics.setExecutorCpuTime(l2);
        metrics.setResultSize(BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Result Size")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long())));
        metrics.setJvmGCTime(BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("JVM GC Time")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long())));
        metrics.setResultSerializationTime(BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Result Serialization Time")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long())));
        metrics.incMemoryBytesSpilled(BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Memory Bytes Spilled")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long())));
        metrics.incDiskBytesSpilled(BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Disk Bytes Spilled")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long())));
        Utils$.MODULE$.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Shuffle Read Metrics")).foreach((Function1)new Serializable(metrics){
            public static final long serialVersionUID = 0L;
            private final TaskMetrics metrics$1;

            public final void apply(JsonAST.JValue readJson) {
                TempShuffleReadMetrics readMetrics = this.metrics$1.createTempShuffleReadMetrics();
                readMetrics.incRemoteBlocksFetched(BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(readJson).$bslash("Remote Blocks Fetched")).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Int())));
                readMetrics.incLocalBlocksFetched(BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(readJson).$bslash("Local Blocks Fetched")).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Int())));
                readMetrics.incRemoteBytesRead(BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(readJson).$bslash("Remote Bytes Read")).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long())));
                readMetrics.incLocalBytesRead(BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(readJson).$bslash("Local Bytes Read")).extractOpt((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long()).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return 0L;
                    }
                })));
                readMetrics.incFetchWaitTime(BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(readJson).$bslash("Fetch Wait Time")).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long())));
                readMetrics.incRecordsRead(BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(readJson).$bslash("Total Records Read")).extractOpt((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long()).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return 0L;
                    }
                })));
                this.metrics$1.mergeShuffleReadMetrics();
            }
            {
                this.metrics$1 = metrics$1;
            }
        });
        Utils$.MODULE$.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Shuffle Write Metrics")).foreach((Function1)new Serializable(metrics){
            public static final long serialVersionUID = 0L;
            private final TaskMetrics metrics$1;

            public final void apply(JsonAST.JValue writeJson) {
                ShuffleWriteMetrics writeMetrics = this.metrics$1.shuffleWriteMetrics();
                writeMetrics.incBytesWritten(BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(writeJson).$bslash("Shuffle Bytes Written")).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long())));
                writeMetrics.incRecordsWritten(BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(writeJson).$bslash("Shuffle Records Written")).extractOpt((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long()).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return 0L;
                    }
                })));
                writeMetrics.incWriteTime(BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(writeJson).$bslash("Shuffle Write Time")).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long())));
            }
            {
                this.metrics$1 = metrics$1;
            }
        });
        Utils$.MODULE$.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Output Metrics")).foreach((Function1)new Serializable(metrics){
            public static final long serialVersionUID = 0L;
            private final TaskMetrics metrics$1;

            public final void apply(JsonAST.JValue outJson) {
                OutputMetrics outputMetrics = this.metrics$1.outputMetrics();
                outputMetrics.setBytesWritten(BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(outJson).$bslash("Bytes Written")).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long())));
                outputMetrics.setRecordsWritten(BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(outJson).$bslash("Records Written")).extractOpt((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long()).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return 0L;
                    }
                })));
            }
            {
                this.metrics$1 = metrics$1;
            }
        });
        Utils$.MODULE$.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Input Metrics")).foreach((Function1)new Serializable(metrics){
            public static final long serialVersionUID = 0L;
            private final TaskMetrics metrics$1;

            public final void apply(JsonAST.JValue inJson) {
                InputMetrics inputMetrics = this.metrics$1.inputMetrics();
                inputMetrics.incBytesRead(BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(inJson).$bslash("Bytes Read")).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long())));
                inputMetrics.incRecordsRead(BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(inJson).$bslash("Records Read")).extractOpt((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long()).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return 0L;
                    }
                })));
            }
            {
                this.metrics$1 = metrics$1;
            }
        });
        Utils$.MODULE$.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Updated Blocks")).foreach((Function1)new Serializable(metrics){
            public static final long serialVersionUID = 0L;
            private final TaskMetrics metrics$1;

            public final void apply(JsonAST.JValue blocksJson) {
                this.metrics$1.setUpdatedBlockStatuses((Seq<Tuple2<BlockId, BlockStatus>>)((Seq)((TraversableLike)org.json4s.package$.MODULE$.jvalue2extractable(blocksJson).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(JsonAST.JValue.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<BlockId, BlockStatus> apply(JsonAST.JValue blockJson) {
                        BlockId id = BlockId$.MODULE$.apply((String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(blockJson).$bslash("Block ID")).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class)));
                        BlockStatus status = JsonProtocol$.MODULE$.blockStatusFromJson(org.json4s.package$.MODULE$.jvalue2monadic(blockJson).$bslash("Status"));
                        return new Tuple2((Object)id, (Object)status);
                    }
                }, List$.MODULE$.canBuildFrom())));
            }
            {
                this.metrics$1 = metrics$1;
            }
        });
        return var2_2;
    }

    public TaskEndReason taskEndReasonFromJson(JsonAST.JValue json) {
        String string;
        block11: {
            Product product;
            block3: {
                String unknownReason;
                block10: {
                    String executorLostFailure;
                    block9: {
                        String taskCommitDenied;
                        block8: {
                            String taskKilled;
                            block7: {
                                String taskResultLost;
                                block6: {
                                    String exceptionFailure;
                                    block5: {
                                        String fetchFailed;
                                        block4: {
                                            String resubmitted;
                                            block2: {
                                                String success = Utils$.MODULE$.getFormattedClassName(Success$.MODULE$);
                                                resubmitted = Utils$.MODULE$.getFormattedClassName(Resubmitted$.MODULE$);
                                                fetchFailed = Utils$.MODULE$.getFormattedClassName((Object)FetchFailed$.MODULE$);
                                                exceptionFailure = Utils$.MODULE$.getFormattedClassName((Object)ExceptionFailure$.MODULE$);
                                                taskResultLost = Utils$.MODULE$.getFormattedClassName(TaskResultLost$.MODULE$);
                                                taskKilled = Utils$.MODULE$.getFormattedClassName(TaskKilled$.MODULE$);
                                                taskCommitDenied = Utils$.MODULE$.getFormattedClassName((Object)TaskCommitDenied$.MODULE$);
                                                executorLostFailure = Utils$.MODULE$.getFormattedClassName((Object)ExecutorLostFailure$.MODULE$);
                                                unknownReason = Utils$.MODULE$.getFormattedClassName(UnknownReason$.MODULE$);
                                                string = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Reason")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class));
                                                String string2 = success;
                                                String string3 = string;
                                                if (string2 != null ? !string2.equals(string3) : string3 != null) break block2;
                                                product = Success$.MODULE$;
                                                break block3;
                                            }
                                            String string4 = resubmitted;
                                            String string5 = string;
                                            if (string4 != null ? !string4.equals(string5) : string5 != null) break block4;
                                            product = Resubmitted$.MODULE$;
                                            break block3;
                                        }
                                        String string6 = fetchFailed;
                                        String string7 = string;
                                        if (string6 != null ? !string6.equals(string7) : string7 != null) break block5;
                                        BlockManagerId blockManagerAddress = this.blockManagerIdFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Block Manager Address"));
                                        int shuffleId = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Shuffle ID")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Int()));
                                        int mapId = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Map ID")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Int()));
                                        int reduceId = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Reduce ID")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Int()));
                                        Option message = Utils$.MODULE$.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Message")).map((Function1)new Serializable(){
                                            public static final long serialVersionUID = 0L;

                                            public final String apply(JsonAST.JValue x$25) {
                                                return (String)org.json4s.package$.MODULE$.jvalue2extractable(x$25).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class));
                                            }
                                        });
                                        product = new FetchFailed(blockManagerAddress, shuffleId, mapId, reduceId, (String)message.getOrElse((Function0)new Serializable(){
                                            public static final long serialVersionUID = 0L;

                                            public final String apply() {
                                                return "Unknown reason";
                                            }
                                        }));
                                        break block3;
                                    }
                                    String string8 = exceptionFailure;
                                    String string9 = string;
                                    if (string8 != null ? !string8.equals(string9) : string9 != null) break block6;
                                    String className = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Class Name")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class));
                                    String description = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Description")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class));
                                    StackTraceElement[] stackTrace = this.stackTraceFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Stack Trace"));
                                    String fullStackTrace = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Full Stack Trace")).extractOpt((Formats)this.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class)).orNull(Predef$.MODULE$.conforms());
                                    Seq accumUpdates = (Seq)Utils$.MODULE$.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Accumulator Updates")).map((Function1)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final List<AccumulableInfo> apply(JsonAST.JValue x$26) {
                                            return (List)((TraversableLike)org.json4s.package$.MODULE$.jvalue2extractable(x$26).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(JsonAST.JValue.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))).map((Function1)new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final AccumulableInfo apply(JsonAST.JValue json) {
                                                    return JsonProtocol$.MODULE$.accumulableInfoFromJson(json);
                                                }
                                            }, List$.MODULE$.canBuildFrom());
                                        }
                                    }).getOrElse((Function0)new Serializable(json){
                                        public static final long serialVersionUID = 0L;
                                        private final JsonAST.JValue json$2;

                                        public final Seq<AccumulableInfo> apply() {
                                            return (Seq)JsonProtocol$.MODULE$.taskMetricsFromJson(org.json4s.package$.MODULE$.jvalue2monadic(this.json$2).$bslash("Metrics")).accumulators().map((Function1)new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final AccumulableInfo apply(AccumulatorV2<?, ?> acc) {
                                                    return acc.toInfo((Option<Object>)new Some(acc.value()), (Option<Object>)None$.MODULE$);
                                                }
                                            }, Seq$.MODULE$.canBuildFrom());
                                        }
                                        {
                                            this.json$2 = json$2;
                                        }
                                    });
                                    product = new ExceptionFailure(className, description, stackTrace, fullStackTrace, (Option<ThrowableSerializationWrapper>)None$.MODULE$, (Seq<AccumulableInfo>)accumUpdates, ExceptionFailure$.MODULE$.apply$default$7());
                                    break block3;
                                }
                                String string10 = taskResultLost;
                                String string11 = string;
                                if (string10 != null ? !string10.equals(string11) : string11 != null) break block7;
                                product = TaskResultLost$.MODULE$;
                                break block3;
                            }
                            String string12 = taskKilled;
                            String string13 = string;
                            if (string12 != null ? !string12.equals(string13) : string13 != null) break block8;
                            product = TaskKilled$.MODULE$;
                            break block3;
                        }
                        String string14 = taskCommitDenied;
                        String string15 = string;
                        if (string14 != null ? !string14.equals(string15) : string15 != null) break block9;
                        int jobId = BoxesRunTime.unboxToInt((Object)Utils$.MODULE$.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Job ID")).map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final int apply(JsonAST.JValue x$27) {
                                return BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$27).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Int()));
                            }
                        }).getOrElse((Function0)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return -1;
                            }
                        }));
                        int partitionId = BoxesRunTime.unboxToInt((Object)Utils$.MODULE$.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Partition ID")).map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final int apply(JsonAST.JValue x$28) {
                                return BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$28).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Int()));
                            }
                        }).getOrElse((Function0)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return -1;
                            }
                        }));
                        int attemptNo = BoxesRunTime.unboxToInt((Object)Utils$.MODULE$.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Attempt Number")).map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final int apply(JsonAST.JValue x$29) {
                                return BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$29).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Int()));
                            }
                        }).getOrElse((Function0)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return -1;
                            }
                        }));
                        product = new TaskCommitDenied(jobId, partitionId, attemptNo);
                        break block3;
                    }
                    String string16 = executorLostFailure;
                    String string17 = string;
                    if (string16 != null ? !string16.equals(string17) : string17 != null) break block10;
                    Option exitCausedByApp = Utils$.MODULE$.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Exit Caused By App")).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(JsonAST.JValue x$30) {
                            return BoxesRunTime.unboxToBoolean((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$30).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Boolean()));
                        }
                    });
                    Option executorId = Utils$.MODULE$.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Executor ID")).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(JsonAST.JValue x$31) {
                            return (String)org.json4s.package$.MODULE$.jvalue2extractable(x$31).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class));
                        }
                    });
                    Option reason = Utils$.MODULE$.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Loss Reason")).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(JsonAST.JValue x$32) {
                            return (String)org.json4s.package$.MODULE$.jvalue2extractable(x$32).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class));
                        }
                    });
                    product = new ExecutorLostFailure((String)executorId.getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Unknown";
                        }
                    }), BoxesRunTime.unboxToBoolean((Object)exitCausedByApp.getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply() {
                            return this.apply$mcZ$sp();
                        }

                        public boolean apply$mcZ$sp() {
                            return true;
                        }
                    })), (Option<String>)reason);
                    break block3;
                }
                String string18 = unknownReason;
                String string19 = string;
                if (string18 != null ? !string18.equals(string19) : string19 != null) break block11;
                product = UnknownReason$.MODULE$;
            }
            return product;
        }
        throw new MatchError((Object)string);
    }

    public BlockManagerId blockManagerIdFromJson(JsonAST.JValue json) {
        JsonAST.JValue jValue = json;
        JsonAST.JNothing$ jNothing$ = JsonAST.JNothing$.MODULE$;
        if (!(jValue != null ? !jValue.equals(jNothing$) : jNothing$ != null)) {
            return null;
        }
        String executorId = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Executor ID")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class));
        String host = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Host")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class));
        int port = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Port")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Int()));
        return BlockManagerId$.MODULE$.apply(executorId, host, port, BlockManagerId$.MODULE$.apply$default$4());
    }

    public JobResult jobResultFromJson(JsonAST.JValue json) {
        String string;
        block4: {
            Product product;
            block3: {
                String jobFailed2;
                block2: {
                    String jobSucceeded = Utils$.MODULE$.getFormattedClassName(JobSucceeded$.MODULE$);
                    jobFailed2 = Utils$.MODULE$.getFormattedClassName((Object)JobFailed$.MODULE$);
                    string = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Result")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class));
                    String string2 = jobSucceeded;
                    String string3 = string;
                    if (string2 != null ? !string2.equals(string3) : string3 != null) break block2;
                    product = JobSucceeded$.MODULE$;
                    break block3;
                }
                String string4 = jobFailed2;
                String string5 = string;
                if (string4 != null ? !string4.equals(string5) : string5 != null) break block4;
                Exception exception2 = this.exceptionFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Exception"));
                product = new JobFailed(exception2);
            }
            return product;
        }
        throw new MatchError((Object)string);
    }

    public RDDInfo rddInfoFromJson(JsonAST.JValue json) {
        int rddId = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("RDD ID")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Int()));
        String name = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Name")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class));
        Option scope = Utils$.MODULE$.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Scope")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(JsonAST.JValue x$33) {
                return (String)org.json4s.package$.MODULE$.jvalue2extractable(x$33).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class));
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final RDDOperationScope apply(String s) {
                return RDDOperationScope$.MODULE$.fromJson(s);
            }
        });
        String callsite = (String)Utils$.MODULE$.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Callsite")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(JsonAST.JValue x$34) {
                return (String)org.json4s.package$.MODULE$.jvalue2extractable(x$34).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class));
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        Seq parentIds = (Seq)Utils$.MODULE$.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Parent IDs")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Object> apply(JsonAST.JValue l) {
                return (List)((TraversableLike)org.json4s.package$.MODULE$.jvalue2extractable(l).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(JsonAST.JValue.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(JsonAST.JValue x$35) {
                        return BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$35).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Int()));
                    }
                }, List$.MODULE$.canBuildFrom());
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.empty();
            }
        });
        StorageLevel storageLevel = this.storageLevelFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Storage Level"));
        int numPartitions = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Number of Partitions")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Int()));
        int numCachedPartitions = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Number of Cached Partitions")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Int()));
        long memSize = BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Memory Size")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long()));
        long diskSize = BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Disk Size")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long()));
        RDDInfo rddInfo = new RDDInfo(rddId, name, numPartitions, storageLevel, (Seq<Object>)parentIds, callsite, (Option<RDDOperationScope>)scope);
        rddInfo.numCachedPartitions_$eq(numCachedPartitions);
        rddInfo.memSize_$eq(memSize);
        rddInfo.diskSize_$eq(diskSize);
        return rddInfo;
    }

    public StorageLevel storageLevelFromJson(JsonAST.JValue json) {
        boolean useDisk = BoxesRunTime.unboxToBoolean((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Use Disk")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Boolean()));
        boolean useMemory = BoxesRunTime.unboxToBoolean((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Use Memory")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Boolean()));
        boolean deserialized = BoxesRunTime.unboxToBoolean((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Deserialized")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Boolean()));
        int replication = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Replication")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Int()));
        return StorageLevel$.MODULE$.apply(useDisk, useMemory, deserialized, replication);
    }

    public BlockStatus blockStatusFromJson(JsonAST.JValue json) {
        StorageLevel storageLevel = this.storageLevelFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Storage Level"));
        long memorySize = BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Memory Size")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long()));
        long diskSize = BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Disk Size")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long()));
        return new BlockStatus(storageLevel, memorySize, diskSize);
    }

    public ExecutorInfo executorInfoFromJson(JsonAST.JValue json) {
        String executorHost = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Host")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class));
        int totalCores = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Total Cores")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Int()));
        scala.collection.immutable.Map logUrls = this.mapFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Log Urls")).toMap(Predef$.MODULE$.conforms());
        return new ExecutorInfo(executorHost, totalCores, (scala.collection.immutable.Map<String, String>)logUrls);
    }

    public Map<String, String> mapFromJson(JsonAST.JValue json) {
        List jsonFields = ((JsonAST.JObject)json).obj();
        return ((TraversableOnce)jsonFields.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(Tuple2<String, JsonAST.JValue> x0$6) {
                Tuple2<String, JsonAST.JValue> tuple2 = x0$6;
                Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                if (!option.isEmpty()) {
                    String k = (String)((Tuple2)option.get())._1();
                    JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                    if (jValue instanceof JsonAST.JString) {
                        JsonAST.JString jString = (JsonAST.JString)jValue;
                        String v = jString.s();
                        Tuple2 tuple22 = new Tuple2((Object)k, (Object)v);
                        return tuple22;
                    }
                }
                throw new MatchError(tuple2);
            }
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }

    public Properties propertiesFromJson(JsonAST.JValue json) {
        return (Properties)Utils$.MODULE$.jsonOption(json).map((Function1)new Serializable(json){
            public static final long serialVersionUID = 0L;
            private final JsonAST.JValue json$1;

            /*
             * WARNING - void declaration
             */
            public final Properties apply(JsonAST.JValue value2) {
                void var2_2;
                Properties properties = new Properties();
                JsonProtocol$.MODULE$.mapFromJson(this.json$1).foreach((Function1)new Serializable(this, properties){
                    public static final long serialVersionUID = 0L;
                    private final Properties properties$1;

                    public final Object apply(Tuple2<String, String> x0$7) {
                        Tuple2<String, String> tuple2 = x0$7;
                        if (tuple2 != null) {
                            String k = (String)tuple2._1();
                            String v = (String)tuple2._2();
                            Object object = this.properties$1.setProperty(k, v);
                            return object;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.properties$1 = properties$1;
                    }
                });
                return var2_2;
            }
            {
                this.json$1 = json$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        });
    }

    public UUID UUIDFromJson(JsonAST.JValue json) {
        long leastSignificantBits = BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Least Significant Bits")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long()));
        long mostSignificantBits = BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Most Significant Bits")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Long()));
        return new UUID(leastSignificantBits, mostSignificantBits);
    }

    public StackTraceElement[] stackTraceFromJson(JsonAST.JValue json) {
        return (StackTraceElement[])((TraversableOnce)((TraversableLike)org.json4s.package$.MODULE$.jvalue2extractable(json).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(JsonAST.JValue.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StackTraceElement apply(JsonAST.JValue line) {
                String declaringClass = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(line).$bslash("Declaring Class")).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class));
                String methodName = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(line).$bslash("Method Name")).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class));
                String fileName = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(line).$bslash("File Name")).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class));
                int lineNumber = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(line).$bslash("Line Number")).extract((Formats)JsonProtocol$.MODULE$.org$apache$spark$util$JsonProtocol$$format(), (Manifest)ManifestFactory$.MODULE$.Int()));
                return new StackTraceElement(declaringClass, methodName, fileName, lineNumber);
            }
        }, List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(StackTraceElement.class));
    }

    /*
     * WARNING - void declaration
     */
    public Exception exceptionFromJson(JsonAST.JValue json) {
        void var2_2;
        Exception e = new Exception((String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Message")).extract((Formats)this.org$apache$spark$util$JsonProtocol$$format(), ManifestFactory$.MODULE$.classType(String.class)));
        e.setStackTrace(this.stackTraceFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Stack Trace")));
        return var2_2;
    }

    private JsonProtocol$() {
        MODULE$ = this;
        this.org$apache$spark$util$JsonProtocol$$format = DefaultFormats$.MODULE$;
        this.mapper = new ObjectMapper().registerModule((Module)DefaultScalaModule$.MODULE$);
    }
}

