/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui;

import java.net.URLDecoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.package$;
import org.apache.spark.ui.SparkUITab;
import org.apache.spark.ui.ToolTips$;
import org.apache.spark.ui.UIUtils$;
import org.apache.spark.ui.WebUITab;
import org.apache.spark.ui.scope.RDDOperationEdge;
import org.apache.spark.ui.scope.RDDOperationGraph;
import org.apache.spark.ui.scope.RDDOperationGraph$;
import org.apache.spark.ui.scope.RDDOperationNode;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.SeqView$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.TraversableViewLike;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Nothing$;
import scala.runtime.TraitSetter;
import scala.util.control.NonFatal$;
import scala.xml.Attribute$;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.Text$;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;
import scala.xml.XML$;
import scala.xml.transform.RewriteRule;
import scala.xml.transform.RuleTransformer;

public final class UIUtils$
implements Logging {
    public static final UIUtils$ MODULE$;
    private final String TABLE_CLASS_NOT_STRIPED;
    private final String TABLE_CLASS_STRIPED;
    private final String TABLE_CLASS_STRIPED_SORTABLE;
    private final ThreadLocal<SimpleDateFormat> dateFormat;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new UIUtils$();
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    public String TABLE_CLASS_NOT_STRIPED() {
        return this.TABLE_CLASS_NOT_STRIPED;
    }

    public String TABLE_CLASS_STRIPED() {
        return this.TABLE_CLASS_STRIPED;
    }

    public String TABLE_CLASS_STRIPED_SORTABLE() {
        return this.TABLE_CLASS_STRIPED_SORTABLE;
    }

    private ThreadLocal<SimpleDateFormat> dateFormat() {
        return this.dateFormat;
    }

    public String formatDate(Date date) {
        return ((DateFormat)this.dateFormat().get()).format(date);
    }

    public String formatDate(long timestamp) {
        return ((DateFormat)this.dateFormat().get()).format(new Date(timestamp));
    }

    public String formatDuration(long milliseconds) {
        if (milliseconds < 100L) {
            return new StringOps(Predef$.MODULE$.augmentString("%d ms")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)milliseconds)}));
        }
        double seconds = (double)milliseconds / (double)1000;
        if (seconds < 1.0) {
            return new StringOps(Predef$.MODULE$.augmentString("%.1f s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)seconds)}));
        }
        if (seconds < (double)60) {
            return new StringOps(Predef$.MODULE$.augmentString("%.0f s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)seconds)}));
        }
        double minutes = seconds / (double)60;
        if (minutes < (double)10) {
            return new StringOps(Predef$.MODULE$.augmentString("%.1f min")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)minutes)}));
        }
        if (minutes < (double)60) {
            return new StringOps(Predef$.MODULE$.augmentString("%.0f min")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)minutes)}));
        }
        double hours = minutes / (double)60;
        return new StringOps(Predef$.MODULE$.augmentString("%.1f h")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)hours)}));
    }

    public String formatDurationVerbose(long ms) {
        Object object = new Object();
        try {
            try {
                long second = 1000L;
                long minute = 60L * second;
                long hour = 60L * minute;
                long day = 24L * hour;
                long week = 7L * day;
                long year = 365L * day;
                String millisecondsString = ms >= second && ms % second == 0L ? "" : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(ms % second))}));
                String secondString = this.toString$1(ms % minute / second, "second");
                String minuteString = this.toString$1(ms % hour / minute, "minute");
                String hourString = this.toString$1(ms % day / hour, "hour");
                String dayString = this.toString$1(ms % week / day, "day");
                String weekString = this.toString$1(ms % year / week, "week");
                String yearString = this.toString$1(ms / year, "year");
                ((IterableLike)scala.collection.Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToLong((long)second)), (Object)millisecondsString), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToLong((long)minute)), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{secondString, millisecondsString}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToLong((long)hour)), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{minuteString, secondString}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToLong((long)day)), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hourString, minuteString, secondString}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToLong((long)week)), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dayString, hourString, minuteString}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToLong((long)year)), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{weekString, dayString, hourString})))}))).foreach((Function1)new Serializable(ms, object){
                    public static final long serialVersionUID = 0L;
                    private final long ms$1;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(Tuple2<Object, String> x0$1) {
                        Tuple2<Object, String> tuple2 = x0$1;
                        if (tuple2 != null) {
                            long durationLimit = tuple2._1$mcJ$sp();
                            String durationString = (String)tuple2._2();
                            if (this.ms$1 < durationLimit) {
                                throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)durationString);
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.ms$1 = ms$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{yearString, weekString, dayString}));
            }
            catch (Exception exception2) {
                this.logError((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Error converting time to string";
                    }
                }, exception2);
                return "";
            }
        }
        catch (NonLocalReturnControl nonLocalReturnControl) {
            if (nonLocalReturnControl.key() == object) {
                return (String)nonLocalReturnControl.value();
            }
            throw nonLocalReturnControl;
        }
    }

    public String formatNumber(double records) {
        Tuple2 tuple2;
        double trillion = 1.0E12;
        double billion = 1.0E9;
        double million = 1000000.0;
        double thousand = 1000.0;
        Tuple2 tuple22 = records >= (double)2 * trillion ? new Tuple2((Object)BoxesRunTime.boxToDouble((double)(records / trillion)), (Object)" T") : (records >= (double)2 * billion ? new Tuple2((Object)BoxesRunTime.boxToDouble((double)(records / billion)), (Object)" B") : (records >= (double)2 * million ? new Tuple2((Object)BoxesRunTime.boxToDouble((double)(records / million)), (Object)" M") : (tuple2 = records >= (double)2 * thousand ? new Tuple2((Object)BoxesRunTime.boxToDouble((double)(records / thousand)), (Object)" K") : new Tuple2((Object)BoxesRunTime.boxToDouble((double)records), (Object)""))));
        if (tuple2 != null) {
            Tuple2 tuple23;
            double value2 = tuple2._1$mcD$sp();
            String unit = (String)tuple2._2();
            Tuple2 tuple24 = tuple23 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)value2), (Object)unit);
            double value3 = tuple24._1$mcD$sp();
            String unit2 = (String)tuple24._2();
            return unit2.isEmpty() ? new StringOps(Predef$.MODULE$.augmentString("%d")).formatLocal(Locale.US, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((int)value3))})) : new StringOps(Predef$.MODULE$.augmentString("%.1f%s")).formatLocal(Locale.US, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)value3), unit2}));
        }
        throw new MatchError((Object)tuple2);
    }

    public String uiRoot() {
        return (String)scala.sys.package$.MODULE$.props().get("spark.ui.proxyBase").orElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply() {
                return scala.sys.package$.MODULE$.env().get((Object)"APPLICATION_WEB_PROXY_BASE");
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
    }

    public String prependBaseUri(String basePath, String resource) {
        return new StringBuilder().append((Object)this.uiRoot()).append((Object)basePath).append((Object)resource).toString();
    }

    public String prependBaseUri$default$1() {
        return "";
    }

    public String prependBaseUri$default$2() {
        return "";
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Node> commonHeaderNodes() {
        void var1_1;
        NodeBuffer $buf = new NodeBuffer();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("content", (Seq)new Text("text/html; charset=utf-8"), (MetaData)$md);
        $md = new UnprefixedAttribute("http-equiv", (Seq)new Text("Content-type"), (MetaData)$md);
        $buf.$amp$plus((Object)new Elem(null, "meta", (MetaData)$md, (NamespaceBinding)Predef$.MODULE$.$scope(), true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("type", (Seq)new Text("text/css"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("href", this.prependBaseUri("/static/bootstrap.min.css", this.prependBaseUri$default$2()), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md2);
        $buf.$amp$plus((Object)new Elem(null, "link", (MetaData)$md2, (NamespaceBinding)Predef$.MODULE$.$scope(), true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("type", (Seq)new Text("text/css"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("href", this.prependBaseUri("/static/vis.min.css", this.prependBaseUri$default$2()), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md3);
        $buf.$amp$plus((Object)new Elem(null, "link", (MetaData)$md3, (NamespaceBinding)Predef$.MODULE$.$scope(), true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("type", (Seq)new Text("text/css"), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("href", this.prependBaseUri("/static/webui.css", this.prependBaseUri$default$2()), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md4);
        $buf.$amp$plus((Object)new Elem(null, "link", (MetaData)$md4, (NamespaceBinding)Predef$.MODULE$.$scope(), true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("type", (Seq)new Text("text/css"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("href", this.prependBaseUri("/static/timeline-view.css", this.prependBaseUri$default$2()), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md5);
        $buf.$amp$plus((Object)new Elem(null, "link", (MetaData)$md5, (NamespaceBinding)Predef$.MODULE$.$scope(), true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("src", this.prependBaseUri("/static/sorttable.js", this.prependBaseUri$default$2()), (MetaData)$md6);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md6, (NamespaceBinding)Predef$.MODULE$.$scope(), false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("src", this.prependBaseUri("/static/jquery-1.11.1.min.js", this.prependBaseUri$default$2()), (MetaData)$md7);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md7, (NamespaceBinding)Predef$.MODULE$.$scope(), false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("src", this.prependBaseUri("/static/vis.min.js", this.prependBaseUri$default$2()), (MetaData)$md8);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md8, (NamespaceBinding)Predef$.MODULE$.$scope(), false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md9 = Null$.MODULE$;
        $md9 = new UnprefixedAttribute("src", this.prependBaseUri("/static/bootstrap-tooltip.js", this.prependBaseUri$default$2()), (MetaData)$md9);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md9, (NamespaceBinding)Predef$.MODULE$.$scope(), false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md10 = Null$.MODULE$;
        $md10 = new UnprefixedAttribute("src", this.prependBaseUri("/static/initialize-tooltips.js", this.prependBaseUri$default$2()), (MetaData)$md10);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md10, (NamespaceBinding)Predef$.MODULE$.$scope(), false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md11 = Null$.MODULE$;
        $md11 = new UnprefixedAttribute("src", this.prependBaseUri("/static/table.js", this.prependBaseUri$default$2()), (MetaData)$md11);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md11, (NamespaceBinding)Predef$.MODULE$.$scope(), false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md12 = Null$.MODULE$;
        $md12 = new UnprefixedAttribute("src", this.prependBaseUri("/static/additional-metrics.js", this.prependBaseUri$default$2()), (MetaData)$md12);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md12, (NamespaceBinding)Predef$.MODULE$.$scope(), false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md13 = Null$.MODULE$;
        $md13 = new UnprefixedAttribute("src", this.prependBaseUri("/static/timeline-view.js", this.prependBaseUri$default$2()), (MetaData)$md13);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md13, (NamespaceBinding)Predef$.MODULE$.$scope(), false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md14 = Null$.MODULE$;
        $md14 = new UnprefixedAttribute("src", this.prependBaseUri("/static/log-view.js", this.prependBaseUri$default$2()), (MetaData)$md14);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md14, (NamespaceBinding)Predef$.MODULE$.$scope(), false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md15 = Null$.MODULE$;
        $md15 = new UnprefixedAttribute("src", this.prependBaseUri("/static/webui.js", this.prependBaseUri$default$2()), (MetaData)$md15);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md15, (NamespaceBinding)Predef$.MODULE$.$scope(), false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("setUIRoot('"));
        $buf2.$amp$plus((Object)this.uiRoot());
        $buf2.$amp$plus((Object)new Text("')"));
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, false, (Seq)$buf2));
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Node> vizHeaderNodes() {
        void var1_1;
        NodeBuffer $buf = new NodeBuffer();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("type", (Seq)new Text("text/css"), (MetaData)$md);
        $md = new UnprefixedAttribute("href", this.prependBaseUri("/static/spark-dag-viz.css", this.prependBaseUri$default$2()), (MetaData)$md);
        $md = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md);
        $buf.$amp$plus((Object)new Elem(null, "link", (MetaData)$md, (NamespaceBinding)Predef$.MODULE$.$scope(), true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("src", this.prependBaseUri("/static/d3.min.js", this.prependBaseUri$default$2()), (MetaData)$md2);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md2, (NamespaceBinding)Predef$.MODULE$.$scope(), false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("src", this.prependBaseUri("/static/dagre-d3.min.js", this.prependBaseUri$default$2()), (MetaData)$md3);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md3, (NamespaceBinding)Predef$.MODULE$.$scope(), false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("src", this.prependBaseUri("/static/graphlib-dot.min.js", this.prependBaseUri$default$2()), (MetaData)$md4);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md4, (NamespaceBinding)Predef$.MODULE$.$scope(), false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("src", this.prependBaseUri("/static/spark-dag-viz.js", this.prependBaseUri$default$2()), (MetaData)$md5);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md5, (NamespaceBinding)Predef$.MODULE$.$scope(), false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Node> dataTablesHeaderNodes() {
        void var1_1;
        NodeBuffer $buf = new NodeBuffer();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("type", (Seq)new Text("text/css"), (MetaData)$md);
        $md = new UnprefixedAttribute("href", this.prependBaseUri("/static/jquery.dataTables.1.10.4.min.css", this.prependBaseUri$default$2()), (MetaData)$md);
        $md = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md);
        $buf.$amp$plus((Object)new Elem(null, "link", (MetaData)$md, (NamespaceBinding)Predef$.MODULE$.$scope(), true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("type", (Seq)new Text("text/css"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("href", this.prependBaseUri("/static/dataTables.bootstrap.css", this.prependBaseUri$default$2()), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md2);
        $buf.$amp$plus((Object)new Elem(null, "link", (MetaData)$md2, (NamespaceBinding)Predef$.MODULE$.$scope(), true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("type", (Seq)new Text("text/css"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("href", this.prependBaseUri("/static/jsonFormatter.min.css", this.prependBaseUri$default$2()), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md3);
        $buf.$amp$plus((Object)new Elem(null, "link", (MetaData)$md3, (NamespaceBinding)Predef$.MODULE$.$scope(), true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("src", this.prependBaseUri("/static/jquery.dataTables.1.10.4.min.js", this.prependBaseUri$default$2()), (MetaData)$md4);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md4, (NamespaceBinding)Predef$.MODULE$.$scope(), false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("src", this.prependBaseUri("/static/jquery.cookies.2.2.0.min.js", this.prependBaseUri$default$2()), (MetaData)$md5);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md5, (NamespaceBinding)Predef$.MODULE$.$scope(), false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("src", this.prependBaseUri("/static/jquery.blockUI.min.js", this.prependBaseUri$default$2()), (MetaData)$md6);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md6, (NamespaceBinding)Predef$.MODULE$.$scope(), false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("src", this.prependBaseUri("/static/dataTables.bootstrap.min.js", this.prependBaseUri$default$2()), (MetaData)$md7);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md7, (NamespaceBinding)Predef$.MODULE$.$scope(), false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("src", this.prependBaseUri("/static/jsonFormatter.min.js", this.prependBaseUri$default$2()), (MetaData)$md8);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md8, (NamespaceBinding)Predef$.MODULE$.$scope(), false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md9 = Null$.MODULE$;
        $md9 = new UnprefixedAttribute("src", this.prependBaseUri("/static/jquery.mustache.js", this.prependBaseUri$default$2()), (MetaData)$md9);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md9, (NamespaceBinding)Predef$.MODULE$.$scope(), false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        return var1_1;
    }

    public Seq<Node> headerSparkPage(String title, Function0<Seq<Node>> content, SparkUITab activeTab, Option<Object> refreshInterval, Option<String> helpText, boolean showVisualization, boolean useDataTables) {
        String appName = activeTab.appName();
        String shortAppName = appName.length() < 36 ? appName : new StringBuilder().append((Object)((String)new StringOps(Predef$.MODULE$.augmentString(appName)).take(32))).append((Object)"...").toString();
        Seq header = (Seq)activeTab.headerTabs().map((Function1)new Serializable(activeTab){
            public static final long serialVersionUID = 0L;
            private final SparkUITab activeTab$1;

            public final Elem apply(WebUITab tab) {
                Null$ $md = Null$.MODULE$;
                WebUITab webUITab = tab;
                SparkUITab sparkUITab = this.activeTab$1;
                $md = new UnprefixedAttribute("class", !(webUITab != null ? !webUITab.equals(sparkUITab) : sparkUITab != null) ? "active" : "", (MetaData)$md);
                TopScope$ topScope$ = Predef$.MODULE$.$scope();
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("\n        "));
                Null$ $md2 = Null$.MODULE$;
                $md2 = new UnprefixedAttribute("href", UIUtils$.MODULE$.prependBaseUri(this.activeTab$1.basePath(), new StringBuilder().append((Object)"/").append((Object)tab.prefix()).append((Object)"/").toString()), (MetaData)$md2);
                TopScope$ topScope$2 = Predef$.MODULE$.$scope();
                NodeBuffer $buf2 = new NodeBuffer();
                $buf2.$amp$plus((Object)tab.name());
                $buf.$amp$plus((Object)new Elem(null, "a", (MetaData)$md2, (NamespaceBinding)topScope$2, false, (Seq)$buf2));
                $buf.$amp$plus((Object)new Text("\n      "));
                return new Elem(null, "li", (MetaData)$md, (NamespaceBinding)topScope$, false, (Seq)$buf);
            }
            {
                this.activeTab$1 = activeTab$1;
            }
        }, scala.collection.Seq$.MODULE$.canBuildFrom());
        Seq helpButton = (Seq)helpText.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Node> apply(String x$2) {
                return UIUtils$.MODULE$.tooltip(x$2, "bottom");
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)scala.collection.Seq$.MODULE$.empty();
            }
        });
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        TopScope$ topScope$2 = Predef$.MODULE$.$scope();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus(this.commonHeaderNodes());
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)(showVisualization ? this.vizHeaderNodes() : scala.collection.Seq$.MODULE$.empty()));
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)(useDataTables ? this.dataTablesHeaderNodes() : scala.collection.Seq$.MODULE$.empty()));
        $buf2.$amp$plus((Object)new Text("\n        "));
        TopScope$ topScope$3 = Predef$.MODULE$.$scope();
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)appName);
        $buf3.$amp$plus((Object)new Text(" - "));
        $buf3.$amp$plus((Object)title);
        $buf2.$amp$plus((Object)new Elem(null, "title", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$3, false, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "head", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$2, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        TopScope$ topScope$4 = Predef$.MODULE$.$scope();
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n        "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("navbar navbar-static-top"), (MetaData)$md);
        TopScope$ topScope$5 = Predef$.MODULE$.$scope();
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n          "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("navbar-inner"), (MetaData)$md2);
        TopScope$ topScope$6 = Predef$.MODULE$.$scope();
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n            "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("brand"), (MetaData)$md3);
        TopScope$ topScope$7 = Predef$.MODULE$.$scope();
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n              "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("class", (Seq)new Text("brand"), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("href", this.prependBaseUri("/", this.prependBaseUri$default$2()), (MetaData)$md4);
        TopScope$ topScope$8 = Predef$.MODULE$.$scope();
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n                "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("src", this.prependBaseUri("/static/spark-logo-77x50px-hd.png", this.prependBaseUri$default$2()), (MetaData)$md5);
        $buf8.$amp$plus((Object)new Elem(null, "img", (MetaData)$md5, (NamespaceBinding)Predef$.MODULE$.$scope(), true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf8.$amp$plus((Object)new Text("\n                "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("class", (Seq)new Text("version"), (MetaData)$md6);
        TopScope$ topScope$9 = Predef$.MODULE$.$scope();
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)package$.MODULE$.SPARK_VERSION());
        $buf8.$amp$plus((Object)new Elem(null, "span", (MetaData)$md6, (NamespaceBinding)topScope$9, false, (Seq)$buf9));
        $buf8.$amp$plus((Object)new Text("\n              "));
        $buf7.$amp$plus((Object)new Elem(null, "a", (MetaData)$md4, (NamespaceBinding)topScope$8, false, (Seq)$buf8));
        $buf7.$amp$plus((Object)new Text("\n            "));
        $buf6.$amp$plus((Object)new Elem(null, "div", (MetaData)$md3, (NamespaceBinding)topScope$7, false, (Seq)$buf7));
        $buf6.$amp$plus((Object)new Text("\n            "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("class", (Seq)new Text("navbar-text pull-right"), (MetaData)$md7);
        TopScope$ topScope$10 = Predef$.MODULE$.$scope();
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("\n              "));
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("title", appName, (MetaData)$md8);
        TopScope$ topScope$11 = Predef$.MODULE$.$scope();
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)shortAppName);
        $buf10.$amp$plus((Object)new Elem(null, "strong", (MetaData)$md8, (NamespaceBinding)topScope$11, false, (Seq)$buf11));
        $buf10.$amp$plus((Object)new Text(" application UI\n            "));
        $buf6.$amp$plus((Object)new Elem(null, "p", (MetaData)$md7, (NamespaceBinding)topScope$10, false, (Seq)$buf10));
        $buf6.$amp$plus((Object)new Text("\n            "));
        Null$ $md9 = Null$.MODULE$;
        $md9 = new UnprefixedAttribute("class", (Seq)new Text("nav"), (MetaData)$md9);
        TopScope$ topScope$12 = Predef$.MODULE$.$scope();
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)header);
        $buf6.$amp$plus((Object)new Elem(null, "ul", (MetaData)$md9, (NamespaceBinding)topScope$12, false, (Seq)$buf12));
        $buf6.$amp$plus((Object)new Text("\n          "));
        $buf5.$amp$plus((Object)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)topScope$6, false, (Seq)$buf6));
        $buf5.$amp$plus((Object)new Text("\n        "));
        $buf4.$amp$plus((Object)new Elem(null, "div", (MetaData)$md, (NamespaceBinding)topScope$5, false, (Seq)$buf5));
        $buf4.$amp$plus((Object)new Text("\n        "));
        Null$ $md10 = Null$.MODULE$;
        $md10 = new UnprefixedAttribute("class", (Seq)new Text("container-fluid"), (MetaData)$md10);
        TopScope$ topScope$13 = Predef$.MODULE$.$scope();
        NodeBuffer $buf13 = new NodeBuffer();
        $buf13.$amp$plus((Object)new Text("\n          "));
        Null$ $md11 = Null$.MODULE$;
        $md11 = new UnprefixedAttribute("class", (Seq)new Text("row-fluid"), (MetaData)$md11);
        TopScope$ topScope$14 = Predef$.MODULE$.$scope();
        NodeBuffer $buf14 = new NodeBuffer();
        $buf14.$amp$plus((Object)new Text("\n            "));
        Null$ $md12 = Null$.MODULE$;
        $md12 = new UnprefixedAttribute("class", (Seq)new Text("span12"), (MetaData)$md12);
        TopScope$ topScope$15 = Predef$.MODULE$.$scope();
        NodeBuffer $buf15 = new NodeBuffer();
        $buf15.$amp$plus((Object)new Text("\n              "));
        Null$ $md13 = Null$.MODULE$;
        $md13 = new UnprefixedAttribute("style", (Seq)new Text("vertical-align: bottom; display: inline-block;"), (MetaData)$md13);
        TopScope$ topScope$16 = Predef$.MODULE$.$scope();
        NodeBuffer $buf16 = new NodeBuffer();
        $buf16.$amp$plus((Object)new Text("\n                "));
        $buf16.$amp$plus((Object)title);
        $buf16.$amp$plus((Object)new Text("\n                "));
        $buf16.$amp$plus((Object)helpButton);
        $buf16.$amp$plus((Object)new Text("\n              "));
        $buf15.$amp$plus((Object)new Elem(null, "h3", (MetaData)$md13, (NamespaceBinding)topScope$16, false, (Seq)$buf16));
        $buf15.$amp$plus((Object)new Text("\n            "));
        $buf14.$amp$plus((Object)new Elem(null, "div", (MetaData)$md12, (NamespaceBinding)topScope$15, false, (Seq)$buf15));
        $buf14.$amp$plus((Object)new Text("\n          "));
        $buf13.$amp$plus((Object)new Elem(null, "div", (MetaData)$md11, (NamespaceBinding)topScope$14, false, (Seq)$buf14));
        $buf13.$amp$plus((Object)new Text("\n          "));
        $buf13.$amp$plus(content.apply());
        $buf13.$amp$plus((Object)new Text("\n        "));
        $buf4.$amp$plus((Object)new Elem(null, "div", (MetaData)$md10, (NamespaceBinding)topScope$13, false, (Seq)$buf13));
        $buf4.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "body", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$4, false, (Seq)$buf4));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "html", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, false, (Seq)$buf);
    }

    public Option<Object> headerSparkPage$default$4() {
        return None$.MODULE$;
    }

    public Option<String> headerSparkPage$default$5() {
        return None$.MODULE$;
    }

    public boolean headerSparkPage$default$6() {
        return false;
    }

    public boolean headerSparkPage$default$7() {
        return false;
    }

    public Seq<Node> basicSparkPage(Function0<Seq<Node>> content, String title, boolean useDataTables) {
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        TopScope$ topScope$2 = Predef$.MODULE$.$scope();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus(this.commonHeaderNodes());
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)(useDataTables ? this.dataTablesHeaderNodes() : scala.collection.Seq$.MODULE$.empty()));
        $buf2.$amp$plus((Object)new Text("\n        "));
        TopScope$ topScope$3 = Predef$.MODULE$.$scope();
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)title);
        $buf2.$amp$plus((Object)new Elem(null, "title", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$3, false, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "head", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$2, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        TopScope$ topScope$4 = Predef$.MODULE$.$scope();
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n        "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("container-fluid"), (MetaData)$md);
        TopScope$ topScope$5 = Predef$.MODULE$.$scope();
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n          "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("row-fluid"), (MetaData)$md2);
        TopScope$ topScope$6 = Predef$.MODULE$.$scope();
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n            "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("span12"), (MetaData)$md3);
        TopScope$ topScope$7 = Predef$.MODULE$.$scope();
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n              "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("style", (Seq)new Text("vertical-align: middle; display: inline-block;"), (MetaData)$md4);
        TopScope$ topScope$8 = Predef$.MODULE$.$scope();
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n                "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("href", this.prependBaseUri("/", this.prependBaseUri$default$2()), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("style", (Seq)new Text("text-decoration: none"), (MetaData)$md5);
        TopScope$ topScope$9 = Predef$.MODULE$.$scope();
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n                  "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("src", this.prependBaseUri("/static/spark-logo-77x50px-hd.png", this.prependBaseUri$default$2()), (MetaData)$md6);
        $buf9.$amp$plus((Object)new Elem(null, "img", (MetaData)$md6, (NamespaceBinding)Predef$.MODULE$.$scope(), true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf9.$amp$plus((Object)new Text("\n                  "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("style", (Seq)new Text("margin-right: 15px;"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("class", (Seq)new Text("version"), (MetaData)$md7);
        TopScope$ topScope$10 = Predef$.MODULE$.$scope();
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)package$.MODULE$.SPARK_VERSION());
        $buf9.$amp$plus((Object)new Elem(null, "span", (MetaData)$md7, (NamespaceBinding)topScope$10, false, (Seq)$buf10));
        $buf9.$amp$plus((Object)new Text("\n                "));
        $buf8.$amp$plus((Object)new Elem(null, "a", (MetaData)$md5, (NamespaceBinding)topScope$9, false, (Seq)$buf9));
        $buf8.$amp$plus((Object)new Text("\n                "));
        $buf8.$amp$plus((Object)title);
        $buf8.$amp$plus((Object)new Text("\n              "));
        $buf7.$amp$plus((Object)new Elem(null, "h3", (MetaData)$md4, (NamespaceBinding)topScope$8, false, (Seq)$buf8));
        $buf7.$amp$plus((Object)new Text("\n            "));
        $buf6.$amp$plus((Object)new Elem(null, "div", (MetaData)$md3, (NamespaceBinding)topScope$7, false, (Seq)$buf7));
        $buf6.$amp$plus((Object)new Text("\n          "));
        $buf5.$amp$plus((Object)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)topScope$6, false, (Seq)$buf6));
        $buf5.$amp$plus((Object)new Text("\n          "));
        $buf5.$amp$plus(content.apply());
        $buf5.$amp$plus((Object)new Text("\n        "));
        $buf4.$amp$plus((Object)new Elem(null, "div", (MetaData)$md, (NamespaceBinding)topScope$5, false, (Seq)$buf5));
        $buf4.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "body", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$4, false, (Seq)$buf4));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "html", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, false, (Seq)$buf);
    }

    public boolean basicSparkPage$default$3() {
        return false;
    }

    public <T> Seq<Node> listingTable(Seq<String> headers2, Function1<T, Seq<Node>> generateDataRow, Iterable<T> data, boolean fixedWidth, Option<String> id, Seq<String> headerClasses, boolean stripeRowsWithCss, boolean sortable) {
        String _tableClass = stripeRowsWithCss ? this.TABLE_CLASS_STRIPED() : this.TABLE_CLASS_NOT_STRIPED();
        String listingTableClass = sortable ? new StringBuilder().append((Object)_tableClass).append((Object)" sortable").toString() : _tableClass;
        double colWidth = (double)100 / (double)headers2.size();
        String colWidthAttr = fixedWidth ? new StringBuilder().append(colWidth).append((Object)"%").toString() : "";
        boolean newlinesInHeader = headers2.exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$3) {
                return x$3.contains("\n");
            }
        });
        Seq headerRow = (Seq)((TraversableViewLike)headers2.view().zipWithIndex(SeqView$.MODULE$.canBuildFrom())).map((Function1)new Serializable(headerClasses, colWidthAttr, newlinesInHeader){
            public static final long serialVersionUID = 0L;
            private final Seq headerClasses$1;
            private final String colWidthAttr$1;
            private final boolean newlinesInHeader$1;

            /*
             * WARNING - void declaration
             */
            public final Elem apply(Tuple2<String, Object> x) {
                void var3_3;
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("class", UIUtils$.MODULE$.org$apache$spark$ui$UIUtils$$getClass$1(x._2$mcI$sp(), this.headerClasses$1), (MetaData)$md);
                $md = new UnprefixedAttribute("width", this.colWidthAttr$1, (MetaData)$md);
                TopScope$ topScope$ = Predef$.MODULE$.$scope();
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)UIUtils$.MODULE$.org$apache$spark$ui$UIUtils$$getHeaderContent$1((String)x._1(), this.newlinesInHeader$1));
                return new Elem(null, "th", (MetaData)$md, (NamespaceBinding)topScope$, false, (Seq)var3_3);
            }
            {
                this.headerClasses$1 = headerClasses$1;
                this.colWidthAttr$1 = colWidthAttr$1;
                this.newlinesInHeader$1 = newlinesInHeader$1;
            }
        }, SeqView$.MODULE$.canBuildFrom());
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("id", id.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Text apply(String data) {
                return Text$.MODULE$.apply(data);
            }
        }), (MetaData)$md);
        $md = new UnprefixedAttribute("class", listingTableClass, (MetaData)$md);
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        TopScope$ topScope$2 = Predef$.MODULE$.$scope();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)headerRow);
        $buf.$amp$plus((Object)new Elem(null, "thead", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$2, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        TopScope$ topScope$3 = Predef$.MODULE$.$scope();
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf3.$amp$plus(data.map((Function1)new Serializable(generateDataRow){
            public static final long serialVersionUID = 0L;
            private final Function1 generateDataRow$1;

            public final Seq<Node> apply(T r) {
                return (Seq)this.generateDataRow$1.apply(r);
            }
            {
                this.generateDataRow$1 = generateDataRow$1;
            }
        }, Iterable$.MODULE$.canBuildFrom()));
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "tbody", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$3, false, (Seq)$buf3));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "table", (MetaData)$md, (NamespaceBinding)topScope$, false, (Seq)$buf);
    }

    public <T> boolean listingTable$default$4() {
        return false;
    }

    public <T> Option<String> listingTable$default$5() {
        return None$.MODULE$;
    }

    public <T> Seq<String> listingTable$default$6() {
        return (Seq)scala.collection.Seq$.MODULE$.empty();
    }

    public <T> boolean listingTable$default$7() {
        return true;
    }

    public <T> boolean listingTable$default$8() {
        return true;
    }

    public Seq<Node> makeProgressBar(int started, int completed, int failed, int skipped, int killed, int total) {
        String completeWidth = new StringOps(Predef$.MODULE$.augmentString("width: %s%%")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)completed / (double)total * (double)100))}));
        int boundedStarted = scala.math.package$.MODULE$.min(started, total - completed);
        String startWidth = new StringOps(Predef$.MODULE$.augmentString("width: %s%%")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)boundedStarted / (double)total * (double)100))}));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("progress"), (MetaData)$md);
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("style", (Seq)new Text("text-align:center; position:absolute; width:100%; left:0;"), (MetaData)$md2);
        TopScope$ topScope$2 = Predef$.MODULE$.$scope();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)BoxesRunTime.boxToInteger((int)completed));
        $buf2.$amp$plus((Object)new Text("/"));
        $buf2.$amp$plus((Object)BoxesRunTime.boxToInteger((int)total));
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)(failed > 0 ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " failed)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)failed)})) : BoxedUnit.UNIT));
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)(skipped > 0 ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " skipped)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)skipped)})) : BoxedUnit.UNIT));
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)(killed > 0 ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " killed)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)killed)})) : BoxedUnit.UNIT));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "span", (MetaData)$md2, (NamespaceBinding)topScope$2, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("style", completeWidth, (MetaData)$md3);
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("bar bar-completed"), (MetaData)$md3);
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)$md3, (NamespaceBinding)Predef$.MODULE$.$scope(), false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("style", startWidth, (MetaData)$md4);
        $md4 = new UnprefixedAttribute("class", (Seq)new Text("bar bar-running"), (MetaData)$md4);
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)$md4, (NamespaceBinding)Predef$.MODULE$.$scope(), false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "div", (MetaData)$md, (NamespaceBinding)topScope$, false, (Seq)$buf);
    }

    public Seq<Node> showDagVizForStage(int stageId, Option<RDDOperationGraph> graph) {
        return this.showDagViz((Seq<RDDOperationGraph>)Option$.MODULE$.option2Iterable(graph).toSeq(), false);
    }

    public Seq<Node> showDagVizForJob(int jobId, Seq<RDDOperationGraph> graphs) {
        return this.showDagViz(graphs, true);
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Node> showDagViz(Seq<RDDOperationGraph> graphs, boolean forJob) {
        void var3_3;
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("onclick", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"toggleDagViz(", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)forJob)})), (MetaData)$md);
        $md = new UnprefixedAttribute("class", (Seq)new Text("expand-dag-viz"), (MetaData)$md);
        $md = new UnprefixedAttribute("id", forJob ? "job-dag-viz" : "stage-dag-viz", (MetaData)$md);
        TopScope$ topScope$2 = Predef$.MODULE$.$scope();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("expand-dag-viz-arrow arrow-closed"), (MetaData)$md2);
        $buf2.$amp$plus((Object)new Elem(null, "span", (MetaData)$md2, (NamespaceBinding)Predef$.MODULE$.$scope(), false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("data-placement", (Seq)new Text("right"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("title", forJob ? ToolTips$.MODULE$.JOB_DAG() : ToolTips$.MODULE$.STAGE_DAG(), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("data-toggle", (Seq)new Text("tooltip"), (MetaData)$md3);
        TopScope$ topScope$3 = Predef$.MODULE$.$scope();
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n          DAG Visualization\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "a", (MetaData)$md3, (NamespaceBinding)topScope$3, false, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "span", (MetaData)$md, (NamespaceBinding)topScope$2, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("id", (Seq)new Text("dag-viz-graph"), (MetaData)$md4);
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)$md4, (NamespaceBinding)Predef$.MODULE$.$scope(), false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("style", (Seq)new Text("display:none"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("id", (Seq)new Text("dag-viz-metadata"), (MetaData)$md5);
        TopScope$ topScope$4 = Predef$.MODULE$.$scope();
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf4.$amp$plus(graphs.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Elem apply(RDDOperationGraph g) {
                String stageId = g.rootCluster().id().replaceAll(RDDOperationGraph$.MODULE$.STAGE_CLUSTER_PREFIX(), "");
                String skipped = ((Object)BoxesRunTime.boxToBoolean((boolean)g.rootCluster().name().contains("skipped"))).toString();
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("skipped", skipped, (MetaData)$md);
                $md = new UnprefixedAttribute("stage-id", stageId, (MetaData)$md);
                $md = new UnprefixedAttribute("class", (Seq)new Text("stage-metadata"), (MetaData)$md);
                TopScope$ topScope$ = Predef$.MODULE$.$scope();
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("\n              "));
                Null$ $md2 = Null$.MODULE$;
                $md2 = new UnprefixedAttribute("class", (Seq)new Text("dot-file"), (MetaData)$md2);
                TopScope$ topScope$2 = Predef$.MODULE$.$scope();
                NodeBuffer $buf2 = new NodeBuffer();
                $buf2.$amp$plus((Object)RDDOperationGraph$.MODULE$.makeDotFile(g));
                $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)topScope$2, false, (Seq)$buf2));
                $buf.$amp$plus((Object)new Text("\n              "));
                $buf.$amp$plus(g.incomingEdges().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    /*
                     * WARNING - void declaration
                     */
                    public final Elem apply(RDDOperationEdge e) {
                        void var3_3;
                        Null$ $md = Null$.MODULE$;
                        $md = new UnprefixedAttribute("class", (Seq)new Text("incoming-edge"), (MetaData)$md);
                        TopScope$ topScope$ = Predef$.MODULE$.$scope();
                        NodeBuffer $buf = new NodeBuffer();
                        $buf.$amp$plus((Object)BoxesRunTime.boxToInteger((int)e.fromId()));
                        $buf.$amp$plus((Object)new Text(","));
                        $buf.$amp$plus((Object)BoxesRunTime.boxToInteger((int)e.toId()));
                        return new Elem(null, "div", (MetaData)$md, (NamespaceBinding)topScope$, false, (Seq)var3_3);
                    }
                }, scala.collection.Seq$.MODULE$.canBuildFrom()));
                $buf.$amp$plus((Object)new Text("\n              "));
                $buf.$amp$plus(g.outgoingEdges().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    /*
                     * WARNING - void declaration
                     */
                    public final Elem apply(RDDOperationEdge e) {
                        void var3_3;
                        Null$ $md = Null$.MODULE$;
                        $md = new UnprefixedAttribute("class", (Seq)new Text("outgoing-edge"), (MetaData)$md);
                        TopScope$ topScope$ = Predef$.MODULE$.$scope();
                        NodeBuffer $buf = new NodeBuffer();
                        $buf.$amp$plus((Object)BoxesRunTime.boxToInteger((int)e.fromId()));
                        $buf.$amp$plus((Object)new Text(","));
                        $buf.$amp$plus((Object)BoxesRunTime.boxToInteger((int)e.toId()));
                        return new Elem(null, "div", (MetaData)$md, (NamespaceBinding)topScope$, false, (Seq)var3_3);
                    }
                }, scala.collection.Seq$.MODULE$.canBuildFrom()));
                $buf.$amp$plus((Object)new Text("\n              "));
                $buf.$amp$plus(g.rootCluster().getCachedNodes().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    /*
                     * WARNING - void declaration
                     */
                    public final Elem apply(RDDOperationNode n) {
                        void var3_3;
                        Null$ $md = Null$.MODULE$;
                        $md = new UnprefixedAttribute("class", (Seq)new Text("cached-rdd"), (MetaData)$md);
                        TopScope$ topScope$ = Predef$.MODULE$.$scope();
                        NodeBuffer $buf = new NodeBuffer();
                        $buf.$amp$plus((Object)BoxesRunTime.boxToInteger((int)n.id()));
                        return new Elem(null, "div", (MetaData)$md, (NamespaceBinding)topScope$, false, (Seq)var3_3);
                    }
                }, scala.collection.Seq$.MODULE$.canBuildFrom()));
                $buf.$amp$plus((Object)new Text("\n            "));
                return new Elem(null, "div", (MetaData)$md, (NamespaceBinding)topScope$, false, (Seq)$buf);
            }
        }, scala.collection.Seq$.MODULE$.canBuildFrom()));
        $buf4.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)$md5, (NamespaceBinding)topScope$4, false, (Seq)$buf4));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, false, (Seq)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Node> tooltip(String text, String position) {
        void var3_3;
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      ("));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("title", text, (MetaData)$md);
        $md = new UnprefixedAttribute("data-placement", position, (MetaData)$md);
        $md = new UnprefixedAttribute("data-toggle", (Seq)new Text("tooltip"), (MetaData)$md);
        TopScope$ topScope$2 = Predef$.MODULE$.$scope();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("?"));
        $buf.$amp$plus((Object)new Elem(null, "a", (MetaData)$md, (NamespaceBinding)topScope$2, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text(")\n    "));
        return new Elem(null, "sup", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, false, (Seq)var3_3);
    }

    public NodeSeq makeDescription(String desc, String basePathUri, boolean plainText) {
        Text text;
        try {
            Elem xml = (Elem)XML$.MODULE$.loadString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<span class=\"description-input\">", "</span>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})));
            Set allowedNodeLabels = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "span"}));
            NodeSeq illegalNodes = (NodeSeq)xml.$bslash$bslash("_").filterNot((Function1)new Serializable(allowedNodeLabels){
                public static final long serialVersionUID = 0L;
                private final Set allowedNodeLabels$1;

                public final boolean apply(Node x0$3) {
                    Node node = x0$3;
                    if (node != null) {
                        Node node2 = node;
                        boolean bl = this.allowedNodeLabels$1.contains((Object)node2.label());
                        return bl;
                    }
                    throw new MatchError((Object)node);
                }
                {
                    this.allowedNodeLabels$1 = allowedNodeLabels$1;
                }
            });
            if (illegalNodes.nonEmpty()) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Only HTML anchors allowed in job descriptions\n").append((Object)((TraversableOnce)illegalNodes.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Node n) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{n.label(), n}));
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString("\n\t")).toString());
            }
            scala.collection.immutable.Seq allLinks = (scala.collection.immutable.Seq)((TraversableLike)((TraversableLike)xml.$bslash$bslash("a").flatMap((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final MetaData apply(Node x$4) {
                    return x$4.attributes();
                }
            }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(MetaData x$5) {
                    String string = x$5.key();
                    String string2 = "href";
                    return !(string != null ? !string.equals(string2) : string2 != null);
                }
            })).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(MetaData x$6) {
                    return x$6.value().toString();
                }
            }, Seq$.MODULE$.canBuildFrom());
            if (allLinks.exists((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$7) {
                    return !x$7.startsWith("/");
                }
            })) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Links in job descriptions must be root-relative:\n").append((Object)allLinks.mkString("\n\t")).toString());
            }
            RewriteRule rule = plainText ? new RewriteRule(){

                /*
                 * WARNING - void declaration
                 * Enabled aggressive block sorting
                 */
                public Seq<Node> transform(Node n) {
                    void var5_8;
                    boolean bl = false;
                    Elem elem = null;
                    Node node = n;
                    if (node instanceof Elem) {
                        bl = true;
                        elem = (Elem)node;
                        if (elem.child().isEmpty()) {
                            Text text = Text$.MODULE$.apply(elem.text());
                            return var5_8;
                        }
                    }
                    if (bl && elem.child().nonEmpty()) {
                        Text text = Text$.MODULE$.apply(NodeSeq$.MODULE$.seqToNodeSeq((Seq)elem.child().flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anon.1 $outer;

                            public final Seq<Node> apply(Node n) {
                                return this.$outer.transform(n);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, scala.collection.Seq$.MODULE$.canBuildFrom())).text());
                        return var5_8;
                    }
                    Node node2 = n;
                    return var5_8;
                }
            } : new RewriteRule(basePathUri){
                private final String basePathUri$1;

                public Seq<Node> transform(Node n) {
                    Node node;
                    Elem elem;
                    Node node2 = n;
                    if (node2 instanceof Elem && (elem = (Elem)node2).$bslash("@href").nonEmpty()) {
                        String relativePath = ((SeqLike)elem.attribute("href").get()).toString();
                        String fullUri = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringOps(Predef$.MODULE$.augmentString(this.basePathUri$1)).stripSuffix("/"), new StringOps(Predef$.MODULE$.augmentString(relativePath)).stripPrefix("/")}));
                        node = elem.$percent((MetaData)Attribute$.MODULE$.apply(null, "href", fullUri, (MetaData)Null$.MODULE$));
                    } else {
                        node = n;
                    }
                    return node;
                }
                {
                    this.basePathUri$1 = basePathUri$1;
                }
            };
            text = NodeSeq$.MODULE$.seqToNodeSeq(new RuleTransformer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RewriteRule[]{rule})).transform((Node)xml));
        }
        catch (Throwable throwable) {
            Text text2;
            Text text3;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            if (plainText) {
                text3 = Text$.MODULE$.apply(desc);
            } else {
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("class", (Seq)new Text("description-input"), (MetaData)$md);
                TopScope$ topScope$ = Predef$.MODULE$.$scope();
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)desc);
                Elem elem = new Elem(null, "span", (MetaData)$md, (NamespaceBinding)topScope$, false, (Seq)$buf);
                text3 = elem;
            }
            text = text2 = text3;
        }
        return text;
    }

    public boolean makeDescription$default$3() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public String decodeURLParameter(String urlParam) {
        String param = urlParam;
        String decodedParam = URLDecoder.decode(param, "UTF-8");
        while (true) {
            String string;
            void var2_2;
            String string2 = param;
            String string3 = decodedParam;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                return var2_2;
            }
            var2_2 = string;
            string = URLDecoder.decode((String)var2_2, "UTF-8");
        }
    }

    public int getTimeZoneOffset() {
        return TimeZone.getDefault().getOffset(System.currentTimeMillis()) / 1000 / 60;
    }

    public String makeHref(boolean proxy, String id, String origHref) {
        return proxy ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/proxy/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id})) : origHref;
    }

    private final String toString$1(long num, String unit) {
        return num == 0L ? "" : (num == 1L ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)num), unit})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", "s"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)num), unit})));
    }

    public final String org$apache$spark$ui$UIUtils$$getClass$1(int index, Seq headerClasses$1) {
        return index < headerClasses$1.size() ? (String)headerClasses$1.apply(index) : "";
    }

    public final Seq org$apache$spark$ui$UIUtils$$getHeaderContent$1(String header, boolean newlinesInHeader$1) {
        Text text;
        if (newlinesInHeader$1) {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("class", (Seq)new Text("unstyled"), (MetaData)$md);
            TopScope$ topScope$ = Predef$.MODULE$.$scope();
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n          "));
            $buf.$amp$plus(Predef$.MODULE$.refArrayOps((Object[])header.split("\n")).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                /*
                 * WARNING - void declaration
                 */
                public final Elem apply(String x0$2) {
                    void var3_3;
                    String string = x0$2;
                    TopScope$ topScope$ = Predef$.MODULE$.$scope();
                    NodeBuffer $buf = new NodeBuffer();
                    $buf.$amp$plus((Object)new Text(" "));
                    $buf.$amp$plus((Object)string);
                    $buf.$amp$plus((Object)new Text(" "));
                    Elem elem = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, false, (Seq)var3_3);
                    return elem;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Elem.class))));
            $buf.$amp$plus((Object)new Text("\n        "));
            Elem elem = new Elem(null, "ul", (MetaData)$md, (NamespaceBinding)topScope$, false, (Seq)$buf);
            text = elem;
        } else {
            text = Text$.MODULE$.apply(header);
        }
        return text;
    }

    private UIUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.TABLE_CLASS_NOT_STRIPED = "table table-bordered table-condensed";
        this.TABLE_CLASS_STRIPED = new StringBuilder().append((Object)this.TABLE_CLASS_NOT_STRIPED()).append((Object)" table-striped").toString();
        this.TABLE_CLASS_STRIPED_SORTABLE = new StringBuilder().append((Object)this.TABLE_CLASS_STRIPED()).append((Object)" sortable").toString();
        this.dateFormat = new anon.3();
    }
}

