/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.RDDInfo;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.storage.StorageStatus;
import org.apache.spark.storage.StorageUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;
import sun.nio.ch.DirectBuffer;

public final class StorageUtils$
implements Logging {
    public static final StorageUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new StorageUtils$();
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    public void dispose(ByteBuffer buffer) {
        if (buffer != null && buffer instanceof MappedByteBuffer) {
            this.logTrace((Function0<String>)new Serializable(buffer){
                public static final long serialVersionUID = 0L;
                private final ByteBuffer buffer$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unmapping ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.buffer$1}));
                }
                {
                    this.buffer$1 = buffer$1;
                }
            });
            if (((DirectBuffer)((Object)buffer)).cleaner() != null) {
                ((DirectBuffer)((Object)buffer)).cleaner().clean();
            }
        }
    }

    public void updateRddInfo(Seq<RDDInfo> rddInfos, Seq<StorageStatus> statuses) {
        rddInfos.foreach((Function1)new Serializable(statuses){
            public static final long serialVersionUID = 0L;
            private final Seq statuses$1;

            public final void apply(RDDInfo rddInfo) {
                int rddId = rddInfo.id();
                StorageLevel storageLevel = (StorageLevel)((TraversableLike)this.statuses$1.flatMap((Function1)new Serializable(this, rddId){
                    public static final long serialVersionUID = 0L;
                    private final int rddId$2;

                    public final Iterable<StorageLevel> apply(StorageStatus x$9) {
                        return Option$.MODULE$.option2Iterable(x$9.rddStorageLevel(this.rddId$2));
                    }
                    {
                        this.rddId$2 = rddId$2;
                    }
                }, Seq$.MODULE$.canBuildFrom())).headOption().getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final StorageLevel apply() {
                        return StorageLevel$.MODULE$.NONE();
                    }
                });
                int numCachedPartitions = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.statuses$1.map((Function1)new Serializable(this, rddId){
                    public static final long serialVersionUID = 0L;
                    private final int rddId$2;

                    public final int apply(StorageStatus x$10) {
                        return x$10.numRddBlocksById(this.rddId$2);
                    }
                    {
                        this.rddId$2 = rddId$2;
                    }
                }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                long memSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.statuses$1.map((Function1)new Serializable(this, rddId){
                    public static final long serialVersionUID = 0L;
                    private final int rddId$2;

                    public final long apply(StorageStatus x$11) {
                        return x$11.memUsedByRdd(this.rddId$2);
                    }
                    {
                        this.rddId$2 = rddId$2;
                    }
                }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                long diskSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.statuses$1.map((Function1)new Serializable(this, rddId){
                    public static final long serialVersionUID = 0L;
                    private final int rddId$2;

                    public final long apply(StorageStatus x$12) {
                        return x$12.diskUsedByRdd(this.rddId$2);
                    }
                    {
                        this.rddId$2 = rddId$2;
                    }
                }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                rddInfo.storageLevel_$eq(storageLevel);
                rddInfo.numCachedPartitions_$eq(numCachedPartitions);
                rddInfo.memSize_$eq(memSize);
                rddInfo.diskSize_$eq(diskSize);
            }
            {
                this.statuses$1 = statuses$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public Map<BlockId, Seq<String>> getRddBlockLocations(int rddId, Seq<StorageStatus> statuses) {
        void var3_3;
        HashMap blockLocations = new HashMap();
        statuses.foreach((Function1)new Serializable(rddId, blockLocations){
            public static final long serialVersionUID = 0L;
            private final int rddId$1;
            public final HashMap blockLocations$1;

            public final void apply(StorageStatus status) {
                status.rddBlocksById(this.rddId$1).foreach((Function1)new Serializable(this, status){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.getRddBlockLocations.1 $outer;
                    private final StorageStatus status$1;

                    public final ListBuffer<String> apply(Tuple2<BlockId, BlockStatus> x0$4) {
                        Tuple2<BlockId, BlockStatus> tuple2 = x0$4;
                        if (tuple2 != null) {
                            BlockId bid = (BlockId)tuple2._1();
                            String location = this.status$1.blockManagerId().hostPort();
                            ListBuffer listBuffer = ((ListBuffer)this.$outer.blockLocations$1.getOrElseUpdate((Object)bid, (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final ListBuffer<String> apply() {
                                    return (ListBuffer)ListBuffer$.MODULE$.empty();
                                }
                            })).$plus$eq((Object)location);
                            return listBuffer;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.status$1 = status$1;
                    }
                });
            }
            {
                this.rddId$1 = rddId$1;
                this.blockLocations$1 = blockLocations$1;
            }
        });
        return var3_3;
    }

    private StorageUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

