/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import org.apache.spark.executor.ShuffleWriteMetrics;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.DiskBlockObjectWriter;
import org.apache.spark.storage.DiskBlockObjectWriter$;
import org.apache.spark.storage.FileSegment;
import org.apache.spark.storage.TimeTrackingOutputStream;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\t\u0015d!B\u0001\u0003\u0001\u0011Q!!\u0006#jg.\u0014En\\2l\u001f\nTWm\u0019;Xe&$XM\u001d\u0006\u0003\u0007\u0011\tqa\u001d;pe\u0006<WM\u0003\u0002\u0006\r\u0005)1\u000f]1sW*\u0011q\u0001C\u0001\u0007CB\f7\r[3\u000b\u0003%\t1a\u001c:h'\r\u00011b\u0005\t\u0003\u0019Ei\u0011!\u0004\u0006\u0003\u001d=\t!![8\u000b\u0003A\tAA[1wC&\u0011!#\u0004\u0002\r\u001fV$\b/\u001e;TiJ,\u0017-\u001c\t\u0003)]i\u0011!\u0006\u0006\u0003-\u0011\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u00031U\u0011q\u0001T8hO&tw\r\u0003\u0005\u001b\u0001\t\u0015\r\u0011\"\u0001\u001d\u0003\u00111\u0017\u000e\\3\u0004\u0001U\tQ\u0004\u0005\u0002\r=%\u0011q$\u0004\u0002\u0005\r&dW\r\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003\u001e\u0003\u00151\u0017\u000e\\3!\u0011!\u0019\u0003A!A!\u0002\u0013!\u0013!E:fe&\fG.\u001b>fe6\u000bg.Y4feB\u0011Q\u0005K\u0007\u0002M)\u0011q\u0005B\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018BA\u0015'\u0005E\u0019VM]5bY&TXM]'b]\u0006<WM\u001d\u0005\tW\u0001\u0011\t\u0011)A\u0005Y\u0005\u00112/\u001a:jC2L'0\u001a:J]N$\u0018M\\2f!\t)S&\u0003\u0002/M\t\u00112+\u001a:jC2L'0\u001a:J]N$\u0018M\\2f\u0011!\u0001\u0004A!A!\u0002\u0013\t\u0014A\u00032vM\u001a,'oU5{KB\u0011!'N\u0007\u0002g)\tA'A\u0003tG\u0006d\u0017-\u0003\u00027g\t\u0019\u0011J\u001c;\t\u0011a\u0002!\u0011!Q\u0001\ne\n!b]=oG^\u0013\u0018\u000e^3t!\t\u0011$(\u0003\u0002<g\t9!i\\8mK\u0006t\u0007\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002 \u0002\u0019]\u0014\u0018\u000e^3NKR\u0014\u0018nY:\u0011\u0005}\u0012U\"\u0001!\u000b\u0005\u0005#\u0011\u0001C3yK\u000e,Ho\u001c:\n\u0005\r\u0003%aE*ik\u001a4G.Z,sSR,W*\u001a;sS\u000e\u001c\b\u0002C#\u0001\u0005\u000b\u0007I\u0011\u0001$\u0002\u000f\tdwnY6JIV\tq\t\u0005\u0002I\u00136\t!!\u0003\u0002K\u0005\t9!\t\\8dW&#\u0007\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011B$\u0002\u0011\tdwnY6JI\u0002BQA\u0014\u0001\u0005\u0002=\u000ba\u0001P5oSRtD\u0003\u0003)R%N#VKV,\u0011\u0005!\u0003\u0001\"\u0002\u000eN\u0001\u0004i\u0002\"B\u0012N\u0001\u0004!\u0003\"B\u0016N\u0001\u0004a\u0003\"\u0002\u0019N\u0001\u0004\t\u0004\"\u0002\u001dN\u0001\u0004I\u0004\"B\u001fN\u0001\u0004q\u0004bB#N!\u0003\u0005\ra\u0012\u0004\b3\u0002\u0001\n1!\u0003[\u0005]i\u0015M\\;bY\u000ecwn]3PkR\u0004X\u000f^*ue\u0016\fWn\u0005\u0002Y\u0017!)A\f\u0017C\u0001;\u00061A%\u001b8ji\u0012\"\u0012A\u0018\t\u0003e}K!\u0001Y\u001a\u0003\tUs\u0017\u000e\u001e\u0005\u0007Eb\u0003J\u0011A/\u0002\u000b\rdwn]3\t\u000b\u0011DF\u0011A/\u0002\u00175\fg.^1m\u00072|7/\u001a\u0005\nMb\u000b\t\u0011!C\u0005;\u001e\f1b];qKJ$3\r\\8tK&\u0011!-\u0005\u0005\bS\u0002\u0001\r\u0011\"\u0003k\u0003\u001d\u0019\u0007.\u00198oK2,\u0012a\u001b\t\u0003YFl\u0011!\u001c\u0006\u0003]>\f\u0001b\u00195b]:,Gn\u001d\u0006\u0003a>\t1A\\5p\u0013\t\u0011XNA\u0006GS2,7\t[1o]\u0016d\u0007b\u0002;\u0001\u0001\u0004%I!^\u0001\fG\"\fgN\\3m?\u0012*\u0017\u000f\u0006\u0002_m\"9qo]A\u0001\u0002\u0004Y\u0017a\u0001=%c!1\u0011\u0010\u0001Q!\n-\f\u0001b\u00195b]:,G\u000e\t\u0005\bw\u0002\u0001\r\u0011\"\u0003}\u0003\ri7m]\u000b\u0002{B\u0011a\u0010W\u0007\u0002\u0001!I\u0011\u0011\u0001\u0001A\u0002\u0013%\u00111A\u0001\b[\u000e\u001cx\fJ3r)\rq\u0016Q\u0001\u0005\bo~\f\t\u00111\u0001~\u0011\u001d\tI\u0001\u0001Q!\nu\fA!\\2tA!I\u0011Q\u0002\u0001A\u0002\u0013%\u0011qB\u0001\u0003EN,\u0012a\u0003\u0005\n\u0003'\u0001\u0001\u0019!C\u0005\u0003+\taAY:`I\u0015\fHc\u00010\u0002\u0018!Aq/!\u0005\u0002\u0002\u0003\u00071\u0002C\u0004\u0002\u001c\u0001\u0001\u000b\u0015B\u0006\u0002\u0007\t\u001c\b\u0005C\u0005\u0002 \u0001\u0001\r\u0011\"\u0003\u0002\"\u0005\u0019am\\:\u0016\u0005\u0005\r\u0002c\u0001\u0007\u0002&%\u0019\u0011qE\u0007\u0003!\u0019KG.Z(viB,Ho\u0015;sK\u0006l\u0007\"CA\u0016\u0001\u0001\u0007I\u0011BA\u0017\u0003\u001d1wn]0%KF$2AXA\u0018\u0011%9\u0018\u0011FA\u0001\u0002\u0004\t\u0019\u0003\u0003\u0005\u00024\u0001\u0001\u000b\u0015BA\u0012\u0003\u00111wn\u001d\u0011\t\u0013\u0005]\u0002\u00011A\u0005\n\u0005e\u0012A\u0001;t+\t\tY\u0004E\u0002I\u0003{I1!a\u0010\u0003\u0005a!\u0016.\\3Ue\u0006\u001c7.\u001b8h\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\n\u0003\u0007\u0002\u0001\u0019!C\u0005\u0003\u000b\na\u0001^:`I\u0015\fHc\u00010\u0002H!Iq/!\u0011\u0002\u0002\u0003\u0007\u00111\b\u0005\t\u0003\u0017\u0002\u0001\u0015)\u0003\u0002<\u0005\u0019Ao\u001d\u0011\t\u0013\u0005=\u0003\u00011A\u0005\n\u0005E\u0013AB8cU>+H/\u0006\u0002\u0002TA\u0019Q%!\u0016\n\u0007\u0005]cEA\nTKJL\u0017\r\\5{CRLwN\\*ue\u0016\fW\u000eC\u0005\u0002\\\u0001\u0001\r\u0011\"\u0003\u0002^\u0005QqN\u00196PkR|F%Z9\u0015\u0007y\u000by\u0006C\u0005x\u00033\n\t\u00111\u0001\u0002T!A\u00111\r\u0001!B\u0013\t\u0019&A\u0004pE*|U\u000f\u001e\u0011\t\u0013\u0005\u001d\u0004\u00011A\u0005\n\u0005%\u0014aC5oSRL\u0017\r\\5{K\u0012,\u0012!\u000f\u0005\n\u0003[\u0002\u0001\u0019!C\u0005\u0003_\nq\"\u001b8ji&\fG.\u001b>fI~#S-\u001d\u000b\u0004=\u0006E\u0004\u0002C<\u0002l\u0005\u0005\t\u0019A\u001d\t\u000f\u0005U\u0004\u0001)Q\u0005s\u0005a\u0011N\\5uS\u0006d\u0017N_3eA!I\u0011\u0011\u0010\u0001A\u0002\u0013%\u0011\u0011N\u0001\u000bgR\u0014X-Y7Pa\u0016t\u0007\"CA?\u0001\u0001\u0007I\u0011BA@\u00039\u0019HO]3b[>\u0003XM\\0%KF$2AXAA\u0011!9\u00181PA\u0001\u0002\u0004I\u0004bBAC\u0001\u0001\u0006K!O\u0001\fgR\u0014X-Y7Pa\u0016t\u0007\u0005C\u0005\u0002\n\u0002\u0001\r\u0011\"\u0003\u0002j\u0005i\u0001.Y:CK\u0016t7\t\\8tK\u0012D\u0011\"!$\u0001\u0001\u0004%I!a$\u0002#!\f7OQ3f]\u000ecwn]3e?\u0012*\u0017\u000fF\u0002_\u0003#C\u0001b^AF\u0003\u0003\u0005\r!\u000f\u0005\b\u0003+\u0003\u0001\u0015)\u0003:\u00039A\u0017m\u001d\"fK:\u001cEn\\:fI\u0002B\u0011\"!'\u0001\u0001\u0004%I!a'\u0002#\r|W.\\5ui\u0016$\u0007k\\:ji&|g.\u0006\u0002\u0002\u001eB\u0019!'a(\n\u0007\u0005\u00056G\u0001\u0003M_:<\u0007\"CAS\u0001\u0001\u0007I\u0011BAT\u0003U\u0019w.\\7jiR,G\rU8tSRLwN\\0%KF$2AXAU\u0011%9\u00181UA\u0001\u0002\u0004\ti\n\u0003\u0005\u0002.\u0002\u0001\u000b\u0015BAO\u0003I\u0019w.\\7jiR,G\rU8tSRLwN\u001c\u0011\t\u0013\u0005E\u0006\u00011A\u0005\n\u0005m\u0015\u0001\u0005:fa>\u0014H/\u001a3Q_NLG/[8o\u0011%\t)\f\u0001a\u0001\n\u0013\t9,\u0001\u000bsKB|'\u000f^3e!>\u001c\u0018\u000e^5p]~#S-\u001d\u000b\u0004=\u0006e\u0006\"C<\u00024\u0006\u0005\t\u0019AAO\u0011!\ti\f\u0001Q!\n\u0005u\u0015!\u0005:fa>\u0014H/\u001a3Q_NLG/[8oA!I\u0011\u0011\u0019\u0001A\u0002\u0013%\u00111Y\u0001\u0012]Vl'+Z2pe\u0012\u001cxK]5ui\u0016tW#A\u0019\t\u0013\u0005\u001d\u0007\u00011A\u0005\n\u0005%\u0017!\u00068v[J+7m\u001c:eg^\u0013\u0018\u000e\u001e;f]~#S-\u001d\u000b\u0004=\u0006-\u0007\u0002C<\u0002F\u0006\u0005\t\u0019A\u0019\t\u000f\u0005=\u0007\u0001)Q\u0005c\u0005\u0011b.^7SK\u000e|'\u000fZ:Xe&$H/\u001a8!\u0011\u0019\t\u0019\u000e\u0001C\u0005;\u0006Q\u0011N\\5uS\u0006d\u0017N_3\t\u000f\u0005]\u0007\u0001\"\u0001\u0002Z\u0006!q\u000e]3o)\u0005\u0001\u0006BBAo\u0001\u0011%Q,\u0001\bdY>\u001cXMU3t_V\u00148-Z:\t\u000b\t\u0004A\u0011I/\t\u000f\u0005\r\b\u0001\"\u0001\u0002f\u0006a1m\\7nSR\fe\u000eZ$fiR\u0011\u0011q\u001d\t\u0004\u0011\u0006%\u0018bAAv\u0005\tYa)\u001b7f'\u0016<W.\u001a8u\u0011\u001d\ty\u000f\u0001C\u0001\u0003c\f1D]3wKJ$\b+\u0019:uS\u0006dwK]5uKN\fe\u000eZ\"m_N,G#A\u000f\t\u000f\u0005U\b\u0001\"\u0001\u0002x\u0006)qO]5uKR)a,!?\u0003\u0004!A\u00111`Az\u0001\u0004\ti0A\u0002lKf\u00042AMA\u0000\u0013\r\u0011\ta\r\u0002\u0004\u0003:L\b\u0002\u0003B\u0003\u0003g\u0004\r!!@\u0002\u000bY\fG.^3\t\u000f\u0005U\b\u0001\"\u0011\u0003\nQ\u0019aLa\u0003\t\u000f\t5!q\u0001a\u0001c\u0005\t!\rC\u0004\u0002v\u0002!\tE!\u0005\u0015\u000fy\u0013\u0019Ba\t\u0003(!A!Q\u0003B\b\u0001\u0004\u00119\"A\u0004lm\nKH/Z:\u0011\u000bI\u0012IB!\b\n\u0007\tm1GA\u0003BeJ\f\u0017\u0010E\u00023\u0005?I1A!\t4\u0005\u0011\u0011\u0015\u0010^3\t\u000f\t\u0015\"q\u0002a\u0001c\u0005!qN\u001a4t\u0011\u001d\u0011ICa\u0004A\u0002E\n1\u0001\\3o\u0011\u0019\u0011i\u0003\u0001C\u0001;\u0006i!/Z2pe\u0012<&/\u001b;uK:DaA!\r\u0001\t\u0013i\u0016AE;qI\u0006$XMQ=uKN<&/\u001b;uK:DqA!\u000e\u0001\t\u0003\"Q,A\u0003gYV\u001c\bn\u0002\u0006\u0003:\t\t\t\u0011#\u0001\u0005\u0005w\tQ\u0003R5tW\ncwnY6PE*,7\r^,sSR,'\u000fE\u0002I\u0005{1\u0011\"\u0001\u0002\u0002\u0002#\u0005AAa\u0010\u0014\t\tu\"\u0011\t\t\u0004e\t\r\u0013b\u0001B#g\t1\u0011I\\=SK\u001aDqA\u0014B\u001f\t\u0003\u0011I\u0005\u0006\u0002\u0003<!Q!Q\nB\u001f#\u0003%\tAa\u0014\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00138+\t\u0011\tFK\u0002H\u0005'Z#A!\u0016\u0011\t\t]#\u0011M\u0007\u0003\u00053RAAa\u0017\u0003^\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005?\u001a\u0014AC1o]>$\u0018\r^5p]&!!1\rB-\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class DiskBlockObjectWriter
extends OutputStream
implements Logging {
    private final File file;
    private final SerializerManager serializerManager;
    private final SerializerInstance serializerInstance;
    public final int org$apache$spark$storage$DiskBlockObjectWriter$$bufferSize;
    private final boolean syncWrites;
    private final ShuffleWriteMetrics writeMetrics;
    private final BlockId blockId;
    private FileChannel channel;
    private ManualCloseOutputStream mcs;
    private OutputStream bs;
    private FileOutputStream fos;
    private TimeTrackingOutputStream org$apache$spark$storage$DiskBlockObjectWriter$$ts;
    private SerializationStream objOut;
    private boolean initialized;
    private boolean streamOpen;
    private boolean hasBeenClosed;
    private long committedPosition;
    private long reportedPosition;
    private int numRecordsWritten;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static BlockId $lessinit$greater$default$7() {
        return DiskBlockObjectWriter$.MODULE$.$lessinit$greater$default$7();
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    public File file() {
        return this.file;
    }

    public BlockId blockId() {
        return this.blockId;
    }

    private FileChannel channel() {
        return this.channel;
    }

    private void channel_$eq(FileChannel x$1) {
        this.channel = x$1;
    }

    private ManualCloseOutputStream mcs() {
        return this.mcs;
    }

    private void mcs_$eq(ManualCloseOutputStream x$1) {
        this.mcs = x$1;
    }

    private OutputStream bs() {
        return this.bs;
    }

    private void bs_$eq(OutputStream x$1) {
        this.bs = x$1;
    }

    private FileOutputStream fos() {
        return this.fos;
    }

    private void fos_$eq(FileOutputStream x$1) {
        this.fos = x$1;
    }

    public TimeTrackingOutputStream org$apache$spark$storage$DiskBlockObjectWriter$$ts() {
        return this.org$apache$spark$storage$DiskBlockObjectWriter$$ts;
    }

    private void org$apache$spark$storage$DiskBlockObjectWriter$$ts_$eq(TimeTrackingOutputStream x$1) {
        this.org$apache$spark$storage$DiskBlockObjectWriter$$ts = x$1;
    }

    private SerializationStream objOut() {
        return this.objOut;
    }

    private void objOut_$eq(SerializationStream x$1) {
        this.objOut = x$1;
    }

    private boolean initialized() {
        return this.initialized;
    }

    private void initialized_$eq(boolean x$1) {
        this.initialized = x$1;
    }

    private boolean streamOpen() {
        return this.streamOpen;
    }

    private void streamOpen_$eq(boolean x$1) {
        this.streamOpen = x$1;
    }

    private boolean hasBeenClosed() {
        return this.hasBeenClosed;
    }

    private void hasBeenClosed_$eq(boolean x$1) {
        this.hasBeenClosed = x$1;
    }

    private long committedPosition() {
        return this.committedPosition;
    }

    private void committedPosition_$eq(long x$1) {
        this.committedPosition = x$1;
    }

    private long reportedPosition() {
        return this.reportedPosition;
    }

    private void reportedPosition_$eq(long x$1) {
        this.reportedPosition = x$1;
    }

    private int numRecordsWritten() {
        return this.numRecordsWritten;
    }

    private void numRecordsWritten_$eq(int x$1) {
        this.numRecordsWritten = x$1;
    }

    private void initialize() {
        this.fos_$eq(new FileOutputStream(this.file(), true));
        this.channel_$eq(this.fos().getChannel());
        this.org$apache$spark$storage$DiskBlockObjectWriter$$ts_$eq(new TimeTrackingOutputStream(this.writeMetrics, this.fos()));
        public class Org_apache_spark_storage_DiskBlockObjectWriter$ManualCloseBufferedOutputStream$1
        extends BufferedOutputStream
        implements ManualCloseOutputStream {
            public final /* synthetic */ DiskBlockObjectWriter $outer;

            public void org$apache$spark$storage$DiskBlockObjectWriter$ManualCloseOutputStream$$super$close() {
                super.close();
            }

            public void close() {
                ManualCloseOutputStream.class.close(this);
            }

            public void manualClose() {
                ManualCloseOutputStream.class.manualClose(this);
            }

            public /* synthetic */ DiskBlockObjectWriter org$apache$spark$storage$DiskBlockObjectWriter$ManualCloseBufferedOutputStream$$$outer() {
                return this.$outer;
            }

            public /* synthetic */ DiskBlockObjectWriter org$apache$spark$storage$DiskBlockObjectWriter$ManualCloseOutputStream$$$outer() {
                return this.org$apache$spark$storage$DiskBlockObjectWriter$ManualCloseBufferedOutputStream$$$outer();
            }

            public Org_apache_spark_storage_DiskBlockObjectWriter$ManualCloseBufferedOutputStream$1(DiskBlockObjectWriter $outer) {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.org$apache$spark$storage$DiskBlockObjectWriter$$ts(), $outer.org$apache$spark$storage$DiskBlockObjectWriter$$bufferSize);
                ManualCloseOutputStream.class.$init$(this);
            }
        }
        this.mcs_$eq(new Org_apache_spark_storage_DiskBlockObjectWriter$ManualCloseBufferedOutputStream$1(this));
    }

    public DiskBlockObjectWriter open() {
        if (this.hasBeenClosed()) {
            throw new IllegalStateException("Writer already closed. Cannot be reopened.");
        }
        if (!this.initialized()) {
            this.initialize();
            this.initialized_$eq(true);
        }
        this.bs_$eq(this.serializerManager.wrapStream(this.blockId(), (OutputStream)((Object)this.mcs())));
        this.objOut_$eq(this.serializerInstance.serializeStream(this.bs()));
        this.streamOpen_$eq(true);
        return this;
    }

    public void org$apache$spark$storage$DiskBlockObjectWriter$$closeResources() {
        if (this.initialized()) {
            this.mcs().manualClose();
            this.channel_$eq(null);
            this.mcs_$eq(null);
            this.bs_$eq(null);
            this.fos_$eq(null);
            this.org$apache$spark$storage$DiskBlockObjectWriter$$ts_$eq(null);
            this.objOut_$eq(null);
            this.initialized_$eq(false);
            this.streamOpen_$eq(false);
            this.hasBeenClosed_$eq(true);
        }
    }

    @Override
    public void close() {
        if (this.initialized()) {
            Utils$.MODULE$.tryWithSafeFinally(new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DiskBlockObjectWriter $outer;

                public final FileSegment apply() {
                    return this.$outer.commitAndGet();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, (Function0<BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DiskBlockObjectWriter $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.org$apache$spark$storage$DiskBlockObjectWriter$$closeResources();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
    }

    public FileSegment commitAndGet() {
        FileSegment fileSegment;
        if (this.streamOpen()) {
            this.objOut().flush();
            this.bs().flush();
            this.objOut().close();
            this.streamOpen_$eq(false);
            if (this.syncWrites) {
                long start2 = System.nanoTime();
                this.fos().getFD().sync();
                this.writeMetrics.incWriteTime(System.nanoTime() - start2);
            }
            long pos = this.channel().position();
            FileSegment fileSegment2 = new FileSegment(this.file(), this.committedPosition(), pos - this.committedPosition());
            this.committedPosition_$eq(pos);
            this.writeMetrics.incBytesWritten(this.committedPosition() - this.reportedPosition());
            this.reportedPosition_$eq(this.committedPosition());
            fileSegment = fileSegment2;
        } else {
            fileSegment = new FileSegment(this.file(), this.committedPosition(), 0L);
        }
        return fileSegment;
    }

    public File revertPartialWritesAndClose() {
        File file;
        try {
            if (this.initialized()) {
                this.writeMetrics.decBytesWritten(this.reportedPosition() - this.committedPosition());
                this.writeMetrics.decRecordsWritten(this.numRecordsWritten());
                this.streamOpen_$eq(false);
                this.org$apache$spark$storage$DiskBlockObjectWriter$$closeResources();
            }
            FileOutputStream truncateStream = new FileOutputStream(this.file(), true);
            try {
                truncateStream.getChannel().truncate(this.committedPosition());
                file = this.file();
            }
            finally {
                truncateStream.close();
            }
        }
        catch (Exception exception2) {
            this.logError((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DiskBlockObjectWriter $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Uncaught exception while reverting partial writes to file ").append((Object)this.$outer.file()).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, exception2);
            file = this.file();
        }
        return file;
    }

    public void write(Object key, Object value2) {
        Object object = this.streamOpen() ? BoxedUnit.UNIT : this.open();
        this.objOut().writeKey(key, ClassTag$.MODULE$.Any());
        this.objOut().writeValue(value2, ClassTag$.MODULE$.Any());
        this.recordWritten();
    }

    @Override
    public void write(int b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(byte[] kvBytes, int offs, int len) {
        Object object = this.streamOpen() ? BoxedUnit.UNIT : this.open();
        this.bs().write(kvBytes, offs, len);
    }

    public void recordWritten() {
        this.numRecordsWritten_$eq(this.numRecordsWritten() + 1);
        this.writeMetrics.incRecordsWritten(1L);
        if (this.numRecordsWritten() % 16384 == 0) {
            this.updateBytesWritten();
        }
    }

    private void updateBytesWritten() {
        long pos = this.channel().position();
        this.writeMetrics.incBytesWritten(pos - this.reportedPosition());
        this.reportedPosition_$eq(pos);
    }

    @Override
    public void flush() {
        this.objOut().flush();
        this.bs().flush();
    }

    public DiskBlockObjectWriter(File file, SerializerManager serializerManager, SerializerInstance serializerInstance, int bufferSize, boolean syncWrites, ShuffleWriteMetrics writeMetrics, BlockId blockId) {
        this.file = file;
        this.serializerManager = serializerManager;
        this.serializerInstance = serializerInstance;
        this.org$apache$spark$storage$DiskBlockObjectWriter$$bufferSize = bufferSize;
        this.syncWrites = syncWrites;
        this.writeMetrics = writeMetrics;
        this.blockId = blockId;
        Logging$class.$init$(this);
        this.channel = null;
        this.mcs = null;
        this.bs = null;
        this.fos = null;
        this.org$apache$spark$storage$DiskBlockObjectWriter$$ts = null;
        this.objOut = null;
        this.initialized = false;
        this.streamOpen = false;
        this.hasBeenClosed = false;
        this.committedPosition = file.length();
        this.reportedPosition = this.committedPosition();
        this.numRecordsWritten = 0;
    }

    public interface ManualCloseOutputStream {
        public void org$apache$spark$storage$DiskBlockObjectWriter$ManualCloseOutputStream$$super$close();

        public void close();

        public void manualClose();

        public /* synthetic */ DiskBlockObjectWriter org$apache$spark$storage$DiskBlockObjectWriter$ManualCloseOutputStream$$$outer();
    }
}

