/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import org.apache.spark.metrics.source.Source;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.StorageStatus;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r3Q!\u0001\u0002\u0001\t)\u0011!C\u00117pG.l\u0015M\\1hKJ\u001cv.\u001e:dK*\u00111\u0001B\u0001\bgR|'/Y4f\u0015\t)a!A\u0003ta\u0006\u00148N\u0003\u0002\b\u0011\u00051\u0011\r]1dQ\u0016T\u0011!C\u0001\u0004_J<7c\u0001\u0001\f#A\u0011AbD\u0007\u0002\u001b)\ta\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0011\u001b\t1\u0011I\\=SK\u001a\u0004\"AE\f\u000e\u0003MQ!\u0001F\u000b\u0002\rM|WO]2f\u0015\t1B!A\u0004nKR\u0014\u0018nY:\n\u0005a\u0019\"AB*pkJ\u001cW\r\u0003\u0005\u001b\u0001\t\u0015\r\u0011\"\u0001\u001d\u00031\u0011Gn\\2l\u001b\u0006t\u0017mZ3s\u0007\u0001)\u0012!\b\t\u0003=}i\u0011AA\u0005\u0003A\t\u0011AB\u00117pG.l\u0015M\\1hKJD\u0001B\t\u0001\u0003\u0002\u0003\u0006I!H\u0001\u000eE2|7m['b]\u0006<WM\u001d\u0011\t\u000b\u0011\u0002A\u0011A\u0013\u0002\rqJg.\u001b;?)\t1s\u0005\u0005\u0002\u001f\u0001!)!d\ta\u0001;!9\u0011\u0006\u0001b\u0001\n\u0003R\u0013AD7fiJL7MU3hSN$(/_\u000b\u0002WA\u0011AFM\u0007\u0002[)\u0011aC\f\u0006\u0003_A\n\u0001bY8eC\"\fG.\u001a\u0006\u0002c\u0005\u00191m\\7\n\u0005Mj#AD'fiJL7MU3hSN$(/\u001f\u0005\u0007k\u0001\u0001\u000b\u0011B\u0016\u0002\u001f5,GO]5d%\u0016<\u0017n\u001d;ss\u0002Bqa\u000e\u0001C\u0002\u0013\u0005\u0003(\u0001\u0006t_V\u00148-\u001a(b[\u0016,\u0012!\u000f\t\u0003u}j\u0011a\u000f\u0006\u0003yu\nA\u0001\\1oO*\ta(\u0001\u0003kCZ\f\u0017B\u0001!<\u0005\u0019\u0019FO]5oO\"1!\t\u0001Q\u0001\ne\n1b]8ve\u000e,g*Y7fA\u0001")
public class BlockManagerSource
implements Source {
    private final BlockManager blockManager;
    private final MetricRegistry metricRegistry;
    private final String sourceName;

    public BlockManager blockManager() {
        return this.blockManager;
    }

    @Override
    public MetricRegistry metricRegistry() {
        return this.metricRegistry;
    }

    @Override
    public String sourceName() {
        return this.sourceName;
    }

    public BlockManagerSource(BlockManager blockManager2) {
        this.blockManager = blockManager2;
        this.metricRegistry = new MetricRegistry();
        this.sourceName = "BlockManager";
        this.metricRegistry().register(MetricRegistry.name((String)"memory", (String[])new String[]{"maxMem_MB"}), (Metric)new Gauge<Object>(this){
            private final /* synthetic */ BlockManagerSource $outer;

            public long getValue() {
                StorageStatus[] storageStatusList = this.$outer.blockManager().master().getStorageStatus();
                long maxMem = BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])storageStatusList).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(StorageStatus x$1) {
                        return x$1.maxMem();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                return maxMem / 1024L / 1024L;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.metricRegistry().register(MetricRegistry.name((String)"memory", (String[])new String[]{"remainingMem_MB"}), (Metric)new Gauge<Object>(this){
            private final /* synthetic */ BlockManagerSource $outer;

            public long getValue() {
                StorageStatus[] storageStatusList = this.$outer.blockManager().master().getStorageStatus();
                long remainingMem = BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])storageStatusList).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(StorageStatus x$2) {
                        return x$2.memRemaining();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                return remainingMem / 1024L / 1024L;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.metricRegistry().register(MetricRegistry.name((String)"memory", (String[])new String[]{"memUsed_MB"}), (Metric)new Gauge<Object>(this){
            private final /* synthetic */ BlockManagerSource $outer;

            public long getValue() {
                StorageStatus[] storageStatusList = this.$outer.blockManager().master().getStorageStatus();
                long memUsed = BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])storageStatusList).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(StorageStatus x$3) {
                        return x$3.memUsed();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                return memUsed / 1024L / 1024L;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.metricRegistry().register(MetricRegistry.name((String)"disk", (String[])new String[]{"diskSpaceUsed_MB"}), (Metric)new Gauge<Object>(this){
            private final /* synthetic */ BlockManagerSource $outer;

            public long getValue() {
                StorageStatus[] storageStatusList = this.$outer.blockManager().master().getStorageStatus();
                long diskSpaceUsed = BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])storageStatusList).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(StorageStatus x$4) {
                        return x$4.diskUsed();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                return diskSpaceUsed / 1024L / 1024L;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

