/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster;

import java.io.File;
import java.util.concurrent.Semaphore;
import org.apache.spark.SparkConf$;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.ApplicationDescription;
import org.apache.spark.deploy.ApplicationDescription$;
import org.apache.spark.deploy.Command;
import org.apache.spark.deploy.client.StandaloneAppClient;
import org.apache.spark.deploy.client.StandaloneAppClientListener;
import org.apache.spark.launcher.LauncherBackend;
import org.apache.spark.launcher.SparkAppHandle;
import org.apache.spark.rpc.RpcEndpointAddress$;
import org.apache.spark.scheduler.ExecutorExited;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.SchedulerBackend$class;
import org.apache.spark.scheduler.SlaveLost;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend$;
import org.apache.spark.scheduler.cluster.StandaloneSchedulerBackend$;
import org.apache.spark.ui.SparkUI;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005eh!B\u0001\u0003\u0001\u0019a!AG*uC:$\u0017\r\\8oKN\u001b\u0007.\u001a3vY\u0016\u0014()Y2lK:$'BA\u0002\u0005\u0003\u001d\u0019G.^:uKJT!!\u0002\u0004\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0014\t\u0001i\u0011#\u0007\t\u0003\u001d=i\u0011AA\u0005\u0003!\t\u0011QdQ8beN,wI]1j]\u0016$7k\u00195fIVdWM\u001d\"bG.,g\u000e\u001a\t\u0003%]i\u0011a\u0005\u0006\u0003)U\taa\u00197jK:$(B\u0001\f\u0007\u0003\u0019!W\r\u001d7ps&\u0011\u0001d\u0005\u0002\u001c'R\fg\u000eZ1m_:,\u0017\t\u001d9DY&,g\u000e\u001e'jgR,g.\u001a:\u0011\u0005iiR\"A\u000e\u000b\u0005q1\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005yY\"a\u0002'pO\u001eLgn\u001a\u0005\t\u000b\u0001\u0011\t\u0011)A\u0005C\r\u0001\u0001C\u0001\u0012$\u001b\u0005!\u0011B\u0001\u0013\u0005\u0005E!\u0016m]6TG\",G-\u001e7fe&k\u0007\u000f\u001c\u0005\tM\u0001\u0011\t\u0011)A\u0005O\u0005\u00111o\u0019\t\u0003Q%j\u0011AB\u0005\u0003U\u0019\u0011Ab\u00159be.\u001cuN\u001c;fqRD\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!L\u0001\b[\u0006\u001cH/\u001a:t!\rq\u0013gM\u0007\u0002_)\t\u0001'A\u0003tG\u0006d\u0017-\u0003\u00023_\t)\u0011I\u001d:bsB\u0011Ag\u000e\b\u0003]UJ!AN\u0018\u0002\rA\u0013X\rZ3g\u0013\tA\u0014H\u0001\u0004TiJLgn\u001a\u0006\u0003m=BQa\u000f\u0001\u0005\u0002q\na\u0001P5oSRtD\u0003B\u001f?\u007f\u0001\u0003\"A\u0004\u0001\t\u000b\u0015Q\u0004\u0019A\u0011\t\u000b\u0019R\u0004\u0019A\u0014\t\u000b1R\u0004\u0019A\u0017\t\u000fQ\u0001\u0001\u0019!C\u0005\u0005V\t1\t\u0005\u0002\u0013\t&\u0011Qi\u0005\u0002\u0014'R\fg\u000eZ1m_:,\u0017\t\u001d9DY&,g\u000e\u001e\u0005\b\u000f\u0002\u0001\r\u0011\"\u0003I\u0003)\u0019G.[3oi~#S-\u001d\u000b\u0003\u00132\u0003\"A\f&\n\u0005-{#\u0001B+oSRDq!\u0014$\u0002\u0002\u0003\u00071)A\u0002yIEBaa\u0014\u0001!B\u0013\u0019\u0015aB2mS\u0016tG\u000f\t\u0005\b#\u0002\u0001\r\u0011\"\u0003S\u0003!\u0019Ho\u001c9qS:<W#A*\u0011\u00059\"\u0016BA+0\u0005\u001d\u0011un\u001c7fC:Dqa\u0016\u0001A\u0002\u0013%\u0001,\u0001\u0007ti>\u0004\b/\u001b8h?\u0012*\u0017\u000f\u0006\u0002J3\"9QJVA\u0001\u0002\u0004\u0019\u0006BB.\u0001A\u0003&1+A\u0005ti>\u0004\b/\u001b8hA!9Q\f\u0001b\u0001\n\u0013q\u0016a\u00047bk:\u001c\u0007.\u001a:CC\u000e\\WM\u001c3\u0016\u0003}\u0003\"\u0001Y2\u000e\u0003\u0005T!A\u0019\u0004\u0002\u00111\fWO\\2iKJL!\u0001Z1\u0003\u001f1\u000bWO\\2iKJ\u0014\u0015mY6f]\u0012DaA\u001a\u0001!\u0002\u0013y\u0016\u0001\u00057bk:\u001c\u0007.\u001a:CC\u000e\\WM\u001c3!\u0011%A\u0007\u00011AA\u0002\u0013\u0005\u0011.\u0001\ttQV$Hm\\<o\u0007\u0006dGNY1dWV\t!\u000e\u0005\u0003/WvJ\u0015B\u000170\u0005%1UO\\2uS>t\u0017\u0007C\u0005o\u0001\u0001\u0007\t\u0019!C\u0001_\u0006!2\u000f[;uI><hnQ1mY\n\f7m[0%KF$\"!\u00139\t\u000f5k\u0017\u0011!a\u0001U\"1!\u000f\u0001Q!\n)\f\u0011c\u001d5vi\u0012|wO\\\"bY2\u0014\u0017mY6!Q\t\tH\u000f\u0005\u0002/k&\u0011ao\f\u0002\tm>d\u0017\r^5mK\"I\u0001\u0010\u0001a\u0001\u0002\u0004%I!_\u0001\u0006CB\u0004\u0018\nZ\u000b\u0002g!I1\u0010\u0001a\u0001\u0002\u0004%I\u0001`\u0001\nCB\u0004\u0018\nZ0%KF$\"!S?\t\u000f5S\u0018\u0011!a\u0001g!1q\u0010\u0001Q!\nM\na!\u00199q\u0013\u0012\u0004\u0003F\u0001@u\u0011%\t)\u0001\u0001b\u0001\n\u0013\t9!A\nsK\u001eL7\u000f\u001e:bi&|gNQ1se&,'/\u0006\u0002\u0002\nA!\u00111BA\r\u001b\t\tiA\u0003\u0003\u0002\u0010\u0005E\u0011AC2p]\u000e,(O]3oi*!\u00111CA\u000b\u0003\u0011)H/\u001b7\u000b\u0005\u0005]\u0011\u0001\u00026bm\u0006LA!a\u0007\u0002\u000e\tI1+Z7ba\"|'/\u001a\u0005\t\u0003?\u0001\u0001\u0015!\u0003\u0002\n\u0005!\"/Z4jgR\u0014\u0018\r^5p]\n\u000b'O]5fe\u0002B\u0011\"a\t\u0001\u0005\u0004%I!!\n\u0002\u00115\f\u0007pQ8sKN,\"!a\n\u0011\u000b9\nI#!\f\n\u0007\u0005-rF\u0001\u0004PaRLwN\u001c\t\u0004]\u0005=\u0012bAA\u0019_\t\u0019\u0011J\u001c;\t\u0011\u0005U\u0002\u0001)A\u0005\u0003O\t\u0011\"\\1y\u0007>\u0014Xm\u001d\u0011\t\u0013\u0005e\u0002A1A\u0005\n\u0005m\u0012A\u0005;pi\u0006dW\t\u001f9fGR,GmQ8sKN,\"!!\f\t\u0011\u0005}\u0002\u0001)A\u0005\u0003[\t1\u0003^8uC2,\u0005\u0010]3di\u0016$7i\u001c:fg\u0002Bq!a\u0011\u0001\t\u0003\n)%A\u0003ti\u0006\u0014H\u000fF\u0001J\u0011\u001d\tI\u0005\u0001C!\u0003\u000b\nAa\u001d;pa\"9\u0011Q\n\u0001\u0005B\u0005=\u0013!C2p]:,7\r^3e)\rI\u0015\u0011\u000b\u0005\u0007q\u0006-\u0003\u0019A\u001a\t\u000f\u0005U\u0003\u0001\"\u0011\u0002F\u0005aA-[:d_:tWm\u0019;fI\"9\u0011\u0011\f\u0001\u0005B\u0005m\u0013\u0001\u00023fC\u0012$2!SA/\u0011\u001d\ty&a\u0016A\u0002M\naA]3bg>t\u0007bBA2\u0001\u0011\u0005\u0013QM\u0001\u000eKb,7-\u001e;pe\u0006#G-\u001a3\u0015\u0017%\u000b9'a\u001b\u0002p\u0005M\u0014q\u000f\u0005\b\u0003S\n\t\u00071\u00014\u0003\u00191W\u000f\u001c7JI\"9\u0011QNA1\u0001\u0004\u0019\u0014\u0001C<pe.,'/\u00133\t\u000f\u0005E\u0014\u0011\ra\u0001g\u0005A\u0001n\\:u!>\u0014H\u000f\u0003\u0005\u0002v\u0005\u0005\u0004\u0019AA\u0017\u0003\u0015\u0019wN]3t\u0011!\tI(!\u0019A\u0002\u00055\u0012AB7f[>\u0014\u0018\u0010C\u0004\u0002~\u0001!\t%a \u0002\u001f\u0015DXmY;u_J\u0014V-\\8wK\u0012$\u0012\"SAA\u0003\u0007\u000b9)a#\t\u000f\u0005%\u00141\u0010a\u0001g!9\u0011QQA>\u0001\u0004\u0019\u0014aB7fgN\fw-\u001a\u0005\t\u0003\u0013\u000bY\b1\u0001\u0002(\u0005QQ\r_5u'R\fG/^:\t\u000f\u00055\u00151\u0010a\u0001'\u0006Qqo\u001c:lKJdun\u001d;\t\u000f\u0005E\u0005\u0001\"\u0011\u0002\u0014\u0006i2/\u001e4gS\u000eLWM\u001c;SKN|WO]2fgJ+w-[:uKJ,G\rF\u0001T\u0011\u001d\t9\n\u0001C!\u00033\u000bQ\"\u00199qY&\u001c\u0017\r^5p]&#G#A\u001a\t\u000f\u0005u\u0005\u0001\"\u0015\u0002 \u00069Bm\u001c*fcV,7\u000f\u001e+pi\u0006dW\t_3dkR|'o\u001d\u000b\u0005\u0003C\u000bY\u000bE\u0003\u0002$\u0006\u001d6+\u0004\u0002\u0002&*\u0019\u0011qB\u0018\n\t\u0005%\u0016Q\u0015\u0002\u0007\rV$XO]3\t\u0011\u00055\u00161\u0014a\u0001\u0003[\taB]3rk\u0016\u001cH/\u001a3U_R\fG\u000eC\u0004\u00022\u0002!\t&a-\u0002\u001f\u0011|7*\u001b7m\u000bb,7-\u001e;peN$B!!)\u00026\"A\u0011qWAX\u0001\u0004\tI,A\u0006fq\u0016\u001cW\u000f^8s\u0013\u0012\u001c\b#BA^\u0003\u0017\u001cd\u0002BA_\u0003\u000ftA!a0\u0002F6\u0011\u0011\u0011\u0019\u0006\u0004\u0003\u0007\u0004\u0013A\u0002\u001fs_>$h(C\u00011\u0013\r\tImL\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti-a4\u0003\u0007M+\u0017OC\u0002\u0002J>Bq!a5\u0001\t\u0013\t)%A\nxC&$hi\u001c:SK\u001eL7\u000f\u001e:bi&|g\u000eC\u0004\u0002X\u0002!I!!\u0012\u0002\u001b9|G/\u001b4z\u0007>tG/\u001a=u\u0011\u001d\tI\u0005\u0001C\u0005\u00037$2!SAo\u0011!\ty.!7A\u0002\u0005\u0005\u0018A\u00034j]\u0006d7\u000b^1uKB!\u00111]Au\u001d\r\u0001\u0017Q]\u0005\u0004\u0003O\f\u0017AD*qCJ\\\u0017\t\u001d9IC:$G.Z\u0005\u0005\u0003W\fiOA\u0003Ti\u0006$XMC\u0002\u0002h\u0006DA\"!=\u0001\u0003\u0003\u0005I\u0011BAM\u0003g\f1c];qKJ$\u0013\r\u001d9mS\u000e\fG/[8o\u0013\u0012LA!a&\u0002v&\u0019\u0011q\u001f\u0003\u0003!M\u001b\u0007.\u001a3vY\u0016\u0014()Y2lK:$\u0007")
public class StandaloneSchedulerBackend
extends CoarseGrainedSchedulerBackend
implements StandaloneAppClientListener {
    private final TaskSchedulerImpl scheduler;
    private final SparkContext sc;
    private final String[] masters;
    private StandaloneAppClient client;
    private boolean stopping;
    private final LauncherBackend launcherBackend;
    private volatile Function1<StandaloneSchedulerBackend, BoxedUnit> shutdownCallback;
    private volatile String appId;
    private final Semaphore registrationBarrier;
    private final Option<Object> maxCores;
    private final int totalExpectedCores;

    public String org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$super$applicationId() {
        return SchedulerBackend$class.applicationId(this);
    }

    private StandaloneAppClient client() {
        return this.client;
    }

    private void client_$eq(StandaloneAppClient x$1) {
        this.client = x$1;
    }

    private boolean stopping() {
        return this.stopping;
    }

    private void stopping_$eq(boolean x$1) {
        this.stopping = x$1;
    }

    private LauncherBackend launcherBackend() {
        return this.launcherBackend;
    }

    public Function1<StandaloneSchedulerBackend, BoxedUnit> shutdownCallback() {
        return this.shutdownCallback;
    }

    public void shutdownCallback_$eq(Function1<StandaloneSchedulerBackend, BoxedUnit> x$1) {
        this.shutdownCallback = x$1;
    }

    private String appId() {
        return this.appId;
    }

    private void appId_$eq(String x$1) {
        this.appId = x$1;
    }

    private Semaphore registrationBarrier() {
        return this.registrationBarrier;
    }

    private Option<Object> maxCores() {
        return this.maxCores;
    }

    private int totalExpectedCores() {
        return this.totalExpectedCores;
    }

    @Override
    public void start() {
        super.start();
        this.launcherBackend().connect();
        String driverUrl = RpcEndpointAddress$.MODULE$.apply(this.sc.conf().get("spark.driver.host"), new StringOps(Predef$.MODULE$.augmentString(this.sc.conf().get("spark.driver.port"))).toInt(), CoarseGrainedSchedulerBackend$.MODULE$.ENDPOINT_NAME()).toString();
        Seq args = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--driver-url", driverUrl, "--executor-id", "{{EXECUTOR_ID}}", "--hostname", "{{HOSTNAME}}", "--cores", "{{CORES}}", "--app-id", "{{APP_ID}}", "--worker-url", "{{WORKER_URL}}"}));
        Seq extraJavaOpts = (Seq)this.sc.conf().getOption("spark.executor.extraJavaOptions").map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(String s) {
                return Utils$.MODULE$.splitCommandString(s);
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.empty();
            }
        });
        Seq classPathEntries = (Seq)this.sc.conf().getOption("spark.executor.extraClassPath").map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(String x$2) {
                return Predef$.MODULE$.refArrayOps((Object[])x$2.split(File.pathSeparator)).toSeq();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nil$ apply() {
                return Nil$.MODULE$;
            }
        });
        Seq libraryPathEntries = (Seq)this.sc.conf().getOption("spark.executor.extraLibraryPath").map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(String x$3) {
                return Predef$.MODULE$.refArrayOps((Object[])x$3.split(File.pathSeparator)).toSeq();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nil$ apply() {
                return Nil$.MODULE$;
            }
        });
        Nil$ testingClassPath = package$.MODULE$.props().contains("spark.testing") ? Predef$.MODULE$.refArrayOps((Object[])((String)package$.MODULE$.props().apply((Object)"java.class.path")).split(File.pathSeparator)).toSeq() : Nil$.MODULE$;
        Seq<String> sparkJavaOpts2 = Utils$.MODULE$.sparkJavaOpts(this.conf(), (Function1<String, Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String name) {
                return SparkConf$.MODULE$.isExecutorStartupConf(name);
            }
        });
        Seq javaOpts = (Seq)sparkJavaOpts2.$plus$plus((GenTraversableOnce)extraJavaOpts, Seq$.MODULE$.canBuildFrom());
        Command command = new Command("org.apache.spark.executor.CoarseGrainedExecutorBackend", (Seq<String>)args, (Map<String, String>)this.sc.executorEnvs(), (Seq<String>)((Seq)classPathEntries.$plus$plus((GenTraversableOnce)testingClassPath, Seq$.MODULE$.canBuildFrom())), (Seq<String>)libraryPathEntries, (Seq<String>)javaOpts);
        String appUIAddress = (String)this.sc.ui().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(SparkUI x$4) {
                return x$4.appUIAddress();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        Option coresPerExecutor = this.conf().getOption("spark.executor.cores").map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$5) {
                return new StringOps(Predef$.MODULE$.augmentString(x$5)).toInt();
            }
        });
        None$ initialExecutorLimit = Utils$.MODULE$.isDynamicAllocationEnabled(this.conf()) ? new Some((Object)BoxesRunTime.boxToInteger((int)0)) : None$.MODULE$;
        ApplicationDescription appDesc = new ApplicationDescription(this.sc.appName(), this.maxCores(), this.sc.executorMemory(), command, appUIAddress, this.sc.eventLogDir(), this.sc.eventLogCodec(), (Option<Object>)coresPerExecutor, (Option<Object>)initialExecutorLimit, ApplicationDescription$.MODULE$.$lessinit$greater$default$10());
        this.client_$eq(new StandaloneAppClient(this.sc.env().rpcEnv(), this.masters, appDesc, this, this.conf()));
        this.client().start();
        this.launcherBackend().setState(SparkAppHandle.State.SUBMITTED);
        this.waitForRegistration();
        this.launcherBackend().setState(SparkAppHandle.State.RUNNING);
    }

    @Override
    public synchronized void stop() {
        this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$stop(SparkAppHandle.State.FINISHED);
    }

    @Override
    public void connected(String appId) {
        this.logInfo((Function0<String>)new Serializable(this, appId){
            public static final long serialVersionUID = 0L;
            private final String appId$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Connected to Spark cluster with app ID ").append((Object)this.appId$1).toString();
            }
            {
                this.appId$1 = appId$1;
            }
        });
        this.appId_$eq(appId);
        this.notifyContext();
        this.launcherBackend().setAppId(appId);
    }

    @Override
    public void disconnected() {
        this.notifyContext();
        if (!this.stopping()) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Disconnected from Spark cluster! Waiting for reconnection...";
                }
            });
        }
    }

    @Override
    public void dead(String reason) {
        this.notifyContext();
        if (!this.stopping()) {
            this.launcherBackend().setState(SparkAppHandle.State.KILLED);
            this.logError((Function0<String>)new Serializable(this, reason){
                public static final long serialVersionUID = 0L;
                private final String reason$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Application has been killed. Reason: ").append((Object)this.reason$1).toString();
                }
                {
                    this.reason$1 = reason$1;
                }
            });
            this.scheduler.error(reason);
        }
        return;
        finally {
            this.sc.stopInNewThread();
        }
    }

    @Override
    public void executorAdded(String fullId, String workerId, String hostPort, int cores, int memory) {
        this.logInfo((Function0<String>)new Serializable(this, fullId, hostPort, cores, memory){
            public static final long serialVersionUID = 0L;
            private final String fullId$1;
            private final String hostPort$1;
            private final int cores$1;
            private final int memory$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Granted executor ID %s on hostPort %s with %d cores, %s RAM")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fullId$1, this.hostPort$1, BoxesRunTime.boxToInteger((int)this.cores$1), Utils$.MODULE$.megabytesToString(this.memory$1)}));
            }
            {
                this.fullId$1 = fullId$1;
                this.hostPort$1 = hostPort$1;
                this.cores$1 = cores$1;
                this.memory$1 = memory$1;
            }
        });
    }

    @Override
    public void executorRemoved(String fullId, String message, Option<Object> exitStatus, boolean workerLost) {
        Option<Object> option;
        block4: {
            ExecutorLossReason executorLossReason;
            block3: {
                block2: {
                    option = exitStatus;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    int code = BoxesRunTime.unboxToInt((Object)some.x());
                    executorLossReason = new ExecutorExited(code, true, message);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<Object> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                executorLossReason = new SlaveLost(message, workerLost);
            }
            ExecutorLossReason reason = executorLossReason;
            this.logInfo((Function0<String>)new Serializable(this, fullId, message){
                public static final long serialVersionUID = 0L;
                private final String fullId$2;
                private final String message$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Executor %s removed: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fullId$2, this.message$1}));
                }
                {
                    this.fullId$2 = fullId$2;
                    this.message$1 = message$1;
                }
            });
            this.removeExecutor(fullId.split("/")[1], reason);
            return;
        }
        throw new MatchError(option);
    }

    @Override
    public boolean sufficientResourcesRegistered() {
        return (double)this.totalCoreCount().get() >= (double)this.totalExpectedCores() * this.minRegisteredRatio();
    }

    @Override
    public String applicationId() {
        return (String)Option$.MODULE$.apply((Object)this.appId()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StandaloneSchedulerBackend $outer;

            public final String apply() {
                this.$outer.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Application ID is not initialized yet.";
                    }
                });
                return this.$outer.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$super$applicationId();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public Future<Object> doRequestTotalExecutors(int requestedTotal) {
        Option option;
        block4: {
            Future future;
            block3: {
                block2: {
                    option = Option$.MODULE$.apply((Object)this.client());
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    StandaloneAppClient c = (StandaloneAppClient)some.x();
                    future = c.requestTotalExecutors(requestedTotal);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                this.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Attempted to request executors before driver fully initialized.";
                    }
                });
                future = Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            return future;
        }
        throw new MatchError((Object)option);
    }

    @Override
    public Future<Object> doKillExecutors(Seq<String> executorIds) {
        Option option;
        block4: {
            Future future;
            block3: {
                block2: {
                    option = Option$.MODULE$.apply((Object)this.client());
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    StandaloneAppClient c = (StandaloneAppClient)some.x();
                    future = c.killExecutors(executorIds);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                this.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Attempted to kill executors before driver fully initialized.";
                    }
                });
                future = Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            return future;
        }
        throw new MatchError((Object)option);
    }

    private void waitForRegistration() {
        this.registrationBarrier().acquire();
    }

    private void notifyContext() {
        this.registrationBarrier().release();
    }

    public synchronized void org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$stop(SparkAppHandle.State finalState) {
        try {
            this.stopping_$eq(true);
            super.stop();
            this.client().stop();
            Function1<StandaloneSchedulerBackend, BoxedUnit> callback = this.shutdownCallback();
            if (callback != null) {
                callback.apply((Object)this);
            }
            return;
        }
        finally {
            this.launcherBackend().setState(finalState);
            this.launcherBackend().close();
        }
    }

    public StandaloneSchedulerBackend(TaskSchedulerImpl scheduler, SparkContext sc, String[] masters) {
        this.scheduler = scheduler;
        this.sc = sc;
        this.masters = masters;
        super(scheduler, sc.env().rpcEnv());
        this.client = null;
        this.stopping = false;
        this.launcherBackend = new $anon$1(this);
        this.registrationBarrier = new Semaphore(0);
        this.maxCores = this.conf().getOption("spark.cores.max").map((Function1)new $anonfun$2(this));
        this.totalExpectedCores = BoxesRunTime.unboxToInt((Object)this.maxCores().getOrElse((Function0)new $anonfun$1(this)));
    }
}

