/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.nio.ByteBuffer;
import java.util.Properties;
import org.apache.spark.Partition;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.rdd.RDD;
import org.apache.spark.scheduler.ResultTask$;
import org.apache.spark.scheduler.Task;
import org.apache.spark.scheduler.TaskLocation;
import org.apache.spark.serializer.SerializerInstance;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055f!B\u0001\u0003\u0001\u0011Q!A\u0003*fgVdG\u000fV1tW*\u00111\u0001B\u0001\ng\u000eDW\rZ;mKJT!!\u0002\u0004\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dA\u0011AB1qC\u000eDWMC\u0001\n\u0003\ry'oZ\u000b\u0005\u0017\u0005%!cE\u0002\u0001\u0019}\u00012!\u0004\b\u0011\u001b\u0005\u0011\u0011BA\b\u0003\u0005\u0011!\u0016m]6\u0011\u0005E\u0011B\u0002\u0001\u0003\u0006'\u0001\u0011\r!\u0006\u0002\u0002+\u000e\u0001\u0011C\u0001\f\u001d!\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"aF\u000f\n\u0005yA\"aA!osB\u0011\u0001%J\u0007\u0002C)\u0011!eI\u0001\u0003S>T\u0011\u0001J\u0001\u0005U\u00064\u0018-\u0003\u0002'C\ta1+\u001a:jC2L'0\u00192mK\"I\u0001\u0006\u0001B\u0001B\u0003%\u0011\u0006L\u0001\bgR\fw-Z%e!\t9\"&\u0003\u0002,1\t\u0019\u0011J\u001c;\n\u0005!r\u0001\"\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u00150\u00039\u0019H/Y4f\u0003R$X-\u001c9u\u0013\u0012L!A\f\b\t\u0011E\u0002!\u0011!Q\u0001\nI\n!\u0002^1tW\nKg.\u0019:z!\r\u0019d\u0007O\u0007\u0002i)\u0011Q\u0007B\u0001\nEJ|\u0017\rZ2bgRL!a\u000e\u001b\u0003\u0013\t\u0013x.\u00193dCN$\bcA\f:w%\u0011!\b\u0007\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003/qJ!!\u0010\r\u0003\t\tKH/\u001a\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\u0006I\u0001/\u0019:uSRLwN\u001c\t\u0003\u0003\nk\u0011\u0001B\u0005\u0003\u0007\u0012\u0011\u0011\u0002U1si&$\u0018n\u001c8\t\u0011\u0015\u0003!\u0011!Q\u0001\n\u0019\u000bA\u0001\\8dgB\u0019qi\u0014*\u000f\u0005!keBA%M\u001b\u0005Q%BA&\u0015\u0003\u0019a$o\\8u}%\t\u0011$\u0003\u0002O1\u00059\u0001/Y2lC\u001e,\u0017B\u0001)R\u0005\r\u0019V-\u001d\u0006\u0003\u001db\u0001\"!D*\n\u0005Q\u0013!\u0001\u0004+bg.dunY1uS>t\u0007\u0002\u0003,\u0001\u0005\u000b\u0007I\u0011A,\u0002\u0011=,H\u000f];u\u0013\u0012,\u0012!\u000b\u0005\t3\u0002\u0011\t\u0011)A\u0005S\u0005Iq.\u001e;qkRLE\r\t\u0005\t7\u0002\u0011\t\u0011)A\u00059\u0006yAn\\2bYB\u0013x\u000e]3si&,7\u000f\u0005\u0002^A6\taL\u0003\u0002`G\u0005!Q\u000f^5m\u0013\t\tgL\u0001\u0006Qe>\u0004XM\u001d;jKND\u0011b\u0019\u0001\u0003\u0002\u0003\u0006I\u0001\u001a6\u0002\u000f5,GO]5dgB\u0011Q\r[\u0007\u0002M*\u0011q\rB\u0001\tKb,7-\u001e;pe&\u0011\u0011N\u001a\u0002\f)\u0006\u001c8.T3ue&\u001c7/\u0003\u0002d\u001d!IA\u000e\u0001B\u0001B\u0003%Q\u000e]\u0001\u0006U>\u0014\u0017\n\u001a\t\u0004/9L\u0013BA8\u0019\u0005\u0019y\u0005\u000f^5p]&\u0011AN\u0004\u0005\ne\u0002\u0011\t\u0011)A\u0005gn\fQ!\u00199q\u0013\u0012\u00042a\u00068u!\t)\bP\u0004\u0002\u0018m&\u0011q\u000fG\u0001\u0007!J,G-\u001a4\n\u0005eT(AB*ue&twM\u0003\u0002x1%\u0011!O\u0004\u0005\n{\u0002\u0011\t\u0011)A\u0005gz\fA\"\u00199q\u0003R$X-\u001c9u\u0013\u0012L!! \b\t\u000f\u0005\u0005\u0001\u0001\"\u0001\u0002\u0004\u00051A(\u001b8jiz\"\u0002$!\u0002\u0002\u000e\u0005=\u0011\u0011CA\n\u0003+\t9\"!\u0007\u0002\u001c\u0005u\u0011qDA\u0011!\u0015i\u0001!a\u0002\u0011!\r\t\u0012\u0011\u0002\u0003\u0007\u0003\u0017\u0001!\u0019A\u000b\u0003\u0003QCQ\u0001K@A\u0002%BQAL@A\u0002%BQ!M@A\u0002IBQaP@A\u0002\u0001CQ!R@A\u0002\u0019CQAV@A\u0002%BQaW@A\u0002qCQaY@A\u0002\u0011Dq\u0001\\@\u0011\u0002\u0003\u0007Q\u000eC\u0004s\u007fB\u0005\t\u0019A:\t\u000fu|\b\u0013!a\u0001g\"9\u0011Q\u0005\u0001!\u0002\u00131\u0015!\u00049sK\u001a,'O]3e\u0019>\u001c7\u000f\u000b\u0003\u0002$\u0005%\u0002cA\f\u0002,%\u0019\u0011Q\u0006\r\u0003\u0013Q\u0014\u0018M\\:jK:$\bbBA\u0019\u0001\u0011\u0005\u00131G\u0001\beVtG+Y:l)\r\u0001\u0012Q\u0007\u0005\t\u0003o\ty\u00031\u0001\u0002:\u000591m\u001c8uKb$\bcA!\u0002<%\u0019\u0011Q\b\u0003\u0003\u0017Q\u000b7o[\"p]R,\u0007\u0010\u001e\u0005\b\u0003\u0003\u0002A\u0011IA\"\u0003I\u0001(/\u001a4feJ,G\rT8dCRLwN\\:\u0016\u0003\u0019Cq!a\u0012\u0001\t\u0003\nI%\u0001\u0005u_N#(/\u001b8h)\u0005!xACA'\u0005\u0005\u0005\t\u0012\u0001\u0003\u0002P\u0005Q!+Z:vYR$\u0016m]6\u0011\u00075\t\tFB\u0005\u0002\u0005\u0005\u0005\t\u0012\u0001\u0003\u0002TM1\u0011\u0011KA+\u00037\u00022aFA,\u0013\r\tI\u0006\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0007]\ti&\u0003\u0002'1!A\u0011\u0011AA)\t\u0003\t\t\u0007\u0006\u0002\u0002P!Q\u0011QMA)#\u0003%\t!a\u001a\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u0013:+\u0019\tI'a \u0002\u0002V\u0011\u00111\u000e\u0016\u0004[\u000654FAA8!\u0011\t\t(a\u001f\u000e\u0005\u0005M$\u0002BA;\u0003o\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005e\u0004$\u0001\u0006b]:|G/\u0019;j_:LA!! \u0002t\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000f\u0005-\u00111\rb\u0001+\u001111#a\u0019C\u0002UA!\"!\"\u0002RE\u0005I\u0011AAD\u0003q!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cA*b!!#\u0002\u000e\u0006=UCAAFU\r\u0019\u0018Q\u000e\u0003\b\u0003\u0017\t\u0019I1\u0001\u0016\t\u0019\u0019\u00121\u0011b\u0001+!Q\u00111SA)#\u0003%\t!!&\u00029\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132cU1\u0011\u0011RAL\u00033#q!a\u0003\u0002\u0012\n\u0007Q\u0003\u0002\u0004\u0014\u0003#\u0013\r!\u0006\u0005\u000b\u0003;\u000b\t&!A\u0005\n\u0005}\u0015a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!)\u0011\t\u0005\r\u0016\u0011V\u0007\u0003\u0003KS1!a*$\u0003\u0011a\u0017M\\4\n\t\u0005-\u0016Q\u0015\u0002\u0007\u001f\nTWm\u0019;")
public class ResultTask<T, U>
extends Task<U>
implements Serializable {
    private final Broadcast<byte[]> taskBinary;
    private final Partition partition;
    private final int outputId;
    private final transient Seq<TaskLocation> preferredLocs;

    public static <T, U> Option<String> $lessinit$greater$default$11() {
        return ResultTask$.MODULE$.$lessinit$greater$default$11();
    }

    public static <T, U> Option<String> $lessinit$greater$default$10() {
        return ResultTask$.MODULE$.$lessinit$greater$default$10();
    }

    public static <T, U> Option<Object> $lessinit$greater$default$9() {
        return ResultTask$.MODULE$.$lessinit$greater$default$9();
    }

    public int outputId() {
        return this.outputId;
    }

    @Override
    public U runTask(TaskContext context) {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        long deserializeStartTime = System.currentTimeMillis();
        long deserializeStartCpuTime = threadMXBean.isCurrentThreadCpuTimeSupported() ? threadMXBean.getCurrentThreadCpuTime() : 0L;
        SerializerInstance ser = SparkEnv$.MODULE$.get().closureSerializer().newInstance();
        Tuple2 tuple2 = (Tuple2)ser.deserialize(ByteBuffer.wrap(this.taskBinary.value()), Thread.currentThread().getContextClassLoader(), ClassTag$.MODULE$.apply(Tuple2.class));
        if (tuple2 != null) {
            Tuple2 tuple22;
            RDD rdd = (RDD)tuple2._1();
            Function2 func = (Function2)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)rdd, (Object)func);
            RDD rdd2 = (RDD)tuple23._1();
            Function2 func2 = (Function2)tuple23._2();
            this._executorDeserializeTime_$eq(System.currentTimeMillis() - deserializeStartTime);
            this._executorDeserializeCpuTime_$eq(threadMXBean.isCurrentThreadCpuTimeSupported() ? threadMXBean.getCurrentThreadCpuTime() - deserializeStartCpuTime : 0L);
            return (U)func2.apply((Object)context, rdd2.iterator(this.partition, context));
        }
        throw new MatchError((Object)tuple2);
    }

    @Override
    public Seq<TaskLocation> preferredLocations() {
        return this.preferredLocs;
    }

    public String toString() {
        return new StringBuilder().append((Object)"ResultTask(").append((Object)BoxesRunTime.boxToInteger((int)super.stageId())).append((Object)", ").append((Object)BoxesRunTime.boxToInteger((int)this.partitionId())).append((Object)")").toString();
    }

    public ResultTask(int stageId, int stageAttemptId, Broadcast<byte[]> taskBinary, Partition partition, Seq<TaskLocation> locs, int outputId, Properties localProperties, TaskMetrics metrics, Option<Object> jobId, Option<String> appId, Option<String> appAttemptId) {
        this.taskBinary = taskBinary;
        this.partition = partition;
        this.outputId = outputId;
        super(stageId, stageAttemptId, partition.index(), metrics, localProperties, jobId, appId, appAttemptId);
        this.preferredLocs = locs == null ? Nil$.MODULE$ : locs.toSet().toSeq();
    }
}

