/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.net.URL;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.Writable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkMasterRegex$;
import org.apache.spark.deploy.LocalSparkCluster;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.scheduler.ExternalClusterManager;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.TaskScheduler;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.StandaloneSchedulerBackend;
import org.apache.spark.scheduler.local.LocalSchedulerBackend;
import org.apache.spark.util.CallSite;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class SparkContext$
implements Logging {
    public static final SparkContext$ MODULE$;
    private final Set<String> org$apache$spark$SparkContext$$VALID_LOG_LEVELS;
    private final Object SPARK_CONTEXT_CONSTRUCTOR_LOCK;
    private final AtomicReference<SparkContext> org$apache$spark$SparkContext$$activeContext;
    private Option<SparkContext> contextBeingConstructed;
    private final String SPARK_JOB_DESCRIPTION;
    private final String SPARK_JOB_GROUP_ID;
    private final String SPARK_JOB_INTERRUPT_ON_CANCEL;
    private final String RDD_SCOPE_KEY;
    private final String RDD_SCOPE_NO_OVERRIDE_KEY;
    private final String DRIVER_IDENTIFIER;
    private final String LEGACY_DRIVER_IDENTIFIER;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SparkContext$();
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    public Set<String> org$apache$spark$SparkContext$$VALID_LOG_LEVELS() {
        return this.org$apache$spark$SparkContext$$VALID_LOG_LEVELS;
    }

    private Object SPARK_CONTEXT_CONSTRUCTOR_LOCK() {
        return this.SPARK_CONTEXT_CONSTRUCTOR_LOCK;
    }

    public AtomicReference<SparkContext> org$apache$spark$SparkContext$$activeContext() {
        return this.org$apache$spark$SparkContext$$activeContext;
    }

    private Option<SparkContext> contextBeingConstructed() {
        return this.contextBeingConstructed;
    }

    private void contextBeingConstructed_$eq(Option<SparkContext> x$1) {
        this.contextBeingConstructed = x$1;
    }

    private void assertNoOtherContextIsRunning(SparkContext sc, boolean allowMultipleContexts) {
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            Option$.MODULE$.apply((Object)this.org$apache$spark$SparkContext$$activeContext().get()).filter((Function1)new Serializable(sc){
                public static final long serialVersionUID = 0L;
                private final SparkContext sc$1;

                public final boolean apply(SparkContext x$34) {
                    return x$34 != this.sc$1;
                }
                {
                    this.sc$1 = sc$1;
                }
            }).foreach((Function1)new Serializable(allowMultipleContexts){
                public static final long serialVersionUID = 0L;
                private final boolean allowMultipleContexts$1;

                public final void apply(SparkContext ctx) {
                    String errMsg = new StringBuilder().append((Object)"Only one SparkContext may be running in this JVM (see SPARK-2243). To ignore this error, set spark.driver.allowMultipleContexts = true. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The currently running SparkContext was created at:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ctx.org$apache$spark$SparkContext$$creationSite().longForm()}))).toString();
                    SparkException exception2 = new SparkException(errMsg);
                    if (this.allowMultipleContexts$1) {
                        SparkContext$.MODULE$.logWarning((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Multiple running SparkContexts detected in the same JVM!";
                            }
                        }, exception2);
                        return;
                    }
                    throw exception2;
                }
                {
                    this.allowMultipleContexts$1 = allowMultipleContexts$1;
                }
            });
            this.contextBeingConstructed().filter((Function1)new Serializable(sc){
                public static final long serialVersionUID = 0L;
                private final SparkContext sc$1;

                public final boolean apply(SparkContext x$35) {
                    return x$35 != this.sc$1;
                }
                {
                    this.sc$1 = sc$1;
                }
            }).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(SparkContext otherContext) {
                    String otherContextCreationSite = (String)Option$.MODULE$.apply((Object)otherContext.org$apache$spark$SparkContext$$creationSite()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(CallSite x$36) {
                            return x$36.longForm();
                        }
                    }).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "unknown location";
                        }
                    });
                    String warnMsg = new StringBuilder().append((Object)"Another SparkContext is being constructed (or threw an exception in its constructor).  This may indicate an error, since only one SparkContext may be running in this JVM (see SPARK-2243).").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" The other SparkContext was created at:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{otherContextCreationSite}))).toString();
                    SparkContext$.MODULE$.logWarning((Function0<String>)new Serializable(this, warnMsg){
                        public static final long serialVersionUID = 0L;
                        private final String warnMsg$1;

                        public final String apply() {
                            return this.warnMsg$1;
                        }
                        {
                            this.warnMsg$1 = warnMsg$1;
                        }
                    });
                }
            });
            return;
        }
    }

    public SparkContext getOrCreate(SparkConf config) {
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            if (this.org$apache$spark$SparkContext$$activeContext().get() == null) {
                this.setActiveContext(new SparkContext(config), false);
            } else if (Predef$.MODULE$.refArrayOps((Object[])config.getAll()).nonEmpty()) {
                this.logWarning((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Using an existing SparkContext; some configuration may not take effect.";
                    }
                });
            }
            SparkContext sparkContext = this.org$apache$spark$SparkContext$$activeContext().get();
            return sparkContext;
        }
    }

    public SparkContext getOrCreate() {
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            if (this.org$apache$spark$SparkContext$$activeContext().get() == null) {
                this.setActiveContext(new SparkContext(), false);
            }
            SparkContext sparkContext = this.org$apache$spark$SparkContext$$activeContext().get();
            return sparkContext;
        }
    }

    public void markPartiallyConstructed(SparkContext sc, boolean allowMultipleContexts) {
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            this.assertNoOtherContextIsRunning(sc, allowMultipleContexts);
            this.contextBeingConstructed_$eq((Option<SparkContext>)new Some((Object)sc));
            return;
        }
    }

    public void setActiveContext(SparkContext sc, boolean allowMultipleContexts) {
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            this.assertNoOtherContextIsRunning(sc, allowMultipleContexts);
            this.contextBeingConstructed_$eq((Option<SparkContext>)None$.MODULE$);
            this.org$apache$spark$SparkContext$$activeContext().set(sc);
            return;
        }
    }

    public void clearActiveContext() {
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            this.org$apache$spark$SparkContext$$activeContext().set(null);
            return;
        }
    }

    public String SPARK_JOB_DESCRIPTION() {
        return this.SPARK_JOB_DESCRIPTION;
    }

    public String SPARK_JOB_GROUP_ID() {
        return this.SPARK_JOB_GROUP_ID;
    }

    public String SPARK_JOB_INTERRUPT_ON_CANCEL() {
        return this.SPARK_JOB_INTERRUPT_ON_CANCEL;
    }

    public String RDD_SCOPE_KEY() {
        return this.RDD_SCOPE_KEY;
    }

    public String RDD_SCOPE_NO_OVERRIDE_KEY() {
        return this.RDD_SCOPE_NO_OVERRIDE_KEY;
    }

    public String DRIVER_IDENTIFIER() {
        return this.DRIVER_IDENTIFIER;
    }

    public String LEGACY_DRIVER_IDENTIFIER() {
        return this.LEGACY_DRIVER_IDENTIFIER;
    }

    private <T> ArrayWritable arrayToArrayWritable(Traversable<T> arr, Function1<T, Writable> evidence$19, ClassTag<T> evidence$20) {
        return new ArrayWritable(package$.MODULE$.classTag(evidence$20).runtimeClass(), (Writable[])((TraversableOnce)arr.map((Function1)new Serializable(evidence$19){
            public static final long serialVersionUID = 0L;
            private final Function1 evidence$19$1;

            public final Writable apply(T x) {
                return SparkContext$.MODULE$.org$apache$spark$SparkContext$$anyToWritable$1(x, this.evidence$19$1);
            }
            {
                this.evidence$19$1 = evidence$19$1;
            }
        }, Traversable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Writable.class)));
    }

    public Option<String> jarOfClass(Class<?> cls) {
        String uriStr;
        URL uri = cls.getResource(new StringBuilder().append((Object)"/").append((Object)cls.getName().replace('.', '/')).append((Object)".class").toString());
        return uri == null ? None$.MODULE$ : ((uriStr = uri.toString()).startsWith("jar:file:") ? new Some((Object)uriStr.substring("jar:file:".length(), uriStr.indexOf(33))) : None$.MODULE$);
    }

    public Option<String> jarOfObject(Object obj) {
        return this.jarOfClass(obj.getClass());
    }

    public SparkConf updatedConf(SparkConf conf, String master, String appName, String sparkHome, Seq<String> jars, Map<String, String> environment) {
        SparkConf res = conf.clone();
        res.setMaster(master);
        res.setAppName(appName);
        Object object = sparkHome == null ? BoxedUnit.UNIT : res.setSparkHome(sparkHome);
        Object object2 = jars == null || jars.isEmpty() ? BoxedUnit.UNIT : res.setJars(jars);
        res.setExecutorEnv((Seq<Tuple2<String, String>>)environment.toSeq());
        return res;
    }

    public String updatedConf$default$4() {
        return null;
    }

    public Seq<String> updatedConf$default$5() {
        return Nil$.MODULE$;
    }

    public Map<String, String> updatedConf$default$6() {
        return (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public int numDriverCores(String master) {
        int n;
        String string;
        String string2 = string = master;
        if (!("local" != null ? !"local".equals(string2) : string2 != null)) {
            n = 1;
        } else {
            Option option = SparkMasterRegex$.MODULE$.LOCAL_N_REGEX().unapplySeq((Object)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                String threads = (String)((LinearSeqOptimized)option.get()).apply(0);
                n = this.convertToInt$1(threads);
            } else {
                Option option2 = SparkMasterRegex$.MODULE$.LOCAL_N_FAILURES_REGEX().unapplySeq((Object)string);
                if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
                    String threads = (String)((LinearSeqOptimized)option2.get()).apply(0);
                    n = this.convertToInt$1(threads);
                } else {
                    n = 0;
                }
            }
        }
        return n;
    }

    public Tuple2<SchedulerBackend, TaskScheduler> org$apache$spark$SparkContext$$createTaskScheduler(SparkContext sc, String master, String deployMode2) {
        Option<ExternalClusterManager> option;
        block16: {
            Tuple2 tuple2;
            block11: {
                ExternalClusterManager clusterMgr;
                ExternalClusterManager externalClusterManager;
                String string;
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                int threadCount;
                                String threads;
                                int MAX_LOCAL_TASK_FAILURES;
                                block10: {
                                    MAX_LOCAL_TASK_FAILURES = 1;
                                    String string2 = string = master;
                                    if ("local" != null ? !"local".equals(string2) : string2 != null) break block10;
                                    TaskSchedulerImpl scheduler = new TaskSchedulerImpl(sc, MAX_LOCAL_TASK_FAILURES, true);
                                    LocalSchedulerBackend backend = new LocalSchedulerBackend(sc.getConf(), scheduler, 1);
                                    scheduler.initialize(backend);
                                    tuple2 = new Tuple2((Object)backend, (Object)scheduler);
                                    break block11;
                                }
                                Option option2 = SparkMasterRegex$.MODULE$.LOCAL_N_REGEX().unapplySeq((Object)string);
                                if (option2.isEmpty() || option2.get() == null || ((LinearSeqOptimized)option2.get()).lengthCompare(1) != 0) break block12;
                                String string3 = threads = (String)((LinearSeqOptimized)option2.get()).apply(0);
                                String string4 = "*";
                                int n = !(string3 != null ? !string3.equals(string4) : string4 != null) ? this.localCpuCount$1() : (threadCount = new StringOps(Predef$.MODULE$.augmentString(threads)).toInt());
                                if (threadCount <= 0) {
                                    throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Asked to run locally with ", " threads"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)threadCount)})));
                                }
                                TaskSchedulerImpl scheduler = new TaskSchedulerImpl(sc, MAX_LOCAL_TASK_FAILURES, true);
                                LocalSchedulerBackend backend = new LocalSchedulerBackend(sc.getConf(), scheduler, threadCount);
                                scheduler.initialize(backend);
                                tuple2 = new Tuple2((Object)backend, (Object)scheduler);
                                break block11;
                            }
                            Option option3 = SparkMasterRegex$.MODULE$.LOCAL_N_FAILURES_REGEX().unapplySeq((Object)string);
                            if (option3.isEmpty() || option3.get() == null || ((LinearSeqOptimized)option3.get()).lengthCompare(2) != 0) break block13;
                            String threads = (String)((LinearSeqOptimized)option3.get()).apply(0);
                            String maxFailures = (String)((LinearSeqOptimized)option3.get()).apply(1);
                            String string5 = threads;
                            String string6 = "*";
                            int threadCount = !(string5 != null ? !string5.equals(string6) : string6 != null) ? this.localCpuCount$2() : new StringOps(Predef$.MODULE$.augmentString(threads)).toInt();
                            TaskSchedulerImpl scheduler = new TaskSchedulerImpl(sc, new StringOps(Predef$.MODULE$.augmentString(maxFailures)).toInt(), true);
                            LocalSchedulerBackend backend = new LocalSchedulerBackend(sc.getConf(), scheduler, threadCount);
                            scheduler.initialize(backend);
                            tuple2 = new Tuple2((Object)backend, (Object)scheduler);
                            break block11;
                        }
                        Option option4 = SparkMasterRegex$.MODULE$.SPARK_REGEX().unapplySeq((Object)string);
                        if (option4.isEmpty() || option4.get() == null || ((LinearSeqOptimized)option4.get()).lengthCompare(1) != 0) break block14;
                        String sparkUrl = (String)((LinearSeqOptimized)option4.get()).apply(0);
                        TaskSchedulerImpl scheduler = new TaskSchedulerImpl(sc);
                        String[] masterUrls = (String[])Predef$.MODULE$.refArrayOps((Object[])sparkUrl.split(",")).map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply(String x$37) {
                                return new StringBuilder().append((Object)"spark://").append((Object)x$37).toString();
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                        StandaloneSchedulerBackend backend = new StandaloneSchedulerBackend(scheduler, sc, masterUrls);
                        scheduler.initialize(backend);
                        tuple2 = new Tuple2((Object)backend, (Object)scheduler);
                        break block11;
                    }
                    Option option5 = SparkMasterRegex$.MODULE$.LOCAL_CLUSTER_REGEX().unapplySeq((Object)string);
                    if (option5.isEmpty() || option5.get() == null || ((LinearSeqOptimized)option5.get()).lengthCompare(3) != 0) break block15;
                    String numSlaves = (String)((LinearSeqOptimized)option5.get()).apply(0);
                    String coresPerSlave = (String)((LinearSeqOptimized)option5.get()).apply(1);
                    String memoryPerSlave = (String)((LinearSeqOptimized)option5.get()).apply(2);
                    int memoryPerSlaveInt = new StringOps(Predef$.MODULE$.augmentString(memoryPerSlave)).toInt();
                    if (sc.executorMemory() > memoryPerSlaveInt) {
                        throw new SparkException(new StringOps(Predef$.MODULE$.augmentString("Asked to launch cluster with %d MB RAM / worker but requested %d MB/worker")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)memoryPerSlaveInt), BoxesRunTime.boxToInteger((int)sc.executorMemory())})));
                    }
                    TaskSchedulerImpl scheduler = new TaskSchedulerImpl(sc);
                    LocalSparkCluster localCluster = new LocalSparkCluster(new StringOps(Predef$.MODULE$.augmentString(numSlaves)).toInt(), new StringOps(Predef$.MODULE$.augmentString(coresPerSlave)).toInt(), memoryPerSlaveInt, sc.conf());
                    String[] masterUrls = localCluster.start();
                    StandaloneSchedulerBackend backend = new StandaloneSchedulerBackend(scheduler, sc, masterUrls);
                    scheduler.initialize(backend);
                    backend.shutdownCallback_$eq((Function1<StandaloneSchedulerBackend, BoxedUnit>)new Serializable(localCluster){
                        public static final long serialVersionUID = 0L;
                        private final LocalSparkCluster localCluster$1;

                        public final void apply(StandaloneSchedulerBackend backend) {
                            this.localCluster$1.stop();
                        }
                        {
                            this.localCluster$1 = localCluster$1;
                        }
                    });
                    tuple2 = new Tuple2((Object)backend, (Object)scheduler);
                    break block11;
                }
                option = this.getClusterManager(string);
                if (!(option instanceof Some)) break block16;
                Some some = (Some)option;
                ExternalClusterManager cm = externalClusterManager = (clusterMgr = (ExternalClusterManager)some.x());
                try {
                    TaskScheduler scheduler = cm.createTaskScheduler(sc, string);
                    SchedulerBackend backend = cm.createSchedulerBackend(sc, string, scheduler);
                    cm.initialize(scheduler, backend);
                    tuple2 = new Tuple2((Object)backend, (Object)scheduler);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof SparkException) {
                        SparkException sparkException = (SparkException)throwable2;
                        throw sparkException;
                    }
                    Option option6 = NonFatal$.MODULE$.unapply(throwable2);
                    if (option6.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option6.get();
                    throw new SparkException("External scheduler cannot be instantiated", e);
                }
            }
            return tuple2;
        }
        None$ none$ = None$.MODULE$;
        Option<ExternalClusterManager> option7 = option;
        if (!(none$ != null ? !none$.equals(option7) : option7 != null)) {
            throw new SparkException(new StringBuilder().append((Object)"Could not parse Master URL: '").append((Object)master).append((Object)"'").toString());
        }
        throw new MatchError(option);
    }

    private Option<ExternalClusterManager> getClusterManager(String url) {
        ClassLoader loader = Utils$.MODULE$.getContextOrSparkClassLoader();
        Iterable serviceLoaders = (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(ServiceLoader.load(ExternalClusterManager.class, loader)).asScala()).filter((Function1)new Serializable(url){
            public static final long serialVersionUID = 0L;
            private final String url$1;

            public final boolean apply(ExternalClusterManager x$38) {
                return x$38.canCreate(this.url$1);
            }
            {
                this.url$1 = url$1;
            }
        });
        if (serviceLoaders.size() > 1) {
            throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Multiple external cluster managers registered for the url ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url, serviceLoaders})));
        }
        return serviceLoaders.headOption();
    }

    public String $lessinit$greater$default$3() {
        return null;
    }

    public Seq<String> $lessinit$greater$default$4() {
        return Nil$.MODULE$;
    }

    public Map<String, String> $lessinit$greater$default$5() {
        return (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public final Writable org$apache$spark$SparkContext$$anyToWritable$1(Object u, Function1 evidence$21) {
        return (Writable)evidence$21.apply(u);
    }

    private final int convertToInt$1(String threads) {
        String string = threads;
        String string2 = "*";
        return !(string != null ? !string.equals(string2) : string2 != null) ? Runtime.getRuntime().availableProcessors() : new StringOps(Predef$.MODULE$.augmentString(threads)).toInt();
    }

    private final int localCpuCount$1() {
        return Runtime.getRuntime().availableProcessors();
    }

    private final int localCpuCount$2() {
        return Runtime.getRuntime().availableProcessors();
    }

    private SparkContext$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.org$apache$spark$SparkContext$$VALID_LOG_LEVELS = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ALL", "DEBUG", "ERROR", "FATAL", "INFO", "OFF", "TRACE", "WARN"}));
        this.SPARK_CONTEXT_CONSTRUCTOR_LOCK = new Object();
        this.org$apache$spark$SparkContext$$activeContext = new AtomicReference<Object>(null);
        this.contextBeingConstructed = None$.MODULE$;
        this.SPARK_JOB_DESCRIPTION = "spark.job.description";
        this.SPARK_JOB_GROUP_ID = "spark.jobGroup.id";
        this.SPARK_JOB_INTERRUPT_ON_CANCEL = "spark.job.interruptOnCancel";
        this.RDD_SCOPE_KEY = "spark.rdd.scope";
        this.RDD_SCOPE_NO_OVERRIDE_KEY = "spark.rdd.scope.noOverride";
        this.DRIVER_IDENTIFIER = "driver";
        this.LEGACY_DRIVER_IDENTIFIER = "<driver>";
    }
}

