/*
 * Decompiled with CFR 0.152.
 */
package org.spark-project.jetty.util.log;

import java.util.logging.Level;
import org.spark-project.jetty.util.log.AbstractLogger;
import org.spark-project.jetty.util.log.Log;
import org.spark-project.jetty.util.log.Logger;

public class JavaUtilLog
extends AbstractLogger {
    private Level configuredLevel;
    private java.util.logging.Logger _logger;

    public JavaUtilLog() {
        this("org.spark-project.jetty.util.log");
    }

    public JavaUtilLog(String name) {
        this._logger = java.util.logging.Logger.getLogger(name);
        if (Boolean.parseBoolean(Log.__props.getProperty("org.spark-project.jetty.util.log.DEBUG", "false"))) {
            this._logger.setLevel(Level.FINE);
        }
        this.configuredLevel = this._logger.getLevel();
    }

    @Override
    public String getName() {
        return this._logger.getName();
    }

    @Override
    public void warn(String msg, Object ... args) {
        this._logger.log(Level.WARNING, this.format(msg, args));
    }

    @Override
    public void warn(Throwable thrown) {
        this.warn("", thrown);
    }

    @Override
    public void warn(String msg, Throwable thrown) {
        this._logger.log(Level.WARNING, msg, thrown);
    }

    @Override
    public void info(String msg, Object ... args) {
        this._logger.log(Level.INFO, this.format(msg, args));
    }

    @Override
    public void info(Throwable thrown) {
        this.info("", thrown);
    }

    @Override
    public void info(String msg, Throwable thrown) {
        this._logger.log(Level.INFO, msg, thrown);
    }

    @Override
    public boolean isDebugEnabled() {
        return this._logger.isLoggable(Level.FINE);
    }

    @Override
    public void setDebugEnabled(boolean enabled) {
        if (enabled) {
            this.configuredLevel = this._logger.getLevel();
            this._logger.setLevel(Level.FINE);
        } else {
            this._logger.setLevel(this.configuredLevel);
        }
    }

    @Override
    public void debug(String msg, Object ... args) {
        this._logger.log(Level.FINE, this.format(msg, args));
    }

    @Override
    public void debug(Throwable thrown) {
        this.debug("", thrown);
    }

    @Override
    public void debug(String msg, Throwable thrown) {
        this._logger.log(Level.FINE, msg, thrown);
    }

    @Override
    protected Logger newLogger(String fullname) {
        return new JavaUtilLog(fullname);
    }

    @Override
    public void ignore(Throwable ignored) {
        if (Log.isIgnored()) {
            this.warn("IGNORED ", ignored);
        }
    }

    private String format(String msg, Object ... args) {
        msg = String.valueOf(msg);
        String braces = "{}";
        StringBuilder builder = new StringBuilder();
        int start2 = 0;
        for (Object arg : args) {
            int bracesIndex = msg.indexOf(braces, start2);
            if (bracesIndex < 0) {
                builder.append(msg.substring(start2));
                builder.append(" ");
                builder.append(arg);
                start2 = msg.length();
                continue;
            }
            builder.append(msg.substring(start2, bracesIndex));
            builder.append(String.valueOf(arg));
            start2 = bracesIndex + braces.length();
        }
        builder.append(msg.substring(start2));
        return builder.toString();
    }
}

