/*
 * Decompiled with CFR 0.152.
 */
package org.spark-project.jetty.server;

import java.io.IOException;
import org.spark-project.jetty.http.HttpException;
import org.spark-project.jetty.io.AsyncEndPoint;
import org.spark-project.jetty.io.Connection;
import org.spark-project.jetty.io.EndPoint;
import org.spark-project.jetty.io.nio.AsyncConnection;
import org.spark-project.jetty.io.nio.SelectChannelEndPoint;
import org.spark-project.jetty.server.AbstractHttpConnection;
import org.spark-project.jetty.server.Connector;
import org.spark-project.jetty.server.Server;
import org.spark-project.jetty.util.log.Log;
import org.spark-project.jetty.util.log.Logger;

public class AsyncHttpConnection
extends AbstractHttpConnection
implements AsyncConnection {
    private static final int NO_PROGRESS_INFO = Integer.getInteger("org.mortbay.jetty.NO_PROGRESS_INFO", 100);
    private static final int NO_PROGRESS_CLOSE = Integer.getInteger("org.mortbay.jetty.NO_PROGRESS_CLOSE", 200);
    private static final Logger LOG = Log.getLogger(AsyncHttpConnection.class);
    private int _total_no_progress;
    private final AsyncEndPoint _asyncEndp;
    private boolean _readInterested = true;

    public AsyncHttpConnection(Connector connector, EndPoint endpoint, Server server) {
        super(connector, endpoint, server);
        this._asyncEndp = (AsyncEndPoint)endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Connection handle() throws IOException {
        Connection connection = this;
        boolean some_progress = false;
        boolean progress = true;
        try {
            AsyncHttpConnection.setCurrentConnection(this);
            this._asyncEndp.setCheckForIdle(false);
            while (progress && connection == this) {
                Connection switched;
                boolean complete;
                boolean generatorComplete;
                boolean parserComplete;
                progress = false;
                try {
                    if (this._request._async.isAsync()) {
                        if (this._request._async.isDispatchable()) {
                            this.handleRequest();
                        }
                    } else if (!this._parser.isComplete() && this._parser.parseAvailable()) {
                        progress = true;
                    }
                    if (this._generator.isCommitted() && !this._generator.isComplete() && !this._endp.isOutputShutdown() && !this._request.getAsyncContinuation().isAsyncStarted() && this._generator.flushBuffer() > 0) {
                        progress = true;
                    }
                    this._endp.flush();
                    if (this._asyncEndp.hasProgressed()) {
                        progress = true;
                    }
                    some_progress |= progress;
                    parserComplete = this._parser.isComplete();
                    generatorComplete = this._generator.isComplete();
                    boolean bl = complete = parserComplete && generatorComplete;
                }
                catch (HttpException e) {
                    try {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("uri=" + this._uri, new Object[0]);
                            LOG.debug("fields=" + this._requestFields, new Object[0]);
                            LOG.debug(e);
                        }
                        progress = true;
                        this._generator.sendError(e.getStatus(), e.getReason(), null, true);
                        some_progress |= progress;
                        parserComplete = this._parser.isComplete();
                        generatorComplete = this._generator.isComplete();
                        boolean bl = complete = parserComplete && generatorComplete;
                    }
                    catch (Throwable throwable) {
                        boolean complete2;
                        some_progress |= progress;
                        boolean parserComplete2 = this._parser.isComplete();
                        boolean generatorComplete2 = this._generator.isComplete();
                        boolean bl = complete2 = parserComplete2 && generatorComplete2;
                        if (parserComplete2) {
                            if (generatorComplete2) {
                                Connection switched2;
                                progress = true;
                                if (this._response.getStatus() == 101 && (switched2 = (Connection)this._request.getAttribute("org.spark-project.jetty.io.Connection")) != null) {
                                    connection = switched2;
                                }
                                this.reset();
                                if (!this._generator.isPersistent() && !this._endp.isOutputShutdown()) {
                                    LOG.warn("Safety net oshut!!!  IF YOU SEE THIS, PLEASE RAISE BUGZILLA", new Object[0]);
                                    this._endp.shutdownOutput();
                                }
                            } else {
                                this._readInterested = false;
                                LOG.debug("Disabled read interest while writing response {}", this._endp);
                            }
                        }
                        if (complete2 || !this._request.getAsyncContinuation().isAsyncStarted()) throw throwable;
                        LOG.debug("suspended {}", this);
                        progress = false;
                        throw throwable;
                        return connection;
                    }
                    if (parserComplete) {
                        if (generatorComplete) {
                            progress = true;
                            if (this._response.getStatus() == 101 && (switched = (Connection)this._request.getAttribute("org.spark-project.jetty.io.Connection")) != null) {
                                connection = switched;
                            }
                            this.reset();
                            if (!this._generator.isPersistent() && !this._endp.isOutputShutdown()) {
                                LOG.warn("Safety net oshut!!!  IF YOU SEE THIS, PLEASE RAISE BUGZILLA", new Object[0]);
                                this._endp.shutdownOutput();
                            }
                        } else {
                            this._readInterested = false;
                            LOG.debug("Disabled read interest while writing response {}", this._endp);
                        }
                    }
                    if (complete || !this._request.getAsyncContinuation().isAsyncStarted()) continue;
                    LOG.debug("suspended {}", this);
                    progress = false;
                    continue;
                }
                if (parserComplete) {
                    if (generatorComplete) {
                        progress = true;
                        if (this._response.getStatus() == 101 && (switched = (Connection)this._request.getAttribute("org.spark-project.jetty.io.Connection")) != null) {
                            connection = switched;
                        }
                        this.reset();
                        if (!this._generator.isPersistent() && !this._endp.isOutputShutdown()) {
                            LOG.warn("Safety net oshut!!!  IF YOU SEE THIS, PLEASE RAISE BUGZILLA", new Object[0]);
                            this._endp.shutdownOutput();
                        }
                    } else {
                        this._readInterested = false;
                        LOG.debug("Disabled read interest while writing response {}", this._endp);
                    }
                }
                if (complete || !this._request.getAsyncContinuation().isAsyncStarted()) continue;
                LOG.debug("suspended {}", this);
                progress = false;
            }
        }
        finally {
            AsyncHttpConnection.setCurrentConnection(null);
            if (!this._request.getAsyncContinuation().isAsyncStarted()) {
                this._parser.returnBuffers();
                this._generator.returnBuffers();
                this._asyncEndp.setCheckForIdle(true);
            }
            if (some_progress) {
                this._total_no_progress = 0;
            } else {
                ++this._total_no_progress;
                if (NO_PROGRESS_INFO > 0 && this._total_no_progress % NO_PROGRESS_INFO == 0 && (NO_PROGRESS_CLOSE <= 0 || this._total_no_progress < NO_PROGRESS_CLOSE)) {
                    LOG.info("EndPoint making no progress: " + this._total_no_progress + " " + this._endp + " " + this, new Object[0]);
                }
                if (NO_PROGRESS_CLOSE > 0 && this._total_no_progress == NO_PROGRESS_CLOSE) {
                    LOG.warn("Closing EndPoint making no progress: " + this._total_no_progress + " " + this._endp + " " + this, new Object[0]);
                    if (this._endp instanceof SelectChannelEndPoint) {
                        ((SelectChannelEndPoint)this._endp).getChannel().close();
                    }
                }
            }
        }
    }

    @Override
    public void onInputShutdown() throws IOException {
        if (this._generator.isIdle() && !this._request.getAsyncContinuation().isSuspended()) {
            this._endp.close();
        }
        if (this._parser.isIdle()) {
            this._parser.setPersistent(false);
        }
    }

    @Override
    public void reset() {
        this._readInterested = true;
        LOG.debug("Enabled read interest {}", this._endp);
        super.reset();
    }

    @Override
    public boolean isSuspended() {
        return !this._readInterested || super.isSuspended();
    }
}

