/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.random;

import org.apache.spark.util.random.BinomialBounds$;
import org.apache.spark.util.random.PoissonBounds$;
import org.apache.spark.util.random.XORShiftRandom;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Random$;

public final class SamplingUtils$ {
    public static final SamplingUtils$ MODULE$;

    static {
        new SamplingUtils$();
    }

    public <T> Tuple2<Object, Object> reservoirSampleAndCount(Iterator<T> input, int k, long seed, ClassTag<T> evidence$1) {
        Tuple2 tuple2;
        int i;
        Object reservoir = evidence$1.newArray(k);
        for (i = 0; i < k && input.hasNext(); ++i) {
            Object item = input.next();
            ScalaRunTime$.MODULE$.array_update(reservoir, i, item);
        }
        if (i < k) {
            Object trimReservoir = evidence$1.newArray(i);
            System.arraycopy(reservoir, 0, trimReservoir, 0, i);
            tuple2 = new Tuple2(trimReservoir, (Object)BoxesRunTime.boxToLong((long)i));
        } else {
            long l = i;
            XORShiftRandom rand = new XORShiftRandom(seed);
            while (input.hasNext()) {
                Object item = input.next();
                long replacementIndex = (long)(rand.nextDouble() * (double)l);
                if (replacementIndex < (long)k) {
                    ScalaRunTime$.MODULE$.array_update(reservoir, (int)replacementIndex, item);
                }
                ++l;
            }
            tuple2 = new Tuple2(reservoir, (Object)BoxesRunTime.boxToLong((long)l));
        }
        return tuple2;
    }

    public <T> long reservoirSampleAndCount$default$3() {
        return Random$.MODULE$.nextLong();
    }

    public double computeFractionForSampleSize(int sampleSizeLowerBound, long total, boolean withReplacement) {
        double d;
        if (withReplacement) {
            d = PoissonBounds$.MODULE$.getUpperBound(sampleSizeLowerBound) / (double)total;
        } else {
            double fraction = (double)sampleSizeLowerBound / (double)total;
            d = BinomialBounds$.MODULE$.getUpperBound(1.0E-4, total, fraction);
        }
        return d;
    }

    private SamplingUtils$() {
        MODULE$ = this;
    }
}

