/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.spark.FetchFailed;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.Resubmitted$;
import org.apache.spark.SparkContext$;
import org.apache.spark.Success$;
import org.apache.spark.TaskEndReason;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.executor.InputMetrics;
import org.apache.spark.executor.OutputMetrics;
import org.apache.spark.executor.ShuffleReadMetrics;
import org.apache.spark.executor.ShuffleWriteMetrics;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.executor.TaskMetrics$;
import org.apache.spark.scheduler.JobFailed;
import org.apache.spark.scheduler.JobLogger$;
import org.apache.spark.scheduler.JobLogger$$anonfun$closeLogWriter$1$;
import org.apache.spark.scheduler.JobResult;
import org.apache.spark.scheduler.JobSucceeded$;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListener$class;
import org.apache.spark.scheduler.SparkListenerApplicationEnd;
import org.apache.spark.scheduler.SparkListenerApplicationStart;
import org.apache.spark.scheduler.SparkListenerBlockManagerAdded;
import org.apache.spark.scheduler.SparkListenerBlockManagerRemoved;
import org.apache.spark.scheduler.SparkListenerBlockUpdated;
import org.apache.spark.scheduler.SparkListenerEnvironmentUpdate;
import org.apache.spark.scheduler.SparkListenerExecutorAdded;
import org.apache.spark.scheduler.SparkListenerExecutorMetricsUpdate;
import org.apache.spark.scheduler.SparkListenerExecutorRemoved;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.scheduler.SparkListenerStageSubmitted;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import org.apache.spark.scheduler.SparkListenerTaskGettingResult;
import org.apache.spark.scheduler.SparkListenerTaskStart;
import org.apache.spark.scheduler.SparkListenerUnpersistRDD;
import org.apache.spark.scheduler.StageInfo;
import org.apache.spark.scheduler.TaskInfo;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.TraitSetter;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\t-a\u0001B\u0001\u0003\u0001-\u0011\u0011BS8c\u0019><w-\u001a:\u000b\u0005\r!\u0011!C:dQ\u0016$W\u000f\\3s\u0015\t)a!A\u0003ta\u0006\u00148N\u0003\u0002\b\u0011\u00051\u0011\r]1dQ\u0016T\u0011!C\u0001\u0004_J<7\u0001A\n\u0005\u00011\u0011b\u0003\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003'Qi\u0011AA\u0005\u0003+\t\u0011Qb\u00159be.d\u0015n\u001d;f]\u0016\u0014\bCA\f\u0019\u001b\u0005!\u0011BA\r\u0005\u0005\u001daunZ4j]\u001eD\u0001b\u0007\u0001\u0003\u0006\u0004%\t\u0001H\u0001\u0005kN,'/F\u0001\u001e!\tq\u0012E\u0004\u0002\u000e?%\u0011\u0001ED\u0001\u0007!J,G-\u001a4\n\u0005\t\u001a#AB*ue&twM\u0003\u0002!\u001d!AQ\u0005\u0001B\u0001B\u0003%Q$A\u0003vg\u0016\u0014\b\u0005\u0003\u0005(\u0001\t\u0015\r\u0011\"\u0001\u001d\u0003)awn\u001a#je:\u000bW.\u001a\u0005\tS\u0001\u0011\t\u0011)A\u0005;\u0005YAn\\4ESJt\u0015-\\3!\u0011\u0015Y\u0003\u0001\"\u0001-\u0003\u0019a\u0014N\\5u}Q\u0019QFL\u0018\u0011\u0005M\u0001\u0001\"B\u000e+\u0001\u0004i\u0002\"B\u0014+\u0001\u0004i\u0002\"B\u0016\u0001\t\u0003\tD#A\u0017\t\u000fM\u0002!\u0019!C\u0005i\u00051An\\4ESJ,\u0012!\u000e\t\u0003mmj\u0011a\u000e\u0006\u0003qe\nA\u0001\\1oO*\t!(\u0001\u0003kCZ\f\u0017B\u0001\u00128\u0011\u0019i\u0004\u0001)A\u0005k\u00059An\\4ESJ\u0004\u0003bB \u0001\u0005\u0004%I\u0001Q\u0001\u0013U>\u0014\u0017\n\u001a+p!JLg\u000e^,sSR,'/F\u0001B!\u0011\u0011u)\u0013'\u000e\u0003\rS!\u0001R#\u0002\u000f5,H/\u00192mK*\u0011aID\u0001\u000bG>dG.Z2uS>t\u0017B\u0001%D\u0005\u001dA\u0015m\u001d5NCB\u0004\"!\u0004&\n\u0005-s!aA%oiB\u0011Q\nU\u0007\u0002\u001d*\u0011q*O\u0001\u0003S>L!!\u0015(\u0003\u0017A\u0013\u0018N\u001c;Xe&$XM\u001d\u0005\u0007'\u0002\u0001\u000b\u0011B!\u0002')|'-\u00133U_B\u0013\u0018N\u001c;Xe&$XM\u001d\u0011\t\u000fU\u0003!\u0019!C\u0005-\u0006q1\u000f^1hK&#Gk\u001c&pE&#W#A,\u0011\t\t;\u0015*\u0013\u0005\u00073\u0002\u0001\u000b\u0011B,\u0002\u001fM$\u0018mZ3JIR{'j\u001c2JI\u0002Bqa\u0017\u0001C\u0002\u0013%A,A\bk_\nLE\rV8Ti\u0006<W-\u00133t+\u0005i\u0006\u0003\u0002\"H\u0013z\u00032aX4J\u001d\t\u0001WM\u0004\u0002bI6\t!M\u0003\u0002d\u0015\u00051AH]8pizJ\u0011aD\u0005\u0003M:\tq\u0001]1dW\u0006<W-\u0003\u0002iS\n\u00191+Z9\u000b\u0005\u0019t\u0001BB6\u0001A\u0003%Q,\u0001\tk_\nLE\rV8Ti\u0006<W-\u00133tA!9Q\u000e\u0001b\u0001\n\u0013q\u0017A\u00033bi\u00164uN]7biV\tq\u000eE\u00027aJL!!]\u001c\u0003\u0017QC'/Z1e\u0019>\u001c\u0017\r\u001c\t\u0003gZl\u0011\u0001\u001e\u0006\u0003kf\nA\u0001^3yi&\u0011q\u000f\u001e\u0002\u0011'&l\u0007\u000f\\3ECR,gi\u001c:nCRDa!\u001f\u0001!\u0002\u0013y\u0017a\u00033bi\u00164uN]7bi\u0002BQa\u001f\u0001\u0005\u0012q\fAb\u0019:fCR,Gj\\4ESJ$\u0012! \t\u0003\u001byL!a \b\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u0007\u0001A\u0011CA\u0003\u0003=\u0019'/Z1uK2{wm\u0016:ji\u0016\u0014HcA?\u0002\b!9\u0011\u0011BA\u0001\u0001\u0004I\u0015!\u00026pE&#\u0007bBA\u0007\u0001\u0011E\u0011qB\u0001\u000fG2|7/\u001a'pO^\u0013\u0018\u000e^3s)\ri\u0018\u0011\u0003\u0005\b\u0003\u0013\tY\u00011\u0001J\u0011\u001d\t)\u0002\u0001C\t\u0003/\t\u0011DY;jY\u0012TuNY*uC\u001e,G)\u001a9f]\u0012,gnY5fgR)Q0!\u0007\u0002\u001c!9\u0011\u0011BA\n\u0001\u0004I\u0005bBA\u000f\u0003'\u0001\rAX\u0001\tgR\fw-Z%eg\"9\u0011\u0011\u0005\u0001\u0005\u0012\u0005\r\u0012A\u00036pE2{w-\u00138g_R9Q0!\n\u0002(\u0005-\u0002bBA\u0005\u0003?\u0001\r!\u0013\u0005\b\u0003S\ty\u00021\u0001\u001e\u0003\u0011IgNZ8\t\u0015\u00055\u0012q\u0004I\u0001\u0002\u0004\ty#\u0001\u0005xSRDG+[7f!\ri\u0011\u0011G\u0005\u0004\u0003gq!a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003o\u0001A\u0011CA\u001d\u00031\u0019H/Y4f\u0019><\u0017J\u001c4p)\u001di\u00181HA \u0003\u0003Bq!!\u0010\u00026\u0001\u0007\u0011*A\u0004ti\u0006<W-\u00133\t\u000f\u0005%\u0012Q\u0007a\u0001;!Q\u0011QFA\u001b!\u0003\u0005\r!a\f\t\u000f\u0005\u0015\u0003\u0001\"\u0005\u0002H\u0005\t\"/Z2pe\u0012$\u0016m]6NKR\u0014\u0018nY:\u0015\u0013u\fI%a\u0013\u0002P\u0005e\u0003bBA\u001f\u0003\u0007\u0002\r!\u0013\u0005\b\u0003\u001b\n\u0019\u00051\u0001\u001e\u0003\u0019\u0019H/\u0019;vg\"A\u0011\u0011KA\"\u0001\u0004\t\u0019&\u0001\u0005uCN\\\u0017J\u001c4p!\r\u0019\u0012QK\u0005\u0004\u0003/\u0012!\u0001\u0003+bg.LeNZ8\t\u0011\u0005m\u00131\ta\u0001\u0003;\n1\u0002^1tW6+GO]5dgB!\u0011qLA3\u001b\t\t\tGC\u0002\u0002d\u0011\t\u0001\"\u001a=fGV$xN]\u0005\u0005\u0003O\n\tGA\u0006UCN\\W*\u001a;sS\u000e\u001c\bbBA6\u0001\u0011\u0005\u0013QN\u0001\u0011_:\u001cF/Y4f'V\u0014W.\u001b;uK\u0012$2!`A8\u0011!\t\t(!\u001bA\u0002\u0005M\u0014AD:uC\u001e,7+\u001e2nSR$X\r\u001a\t\u0004'\u0005U\u0014bAA<\u0005\tY2\u000b]1sW2K7\u000f^3oKJ\u001cF/Y4f'V\u0014W.\u001b;uK\u0012Dq!a\u001f\u0001\t\u0003\ni(\u0001\tp]N#\u0018mZ3D_6\u0004H.\u001a;fIR\u0019Q0a \t\u0011\u0005\u0005\u0015\u0011\u0010a\u0001\u0003\u0007\u000bab\u001d;bO\u0016\u001cu.\u001c9mKR,G\rE\u0002\u0014\u0003\u000bK1!a\"\u0003\u0005m\u0019\u0006/\u0019:l\u0019&\u001cH/\u001a8feN#\u0018mZ3D_6\u0004H.\u001a;fI\"9\u00111\u0012\u0001\u0005B\u00055\u0015!C8o)\u0006\u001c8.\u00128e)\ri\u0018q\u0012\u0005\t\u0003#\u000bI\t1\u0001\u0002\u0014\u00069A/Y:l\u000b:$\u0007cA\n\u0002\u0016&\u0019\u0011q\u0013\u0002\u0003)M\u0003\u0018M]6MSN$XM\\3s)\u0006\u001c8.\u00128e\u0011\u001d\tY\n\u0001C!\u0003;\u000b\u0001b\u001c8K_\n,e\u000e\u001a\u000b\u0004{\u0006}\u0005\u0002CAQ\u00033\u0003\r!a)\u0002\r)|'-\u00128e!\r\u0019\u0012QU\u0005\u0004\u0003O\u0013!aE*qCJ\\G*[:uK:,'OS8c\u000b:$\u0007bBAV\u0001\u0011E\u0011QV\u0001\u0014e\u0016\u001cwN\u001d3K_\n\u0004&o\u001c9feRLWm\u001d\u000b\u0006{\u0006=\u0016\u0011\u0017\u0005\b\u0003\u0013\tI\u000b1\u0001J\u0011!\t\u0019,!+A\u0002\u0005U\u0016A\u00039s_B,'\u000f^5fgB!\u0011qWA_\u001b\t\tILC\u0002\u0002<f\nA!\u001e;jY&!\u0011qXA]\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\b\u0003\u0007\u0004A\u0011IAc\u0003)ygNS8c'R\f'\u000f\u001e\u000b\u0004{\u0006\u001d\u0007\u0002CAe\u0003\u0003\u0004\r!a3\u0002\u0011)|'m\u0015;beR\u00042aEAg\u0013\r\tyM\u0001\u0002\u0016'B\f'o\u001b'jgR,g.\u001a:K_\n\u001cF/\u0019:u\u0011%\t\u0019\u000eAI\u0001\n#\t).\u0001\u000bk_\ndunZ%oM>$C-\u001a4bk2$HeM\u000b\u0003\u0003/TC!a\f\u0002Z.\u0012\u00111\u001c\t\u0005\u0003;\f9/\u0004\u0002\u0002`*!\u0011\u0011]Ar\u0003%)hn\u00195fG.,GMC\u0002\u0002f:\t!\"\u00198o_R\fG/[8o\u0013\u0011\tI/a8\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002n\u0002\t\n\u0011\"\u0005\u0002V\u000612\u000f^1hK2{w-\u00138g_\u0012\"WMZ1vYR$3\u0007K\u0004\u0001\u0003c\f90a?\u0011\u00075\t\u00190C\u0002\u0002v:\u0011!\u0002Z3qe\u0016\u001c\u0017\r^3eC\t\tI0\u0001 M_\u001e\u0004\u0013\r\u001d9mS\u000e\fG/[8oA%tgm\u001c:nCRLwN\u001c\u0011cs\u0002\u001aX\r\u001e;j]\u001e\u00043\u000f]1sW:*g/\u001a8u\u0019><g&\u001a8bE2,GML\u0011\u0003\u0003{\fQ!\r\u00181]AB3\u0001\u0001B\u0001!\u0011\u0011\u0019Aa\u0002\u000e\u0005\t\u0015!bAAs\t%!!\u0011\u0002B\u0003\u00051!UM^3m_B,'/\u00119j\u0001")
public class JobLogger
implements SparkListener,
Logging {
    private final String user;
    private final String logDirName;
    private final String logDir;
    private final HashMap<Object, PrintWriter> org$apache$spark$scheduler$JobLogger$$jobIdToPrintWriter;
    private final HashMap<Object, Object> org$apache$spark$scheduler$JobLogger$$stageIdToJobId;
    private final HashMap<Object, Seq<Object>> org$apache$spark$scheduler$JobLogger$$jobIdToStageIds;
    private final ThreadLocal<SimpleDateFormat> dateFormat;
    private transient Logger org$apache$spark$Logging$$log_;

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void onTaskStart(SparkListenerTaskStart taskStart) {
        SparkListener$class.onTaskStart(this, taskStart);
    }

    @Override
    public void onTaskGettingResult(SparkListenerTaskGettingResult taskGettingResult) {
        SparkListener$class.onTaskGettingResult(this, taskGettingResult);
    }

    @Override
    public void onEnvironmentUpdate(SparkListenerEnvironmentUpdate environmentUpdate) {
        SparkListener$class.onEnvironmentUpdate(this, environmentUpdate);
    }

    @Override
    public void onBlockManagerAdded(SparkListenerBlockManagerAdded blockManagerAdded) {
        SparkListener$class.onBlockManagerAdded(this, blockManagerAdded);
    }

    @Override
    public void onBlockManagerRemoved(SparkListenerBlockManagerRemoved blockManagerRemoved) {
        SparkListener$class.onBlockManagerRemoved(this, blockManagerRemoved);
    }

    @Override
    public void onUnpersistRDD(SparkListenerUnpersistRDD unpersistRDD) {
        SparkListener$class.onUnpersistRDD(this, unpersistRDD);
    }

    @Override
    public void onApplicationStart(SparkListenerApplicationStart applicationStart) {
        SparkListener$class.onApplicationStart(this, applicationStart);
    }

    @Override
    public void onApplicationEnd(SparkListenerApplicationEnd applicationEnd) {
        SparkListener$class.onApplicationEnd(this, applicationEnd);
    }

    @Override
    public void onExecutorMetricsUpdate(SparkListenerExecutorMetricsUpdate executorMetricsUpdate) {
        SparkListener$class.onExecutorMetricsUpdate(this, executorMetricsUpdate);
    }

    @Override
    public void onExecutorAdded(SparkListenerExecutorAdded executorAdded2) {
        SparkListener$class.onExecutorAdded(this, executorAdded2);
    }

    @Override
    public void onExecutorRemoved(SparkListenerExecutorRemoved executorRemoved2) {
        SparkListener$class.onExecutorRemoved(this, executorRemoved2);
    }

    @Override
    public void onBlockUpdated(SparkListenerBlockUpdated blockUpdated) {
        SparkListener$class.onBlockUpdated(this, blockUpdated);
    }

    public String user() {
        return this.user;
    }

    public String logDirName() {
        return this.logDirName;
    }

    private String logDir() {
        return this.logDir;
    }

    public HashMap<Object, PrintWriter> org$apache$spark$scheduler$JobLogger$$jobIdToPrintWriter() {
        return this.org$apache$spark$scheduler$JobLogger$$jobIdToPrintWriter;
    }

    public HashMap<Object, Object> org$apache$spark$scheduler$JobLogger$$stageIdToJobId() {
        return this.org$apache$spark$scheduler$JobLogger$$stageIdToJobId;
    }

    public HashMap<Object, Seq<Object>> org$apache$spark$scheduler$JobLogger$$jobIdToStageIds() {
        return this.org$apache$spark$scheduler$JobLogger$$jobIdToStageIds;
    }

    private ThreadLocal<SimpleDateFormat> dateFormat() {
        return this.dateFormat;
    }

    public void createLogDir() {
        File dir = new File(new StringBuilder().append((Object)this.logDir()).append((Object)"/").append((Object)this.logDirName()).append((Object)"/").toString());
        if (dir.exists()) {
            return;
        }
        if (dir.mkdirs()) {
            return;
        }
        throw new IOException(new StringBuilder().append((Object)"create log directory error:").append((Object)this.logDir()).append((Object)"/").append((Object)this.logDirName()).append((Object)"/").toString());
    }

    public void createLogWriter(int jobId) {
        try {
            PrintWriter fileWriter = new PrintWriter(new StringBuilder().append((Object)this.logDir()).append((Object)"/").append((Object)this.logDirName()).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)jobId)).toString());
            this.org$apache$spark$scheduler$JobLogger$$jobIdToPrintWriter().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)jobId)), (Object)fileWriter));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    public void closeLogWriter(int jobId) {
        this.org$apache$spark$scheduler$JobLogger$$jobIdToPrintWriter().get((Object)BoxesRunTime.boxToInteger((int)jobId)).foreach((Function1)new Serializable(this, jobId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JobLogger $outer;
            private final int jobId$1;

            public final HashMap<Object, Seq<Object>> apply(PrintWriter fileWriter) {
                fileWriter.close();
                this.$outer.org$apache$spark$scheduler$JobLogger$$jobIdToStageIds().get((Object)BoxesRunTime.boxToInteger((int)this.jobId$1)).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$closeLogWriter$1 $outer;

                    public final void apply(Seq<Object> x$1) {
                        x$1.foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$closeLogWriter$1$$anonfun$apply$1 $outer;

                            public final HashMap<Object, Object> apply(int stageId) {
                                return this.$outer.org$apache$spark$scheduler$JobLogger$$anonfun$$anonfun$$$outer().org$apache$spark$scheduler$JobLogger$$anonfun$$$outer().org$apache$spark$scheduler$JobLogger$$stageIdToJobId().$minus$eq((Object)BoxesRunTime.boxToInteger((int)stageId));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$closeLogWriter$1 org$apache$spark$scheduler$JobLogger$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.$outer.org$apache$spark$scheduler$JobLogger$$jobIdToPrintWriter().$minus$eq((Object)BoxesRunTime.boxToInteger((int)this.jobId$1));
                return this.$outer.org$apache$spark$scheduler$JobLogger$$jobIdToStageIds().$minus$eq((Object)BoxesRunTime.boxToInteger((int)this.jobId$1));
            }

            public /* synthetic */ JobLogger org$apache$spark$scheduler$JobLogger$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.jobId$1 = jobId$1;
            }
        });
    }

    public void buildJobStageDependencies(int jobId, Seq<Object> stageIds) {
        this.org$apache$spark$scheduler$JobLogger$$jobIdToStageIds().update((Object)BoxesRunTime.boxToInteger((int)jobId), stageIds);
        stageIds.foreach((Function1)new Serializable(this, jobId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JobLogger $outer;
            private final int jobId$2;

            public final void apply(int stageId) {
                this.apply$mcVI$sp(stageId);
            }

            public void apply$mcVI$sp(int stageId) {
                this.$outer.org$apache$spark$scheduler$JobLogger$$stageIdToJobId().update((Object)BoxesRunTime.boxToInteger((int)stageId), (Object)BoxesRunTime.boxToInteger((int)this.jobId$2));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.jobId$2 = jobId$2;
            }
        });
    }

    public void jobLogInfo(int jobId, String info, boolean withTime) {
        ObjectRef writeInfo = new ObjectRef((Object)info);
        if (withTime) {
            Date date = new Date(System.currentTimeMillis());
            writeInfo.elem = new StringBuilder().append((Object)((DateFormat)this.dateFormat().get()).format(date)).append((Object)": ").append((Object)info).toString();
        }
        this.org$apache$spark$scheduler$JobLogger$$jobIdToPrintWriter().get((Object)BoxesRunTime.boxToInteger((int)jobId)).foreach((Function1)new Serializable(this, writeInfo){
            public static final long serialVersionUID = 0L;
            private final ObjectRef writeInfo$1;

            public final void apply(PrintWriter x$2) {
                x$2.println((String)this.writeInfo$1.elem);
            }
            {
                this.writeInfo$1 = writeInfo$1;
            }
        });
    }

    public boolean jobLogInfo$default$3() {
        return true;
    }

    public void stageLogInfo(int stageId, String info, boolean withTime) {
        this.org$apache$spark$scheduler$JobLogger$$stageIdToJobId().get((Object)BoxesRunTime.boxToInteger((int)stageId)).foreach((Function1)new Serializable(this, info, withTime){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JobLogger $outer;
            private final String info$1;
            private final boolean withTime$1;

            public final void apply(int jobId) {
                this.apply$mcVI$sp(jobId);
            }

            public void apply$mcVI$sp(int jobId) {
                this.$outer.jobLogInfo(jobId, this.info$1, this.withTime$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.info$1 = info$1;
                this.withTime$1 = withTime$1;
            }
        });
    }

    public boolean stageLogInfo$default$3() {
        return true;
    }

    public void recordTaskMetrics(int stageId, String status, TaskInfo taskInfo, TaskMetrics taskMetrics) {
        Option<InputMetrics> option;
        block4: {
            Option<OutputMetrics> option2;
            block7: {
                Option<ShuffleReadMetrics> option3;
                block10: {
                    Option<ShuffleWriteMetrics> option4;
                    block13: {
                        String string;
                        String shuffleReadMetrics;
                        String outputMetrics;
                        String inputMetrics;
                        String gcTime;
                        String executorRunTime;
                        String info;
                        block12: {
                            block11: {
                                String string2;
                                block9: {
                                    block8: {
                                        String string3;
                                        block6: {
                                            block5: {
                                                String string4;
                                                block3: {
                                                    block2: {
                                                        info = new StringBuilder().append((Object)" TID=").append((Object)BoxesRunTime.boxToLong((long)taskInfo.taskId())).append((Object)" STAGE_ID=").append((Object)BoxesRunTime.boxToInteger((int)stageId)).append((Object)" START_TIME=").append((Object)BoxesRunTime.boxToLong((long)taskInfo.launchTime())).append((Object)" FINISH_TIME=").append((Object)BoxesRunTime.boxToLong((long)taskInfo.finishTime())).append((Object)" EXECUTOR_ID=").append((Object)taskInfo.executorId()).append((Object)" HOST=").append((Object)taskMetrics.hostname()).toString();
                                                        executorRunTime = new StringBuilder().append((Object)" EXECUTOR_RUN_TIME=").append((Object)BoxesRunTime.boxToLong((long)taskMetrics.executorRunTime())).toString();
                                                        gcTime = new StringBuilder().append((Object)" GC_TIME=").append((Object)BoxesRunTime.boxToLong((long)taskMetrics.jvmGCTime())).toString();
                                                        option = taskMetrics.inputMetrics();
                                                        if (!(option instanceof Some)) break block2;
                                                        Some some = (Some)option;
                                                        InputMetrics metrics = (InputMetrics)some.x();
                                                        string4 = new StringBuilder().append((Object)" READ_METHOD=").append((Object)metrics.readMethod().toString()).append((Object)" INPUT_BYTES=").append((Object)BoxesRunTime.boxToLong((long)metrics.bytesRead())).toString();
                                                        break block3;
                                                    }
                                                    None$ none$ = None$.MODULE$;
                                                    Option<InputMetrics> option5 = option;
                                                    if (none$ != null ? !none$.equals(option5) : option5 != null) break block4;
                                                    string4 = "";
                                                }
                                                inputMetrics = string4;
                                                option2 = taskMetrics.outputMetrics();
                                                if (!(option2 instanceof Some)) break block5;
                                                Some some = (Some)option2;
                                                OutputMetrics metrics = (OutputMetrics)some.x();
                                                string3 = new StringBuilder().append((Object)" OUTPUT_BYTES=").append((Object)BoxesRunTime.boxToLong((long)metrics.bytesWritten())).toString();
                                                break block6;
                                            }
                                            None$ none$ = None$.MODULE$;
                                            Option<OutputMetrics> option6 = option2;
                                            if (none$ != null ? !none$.equals(option6) : option6 != null) break block7;
                                            string3 = "";
                                        }
                                        outputMetrics = string3;
                                        option3 = taskMetrics.shuffleReadMetrics();
                                        if (!(option3 instanceof Some)) break block8;
                                        Some some = (Some)option3;
                                        ShuffleReadMetrics metrics = (ShuffleReadMetrics)some.x();
                                        string2 = new StringBuilder().append((Object)" BLOCK_FETCHED_TOTAL=").append((Object)BoxesRunTime.boxToInteger((int)metrics.totalBlocksFetched())).append((Object)" BLOCK_FETCHED_LOCAL=").append((Object)BoxesRunTime.boxToInteger((int)metrics.localBlocksFetched())).append((Object)" BLOCK_FETCHED_REMOTE=").append((Object)BoxesRunTime.boxToInteger((int)metrics.remoteBlocksFetched())).append((Object)" REMOTE_FETCH_WAIT_TIME=").append((Object)BoxesRunTime.boxToLong((long)metrics.fetchWaitTime())).append((Object)" REMOTE_BYTES_READ=").append((Object)BoxesRunTime.boxToLong((long)metrics.remoteBytesRead())).append((Object)" LOCAL_BYTES_READ=").append((Object)BoxesRunTime.boxToLong((long)metrics.localBytesRead())).toString();
                                        break block9;
                                    }
                                    None$ none$ = None$.MODULE$;
                                    Option<ShuffleReadMetrics> option7 = option3;
                                    if (none$ != null ? !none$.equals(option7) : option7 != null) break block10;
                                    string2 = "";
                                }
                                shuffleReadMetrics = string2;
                                option4 = taskMetrics.shuffleWriteMetrics();
                                if (!(option4 instanceof Some)) break block11;
                                Some some = (Some)option4;
                                ShuffleWriteMetrics metrics = (ShuffleWriteMetrics)some.x();
                                string = new StringBuilder().append((Object)" SHUFFLE_BYTES_WRITTEN=").append((Object)BoxesRunTime.boxToLong((long)metrics.shuffleBytesWritten())).append((Object)" SHUFFLE_WRITE_TIME=").append((Object)BoxesRunTime.boxToLong((long)metrics.shuffleWriteTime())).toString();
                                break block12;
                            }
                            None$ none$ = None$.MODULE$;
                            Option<ShuffleWriteMetrics> option8 = option4;
                            if (none$ != null ? !none$.equals(option8) : option8 != null) break block13;
                            string = "";
                        }
                        String writeMetrics = string;
                        this.stageLogInfo(stageId, new StringBuilder().append((Object)status).append((Object)info).append((Object)executorRunTime).append((Object)gcTime).append((Object)inputMetrics).append((Object)outputMetrics).append((Object)shuffleReadMetrics).append((Object)writeMetrics).toString(), this.stageLogInfo$default$3());
                        return;
                    }
                    throw new MatchError(option4);
                }
                throw new MatchError(option3);
            }
            throw new MatchError(option2);
        }
        throw new MatchError(option);
    }

    @Override
    public void onStageSubmitted(SparkListenerStageSubmitted stageSubmitted) {
        StageInfo stageInfo = stageSubmitted.stageInfo();
        this.stageLogInfo(stageInfo.stageId(), new StringOps(Predef$.MODULE$.augmentString("STAGE_ID=%d STATUS=SUBMITTED TASK_SIZE=%d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)stageInfo.stageId()), BoxesRunTime.boxToInteger((int)stageInfo.numTasks())})), this.stageLogInfo$default$3());
    }

    @Override
    public void onStageCompleted(SparkListenerStageCompleted stageCompleted) {
        int stageId = stageCompleted.stageInfo().stageId();
        if (stageCompleted.stageInfo().failureReason().isEmpty()) {
            this.stageLogInfo(stageId, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"STAGE_ID=", " STATUS=COMPLETED"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)stageId)})), this.stageLogInfo$default$3());
        } else {
            this.stageLogInfo(stageId, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"STAGE_ID=", " STATUS=FAILED"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)stageId)})), this.stageLogInfo$default$3());
        }
    }

    @Override
    public void onTaskEnd(SparkListenerTaskEnd taskEnd) {
        TaskInfo taskInfo = taskEnd.taskInfo();
        String taskStatus = new StringOps(Predef$.MODULE$.augmentString("TASK_TYPE=%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taskEnd.taskType()}));
        TaskMetrics taskMetrics = taskEnd.taskMetrics() == null ? TaskMetrics$.MODULE$.empty() : taskEnd.taskMetrics();
        TaskEndReason taskEndReason = taskEnd.reason();
        Success$ success$ = Success$.MODULE$;
        TaskEndReason taskEndReason2 = taskEndReason;
        if (!(success$ != null ? !success$.equals(taskEndReason2) : taskEndReason2 != null)) {
            taskStatus = new StringBuilder().append((Object)taskStatus).append((Object)" STATUS=SUCCESS").toString();
            this.recordTaskMetrics(taskEnd.stageId(), taskStatus, taskInfo, taskMetrics);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Resubmitted$ resubmitted$ = Resubmitted$.MODULE$;
            TaskEndReason taskEndReason3 = taskEndReason;
            if (!(resubmitted$ != null ? !resubmitted$.equals(taskEndReason3) : taskEndReason3 != null)) {
                taskStatus = new StringBuilder().append((Object)taskStatus).append((Object)new StringBuilder().append((Object)" STATUS=RESUBMITTED TID=").append((Object)BoxesRunTime.boxToLong((long)taskInfo.taskId())).append((Object)" STAGE_ID=").append((Object)BoxesRunTime.boxToInteger((int)taskEnd.stageId())).toString()).toString();
                this.stageLogInfo(taskEnd.stageId(), taskStatus, this.stageLogInfo$default$3());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (taskEndReason instanceof FetchFailed) {
                FetchFailed fetchFailed = (FetchFailed)taskEndReason;
                int shuffleId = fetchFailed.shuffleId();
                int mapId = fetchFailed.mapId();
                int reduceId = fetchFailed.reduceId();
                taskStatus = new StringBuilder().append((Object)taskStatus).append((Object)new StringBuilder().append((Object)" STATUS=FETCHFAILED TID=").append((Object)BoxesRunTime.boxToLong((long)taskInfo.taskId())).append((Object)" STAGE_ID=").append((Object)BoxesRunTime.boxToInteger((int)taskEnd.stageId())).append((Object)" SHUFFLE_ID=").append((Object)BoxesRunTime.boxToInteger((int)shuffleId)).append((Object)" MAP_ID=").append((Object)BoxesRunTime.boxToInteger((int)mapId)).append((Object)" REDUCE_ID=").append((Object)BoxesRunTime.boxToInteger((int)reduceId)).toString()).toString();
                this.stageLogInfo(taskEnd.stageId(), taskStatus, this.stageLogInfo$default$3());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    @Override
    public void onJobEnd(SparkListenerJobEnd jobEnd) {
        int jobId = jobEnd.jobId();
        ObjectRef info = new ObjectRef((Object)new StringBuilder().append((Object)"JOB_ID=").append((Object)BoxesRunTime.boxToInteger((int)jobId)).toString());
        JobResult jobResult = jobEnd.jobResult();
        JobSucceeded$ jobSucceeded$ = JobSucceeded$.MODULE$;
        JobResult jobResult2 = jobResult;
        if (!(jobSucceeded$ != null ? !jobSucceeded$.equals(jobResult2) : jobResult2 != null)) {
            info.elem = new StringBuilder().append((Object)((String)info.elem)).append((Object)" STATUS=SUCCESS").toString();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jobResult instanceof JobFailed) {
            JobFailed jobFailed = (JobFailed)jobResult;
            Exception exception2 = jobFailed.exception();
            info.elem = new StringBuilder().append((Object)((String)info.elem)).append((Object)" STATUS=FAILED REASON=").toString();
            Predef$.MODULE$.refArrayOps((Object[])exception2.getMessage().split("\\s+")).foreach((Function1)new Serializable(this, info){
                public static final long serialVersionUID = 0L;
                private final ObjectRef info$2;

                public final void apply(String x$3) {
                    this.info$2.elem = new StringBuilder().append((Object)((String)this.info$2.elem)).append((Object)new StringBuilder().append((Object)x$3).append((Object)"_").toString()).toString();
                }
                {
                    this.info$2 = info$2;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        this.jobLogInfo(jobId, ((String)info.elem).substring(0, ((String)info.elem).length() - 1).toUpperCase(), this.jobLogInfo$default$3());
        this.closeLogWriter(jobId);
    }

    public void recordJobProperties(int jobId, Properties properties) {
        if (properties != null) {
            String description = properties.getProperty(SparkContext$.MODULE$.SPARK_JOB_DESCRIPTION(), "");
            this.jobLogInfo(jobId, description, false);
        }
    }

    @Override
    public void onJobStart(SparkListenerJobStart jobStart) {
        int jobId = jobStart.jobId();
        Properties properties = jobStart.properties();
        this.createLogWriter(jobId);
        this.recordJobProperties(jobId, properties);
        this.buildJobStageDependencies(jobId, jobStart.stageIds());
        this.jobLogInfo(jobId, new StringBuilder().append((Object)"JOB_ID=").append((Object)BoxesRunTime.boxToInteger((int)jobId)).append((Object)" STATUS=STARTED").toString(), this.jobLogInfo$default$3());
    }

    public JobLogger(String user, String logDirName) {
        this.user = user;
        this.logDirName = logDirName;
        SparkListener$class.$init$(this);
        Logging$class.$init$(this);
        this.logDir = System.getenv("SPARK_LOG_DIR") == null ? new StringOps(Predef$.MODULE$.augmentString("/tmp/spark-%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{user})) : System.getenv("SPARK_LOG_DIR");
        this.org$apache$spark$scheduler$JobLogger$$jobIdToPrintWriter = new HashMap();
        this.org$apache$spark$scheduler$JobLogger$$stageIdToJobId = new HashMap();
        this.org$apache$spark$scheduler$JobLogger$$jobIdToStageIds = new HashMap();
        this.dateFormat = new $anon$1(this);
        this.createLogDir();
    }

    public JobLogger() {
        this(System.getProperty("user.name", "<unknown>"), String.valueOf(System.currentTimeMillis()));
    }
}

