/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.nio.ByteBuffer;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproximatePercentile$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.QuantileSummaries;
import org.apache.spark.sql.catalyst.util.QuantileSummaries$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(col, percentage [, accuracy]) - Returns the approximate percentile value of numeric\n      column `col` at the given percentage. The value of percentage must be between 0.0\n      and 1.0. The `accuracy` parameter (default: 10000) is a positive numeric literal which\n      controls approximation accuracy at the cost of memory. Higher value of `accuracy` yields\n      better accuracy, `1.0/accuracy` is the relative error of the approximation.\n      When `percentage` is an array, each value of the percentage array must be between 0.0 and 1.0.\n      In this case, returns the approximate percentile array of column `col` at the given\n      percentage array.\n  ", extended="\n    Examples:\n      > SELECT percentile_approx(10.0, array(0.5, 0.4, 0.1), 100);\n       [10.0,10.0,10.0]\n      > SELECT percentile_approx(10.0, 0.5, 100);\n       10.0\n  ")
@ScalaSignature(bytes="\u0006\u0001\r\u001dc\u0001B\u0001\u0003\u0001F\u0011Q#\u00119qe>D\u0018.\\1uKB+'oY3oi&dWM\u0003\u0002\u0004\t\u0005I\u0011mZ4sK\u001e\fG/\u001a\u0006\u0003\u000b\u0019\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011q\u0001C\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0011BC\u0001\u0004gFd'BA\u0006\r\u0003\u0015\u0019\b/\u0019:l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M)\u0001AEAPiA\u00191\u0003\u0006\f\u000e\u0003\tI!!\u0006\u0002\u00031QK\b/\u001a3J[B,'/\u0019;jm\u0016\fum\u001a:fO\u0006$X\r\u0005\u0002\u0018\u0005:\u0011\u0001$\u000b\b\u00033!r!AG\u0014\u000f\u0005m1cB\u0001\u000f&\u001d\tiBE\u0004\u0002\u001fG9\u0011qDI\u0007\u0002A)\u0011\u0011\u0005E\u0001\u0007yI|w\u000e\u001e \n\u0003=I!!\u0004\b\n\u0005-a\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u00111\u0001B\u0004\u0006U\tA\taK\u0001\u0016\u0003B\u0004(o\u001c=j[\u0006$X\rU3sG\u0016tG/\u001b7f!\t\u0019BFB\u0003\u0002\u0005!\u0005QfE\u0002-]Q\u0002\"a\f\u001a\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u0012a!\u00118z%\u00164\u0007CA\u00186\u0013\t1\u0004G\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u00039Y\u0011\u0005\u0011(\u0001\u0004=S:LGO\u0010\u000b\u0002W!91\b\fb\u0001\n\u0003a\u0014a\u0007#F\r\u0006+F\nV0Q\u000bJ\u001bUI\u0014+J\u0019\u0016{\u0016iQ\"V%\u0006\u001b\u0015,F\u0001>!\tyc(\u0003\u0002@a\t\u0019\u0011J\u001c;\t\r\u0005c\u0003\u0015!\u0003>\u0003q!UIR!V\u0019R{\u0006+\u0012*D\u000b:#\u0016\nT#`\u0003\u000e\u001bUKU!D3\u00022Aa\u0011\u0017\u0001\t\n\u0001\u0002+\u001a:dK:$\u0018\u000e\\3ES\u001e,7\u000f^\n\u0003\u0005:B\u0001B\u0012\"\u0003\u0002\u0004%IaR\u0001\ngVlW.\u0019:jKN,\u0012\u0001\u0013\t\u0003\u00132k\u0011A\u0013\u0006\u0003\u0017\u001a\tA!\u001e;jY&\u0011QJ\u0013\u0002\u0012#V\fg\u000e^5mKN+X.\\1sS\u0016\u001c\b\u0002C(C\u0005\u0003\u0007I\u0011\u0002)\u0002\u001bM,X.\\1sS\u0016\u001cx\fJ3r)\t\tF\u000b\u0005\u00020%&\u00111\u000b\r\u0002\u0005+:LG\u000fC\u0004V\u001d\u0006\u0005\t\u0019\u0001%\u0002\u0007a$\u0013\u0007\u0003\u0005X\u0005\n\u0005\t\u0015)\u0003I\u0003)\u0019X/\\7be&,7\u000f\t\u0005\t3\n\u0013\t\u0019!C\u00055\u0006a\u0011n]\"p[B\u0014Xm]:fIV\t1\f\u0005\u000209&\u0011Q\f\r\u0002\b\u0005>|G.Z1o\u0011!y&I!a\u0001\n\u0013\u0001\u0017\u0001E5t\u0007>l\u0007O]3tg\u0016$w\fJ3r)\t\t\u0016\rC\u0004V=\u0006\u0005\t\u0019A.\t\u0011\r\u0014%\u0011!Q!\nm\u000bQ\"[:D_6\u0004(/Z:tK\u0012\u0004\u0003\"\u0002\u001dC\t\u0003)Gc\u00014iSB\u0011qMQ\u0007\u0002Y!)a\t\u001aa\u0001\u0011\")\u0011\f\u001aa\u00017\"11N\u0011Q\u0001\u000eu\nQdY8naJ,7o\u001d+ie\u0016\u001c\bj\u001c7e\u0005V4g-\u001a:MK:<G\u000f\u001b\u0005\u0006q\t#\t!\u001c\u000b\u0003M:DQa\u001c7A\u0002A\fQB]3mCRLg/Z#se>\u0014\bCA\u0018r\u0013\t\u0011\bG\u0001\u0004E_V\u0014G.\u001a\u0005\u0006i\n#\taR\u0001\u0012cV\fg\u000e^5mKN+X.\\1sS\u0016\u001c\b\"\u0002<C\t\u00039\u0018aA1eIR\u0011\u0011\u000b\u001f\u0005\u0006sV\u0004\r\u0001]\u0001\u0006m\u0006dW/\u001a\u0005\u0006w\n#\t\u0001`\u0001\u0006[\u0016\u0014x-\u001a\u000b\u0003#vDQA >A\u0002\u0019\fQa\u001c;iKJDq!!\u0001C\t\u0003\t\u0019!\u0001\bhKR\u0004VM]2f]RLG.Z:\u0015\t\u0005\u0015\u00111\u0002\t\u0005_\u0005\u001d\u0001/C\u0002\u0002\nA\u0012Q!\u0011:sCfDq!!\u0004\u0000\u0001\u0004\t)!A\u0006qKJ\u001cWM\u001c;bO\u0016\u001c\bbBA\t\u0005\u00125\u00111C\u0001\tG>l\u0007O]3tgR\t\u0011K\u0002\u0004\u0002\u00181\u0002\u0011\u0011\u0004\u0002\u001b!\u0016\u00148-\u001a8uS2,G)[4fgR\u001cVM]5bY&TXM]\n\u0004\u0003+q\u0003b\u0002\u001d\u0002\u0016\u0011\u0005\u0011Q\u0004\u000b\u0003\u0003?\u00012aZA\u000b\u0011!\t\u0019#!\u0006\u0005\u000e\u0005\u0015\u0012A\u00027f]\u001e$\b\u000eF\u0002>\u0003OAaARA\u0011\u0001\u0004A\u0005\u0002CA\u0016\u0003+!)!!\f\u0002\u0013M,'/[1mSj,G\u0003BA\u0018\u0003o\u0001RaLA\u0004\u0003c\u00012aLA\u001a\u0013\r\t)\u0004\r\u0002\u0005\u0005f$X\rC\u0004\u0002:\u0005%\u0002\u0019\u00014\u0002\u0007=\u0014'\u000e\u0003\u0005\u0002>\u0005UAQAA \u0003-!Wm]3sS\u0006d\u0017N_3\u0015\u0007\u0019\f\t\u0005\u0003\u0005\u0002D\u0005m\u0002\u0019AA\u0018\u0003\u0015\u0011\u0017\u0010^3t\u0011%\t9\u0005\fb\u0001\n\u0003\tI%\u0001\u0006tKJL\u0017\r\\5{KJ,\"!a\b\t\u0011\u00055C\u0006)A\u0005\u0003?\t1b]3sS\u0006d\u0017N_3sA!I\u0011\u0011\u000b\u0017\u0002\u0002\u0013\u0005\u00151K\u0001\u0006CB\u0004H.\u001f\u000b\r\u0003+\n9&a\u0019\u0002h\u0005-\u0014q\u000e\t\u0003'\u0001A\u0001\"!\u0017\u0002P\u0001\u0007\u00111L\u0001\u0006G\"LG\u000e\u001a\t\u0005\u0003;\ny&D\u0001\u0005\u0013\r\t\t\u0007\u0002\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007\u0002CA3\u0003\u001f\u0002\r!a\u0017\u0002)A,'oY3oi\u0006<W-\u0012=qe\u0016\u001c8/[8o\u0011!\tI'a\u0014A\u0002\u0005m\u0013AE1dGV\u0014\u0018mY=FqB\u0014Xm]:j_:Dq!!\u001c\u0002P\u0001\u0007Q(\u0001\fnkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3u\u0011\u001d\t\t(a\u0014A\u0002u\nA#\u001b8qkR\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\b\"CA;Y\u0005\u0005I\u0011QA<\u0003\u001d)h.\u00199qYf$B!!\u001f\u0002\u0006B)q&a\u001f\u0002\u0000%\u0019\u0011Q\u0010\u0019\u0003\r=\u0003H/[8o!-y\u0013\u0011QA.\u00037\nY&P\u001f\n\u0007\u0005\r\u0005G\u0001\u0004UkBdW-\u000e\u0005\u000b\u0003\u000f\u000b\u0019(!AA\u0002\u0005U\u0013a\u0001=%a!I\u00111\u0012\u0017\u0002\u0002\u0013%\u0011QR\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002\u0010B!\u0011\u0011SAN\u001b\t\t\u0019J\u0003\u0003\u0002\u0016\u0006]\u0015\u0001\u00027b]\u001eT!!!'\u0002\t)\fg/Y\u0005\u0005\u0003;\u000b\u0019J\u0001\u0004PE*,7\r\u001e\t\u0004_\u0005\u0005\u0016bAARa\t9\u0001K]8ek\u000e$\bBCA-\u0001\tU\r\u0011\"\u0001\u0002(V\u0011\u00111\f\u0005\u000b\u0003W\u0003!\u0011#Q\u0001\n\u0005m\u0013AB2iS2$\u0007\u0005\u0003\u0006\u0002f\u0001\u0011)\u001a!C\u0001\u0003OC!\"!-\u0001\u0005#\u0005\u000b\u0011BA.\u0003U\u0001XM]2f]R\fw-Z#yaJ,7o]5p]\u0002B!\"!\u001b\u0001\u0005+\u0007I\u0011AAT\u0011)\t9\f\u0001B\tB\u0003%\u00111L\u0001\u0014C\u000e\u001cWO]1ds\u0016C\bO]3tg&|g\u000e\t\u0005\n\u0003[\u0002!Q3A\u0005BqB\u0011\"!0\u0001\u0005#\u0005\u000b\u0011B\u001f\u0002/5,H/\u00192mK\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\u0004\u0003\"CA9\u0001\tU\r\u0011\"\u0011=\u0011%\t\u0019\r\u0001B\tB\u0003%Q(A\u000bj]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u0011\t\ra\u0002A\u0011AAd)1\t)&!3\u0002L\u00065\u0017qZAi\u0011!\tI&!2A\u0002\u0005m\u0003\u0002CA3\u0003\u000b\u0004\r!a\u0017\t\u0011\u0005%\u0014Q\u0019a\u0001\u00037Bq!!\u001c\u0002F\u0002\u0007Q\bC\u0004\u0002r\u0005\u0015\u0007\u0019A\u001f\t\ra\u0002A\u0011AAk)!\t)&a6\u0002Z\u0006m\u0007\u0002CA-\u0003'\u0004\r!a\u0017\t\u0011\u0005\u0015\u00141\u001ba\u0001\u00037B\u0001\"!\u001b\u0002T\u0002\u0007\u00111\f\u0005\u0007q\u0001!\t!a8\u0015\r\u0005U\u0013\u0011]Ar\u0011!\tI&!8A\u0002\u0005m\u0003\u0002CA3\u0003;\u0004\r!a\u0017\t\u0013\u0005\u001d\b\u0001#b\u0001\n\u0013a\u0014\u0001C1dGV\u0014\u0018mY=\t\u0013\u0005-\b\u0001#A!B\u0013i\u0014!C1dGV\u0014\u0018mY=!\u0011\u001d\ty\u000f\u0001C!\u0003c\f!\"\u001b8qkR$\u0016\u0010]3t+\t\t\u0019\u0010\u0005\u0004\u0002v\u0006}(Q\u0001\b\u0005\u0003o\fYPD\u0002 \u0003sL\u0011!M\u0005\u0004\u0003{\u0004\u0014a\u00029bG.\fw-Z\u0005\u0005\u0005\u0003\u0011\u0019AA\u0002TKFT1!!@1!\u0011\u00119A!\u0004\u000e\u0005\t%!b\u0001B\u0006\u0011\u0005)A/\u001f9fg&!!q\u0002B\u0005\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X\rC\u0006V\u0001A\u0005\tr1Q\u0005\n\tMQC\u0001B\u000b!\u0019y#qC.\u0002\u0006%\u0019!\u0011\u0004\u0019\u0003\rQ+\b\u000f\\33\u0011)\u0011i\u0002\u0001E\u0001B\u0003&!QC\u0001\u0005q\u0012\n\u0004\u0005C\u0005\u0003\"\u0001A)\u0019!C\u00055\u0006)\"/\u001a;ve:\u0004VM]2f]RLG.Z!se\u0006L\b\"\u0003B\u0013\u0001!\u0005\t\u0015)\u0003\\\u0003Y\u0011X\r^;s]B+'oY3oi&dW-\u0011:sCf\u0004\u0003BCA\u0007\u0001!\u0015\r\u0011\"\u0003\u0003*U\u0011\u0011Q\u0001\u0005\u000b\u0005[\u0001\u0001\u0012!Q!\n\u0005\u0015\u0011\u0001\u00049fe\u000e,g\u000e^1hKN\u0004\u0003b\u0002B\u0019\u0001\u0011\u0005#1G\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0003\u0005k\u0001BAa\u000e\u0003>5\u0011!\u0011\b\u0006\u0004\u0005w1\u0011\u0001C1oC2L8/[:\n\t\t}\"\u0011\b\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\"9!1\t\u0001\u0005B\t\u0015\u0013aF2sK\u0006$X-Q4he\u0016<\u0017\r^5p]\n+hMZ3s)\u00051\u0002b\u0002B%\u0001\u0011\u0005#1J\u0001\u0007kB$\u0017\r^3\u0015\u000bE\u0013iE!\u0015\t\u000f\t=#q\ta\u0001-\u00051!-\u001e4gKJD\u0001Ba\u0015\u0003H\u0001\u0007!QK\u0001\tS:\u0004X\u000f\u001e*poB!!q\u000bB-\u001b\u00051\u0011b\u0001B.\r\tY\u0011J\u001c;fe:\fGNU8x\u0011\u0019Y\b\u0001\"\u0011\u0003`Q)\u0011K!\u0019\u0003d!9!q\nB/\u0001\u00041\u0002B\u0002@\u0003^\u0001\u0007a\u0003C\u0004\u0003h\u0001!\tE!\u001b\u0002\t\u00154\u0018\r\u001c\u000b\u0005\u0005W\u0012\t\bE\u00020\u0005[J1Aa\u001c1\u0005\r\te.\u001f\u0005\b\u0005\u001f\u0012)\u00071\u0001\u0017\u0011\u001d\u0011)\b\u0001C!\u0005o\nQd^5uQ:+w/T;uC\ndW-Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u000b\u0005\u0003+\u0012I\bC\u0004\u0003|\tM\u0004\u0019A\u001f\u0002\u00139,wo\u00144gg\u0016$\bb\u0002B@\u0001\u0011\u0005#\u0011Q\u0001\u001co&$\bNT3x\u0013:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0015\t\u0005U#1\u0011\u0005\b\u0005w\u0012i\b1\u0001>\u0011\u001d\u00119\t\u0001C!\u0005\u0013\u000b\u0001b\u00195jY\u0012\u0014XM\\\u000b\u0003\u0005\u0017\u0003b!!>\u0002\u0000\u0006m\u0003B\u0002BH\u0001\u0011\u0005#,\u0001\u0005ok2d\u0017M\u00197f\u0011\u001d\u0011\u0019\n\u0001C!\u0005+\u000b\u0001\u0002Z1uCRK\b/Z\u000b\u0003\u0005/\u0003BAa\u0002\u0003\u001a&!!1\u0014B\u0005\u0005!!\u0015\r^1UsB,\u0007b\u0002BP\u0001\u0011\u0005#\u0011U\u0001\u000baJ,G\u000f^=OC6,WC\u0001BR!\u0011\u0011)Ka+\u000f\u0007=\u00129+C\u0002\u0003*B\na\u0001\u0015:fI\u00164\u0017\u0002\u0002BW\u0005_\u0013aa\u0015;sS:<'b\u0001BUa!9\u00111\u0006\u0001\u0005B\tMF\u0003BA\u0018\u0005kCq!!\u000f\u00032\u0002\u0007a\u0003C\u0004\u0002>\u0001!\tE!/\u0015\u0007Y\u0011Y\f\u0003\u0005\u0002D\t]\u0006\u0019AA\u0018\u0011%\u0011y\fAA\u0001\n\u0003\u0011\t-\u0001\u0003d_BLH\u0003DA+\u0005\u0007\u0014)Ma2\u0003J\n-\u0007BCA-\u0005{\u0003\n\u00111\u0001\u0002\\!Q\u0011Q\rB_!\u0003\u0005\r!a\u0017\t\u0015\u0005%$Q\u0018I\u0001\u0002\u0004\tY\u0006C\u0005\u0002n\tu\u0006\u0013!a\u0001{!I\u0011\u0011\u000fB_!\u0003\u0005\r!\u0010\u0005\n\u0005\u001f\u0004\u0011\u0013!C\u0001\u0005#\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003T*\"\u00111\fBkW\t\u00119\u000e\u0005\u0003\u0003Z\n\rXB\u0001Bn\u0015\u0011\u0011iNa8\u0002\u0013Ut7\r[3dW\u0016$'b\u0001Bqa\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u0015(1\u001c\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"\u0003Bu\u0001E\u0005I\u0011\u0001Bi\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIIB\u0011B!<\u0001#\u0003%\tA!5\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g!I!\u0011\u001f\u0001\u0012\u0002\u0013\u0005!1_\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011)PK\u0002>\u0005+D\u0011B!?\u0001#\u0003%\tAa=\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%k!I!Q \u0001\u0002\u0002\u0013\u0005#q`\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\r\u0005\u0001\u0003BAI\u0007\u0007IAA!,\u0002\u0014\"A1q\u0001\u0001\u0002\u0002\u0013\u0005A(\u0001\u0007qe>$Wo\u0019;Be&$\u0018\u0010C\u0005\u0004\f\u0001\t\t\u0011\"\u0001\u0004\u000e\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B6\u0007\u001fA\u0001\"VB\u0005\u0003\u0003\u0005\r!\u0010\u0005\n\u0007'\u0001\u0011\u0011!C!\u0007+\tq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0007/\u0001ba!\u0007\u0004 \t-TBAB\u000e\u0015\r\u0019i\u0002M\u0001\u000bG>dG.Z2uS>t\u0017\u0002BB\u0011\u00077\u0011\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0007K\u0001\u0011\u0011!C\u0001\u0007O\t\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u00047\u000e%\u0002\"C+\u0004$\u0005\u0005\t\u0019\u0001B6\u0011%\u0019i\u0003AA\u0001\n\u0003\u001ay#\u0001\u0004fcV\fGn\u001d\u000b\u00047\u000eE\u0002\"C+\u0004,\u0005\u0005\t\u0019\u0001B6Q-\u00011QGB\u001e\u0007{\u0019\tea\u0011\u0011\t\u0005u3qG\u0005\u0004\u0007s!!!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0007\u007f\tQq\b\u0006!A\u0001\u0002sLR+O\u0007~C3m\u001c7-AA,'oY3oi\u0006<W\rI.-A\u0005\u001c7-\u001e:bGfl\u0016\u0006I\u0017!%\u0016$XO\u001d8tAQDW\rI1qaJ|\u00070[7bi\u0016\u0004\u0003/\u001a:dK:$\u0018\u000e\\3!m\u0006dW/\u001a\u0011pM\u0002rW/\\3sS\u000eT\u0001\u0005\t\u0011!A\u0001\u001aw\u000e\\;n]\u0002\u00027m\u001c7aA\u0005$\b\u0005\u001e5fA\u001dLg/\u001a8!a\u0016\u00148-\u001a8uC\u001e,g\u0006\t+iK\u00022\u0018\r\\;fA=4\u0007\u0005]3sG\u0016tG/Y4fA5,8\u000f\u001e\u0011cK\u0002\u0012W\r^<fK:\u0004\u0003G\f\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011b]\u0012\u0004\u0013G\f\u0019/AQCW\r\t1bG\u000e,(/Y2zA\u0002\u0002\u0018M]1nKR,'\u000f\t\u0015eK\u001a\fW\u000f\u001c;;AE\u0002\u0004\u0007\r\u0019*A%\u001c\b%\u0019\u0011q_NLG/\u001b<fA9,X.\u001a:jG\u0002b\u0017\u000e^3sC2\u0004s\u000f[5dQ*\u0001\u0003\u0005\t\u0011!A\r|g\u000e\u001e:pYN\u0004\u0013\r\u001d9s_bLW.\u0019;j_:\u0004\u0013mY2ve\u0006\u001c\u0017\u0010I1uAQDW\rI2pgR\u0004sN\u001a\u0011nK6|'/\u001f\u0018!\u0011&<\u0007.\u001a:!m\u0006dW/\u001a\u0011pM\u0002\u0002\u0017mY2ve\u0006\u001c\u0017\u0010\u0019\u0011zS\u0016dGm\u001d\u0006!A\u0001\u0002\u0003\u0005\t2fiR,'\u000fI1dGV\u0014\u0018mY=-A\u0001\fd\u0006M\u0018bG\u000e,(/Y2zA\u0002J7\u000f\t;iK\u0002\u0012X\r\\1uSZ,\u0007%\u001a:s_J\u0004sN\u001a\u0011uQ\u0016\u0004\u0013\r\u001d9s_bLW.\u0019;j_:t#\u0002\t\u0011!A\u0001\u0002s\u000b[3oA\u0001\u0004XM]2f]R\fw-\u001a1!SN\u0004\u0013M\u001c\u0011beJ\f\u0017\u0010\f\u0011fC\u000eD\u0007E^1mk\u0016\u0004sN\u001a\u0011uQ\u0016\u0004\u0003/\u001a:dK:$\u0018mZ3!CJ\u0014\u0018-\u001f\u0011nkN$\bEY3!E\u0016$x/Z3oAAr\u0003\u0007I1oI\u0002\nd\u0006\r\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011J]\u0002\"\b.[:!G\u0006\u001cX\r\f\u0011sKR,(O\\:!i\",\u0007%\u00199qe>D\u0018.\\1uK\u0002\u0002XM]2f]RLG.\u001a\u0011beJ\f\u0017\u0010I8gA\r|G.^7oA\u0001\u001cw\u000e\u001c1!CR\u0004C\u000f[3!O&4XM\u001c\u0006!A\u0001\u0002\u0003\u0005\t9fe\u000e,g\u000e^1hK\u0002\n'O]1z])\u0001\u0003%\u0001\u0005fqR,g\u000eZ3eC\t\u0019)%AA+\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\u0002XM]2f]RLG.Z0baB\u0014x\u000e\u001f\u00152a9\u0002D\u0006I1se\u0006L\b\u0006\r\u00186Y\u0001\u0002d\u0006\u000e\u0017!a9\n\u0014\u0006\f\u00112aAJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I.2a9\u0002D&\r\u0019/a1\n\u0004G\f\u0019^\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\u0002XM]2f]RLG.Z0baB\u0014x\u000e\u001f\u00152a9\u0002D\u0006\t\u0019/k1\u0002\u0013\u0007\r\u0019*w)\u0001\u0003\u0005\t\u0011!A\u0001\n\u0004G\f\u0019\u000bA\u0001\u0002")
public class ApproximatePercentile
extends TypedImperativeAggregate<PercentileDigest>
implements Serializable {
    private final Expression child;
    private final Expression percentageExpression;
    private final Expression accuracyExpression;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private int accuracy;
    private Tuple2<Object, double[]> x$1;
    private boolean returnPercentileArray;
    private double[] percentages;
    private volatile byte bitmap$0;

    public static Option<Tuple5<Expression, Expression, Expression, Object, Object>> unapply(ApproximatePercentile approximatePercentile) {
        return ApproximatePercentile$.MODULE$.unapply(approximatePercentile);
    }

    public static PercentileDigestSerializer serializer() {
        return ApproximatePercentile$.MODULE$.serializer();
    }

    public static int DEFAULT_PERCENTILE_ACCURACY() {
        return ApproximatePercentile$.MODULE$.DEFAULT_PERCENTILE_ACCURACY();
    }

    private int accuracy$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.accuracy = BoxesRunTime.unboxToInt((Object)this.accuracyExpression().eval(this.accuracyExpression().eval$default$1()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.accuracy;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Tuple2 x$1$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Tuple2 tuple2;
                Tuple2 tuple22;
                Object num;
                Tuple2 tuple23 = new Tuple2((Object)this.percentageExpression().dataType(), this.percentageExpression().eval(this.percentageExpression().eval$default$1()));
                if (tuple23 != null && (num = tuple23._2()) instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)num);
                    tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new double[]{d});
                } else {
                    ArrayType arrayType2;
                    DataType baseType;
                    if (tuple23 == null) throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid data type ", " for parameter percentage"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tuple23._1()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    DataType dataType2 = (DataType)tuple23._1();
                    Object arrayData = tuple23._2();
                    if (!(dataType2 instanceof ArrayType) || !((baseType = (arrayType2 = (ArrayType)dataType2).elementType()) instanceof NumericType)) throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid data type ", " for parameter percentage"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tuple23._1()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    NumericType numericType = (NumericType)baseType;
                    if (!(arrayData instanceof ArrayData)) throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid data type ", " for parameter percentage"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tuple23._1()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    ArrayData arrayData2 = (ArrayData)arrayData;
                    Object[] numericArray = arrayData2.toObjectArray(numericType);
                    tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), Predef$.MODULE$.refArrayOps(numericArray).map((Function1)new Serializable(this, numericType){
                        public static final long serialVersionUID = 0L;
                        private final NumericType x7$1;

                        public final double apply(Object x) {
                            return this.x7$1.numeric().toDouble(x);
                        }
                        {
                            this.x7$1 = x7$1;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
                }
                Tuple2 tuple24 = tuple22;
                if (tuple24 == null) throw new MatchError((Object)tuple24);
                boolean returnPercentileArray = tuple24._1$mcZ$sp();
                double[] percentages2 = (double[])tuple24._2();
                boolean bl = returnPercentileArray;
                if (percentages2 == null) throw new MatchError((Object)tuple24);
                double[] dArray = percentages2;
                this.x$1 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)bl), (Object)dArray);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.x$1;
        }
    }

    private boolean returnPercentileArray$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.returnPercentileArray = this.x$1()._1$mcZ$sp();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.returnPercentileArray;
        }
    }

    private double[] percentages$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.percentages = (double[])this.x$1()._2();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.percentages;
        }
    }

    public Expression child() {
        return this.child;
    }

    public Expression percentageExpression() {
        return this.percentageExpression;
    }

    public Expression accuracyExpression() {
        return this.accuracyExpression;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private int accuracy() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.accuracy$lzycompute() : this.accuracy;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, ArrayType$.MODULE$})), IntegerType$.MODULE$}));
    }

    private /* synthetic */ Tuple2 x$1() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.x$1$lzycompute() : this.x$1;
    }

    private boolean returnPercentileArray() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.returnPercentileArray$lzycompute() : this.returnPercentileArray;
    }

    private double[] percentages() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.percentages$lzycompute() : this.percentages;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes$class.checkInputDataTypes(this);
        return defaultCheck.isFailure() ? defaultCheck : (this.percentageExpression().foldable() && this.accuracyExpression().foldable() ? (this.accuracy() <= 0 ? new TypeCheckResult.TypeCheckFailure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The accuracy provided must be a positive integer literal (current value = ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.accuracy())}))) : (Predef$.MODULE$.doubleArrayOps(this.percentages()).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(double percentage) {
                return this.apply$mcZD$sp(percentage);
            }

            public boolean apply$mcZD$sp(double percentage) {
                return percentage < 0.0 || percentage > 1.0;
            }
        }) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"All percentage values must be between 0.0 and 1.0 "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(current = ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.doubleArrayOps(this.percentages()).mkString(", ")}))).toString()) : TypeCheckResult$TypeCheckSuccess$.MODULE$)) : new TypeCheckResult.TypeCheckFailure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The accuracy or percentage provided must be a constant literal"})).s((Seq)Nil$.MODULE$)));
    }

    @Override
    public PercentileDigest createAggregationBuffer() {
        double relativeError = 1.0 / (double)this.accuracy();
        return new PercentileDigest(relativeError);
    }

    @Override
    public void update(PercentileDigest buffer, InternalRow inputRow) {
        Object value2 = this.child().eval(inputRow);
        if (value2 != null) {
            buffer.add(BoxesRunTime.unboxToDouble((Object)value2));
        }
    }

    @Override
    public void merge(PercentileDigest buffer, PercentileDigest other) {
        buffer.merge(other);
    }

    @Override
    public Object eval(PercentileDigest buffer) {
        double[] result = buffer.getPercentiles(this.percentages());
        return result.length == 0 ? null : (this.returnPercentileArray() ? new GenericArrayData(result) : BoxesRunTime.boxToDouble((double)result[0]));
    }

    @Override
    public ApproximatePercentile withNewMutableAggBufferOffset(int newOffset) {
        int x$2 = newOffset;
        Expression x$3 = this.copy$default$1();
        Expression x$4 = this.copy$default$2();
        Expression x$5 = this.copy$default$3();
        int x$6 = this.copy$default$5();
        return this.copy(x$3, x$4, x$5, x$2, x$6);
    }

    @Override
    public ApproximatePercentile withNewInputAggBufferOffset(int newOffset) {
        int x$7 = newOffset;
        Expression x$8 = this.copy$default$1();
        Expression x$9 = this.copy$default$2();
        Expression x$10 = this.copy$default$3();
        int x$11 = this.copy$default$4();
        return this.copy(x$8, x$9, x$10, x$11, x$7);
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child(), this.percentageExpression(), this.accuracyExpression()}));
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return this.returnPercentileArray() ? ArrayType$.MODULE$.apply(DoubleType$.MODULE$) : DoubleType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "percentile_approx";
    }

    @Override
    public byte[] serialize(PercentileDigest obj) {
        return ApproximatePercentile$.MODULE$.serializer().serialize(obj);
    }

    @Override
    public PercentileDigest deserialize(byte[] bytes) {
        return ApproximatePercentile$.MODULE$.serializer().deserialize(bytes);
    }

    public ApproximatePercentile copy(Expression child, Expression percentageExpression, Expression accuracyExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new ApproximatePercentile(child, percentageExpression, accuracyExpression, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.percentageExpression();
    }

    public Expression copy$default$3() {
        return this.accuracyExpression();
    }

    public int copy$default$4() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$5() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "ApproximatePercentile";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 4: {
                object = BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
                break;
            }
            case 2: {
                object = this.accuracyExpression();
                break;
            }
            case 1: {
                object = this.percentageExpression();
                break;
            }
            case 0: {
                object = this.child();
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ApproximatePercentile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ApproximatePercentile)) return false;
        boolean bl = true;
        if (!bl) return false;
        ApproximatePercentile approximatePercentile = (ApproximatePercentile)x$1;
        Expression expression = this.child();
        Expression expression2 = approximatePercentile.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.percentageExpression();
        Expression expression4 = approximatePercentile.percentageExpression();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.accuracyExpression();
        Expression expression6 = approximatePercentile.accuracyExpression();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (this.mutableAggBufferOffset() != approximatePercentile.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != approximatePercentile.inputAggBufferOffset()) return false;
        if (!approximatePercentile.canEqual(this)) return false;
        return true;
    }

    public ApproximatePercentile(Expression child, Expression percentageExpression, Expression accuracyExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.percentageExpression = percentageExpression;
        this.accuracyExpression = accuracyExpression;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
    }

    public ApproximatePercentile(Expression child, Expression percentageExpression, Expression accuracyExpression) {
        this(child, percentageExpression, accuracyExpression, 0, 0);
    }

    public ApproximatePercentile(Expression child, Expression percentageExpression) {
        this(child, percentageExpression, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)ApproximatePercentile$.MODULE$.DEFAULT_PERCENTILE_ACCURACY())));
    }

    public static class PercentileDigest {
        private QuantileSummaries summaries;
        private boolean isCompressed;
        private final int compressThresHoldBufferLength;

        private QuantileSummaries summaries() {
            return this.summaries;
        }

        private void summaries_$eq(QuantileSummaries x$1) {
            this.summaries = x$1;
        }

        private boolean isCompressed() {
            return this.isCompressed;
        }

        private void isCompressed_$eq(boolean x$1) {
            this.isCompressed = x$1;
        }

        public QuantileSummaries quantileSummaries() {
            if (!this.isCompressed()) {
                this.compress();
            }
            return this.summaries();
        }

        public void add(double value2) {
            this.summaries_$eq(this.summaries().insert(value2));
            this.isCompressed_$eq(false);
            if (this.summaries().sampled().length >= this.compressThresHoldBufferLength) {
                this.compress();
            }
        }

        public void merge(PercentileDigest other) {
            if (!this.isCompressed()) {
                this.compress();
            }
            this.summaries_$eq(this.summaries().merge(other.quantileSummaries()));
        }

        /*
         * WARNING - void declaration
         */
        public double[] getPercentiles(double[] percentages2) {
            double[] dArray;
            if (!this.isCompressed()) {
                this.compress();
            }
            if (this.summaries().count() == 0L || percentages2.length == 0) {
                dArray = (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double());
            } else {
                void var2_2;
                double[] result = new double[percentages2.length];
                for (int i = 0; i < percentages2.length; ++i) {
                    result[i] = this.summaries().query(percentages2[i]);
                }
                dArray = var2_2;
            }
            return dArray;
        }

        private final void compress() {
            this.summaries_$eq(this.summaries().compress());
            this.isCompressed_$eq(true);
        }

        public PercentileDigest(QuantileSummaries summaries, boolean isCompressed) {
            this.summaries = summaries;
            this.isCompressed = isCompressed;
            int maxBufferLengthAfterCompression = (int)(1.0 / this.summaries().relativeError()) * 2;
            this.compressThresHoldBufferLength = maxBufferLengthAfterCompression * 2;
        }

        public PercentileDigest(double relativeError) {
            this(new QuantileSummaries(QuantileSummaries$.MODULE$.defaultCompressThreshold(), relativeError, QuantileSummaries$.MODULE$.$lessinit$greater$default$3(), QuantileSummaries$.MODULE$.$lessinit$greater$default$4()), true);
        }
    }

    public static class PercentileDigestSerializer {
        private final int length(QuantileSummaries summaries) {
            return 24 + summaries.sampled().length * 16;
        }

        public final byte[] serialize(PercentileDigest obj) {
            QuantileSummaries summary = obj.quantileSummaries();
            ByteBuffer buffer = ByteBuffer.wrap(new byte[this.length(summary)]);
            buffer.putInt(summary.compressThreshold());
            buffer.putDouble(summary.relativeError());
            buffer.putLong(summary.count());
            buffer.putInt(summary.sampled().length);
            for (int i = 0; i < summary.sampled().length; ++i) {
                QuantileSummaries.Stats stat = summary.sampled()[i];
                buffer.putDouble(stat.value());
                buffer.putInt(stat.g());
                buffer.putInt(stat.delta());
            }
            return buffer.array();
        }

        public final PercentileDigest deserialize(byte[] bytes) {
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            int compressThreshold = buffer.getInt();
            double relativeError = buffer.getDouble();
            long count = buffer.getLong();
            int sampledLength = buffer.getInt();
            QuantileSummaries.Stats[] sampled = new QuantileSummaries.Stats[sampledLength];
            for (int i = 0; i < sampledLength; ++i) {
                double value2 = buffer.getDouble();
                int g = buffer.getInt();
                int delta = buffer.getInt();
                sampled[i] = new QuantileSummaries.Stats(value2, g, delta);
            }
            QuantileSummaries summary = new QuantileSummaries(compressThreshold, relativeError, sampled, count);
            return new PercentileDigest(summary, true);
        }
    }
}

