/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.solr.common.IteratorWriter;
import org.apache.solr.common.MapSerializable;

public interface MapWriter
extends MapSerializable {
    @Override
    default public Map toMap(final Map<String, Object> map) {
        try {
            this.writeMap(new EntryWriter(){

                @Override
                public EntryWriter put(String k, Object v) throws IOException {
                    if (v instanceof MapWriter) {
                        v = ((MapWriter)v).toMap(new LinkedHashMap<String, Object>());
                    }
                    if (v instanceof IteratorWriter) {
                        v = ((IteratorWriter)v).toList(new ArrayList());
                    }
                    map.put(k, v);
                    return this;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    public void writeMap(EntryWriter var1) throws IOException;

    public static interface EntryWriter {
        public EntryWriter put(String var1, Object var2) throws IOException;

        default public EntryWriter putIfNotNull(String k, Object v) throws IOException {
            if (v != null) {
                this.put(k, v);
            }
            return this;
        }

        default public EntryWriter put(String k, int v) throws IOException {
            this.put(k, (Object)v);
            return this;
        }

        default public EntryWriter put(String k, long v) throws IOException {
            this.put(k, (Object)v);
            return this;
        }

        default public EntryWriter put(String k, float v) throws IOException {
            this.put(k, Float.valueOf(v));
            return this;
        }

        default public EntryWriter put(String k, double v) throws IOException {
            this.put(k, (Object)v);
            return this;
        }

        default public EntryWriter put(String k, boolean v) throws IOException {
            this.put(k, (Object)v);
            return this;
        }
    }
}

