/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.client.solrj.io.SolrClientCache;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.JSONTupleStream;
import org.apache.solr.client.solrj.io.stream.JavabinTupleStreamParser;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.TupleStreamParser;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrStream
extends TupleStream {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final long serialVersionUID = 1L;
    private String baseUrl;
    private SolrParams params;
    private int numWorkers;
    private int workerID;
    private boolean trace;
    private Map<String, String> fieldMappings;
    private transient TupleStreamParser tupleStreamParser;
    private transient HttpSolrClient client;
    private transient SolrClientCache cache;
    private String slice;
    private long checkpoint = -1L;
    private CloseableHttpResponse closeableHttpResponse;

    public SolrStream(String baseUrl, SolrParams params) {
        this.baseUrl = baseUrl;
        this.params = params;
    }

    public void setFieldMappings(Map<String, String> fieldMappings) {
        this.fieldMappings = fieldMappings;
    }

    @Override
    public List<TupleStream> children() {
        return new ArrayList<TupleStream>();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.numWorkers = context.numWorkers;
        this.workerID = context.workerID;
        this.cache = context.getSolrClientCache();
    }

    @Override
    public void open() throws IOException {
        this.client = this.cache == null ? new HttpSolrClient.Builder(this.baseUrl).build() : this.cache.getHttpSolrClient(this.baseUrl);
        try {
            this.tupleStreamParser = this.constructParser(this.client, this.loadParams(this.params));
        }
        catch (Exception e) {
            throw new IOException("params " + this.params, e);
        }
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public void setSlice(String slice) {
        this.slice = slice;
    }

    public void setCheckpoint(long checkpoint) {
        this.checkpoint = checkpoint;
    }

    private SolrParams loadParams(SolrParams paramsIn) throws IOException {
        ModifiableSolrParams solrParams = new ModifiableSolrParams(paramsIn);
        if (this.params.get("partitionKeys") != null) {
            if (!this.params.get("partitionKeys").equals("none")) {
                String partitionFilter = this.getPartitionFilter();
                solrParams.add("fq", partitionFilter);
            }
        } else if (this.numWorkers > 1) {
            throw new IOException("When numWorkers > 1 partitionKeys must be set. Set partitionKeys=none to send the entire stream to each worker.");
        }
        if (this.checkpoint > 0L) {
            solrParams.add("fq", "{!frange cost=100 incl=false l=" + this.checkpoint + "}_version_");
        }
        return solrParams;
    }

    private String getPartitionFilter() {
        StringBuilder buf = new StringBuilder("{!hash workers=");
        buf.append(this.numWorkers);
        buf.append(" worker=");
        buf.append(this.workerID);
        buf.append("}");
        return buf.toString();
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new StreamExplanation(this.getStreamNodeId().toString()).withFunctionName("non-expressible").withImplementingClass(this.getClass().getName()).withExpressionType("stream-source").withExpression("non-expressible");
    }

    @Override
    public void close() throws IOException {
        this.closeableHttpResponse.close();
        if (this.cache == null) {
            this.client.close();
        }
    }

    @Override
    public Tuple read() throws IOException {
        try {
            Map fields = this.tupleStreamParser.next();
            if (fields == null) {
                HashMap<String, Boolean> m = new HashMap<String, Boolean>();
                m.put("EOF", true);
                return new Tuple(m);
            }
            String msg = (String)fields.get("EXCEPTION");
            if (msg != null) {
                HandledException ioException = new HandledException(msg);
                throw ioException;
            }
            if (this.trace) {
                fields.put((String)"_CORE_", (Object)this.baseUrl);
                if (this.slice != null) {
                    fields.put("_SLICE_", this.slice);
                }
            }
            if (this.fieldMappings != null) {
                fields = this.mapFields(fields, this.fieldMappings);
            }
            return new Tuple(fields);
        }
        catch (HandledException e) {
            throw new IOException("--> " + this.baseUrl + ":" + e.getMessage());
        }
        catch (Exception e) {
            throw new IOException("--> " + this.baseUrl + ": An exception has occurred on the server, refer to server log for details.", e);
        }
    }

    @Override
    public StreamComparator getStreamSort() {
        return null;
    }

    private Map mapFields(Map fields, Map<String, String> mappings) {
        for (Map.Entry<String, String> entry : mappings.entrySet()) {
            String mapFrom = entry.getKey();
            String mapTo = entry.getValue();
            Object o = fields.get(mapFrom);
            fields.remove(mapFrom);
            fields.put(mapTo, o);
        }
        return fields;
    }

    public TupleStreamParser constructParser(SolrClient server, SolrParams requestParams) throws IOException, SolrServerException {
        String p = requestParams.get("qt");
        if (p != null) {
            ModifiableSolrParams modifiableSolrParams = (ModifiableSolrParams)requestParams;
            modifiableSolrParams.remove("qt");
            modifiableSolrParams.set("indent", modifiableSolrParams.get("indent", "off"));
        }
        String wt = requestParams.get("wt", "json");
        QueryRequest query = new QueryRequest(requestParams);
        query.setPath(p);
        query.setResponseParser(new InputStreamResponseParser(wt));
        query.setMethod(SolrRequest.METHOD.POST);
        NamedList<Object> genericResponse = server.request(query);
        InputStream stream = (InputStream)genericResponse.get("stream");
        this.closeableHttpResponse = (CloseableHttpResponse)genericResponse.get("closeableResponse");
        if ("javabin".equals(wt)) {
            return new JavabinTupleStreamParser(stream, true);
        }
        InputStreamReader reader = new InputStreamReader(stream, "UTF-8");
        return new JSONTupleStream(reader);
    }

    public static class HandledException
    extends IOException {
        public HandledException(String msg) {
            super(msg);
        }
    }
}

