/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.math3.util.MathArrays;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.ComplexEvaluator;
import org.apache.solr.client.solrj.io.eval.StreamEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class ScaleEvaluator
extends ComplexEvaluator
implements Expressible {
    private static final long serialVersionUID = 1L;

    public ScaleEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (2 != this.subEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting two values but found %d", expression, this.subEvaluators.size()));
        }
    }

    @Override
    public List<Number> evaluate(Tuple tuple) throws IOException {
        StreamEvaluator numEval = (StreamEvaluator)this.subEvaluators.get(0);
        StreamEvaluator colEval1 = (StreamEvaluator)this.subEvaluators.get(1);
        Number num = (Number)numEval.evaluate(tuple);
        List numbers1 = (List)colEval1.evaluate(tuple);
        double[] column1 = new double[numbers1.size()];
        for (int i = 0; i < numbers1.size(); ++i) {
            column1[i] = ((Number)numbers1.get(i)).doubleValue();
        }
        double[] scaled = MathArrays.scale((double)num.doubleValue(), (double[])column1);
        ArrayList<Number> scaledList = new ArrayList<Number>(scaled.length);
        for (double d : scaled) {
            scaledList.add(d);
        }
        return scaledList;
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new Explanation(this.nodeId.toString()).withExpressionType("evaluator").withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpression(this.toExpression(factory).toString());
    }
}

