/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.math3.stat.regression.SimpleRegression;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.ComplexEvaluator;
import org.apache.solr.client.solrj.io.eval.StreamEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class RegressionEvaluator
extends ComplexEvaluator
implements Expressible {
    private static final long serialVersionUID = 1L;

    public RegressionEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (2 != this.subEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting two columns but found %d", expression, this.subEvaluators.size()));
        }
    }

    @Override
    public Tuple evaluate(Tuple tuple) throws IOException {
        int i;
        StreamEvaluator colEval1 = (StreamEvaluator)this.subEvaluators.get(0);
        StreamEvaluator colEval2 = (StreamEvaluator)this.subEvaluators.get(1);
        List numbers1 = (List)colEval1.evaluate(tuple);
        List numbers2 = (List)colEval2.evaluate(tuple);
        double[] column1 = new double[numbers1.size()];
        double[] column2 = new double[numbers2.size()];
        for (i = 0; i < numbers1.size(); ++i) {
            column1[i] = ((Number)numbers1.get(i)).doubleValue();
        }
        for (i = 0; i < numbers2.size(); ++i) {
            column2[i] = ((Number)numbers2.get(i)).doubleValue();
        }
        SimpleRegression regression = new SimpleRegression();
        for (int i2 = 0; i2 < column1.length; ++i2) {
            regression.addData(column1[i2], column2[i2]);
        }
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put("slope", regression.getSlope());
        map.put("intercept", regression.getIntercept());
        map.put("R", regression.getR());
        map.put("N", regression.getN());
        map.put("regressionSumSquares", regression.getRegressionSumSquares());
        map.put("slopeConfidenceInterval", regression.getSlopeConfidenceInterval());
        map.put("interceptStdErr", regression.getInterceptStdErr());
        map.put("totalSumSquares", regression.getTotalSumSquares());
        map.put("significance", regression.getSignificance());
        map.put("meanSquareError", regression.getMeanSquareError());
        return new RegressionTuple(regression, map);
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new Explanation(this.nodeId.toString()).withExpressionType("evaluator").withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpression(this.toExpression(factory).toString());
    }

    public static class RegressionTuple
    extends Tuple {
        private SimpleRegression simpleRegression;

        public RegressionTuple(SimpleRegression simpleRegression, Map map) {
            super(map);
            this.simpleRegression = simpleRegression;
        }

        public double predict(double d) {
            return this.simpleRegression.predict(d);
        }
    }
}

