/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.ComplexEvaluator;
import org.apache.solr.client.solrj.io.eval.StreamEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class CopyOfEvaluator
extends ComplexEvaluator
implements Expressible {
    private static final long serialVersionUID = 1L;

    public CopyOfEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public List<Number> evaluate(Tuple tuple) throws IOException {
        StreamEvaluator colEval1 = (StreamEvaluator)this.subEvaluators.get(0);
        List numbers1 = (List)colEval1.evaluate(tuple);
        double[] vals = new double[numbers1.size()];
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = ((Number)numbers1.get(i)).doubleValue();
        }
        if (this.subEvaluators.size() == 2) {
            StreamEvaluator lengthEval = (StreamEvaluator)this.subEvaluators.get(1);
            Number lengthNum = (Number)lengthEval.evaluate(tuple);
            int length = lengthNum.intValue();
            vals = Arrays.copyOf(vals, length);
        } else {
            vals = Arrays.copyOf(vals, vals.length);
        }
        ArrayList<Number> copyOf = new ArrayList<Number>(vals.length);
        for (int i = 0; i < vals.length; ++i) {
            copyOf.add(vals[i]);
        }
        return copyOf;
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new Explanation(this.nodeId.toString()).withExpressionType("evaluator").withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpression(this.toExpression(factory).toString());
    }
}

