/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.ComplexEvaluator;
import org.apache.solr.client.solrj.io.eval.StreamEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class ArrayEvaluator
extends ComplexEvaluator
implements Expressible {
    private static final long serialVersionUID = 1L;
    private String sortOrder;

    public ArrayEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory, Arrays.asList("sort"));
        this.sortOrder = this.extractSortOrder(expression, factory);
    }

    private String extractSortOrder(StreamExpression expression, StreamFactory factory) throws IOException {
        String sortOrder;
        StreamExpressionNamedParameter sortParam = factory.getNamedOperand(expression, "sort");
        if (null == sortParam) {
            return null;
        }
        if (sortParam.getParameter() instanceof StreamExpressionValue && ("asc".equals(sortOrder = ((StreamExpressionValue)sortParam.getParameter()).getValue().trim().toLowerCase(Locale.ROOT)) || "desc".equals(sortOrder))) {
            return sortOrder;
        }
        throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - invalid 'sort' parameter - expecting either 'asc' or 'desc'", expression));
    }

    @Override
    public List<Object> evaluate(Tuple tuple) throws IOException {
        List<Object> list = new ArrayList<Object>();
        for (StreamEvaluator subEvaluator : this.subEvaluators) {
            Object value2 = subEvaluator.evaluate(tuple);
            if (null != this.sortOrder && !(value2 instanceof Comparable)) {
                String message = String.format(Locale.ROOT, "Failed to evaluate to a comparable object - evaluator '%s' resulted in type '%s' and value '%s'", subEvaluator.toExpression(this.constructingFactory), value2.getClass().getName(), value2.toString());
                throw new IOException(message);
            }
            list.add(value2);
        }
        if (null != this.sortOrder) {
            Comparator comparator = "asc".equals(this.sortOrder) ? (left, right) -> left.compareTo(right) : (left, right) -> right.compareTo(left);
            list = list.stream().map(value -> (Comparable)value).sorted(comparator).collect(Collectors.toList());
        }
        return list;
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new Explanation(this.nodeId.toString()).withExpressionType("evaluator").withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpression(this.toExpression(factory).toString());
    }
}

