/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.cloud.autoscaling.Policy;
import org.apache.solr.client.solrj.cloud.autoscaling.Row;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;

public class Preference
implements MapWriter {
    final Policy.SortParam name;
    Integer precision;
    final Policy.Sort sort;
    Preference next;
    public int idx;
    private final Map original;

    Preference(Map<String, Object> m) {
        this.original = Utils.getDeepCopy(m, 3);
        this.sort = Policy.Sort.get(m);
        this.name = Policy.SortParam.get(m.get(this.sort.name()).toString());
        Object p = m.getOrDefault("precision", 0);
        this.precision = p instanceof Number ? ((Number)p).intValue() : Integer.parseInt(p.toString());
        if (this.precision < 0) {
            throw new RuntimeException("precision must be a positive value ");
        }
        if (this.precision < this.name.min || this.precision > this.name.max) {
            throw new RuntimeException(StrUtils.formatString("invalid precision value {0} must lie between {1} and {1}", this.precision, this.name.min, this.name.max));
        }
    }

    int compare(Row r1, Row r2, boolean useApprox) {
        Object o1 = useApprox ? r1.cells[this.idx].approxVal : r1.cells[this.idx].val;
        Object o2 = useApprox ? r2.cells[this.idx].approxVal : r2.cells[this.idx].val;
        int result = 0;
        if (o1 instanceof Long && o2 instanceof Long) {
            result = ((Long)o1).compareTo((Long)o2);
        } else if (o1 instanceof Double && o2 instanceof Double) {
            result = ((Double)o1).compareTo((Double)o2);
        } else if (!o1.getClass().getName().equals(o2.getClass().getName())) {
            throw new RuntimeException("Unable to compare " + o1 + " of type: " + o1.getClass().getName() + " from " + r1.cells[this.idx].toString() + " and " + o2 + " of type: " + o2.getClass().getName() + " from " + r2.cells[this.idx].toString());
        }
        return result == 0 ? (this.next == null ? 0 : this.next.compare(r1, r2, useApprox)) : this.sort.sortval * result;
    }

    void setApproxVal(List<Row> tmpMatrix) {
        Object prevVal = null;
        for (Row row : tmpMatrix) {
            row.cells[this.idx].approxVal = prevVal == null || Double.compare(Math.abs(((Number)prevVal).doubleValue() - ((Number)row.cells[this.idx].val).doubleValue()), this.precision.intValue()) > 0 ? row.cells[this.idx].val : prevVal;
            prevVal = row.cells[this.idx].approxVal;
        }
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        Iterator iterator = this.original.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry e = o = iterator.next();
            ew.put(String.valueOf(e.getKey()), e.getValue());
        }
    }

    public Policy.SortParam getName() {
        return this.name;
    }
}

