/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.cloud.autoscaling.AddReplicaSuggester;
import org.apache.solr.client.solrj.cloud.autoscaling.Clause;
import org.apache.solr.client.solrj.cloud.autoscaling.ClusterDataProvider;
import org.apache.solr.client.solrj.cloud.autoscaling.MoveReplicaSuggester;
import org.apache.solr.client.solrj.cloud.autoscaling.Preference;
import org.apache.solr.client.solrj.cloud.autoscaling.Row;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.util.Pair;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;

public class Policy
implements MapWriter {
    public static final String POLICY = "policy";
    public static final String EACH = "#EACH";
    public static final String ANY = "#ANY";
    public static final String CLUSTER_POLICY = "cluster-policy";
    public static final String CLUSTER_PREFERENCE = "cluster-preferences";
    public static final Set<String> GLOBAL_ONLY_TAGS = Collections.singleton("cores");
    final Map<String, List<Clause>> policies = new HashMap<String, List<Clause>>();
    final List<Clause> clusterPolicy;
    final List<Preference> clusterPreferences;
    final List<String> params;
    private static final Map<CollectionParams.CollectionAction, Supplier<Suggester>> ops = new HashMap<CollectionParams.CollectionAction, Supplier<Suggester>>();

    public Policy(Map<String, Object> jsonMap) {
        this.clusterPreferences = jsonMap.getOrDefault(CLUSTER_PREFERENCE, Collections.emptyList()).stream().map(Preference::new).collect(Collectors.toList());
        for (int i = 0; i < this.clusterPreferences.size() - 1; ++i) {
            Preference preference = this.clusterPreferences.get(i);
            preference.next = this.clusterPreferences.get(i + 1);
        }
        if (this.clusterPreferences.isEmpty()) {
            this.clusterPreferences.add(new Preference((Map)Utils.fromJSONString("{minimize : cores, precision:1}")));
        }
        TreeSet<String> paramsOfInterest = new TreeSet<String>();
        for (Preference preference : this.clusterPreferences) {
            if (paramsOfInterest.contains(preference.name.name())) {
                throw new RuntimeException((Object)((Object)preference.name) + " is repeated");
            }
            paramsOfInterest.add(preference.name.toString());
        }
        this.params = new ArrayList<String>(paramsOfInterest);
        this.clusterPolicy = jsonMap.getOrDefault(CLUSTER_POLICY, Collections.emptyList()).stream().map(Clause::new).filter(clause -> {
            clause.addTags(this.params);
            return true;
        }).collect(Collectors.toList());
        jsonMap.getOrDefault("policies", Collections.emptyMap()).forEach((s, l1) -> this.policies.put((String)s, l1.stream().map(Clause::new).filter(clause -> {
            if (!clause.isPerCollectiontag()) {
                throw new RuntimeException(clause.globalTag.name + " is only allowed in 'cluster-policy'");
            }
            clause.addTags(this.params);
            return true;
        }).sorted().collect(Collectors.toList())));
    }

    public List<Clause> getClusterPolicy() {
        return this.clusterPolicy;
    }

    public List<Preference> getClusterPreferences() {
        return this.clusterPreferences;
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        if (!this.policies.isEmpty()) {
            ew.put("policies", ew1 -> {
                for (Map.Entry<String, List<Clause>> e : this.policies.entrySet()) {
                    ew1.put(e.getKey(), e.getValue());
                }
            });
        }
        if (!this.clusterPreferences.isEmpty()) {
            ew.put("preferences", iw -> {
                for (Preference p : this.clusterPreferences) {
                    iw.add(p);
                }
            });
        }
    }

    public Session createSession(ClusterDataProvider dataProvider) {
        return new Session(dataProvider);
    }

    public static List<Clause> mergePolicies(String coll, List<Clause> collPolicy, List<Clause> globalPolicy) {
        List<Clause> merged = Policy.insertColl(coll, collPolicy);
        List<Clause> global = Policy.insertColl(coll, globalPolicy);
        merged.addAll(global.stream().filter(clusterPolicyClause -> merged.stream().noneMatch(perCollPolicy -> perCollPolicy.doesOverride((Clause)clusterPolicyClause))).collect(Collectors.toList()));
        return merged;
    }

    static List<Clause> insertColl(String coll, Collection<Clause> conditions) {
        return conditions.stream().filter(Clause::isPerCollectiontag).map(clause -> {
            LinkedHashMap<String, Object> copy = new LinkedHashMap<String, Object>(clause.original);
            if (!copy.containsKey("collection")) {
                copy.put("collection", coll);
            }
            return new Clause(copy);
        }).filter(it -> it.collection.isPass(coll)).collect(Collectors.toList());
    }

    public Map<String, List<Clause>> getPolicies() {
        return this.policies;
    }

    static {
        ops.put(CollectionParams.CollectionAction.ADDREPLICA, () -> new AddReplicaSuggester());
        ops.put(CollectionParams.CollectionAction.MOVEREPLICA, () -> new MoveReplicaSuggester());
    }

    public static abstract class Suggester {
        protected final EnumMap<Hint, Object> hints = new EnumMap(Hint.class);
        Session session;
        SolrRequest operation;
        protected List<Clause.Violation> originalViolations = new ArrayList<Clause.Violation>();
        private boolean isInitialized = false;

        private void _init(Session session) {
            this.session = session.copy();
        }

        public Suggester hint(Hint hint, Object value) {
            if (hint == Hint.TARGET_NODE || hint == Hint.SRC_NODE) {
                ((Set)this.hints.computeIfAbsent(hint, h -> new HashSet())).add(value);
            } else {
                this.hints.put(hint, value);
            }
            return this;
        }

        abstract SolrRequest init();

        public SolrRequest getOperation() {
            if (!this.isInitialized) {
                String coll = (String)this.hints.get((Object)Hint.COLL);
                String shard = (String)this.hints.get((Object)Hint.SHARD);
                if (this.session.matrix.stream().noneMatch(row -> row.collectionVsShardVsReplicas.containsKey(coll))) {
                    this.session.addClausesForCollection(this.session.dataProvider, coll);
                    Collections.sort(this.session.expandedClauses);
                }
                if (coll != null) {
                    for (Row row2 : this.session.matrix) {
                        Map<String, List<ReplicaInfo>> shardInfo;
                        if (!row2.collectionVsShardVsReplicas.containsKey(coll)) {
                            row2.collectionVsShardVsReplicas.put(coll, new HashMap());
                        }
                        if (shard == null || (shardInfo = row2.collectionVsShardVsReplicas.get(coll)).containsKey(shard)) continue;
                        shardInfo.put(shard, new ArrayList());
                    }
                }
                this.session.applyRules();
                this.originalViolations.addAll(this.session.getViolations());
                this.operation = this.init();
                this.isInitialized = true;
            }
            return this.operation;
        }

        public Session getSession() {
            return this.session;
        }

        List<Row> getMatrix() {
            return this.session.matrix;
        }

        boolean isLessSerious(List<Clause.Violation> fresh, List<Clause.Violation> old) {
            if (old == null || fresh.size() < old.size()) {
                return true;
            }
            if (fresh.size() == old.size()) {
                for (int i = 0; i < fresh.size(); ++i) {
                    Clause.Violation freshViolation = fresh.get(i);
                    Clause.Violation oldViolation = null;
                    for (Clause.Violation v : old) {
                        if (!v.equals(freshViolation)) continue;
                        oldViolation = v;
                    }
                    if (oldViolation == null || !freshViolation.isLessSerious(oldViolation)) continue;
                    return true;
                }
            }
            return false;
        }

        boolean containsNewErrors(List<Clause.Violation> violations) {
            for (Clause.Violation v : violations) {
                int idx = this.originalViolations.indexOf(v);
                if (idx >= 0 && !this.originalViolations.get(idx).isLessSerious(v)) continue;
                return true;
            }
            return false;
        }

        List<Pair<ReplicaInfo, Row>> getValidReplicas(boolean sortDesc, boolean isSource, int until) {
            ArrayList<Pair<ReplicaInfo, Row>> allPossibleReplicas = new ArrayList<Pair<ReplicaInfo, Row>>();
            if (sortDesc) {
                if (until == -1) {
                    until = this.getMatrix().size();
                }
                for (int i = 0; i < until; ++i) {
                    this.addReplicaToList(this.getMatrix().get(i), isSource, allPossibleReplicas);
                }
            } else {
                if (until == -1) {
                    until = 0;
                }
                for (int i = this.getMatrix().size() - 1; i >= until; --i) {
                    this.addReplicaToList(this.getMatrix().get(i), isSource, allPossibleReplicas);
                }
            }
            return allPossibleReplicas;
        }

        void addReplicaToList(Row r, boolean isSource, List<Pair<ReplicaInfo, Row>> replicaList) {
            if (!this.isAllowed(r.node, isSource ? Hint.SRC_NODE : Hint.TARGET_NODE)) {
                return;
            }
            for (Map.Entry<String, Map<String, List<ReplicaInfo>>> e : r.collectionVsShardVsReplicas.entrySet()) {
                if (!this.isAllowed(e.getKey(), Hint.COLL)) continue;
                for (Map.Entry<String, List<ReplicaInfo>> shard : e.getValue().entrySet()) {
                    if (!this.isAllowed(e.getKey(), Hint.SHARD)) continue;
                    replicaList.add(new Pair<ReplicaInfo, Row>(shard.getValue().get(0), r));
                }
            }
        }

        protected List<Clause.Violation> testChangedMatrix(boolean strict, List<Row> rows) {
            ArrayList<Clause.Violation> errors = new ArrayList<Clause.Violation>();
            for (Clause clause : this.session.expandedClauses) {
                List<Clause.Violation> errs;
                if (!strict && !clause.strict || (errs = clause.test(rows)).isEmpty()) continue;
                errors.addAll(errs);
            }
            return errors;
        }

        ArrayList<Row> getModifiedMatrix(List<Row> matrix, Row tmpRow, int i) {
            ArrayList<Row> copy = new ArrayList<Row>(matrix);
            copy.set(i, tmpRow);
            return copy;
        }

        protected boolean isAllowed(Object v, Hint hint) {
            Object hintVal = this.hints.get((Object)hint);
            if (hint == Hint.TARGET_NODE || hint == Hint.SRC_NODE) {
                Set set = (Set)hintVal;
                return set == null || set.contains(v);
            }
            return hintVal == null || Objects.equals(v, hintVal);
        }

        public static enum Hint {
            COLL,
            SHARD,
            SRC_NODE,
            TARGET_NODE;

        }
    }

    public static class ReplicaInfo
    implements MapWriter {
        final String name;
        String core;
        String collection;
        String shard;
        Map<String, Object> variables;

        public ReplicaInfo(String name, String coll, String shard, Map<String, Object> vals) {
            this.name = name;
            this.variables = vals;
            this.collection = coll;
            this.shard = shard;
        }

        @Override
        public void writeMap(MapWriter.EntryWriter ew) throws IOException {
            ew.put(this.name, this.variables);
        }

        public String getCore() {
            return this.core;
        }

        public String getCollection() {
            return this.collection;
        }

        public String getShard() {
            return this.shard;
        }
    }

    static enum Sort {
        maximize(1),
        minimize(-1);

        final int sortval;

        private Sort(int i) {
            this.sortval = i;
        }

        static Sort get(Map<String, Object> m) {
            if (m.containsKey(maximize.name()) && m.containsKey(minimize.name())) {
                throw new RuntimeException("Cannot have both 'maximize' and 'minimize'");
            }
            if (m.containsKey(maximize.name())) {
                return maximize;
            }
            if (m.containsKey(minimize.name())) {
                return minimize;
            }
            throw new RuntimeException("must have either 'maximize' or 'minimize'");
        }
    }

    public static enum SortParam {
        freedisk(0, Integer.MAX_VALUE),
        cores(0, Integer.MAX_VALUE),
        heapUsage(0, Integer.MAX_VALUE),
        sysLoadAvg(0, 100);

        public final int min;
        public final int max;

        private SortParam(int min, int max) {
            this.min = min;
            this.max = max;
        }

        static SortParam get(String m) {
            for (SortParam p : SortParam.values()) {
                if (!p.name().equals(m)) continue;
                return p;
            }
            throw new RuntimeException(StrUtils.formatString("Invalid sort {0} Sort must be on one of these {1}", m, Arrays.asList(SortParam.values())));
        }
    }

    public class Session
    implements MapWriter {
        final List<String> nodes;
        final ClusterDataProvider dataProvider;
        final List<Row> matrix;
        Set<String> collections = new HashSet<String>();
        List<Clause> expandedClauses;
        List<Clause.Violation> violations = new ArrayList<Clause.Violation>();

        private Session(List<String> nodes, ClusterDataProvider dataProvider, List<Row> matrix, List<Clause> expandedClauses) {
            this.nodes = nodes;
            this.dataProvider = dataProvider;
            this.matrix = matrix;
            this.expandedClauses = expandedClauses;
        }

        Session(ClusterDataProvider dataProvider) {
            this.nodes = new ArrayList<String>(dataProvider.getNodes());
            this.dataProvider = dataProvider;
            for (String node : this.nodes) {
                this.collections.addAll(dataProvider.getReplicaInfo(node, Collections.emptyList()).keySet());
            }
            this.expandedClauses = Policy.this.clusterPolicy.stream().filter(clause -> !clause.isPerCollectiontag()).collect(Collectors.toList());
            for (String c : this.collections) {
                this.addClausesForCollection(dataProvider, c);
            }
            Collections.sort(this.expandedClauses);
            this.matrix = new ArrayList<Row>(this.nodes.size());
            for (String node : this.nodes) {
                this.matrix.add(new Row(node, Policy.this.params, dataProvider));
            }
            this.applyRules();
        }

        private void addClausesForCollection(ClusterDataProvider dataProvider, String c) {
            List<Clause> perCollPolicy;
            String p = dataProvider.getPolicyNameByCollection(c);
            if (p != null && (perCollPolicy = Policy.this.policies.get(p)) == null) {
                throw new RuntimeException(StrUtils.formatString("Policy for collection {0} is {1} . It does not exist", c, p));
            }
            this.expandedClauses.addAll(Policy.mergePolicies(c, Policy.this.policies.getOrDefault(p, Collections.emptyList()), Policy.this.clusterPolicy));
        }

        Session copy() {
            return new Session(this.nodes, this.dataProvider, this.getMatrixCopy(), this.expandedClauses);
        }

        List<Row> getMatrixCopy() {
            return this.matrix.stream().map(Row::copy).collect(Collectors.toList());
        }

        Policy getPolicy() {
            return Policy.this;
        }

        private void applyRules() {
            if (!Policy.this.clusterPreferences.isEmpty()) {
                ArrayList<Row> tmpMatrix = new ArrayList<Row>(this.matrix);
                for (Preference p : Policy.this.clusterPreferences) {
                    Collections.sort(tmpMatrix, (r1, r2) -> p.compare((Row)r1, (Row)r2, false));
                    p.setApproxVal(tmpMatrix);
                }
                Collections.sort(this.matrix, (r1, r2) -> {
                    int result = Policy.this.clusterPreferences.get(0).compare((Row)r1, (Row)r2, true);
                    if (result == 0) {
                        result = Policy.this.clusterPreferences.get(0).compare((Row)r1, (Row)r2, false);
                    }
                    return result;
                });
            }
            for (Clause clause : this.expandedClauses) {
                List<Clause.Violation> errs = clause.test(this.matrix);
                this.violations.addAll(errs);
            }
        }

        public List<Clause.Violation> getViolations() {
            return this.violations;
        }

        public Suggester getSuggester(CollectionParams.CollectionAction action) {
            Suggester op = (Suggester)((Supplier)ops.get((Object)action)).get();
            if (op == null) {
                throw new UnsupportedOperationException(action.toString() + "is not supported");
            }
            op._init(this);
            return op;
        }

        @Override
        public void writeMap(MapWriter.EntryWriter ew) throws IOException {
            for (int i = 0; i < this.matrix.size(); ++i) {
                Row row = this.matrix.get(i);
                ew.put(row.node, row);
            }
        }

        public String toString() {
            return Utils.toJSONString(this.toMap(new LinkedHashMap<String, Object>()));
        }

        public List<Row> getSorted() {
            return Collections.unmodifiableList(this.matrix);
        }
    }
}

