/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.solr.client.solrj.cloud.autoscaling.Operand;
import org.apache.solr.client.solrj.cloud.autoscaling.Policy;
import org.apache.solr.client.solrj.cloud.autoscaling.Row;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.cloud.rule.ImplicitSnitch;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;

public class Clause
implements MapWriter,
Comparable<Clause> {
    public Map<String, Object> original;
    public Condition collection;
    public Condition shard;
    public Condition replica;
    public Condition tag;
    public Condition globalTag;
    boolean strict = true;
    private static final Set<String> IGNORE_TAGS = new HashSet<String>(Arrays.asList("replica", "collection", "shard", "strict"));
    private static final Map<String, ValidateInfo> validatetypes = new HashMap<String, ValidateInfo>();

    public Clause(Map<String, Object> m) {
        this.original = m;
        this.strict = Boolean.parseBoolean(String.valueOf(m.getOrDefault("strict", "true")));
        Optional<String> globalTagName = m.keySet().stream().filter(Policy.GLOBAL_ONLY_TAGS::contains).findFirst();
        if (globalTagName.isPresent()) {
            this.globalTag = Clause.parse(globalTagName.get(), m);
            if (m.size() > 2) {
                throw new RuntimeException("Only one extra tag supported for the tag " + globalTagName.get() + " in " + Utils.toJSONString(m));
            }
            this.tag = Clause.parse(m.keySet().stream().filter(s -> !((String)globalTagName.get()).equals(s) && !IGNORE_TAGS.contains(s)).findFirst().get(), m);
        } else {
            this.collection = Clause.parse("collection", m);
            this.shard = Clause.parse("shard", m);
            if (m.get("replica") == null) {
                throw new RuntimeException(StrUtils.formatString("'replica' is required in {0}", Utils.toJSONString(m)));
            }
            this.replica = Clause.parse("replica", m);
            if (this.replica.op == Operand.WILDCARD) {
                throw new RuntimeException("replica val cannot be null" + Utils.toJSONString(m));
            }
            m.forEach((s, o) -> this.parseCondition((String)s, o));
        }
        if (this.tag == null) {
            throw new RuntimeException("Invalid op, must have one and only one tag other than collection, shard,replica " + Utils.toJSONString(m));
        }
    }

    public boolean doesOverride(Clause that) {
        return this.collection.equals(that.collection) && this.tag.name.equals(that.tag.name);
    }

    public boolean isPerCollectiontag() {
        return this.globalTag == null;
    }

    void parseCondition(String s, Object o) {
        if (IGNORE_TAGS.contains(s)) {
            return;
        }
        if (this.tag != null) {
            throw new IllegalArgumentException("Only one tag other than collection, shard, replica is possible");
        }
        this.tag = Clause.parse(s, Collections.singletonMap(s, o));
    }

    @Override
    public int compareTo(Clause that) {
        int v = Integer.compare(this.tag.op.priority, that.tag.op.priority);
        if (v != 0) {
            return v;
        }
        if (this.isPerCollectiontag() && that.isPerCollectiontag()) {
            v = Integer.compare(this.replica.op.priority, that.replica.op.priority);
            if (v == 0) {
                v = Long.compare((Long)this.replica.val, (Long)that.replica.val);
                v = this.replica.op == Operand.LESS_THAN ? v : v * -1;
            }
            return v;
        }
        return 0;
    }

    void addTags(List<String> params) {
        if (this.globalTag != null && !params.contains(this.globalTag.name)) {
            params.add(this.globalTag.name);
        }
        if (this.tag != null && !params.contains(this.tag.name)) {
            params.add(this.tag.name);
        }
    }

    static Condition parse(String s, Map m) {
        Object expectedVal = null;
        Object val = m.get(s);
        try {
            String conditionName = s.trim();
            Operand operand = null;
            if (val == null) {
                operand = Operand.WILDCARD;
                expectedVal = "#ANY";
            } else if (val instanceof String) {
                String strVal = ((String)val).trim();
                operand = "#ANY".equals(strVal) || "#EACH".equals(strVal) ? Operand.WILDCARD : (strVal.startsWith(Operand.NOT_EQUAL.operand) ? Operand.NOT_EQUAL : (strVal.startsWith(Operand.GREATER_THAN.operand) ? Operand.GREATER_THAN : (strVal.startsWith(Operand.LESS_THAN.operand) ? Operand.LESS_THAN : Operand.EQUAL)));
                expectedVal = Clause.validate(s, strVal.substring(Operand.EQUAL == operand || Operand.WILDCARD == operand ? 0 : 1), true);
            } else if (val instanceof Number) {
                operand = Operand.EQUAL;
                expectedVal = Clause.validate(s, val, true);
            }
            return new Condition(conditionName, expectedVal, operand);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid tag : " + s + ":" + val, e);
        }
    }

    public List<Violation> test(List<Row> allRows) {
        ArrayList<Violation> violations = new ArrayList<Violation>();
        if (this.isPerCollectiontag()) {
            Map<String, Map<String, Map<String, AtomicInteger>>> replicaCount = this.computeReplicaCounts(allRows);
            for (Map.Entry<String, Map<String, Map<String, AtomicInteger>>> e : replicaCount.entrySet()) {
                if (!this.collection.isPass(e.getKey())) continue;
                for (Map.Entry<String, Map<String, AtomicInteger>> shardVsCount : e.getValue().entrySet()) {
                    if (!this.shard.isPass(shardVsCount.getKey())) continue;
                    for (Map.Entry<String, AtomicInteger> counts : shardVsCount.getValue().entrySet()) {
                        if (this.replica.isPass(counts.getValue())) continue;
                        violations.add(new Violation(e.getKey(), shardVsCount.getKey(), this.tag.name.equals("node") ? counts.getKey() : null, counts.getValue(), this.replica.delta(counts.getValue()), counts.getKey()));
                    }
                }
            }
        } else {
            for (Row r : allRows) {
                if (this.tag.isPass(r)) continue;
                violations.add(new Violation(null, null, r.node, r.getVal(this.tag.name), this.tag.delta(r.getVal(this.tag.name)), null));
            }
        }
        return violations;
    }

    private Map<String, Map<String, Map<String, AtomicInteger>>> computeReplicaCounts(List<Row> allRows) {
        HashMap<String, Map<String, Map<String, AtomicInteger>>> collVsShardVsTagVsCount = new HashMap<String, Map<String, Map<String, AtomicInteger>>>();
        for (Row row : allRows) {
            block1: for (Map.Entry<String, Map<String, List<Policy.ReplicaInfo>>> colls : row.collectionVsShardVsReplicas.entrySet()) {
                String collectionName = colls.getKey();
                if (!this.collection.isPass(collectionName)) continue;
                collVsShardVsTagVsCount.putIfAbsent(collectionName, new HashMap());
                Map collMap = (Map)collVsShardVsTagVsCount.get(collectionName);
                for (Map.Entry<String, List<Policy.ReplicaInfo>> shards : colls.getValue().entrySet()) {
                    String shardName = shards.getKey();
                    if ("#ANY".equals(this.shard.val)) {
                        shardName = "#ANY";
                    }
                    if (!this.shard.isPass(shardName)) continue block1;
                    collMap.putIfAbsent(shardName, new HashMap());
                    Map tagVsCount = (Map)collMap.get(shardName);
                    Object tagVal = row.getVal(this.tag.name);
                    tagVsCount.putIfAbsent(this.tag.isPass(tagVal) ? String.valueOf(tagVal) : "", new AtomicInteger());
                    if (!this.tag.isPass(tagVal)) continue;
                    ((AtomicInteger)tagVsCount.get(String.valueOf(tagVal))).addAndGet(shards.getValue().size());
                }
            }
        }
        return collVsShardVsTagVsCount;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public String toString() {
        return Utils.toJSONString(this.original);
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        for (Map.Entry<String, Object> e : this.original.entrySet()) {
            ew.put(e.getKey(), e.getValue());
        }
    }

    public static Object validate(String name, Object val, boolean isRuleVal) {
        if (val == null) {
            return null;
        }
        ValidateInfo info = validatetypes.get(name);
        if (info == null && name.startsWith("sysprop.")) {
            info = validatetypes.get("STRING");
        }
        if (info == null) {
            throw new RuntimeException("Unknown type :" + name);
        }
        if (info.type == Double.class) {
            Double num = Clause.parseDouble(name, val);
            if (isRuleVal) {
                if (info.min != null && Double.compare(num, (Double)info.min) == -1) {
                    throw new RuntimeException(name + ": " + val + " must be greater than " + info.min);
                }
                if (info.max != null && Double.compare(num, (Double)info.max) == 1) {
                    throw new RuntimeException(name + ": " + val + " must be less than " + info.max);
                }
            }
            return num;
        }
        if (info.type == Long.class) {
            Long num = Clause.parseLong(name, val);
            if (isRuleVal) {
                if (info.min != null && num < info.min.longValue()) {
                    throw new RuntimeException(name + ": " + val + " must be greater than " + info.min);
                }
                if (info.max != null && num > info.max.longValue()) {
                    throw new RuntimeException(name + ": " + val + " must be less than " + info.max);
                }
            }
            return num;
        }
        if (info.type == String.class) {
            if (isRuleVal && info.vals != null && !info.vals.contains(val)) {
                throw new RuntimeException(name + ": " + val + " must be one of " + StrUtils.join(info.vals, ','));
            }
            return val;
        }
        throw new RuntimeException("Invalid type ");
    }

    public static Long parseLong(String name, Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Long) {
            return (Long)val;
        }
        Number num = null;
        if (val instanceof String) {
            try {
                num = Long.parseLong(((String)val).trim());
            }
            catch (NumberFormatException e) {
                try {
                    num = Double.parseDouble((String)val);
                }
                catch (NumberFormatException e1) {
                    throw new RuntimeException(name + ": " + val + "not a valid number", e);
                }
            }
        } else if (val instanceof Number) {
            num = (Number)val;
        }
        if (num != null) {
            return num.longValue();
        }
        throw new RuntimeException(name + ": " + val + "not a valid number");
    }

    public static Double parseDouble(String name, Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Double) {
            return (Double)val;
        }
        Number num = null;
        if (val instanceof String) {
            try {
                num = Double.parseDouble((String)val);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException(name + ": " + val + "not a valid number", e);
            }
        } else if (val instanceof Number) {
            num = (Number)val;
        }
        if (num != null) {
            return num.doubleValue();
        }
        throw new RuntimeException(name + ": " + val + "not a valid number");
    }

    static {
        validatetypes.put("collection", new ValidateInfo(String.class, null, null, null));
        validatetypes.put("shard", new ValidateInfo(String.class, null, null, null));
        validatetypes.put("replica", new ValidateInfo(Long.class, null, 0L, null));
        validatetypes.put("port", new ValidateInfo(Long.class, null, 1L, 65535L));
        validatetypes.put("freedisk", new ValidateInfo(Double.class, null, 0.0, Double.MAX_VALUE));
        validatetypes.put("nodeRole", new ValidateInfo(String.class, Collections.singleton("overseer"), null, null));
        validatetypes.put("cores", new ValidateInfo(Long.class, null, 0L, Long.MAX_VALUE));
        validatetypes.put("sysLoadAvg", new ValidateInfo(Double.class, null, 0.0, 100.0));
        validatetypes.put("heapUsage", new ValidateInfo(Double.class, null, 0.0, null));
        validatetypes.put("NUMBER", new ValidateInfo(Long.class, null, 0L, Long.MAX_VALUE));
        validatetypes.put("STRING", new ValidateInfo(String.class, null, null, null));
        validatetypes.put("node", new ValidateInfo(String.class, null, null, null));
        for (String ip : ImplicitSnitch.IP_SNITCHES) {
            validatetypes.put(ip, new ValidateInfo(Long.class, null, 0L, 255L));
        }
    }

    static class ValidateInfo {
        final Class type;
        final Set<String> vals;
        final Number min;
        final Number max;

        ValidateInfo(Class type, Set<String> vals, Number min, Number max) {
            this.type = type;
            this.vals = vals;
            this.min = min;
            if (min != null && !type.isInstance(min)) {
                throw new RuntimeException("wrong min value type, expected: " + type.getName() + " actual: " + min.getClass().getName());
            }
            this.max = max;
            if (max != null && !type.isInstance(max)) {
                throw new RuntimeException("wrong max value type, expected: " + type.getName() + " actual: " + max.getClass().getName());
            }
        }
    }

    static enum TestStatus {
        NOT_APPLICABLE,
        FAIL,
        PASS;

    }

    public class Violation
    implements MapWriter {
        final String shard;
        final String coll;
        final String node;
        final Object actualVal;
        final Integer delta;
        final Object tagKey;
        private final int hash;

        private Violation(String coll, String shard, String node, Object actualVal, Integer delta, Object tagKey) {
            this.shard = shard;
            this.coll = coll;
            this.node = node;
            this.delta = delta;
            this.actualVal = actualVal;
            this.tagKey = tagKey;
            this.hash = ("" + coll + " " + shard + " " + node + " " + String.valueOf(tagKey) + " " + Utils.toJSONString(this.getClause().toMap(new HashMap<String, Object>()))).hashCode();
        }

        public Clause getClause() {
            return Clause.this;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean isLessSerious(Violation that) {
            return that.delta != null && this.delta != null && Math.abs(this.delta) < Math.abs(that.delta);
        }

        public boolean equals(Object that) {
            if (that instanceof Violation) {
                Violation v = (Violation)that;
                return Objects.equals(this.shard, v.shard) && Objects.equals(this.coll, v.coll) && Objects.equals(this.node, v.node) && Objects.equals(this.tagKey, v.tagKey);
            }
            return false;
        }

        @Override
        public void writeMap(MapWriter.EntryWriter ew) throws IOException {
            ew.putIfNotNull("collection", this.coll);
            ew.putIfNotNull("shard", this.shard);
            ew.putIfNotNull("node", this.node);
            ew.putIfNotNull("tagKey", String.valueOf(this.tagKey));
            ew.putIfNotNull("violation", ew1 -> {
                ew1.put(this.getClause().isPerCollectiontag() ? "replica" : Clause.this.tag.name, String.valueOf(this.actualVal));
                ew1.putIfNotNull("delta", this.delta);
            });
            ew.put("clause", this.getClause());
        }
    }

    public static class Condition {
        final String name;
        final Object val;
        final Operand op;

        Condition(String name, Object val, Operand op) {
            this.name = name;
            this.val = val;
            this.op = op;
        }

        TestStatus match(Row row) {
            return this.op.match(this.val, row.getVal(this.name));
        }

        TestStatus match(Object testVal) {
            return this.op.match(this.val, testVal);
        }

        public boolean isPass(Object inputVal) {
            return this.op.match(this.val, Clause.validate(this.name, inputVal, false)) == TestStatus.PASS;
        }

        public boolean isPass(Row row) {
            return this.op.match(this.val, row.getVal(this.name)) == TestStatus.PASS;
        }

        public boolean equals(Object that) {
            if (that instanceof Condition) {
                Condition c = (Condition)that;
                return Objects.equals(c.name, this.name) && Objects.equals(c.val, this.val) && c.op == this.op;
            }
            return false;
        }

        public Integer delta(Object val) {
            return this.op.delta(this.val, val);
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.val;
        }

        public Operand getOperand() {
            return this.op;
        }
    }
}

