/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.util.List;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.cloud.autoscaling.Clause;
import org.apache.solr.client.solrj.cloud.autoscaling.Policy;
import org.apache.solr.client.solrj.cloud.autoscaling.Row;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;

class AddReplicaSuggester
extends Policy.Suggester {
    AddReplicaSuggester() {
    }

    @Override
    SolrRequest init() {
        SolrRequest operation = this.tryEachNode(true);
        if (operation == null) {
            operation = this.tryEachNode(false);
        }
        return operation;
    }

    SolrRequest tryEachNode(boolean strict) {
        String coll = (String)this.hints.get((Object)Policy.Suggester.Hint.COLL);
        String shard = (String)this.hints.get((Object)Policy.Suggester.Hint.SHARD);
        if (coll == null || shard == null) {
            throw new RuntimeException("add-replica requires 'collection' and 'shard'");
        }
        List<Clause.Violation> leastSeriousViolation = null;
        Integer targetNodeIndex = null;
        for (int i = this.getMatrix().size() - 1; i >= 0; --i) {
            Row row = this.getMatrix().get(i);
            if (!this.isAllowed(row.node, Policy.Suggester.Hint.TARGET_NODE)) continue;
            Row tmpRow = row.addReplica(coll, shard);
            tmpRow.violations.clear();
            List<Clause.Violation> errs = this.testChangedMatrix(strict, this.getModifiedMatrix(this.getMatrix(), tmpRow, i));
            if (this.containsNewErrors(errs) || !this.isLessSerious(errs, leastSeriousViolation)) continue;
            leastSeriousViolation = errs;
            targetNodeIndex = i;
        }
        if (targetNodeIndex != null) {
            this.getMatrix().set(targetNodeIndex, this.getMatrix().get(targetNodeIndex).addReplica(coll, shard));
            return CollectionAdminRequest.addReplicaToShard(coll, shard).setNode(this.getMatrix().get((int)targetNodeIndex.intValue()).node);
        }
        return null;
    }
}

