/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream.metrics;

import java.io.IOException;
import java.io.Serializable;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.client.solrj.io.stream.metrics.Metric;

public class MaxMetric
extends Metric
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String MAX = "max";
    private long longMax = Long.MIN_VALUE;
    private double doubleMax = -1.7976931348623157E308;
    private String columnName;

    public MaxMetric(String columnName) {
        this.init(MAX, columnName);
    }

    public MaxMetric(StreamExpression expression, StreamFactory factory) throws IOException {
        String functionName = expression.getFunctionName();
        String columnName = factory.getValueOperand(expression, 0);
        if (null == columnName) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expected %s(columnName)", expression, functionName));
        }
        if (1 != expression.getParameters().size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - unknown operands found", expression));
        }
        this.init(functionName, columnName);
    }

    private void init(String functionName, String columnName) {
        this.columnName = columnName;
        this.setFunctionName(functionName);
        this.setIdentifier(functionName, "(", columnName, ")");
    }

    @Override
    public double getValue() {
        if (this.longMax == Long.MIN_VALUE) {
            return this.doubleMax;
        }
        return this.longMax;
    }

    @Override
    public void update(Tuple tuple) {
        Object o = tuple.get(this.columnName);
        if (o instanceof Double) {
            double d = (Double)o;
            if (d > this.doubleMax) {
                this.doubleMax = d;
            }
        } else {
            long l = (Long)o;
            if (l > this.longMax) {
                this.longMax = l;
            }
        }
    }

    @Override
    public Metric newInstance() {
        return new MaxMetric(this.columnName);
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        return new StreamExpression(this.getFunctionName()).withParameter(this.columnName);
    }
}

