/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream.metrics;

import java.io.IOException;
import java.io.Serializable;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.client.solrj.io.stream.metrics.Metric;

public class CountMetric
extends Metric
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long count;

    public CountMetric() {
        this.init("count");
    }

    public CountMetric(StreamExpression expression, StreamFactory factory) throws IOException {
        String functionName = expression.getFunctionName();
        String columnName = factory.getValueOperand(expression, 0);
        if (!"*".equals(columnName)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expected %s(*)", expression, functionName));
        }
        if (1 != expression.getParameters().size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - unknown operands found", expression));
        }
        this.init(functionName);
    }

    private void init(String functionName) {
        this.setFunctionName(functionName);
        this.setIdentifier(functionName, "(*)");
    }

    @Override
    public void update(Tuple tuple) {
        ++this.count;
    }

    @Override
    public double getValue() {
        return this.count;
    }

    @Override
    public Metric newInstance() {
        return new CountMetric();
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        return new StreamExpression(this.getFunctionName()).withParameter("*");
    }
}

