/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.io.SolrClientCache;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.JSONTupleStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrStream
extends TupleStream {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final long serialVersionUID = 1L;
    private String baseUrl;
    private Map params;
    private int numWorkers;
    private int workerID;
    private boolean trace;
    private Map<String, String> fieldMappings;
    private transient JSONTupleStream jsonTupleStream;
    private transient HttpSolrClient client;
    private transient SolrClientCache cache;
    private String slice;
    private long checkpoint = -1L;

    public SolrStream(String baseUrl, Map params) {
        this.baseUrl = baseUrl;
        this.params = params;
    }

    public void setFieldMappings(Map<String, String> fieldMappings) {
        this.fieldMappings = fieldMappings;
    }

    @Override
    public List<TupleStream> children() {
        return new ArrayList<TupleStream>();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.numWorkers = context.numWorkers;
        this.workerID = context.workerID;
        this.cache = context.getSolrClientCache();
    }

    @Override
    public void open() throws IOException {
        this.client = this.cache == null ? new HttpSolrClient(this.baseUrl) : this.cache.getHttpSolrClient(this.baseUrl);
        try {
            this.jsonTupleStream = JSONTupleStream.create(this.client, this.loadParams(this.params));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public void setSlice(String slice) {
        this.slice = slice;
    }

    public void setCheckpoint(long checkpoint) {
        this.checkpoint = checkpoint;
    }

    private SolrParams loadParams(Map params) throws IOException {
        ModifiableSolrParams solrParams = new ModifiableSolrParams();
        if (params.containsKey("partitionKeys")) {
            if (!params.get("partitionKeys").equals("none")) {
                String partitionFilter = this.getPartitionFilter();
                solrParams.add("fq", partitionFilter);
            }
        } else if (this.numWorkers > 1) {
            throw new IOException("When numWorkers > 1 partitionKeys must be set. Set partitionKeys=none to send the entire stream to each worker.");
        }
        if (this.checkpoint > 0L) {
            solrParams.add("fq", "{!frange cost=100 incl=false l=" + this.checkpoint + "}_version_");
        }
        for (Map.Entry entry : params.entrySet()) {
            solrParams.add((String)entry.getKey(), entry.getValue().toString());
        }
        return solrParams;
    }

    private String getPartitionFilter() {
        StringBuilder buf = new StringBuilder("{!hash workers=");
        buf.append(this.numWorkers);
        buf.append(" worker=");
        buf.append(this.workerID);
        buf.append("}");
        return buf.toString();
    }

    @Override
    public void close() throws IOException {
        if (this.jsonTupleStream != null) {
            this.jsonTupleStream.close();
        }
        if (this.cache == null) {
            this.client.close();
        }
    }

    @Override
    public Tuple read() throws IOException {
        try {
            Map fields = this.jsonTupleStream.next();
            if (fields == null) {
                HashMap<String, Boolean> m = new HashMap<String, Boolean>();
                m.put("EOF", true);
                return new Tuple(m);
            }
            String msg = (String)fields.get("EXCEPTION");
            if (msg != null) {
                HandledException ioException = new HandledException(msg);
                throw ioException;
            }
            if (this.trace) {
                fields.put((String)"_CORE_", (Object)this.baseUrl);
                if (this.slice != null) {
                    fields.put("_SLICE_", this.slice);
                }
            }
            if (this.fieldMappings != null) {
                fields = this.mapFields(fields, this.fieldMappings);
            }
            return new Tuple(fields);
        }
        catch (HandledException e) {
            throw new IOException("--> " + this.baseUrl + ":" + e.getMessage());
        }
        catch (Exception e) {
            throw new IOException("--> " + this.baseUrl + ": An exception has occurred on the server, refer to server log for details.");
        }
    }

    @Override
    public StreamComparator getStreamSort() {
        return null;
    }

    private Map mapFields(Map fields, Map<String, String> mappings) {
        for (Map.Entry<String, String> entry : mappings.entrySet()) {
            String mapFrom = entry.getKey();
            String mapTo = entry.getValue();
            Object o = fields.get(mapFrom);
            fields.remove(mapFrom);
            fields.put(mapTo, o);
        }
        return fields;
    }

    public static class HandledException
    extends IOException {
        public HandledException(String msg) {
            super(msg);
        }
    }
}

