/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.io.SolrClientCache;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.ComparatorOrder;
import org.apache.solr.client.solrj.io.comp.FieldComparator;
import org.apache.solr.client.solrj.io.comp.MultipleFieldComparator;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.client.solrj.io.stream.metrics.Bucket;
import org.apache.solr.client.solrj.io.stream.metrics.Metric;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;

public class FacetStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    private Bucket[] buckets;
    private Metric[] metrics;
    private int bucketSizeLimit;
    private FieldComparator[] bucketSorts;
    private List<Tuple> tuples = new ArrayList<Tuple>();
    private int index;
    private String zkHost;
    private Map<String, String> props;
    private String collection;
    protected transient SolrClientCache cache;
    protected transient CloudSolrClient cloudSolrClient;

    public FacetStream(String zkHost, String collection, Map<String, String> props, Bucket[] buckets, Metric[] metrics, FieldComparator[] bucketSorts, int bucketSizeLimit) throws IOException {
        this.init(collection, props, buckets, bucketSorts, metrics, bucketSizeLimit, zkHost);
    }

    public FacetStream(StreamExpression expression, StreamFactory factory) throws IOException {
        String[] keys;
        String collectionName = factory.getValueOperand(expression, 0);
        List<StreamExpressionNamedParameter> namedParams = factory.getNamedOperands(expression);
        StreamExpressionNamedParameter bucketExpression = factory.getNamedOperand(expression, "buckets");
        StreamExpressionNamedParameter bucketSortExpression = factory.getNamedOperand(expression, "bucketSorts");
        List<StreamExpression> metricExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, Metric.class);
        StreamExpressionNamedParameter limitExpression = factory.getNamedOperand(expression, "bucketSizeLimit");
        StreamExpressionNamedParameter zkHostExpression = factory.getNamedOperand(expression, "zkHost");
        if (expression.getParameters().size() != 1 + namedParams.size() + metricExpressions.size()) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - unknown operands found", expression));
        }
        if (null == collectionName) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - collectionName expected as first operand", expression));
        }
        if (0 == namedParams.size()) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - at least one named parameter expected. eg. 'q=*:*'", expression));
        }
        HashMap<String, String> params = new HashMap<String, String>();
        for (StreamExpressionNamedParameter namedParam : namedParams) {
            if (namedParam.getName().equals("zkHost") || namedParam.getName().equals("buckets") || namedParam.getName().equals("bucketSorts") || namedParam.getName().equals("limit")) continue;
            params.put(namedParam.getName(), namedParam.getParameter().toString().trim());
        }
        Bucket[] buckets = null;
        if (null != bucketExpression && bucketExpression.getParameter() instanceof StreamExpressionValue && 0 != (keys = ((StreamExpressionValue)bucketExpression.getParameter()).getValue().split(",")).length) {
            buckets = new Bucket[keys.length];
            for (int idx = 0; idx < keys.length; ++idx) {
                buckets[idx] = new Bucket(keys[idx].trim());
            }
        }
        if (null == buckets) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - at least one bucket expected. eg. 'buckets=\"name\"'", expression, collectionName));
        }
        FieldComparator[] bucketSorts = null;
        if (null != bucketSortExpression && bucketSortExpression.getParameter() instanceof StreamExpressionValue) {
            bucketSorts = this.parseBucketSorts(((StreamExpressionValue)bucketSortExpression.getParameter()).getValue());
        }
        if (null == bucketSorts || 0 == bucketSorts.length) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - at least one bucket sort expected. eg. 'bucketSorts=\"name asc\"'", expression, collectionName));
        }
        Metric[] metrics = new Metric[metricExpressions.size()];
        for (int idx = 0; idx < metricExpressions.size(); ++idx) {
            metrics[idx] = factory.constructMetric(metricExpressions.get(idx));
        }
        if (0 == metrics.length) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - at least one metric expected.", expression, collectionName));
        }
        if (null == limitExpression || null == limitExpression.getParameter() || !(limitExpression.getParameter() instanceof StreamExpressionValue)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting a single 'limit' parameter of type positive integer but didn't find one", expression));
        }
        String limitStr = ((StreamExpressionValue)limitExpression.getParameter()).getValue();
        int limitInt = 0;
        try {
            limitInt = Integer.parseInt(limitStr);
            if (limitInt <= 0) {
                throw new IOException(String.format(Locale.ROOT, "invalid expression %s - limit '%s' must be greater than 0.", expression, limitStr));
            }
        }
        catch (NumberFormatException e) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - limit '%s' is not a valid integer.", expression, limitStr));
        }
        String zkHost = null;
        if (null == zkHostExpression) {
            zkHost = factory.getCollectionZkHost(collectionName);
            if (zkHost == null) {
                zkHost = factory.getDefaultZkHost();
            }
        } else if (zkHostExpression.getParameter() instanceof StreamExpressionValue) {
            zkHost = ((StreamExpressionValue)zkHostExpression.getParameter()).getValue();
        }
        if (null == zkHost) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - zkHost not found for collection '%s'", expression, collectionName));
        }
        this.init(collectionName, params, buckets, bucketSorts, metrics, limitInt, zkHost);
    }

    private FieldComparator[] parseBucketSorts(String bucketSortString) throws IOException {
        String[] sorts = bucketSortString.split(",");
        FieldComparator[] comps = new FieldComparator[sorts.length];
        for (int i = 0; i < sorts.length; ++i) {
            String s = sorts[i];
            String[] spec = s.trim().split("\\s+");
            if (2 != spec.length) {
                throw new IOException(String.format(Locale.ROOT, "invalid expression - bad bucketSort '%s'. Expected form 'field order'", bucketSortString));
            }
            String fieldName = spec[0].trim();
            String order = spec[1].trim();
            comps[i] = new FieldComparator(fieldName, order.equalsIgnoreCase("asc") ? ComparatorOrder.ASCENDING : ComparatorOrder.DESCENDING);
        }
        return comps;
    }

    private void init(String collection, Map<String, String> props, Bucket[] buckets, FieldComparator[] bucketSorts, Metric[] metrics, int bucketSizeLimit, String zkHost) throws IOException {
        this.zkHost = zkHost;
        this.props = props;
        this.buckets = buckets;
        this.metrics = metrics;
        this.bucketSizeLimit = bucketSizeLimit;
        this.collection = collection;
        this.bucketSorts = bucketSorts;
        for (FieldComparator sort : bucketSorts) {
            if (!sort.hasDifferentFieldNames()) continue;
            throw new IOException("Invalid FacetStream - all sorts must be constructed with a single field name.");
        }
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        expression.addParameter(this.collection);
        for (Map.Entry<String, String> param : this.props.entrySet()) {
            expression.addParameter(new StreamExpressionNamedParameter(param.getKey(), param.getValue()));
        }
        StringBuilder builder = new StringBuilder();
        for (Bucket bucket : this.buckets) {
            if (0 != builder.length()) {
                builder.append(",");
            }
            builder.append(bucket.toString());
        }
        expression.addParameter(new StreamExpressionNamedParameter("buckets", builder.toString()));
        builder = new StringBuilder();
        Serializable[] serializableArray = this.bucketSorts;
        int n = serializableArray.length;
        for (int i = 0; i < n; ++i) {
            Serializable sort = serializableArray[i];
            if (0 != builder.length()) {
                builder.append(",");
            }
            builder.append(((FieldComparator)sort).toExpression(factory));
        }
        expression.addParameter(new StreamExpressionNamedParameter("bucketSorts", builder.toString()));
        for (Metric metric : this.metrics) {
            expression.addParameter(metric.toExpression(factory));
        }
        expression.addParameter(new StreamExpressionNamedParameter("bucketSizeLimit", Integer.toString(this.bucketSizeLimit)));
        expression.addParameter(new StreamExpressionNamedParameter("zkHost", this.zkHost));
        return expression;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.cache = context.getSolrClientCache();
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        return l;
    }

    @Override
    public void open() throws IOException {
        this.cloudSolrClient = this.cache != null ? this.cache.getCloudSolrClient(this.zkHost) : new CloudSolrClient(this.zkHost);
        FieldComparator[] adjustedSorts = this.adjustSorts(this.buckets, this.bucketSorts);
        String json = this.getJsonFacetString(this.buckets, this.metrics, adjustedSorts, this.bucketSizeLimit);
        ModifiableSolrParams params = this.getParams(this.props);
        params.add("json.facet", json);
        params.add("rows", "0");
        QueryRequest request = new QueryRequest(params);
        try {
            NamedList<Object> response = this.cloudSolrClient.request(request, this.collection);
            this.getTuples(response, this.buckets, this.metrics);
            Collections.sort(this.tuples, this.getStreamSort());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.cache == null) {
            this.cloudSolrClient.close();
        }
    }

    @Override
    public Tuple read() throws IOException {
        if (this.index < this.tuples.size() && this.index < this.bucketSizeLimit) {
            Tuple tuple = this.tuples.get(this.index);
            ++this.index;
            return tuple;
        }
        HashMap<String, Boolean> fields = new HashMap<String, Boolean>();
        fields.put("EOF", true);
        Tuple tuple = new Tuple(fields);
        return tuple;
    }

    private ModifiableSolrParams getParams(Map<String, String> props) {
        ModifiableSolrParams params = new ModifiableSolrParams();
        for (String key : props.keySet()) {
            String value = props.get(key);
            params.add(key, value);
        }
        return params;
    }

    private String getJsonFacetString(Bucket[] _buckets, Metric[] _metrics, FieldComparator[] _sorts, int _limit) {
        StringBuilder buf = new StringBuilder();
        this.appendJson(buf, _buckets, _metrics, _sorts, _limit, 0);
        return "{" + buf.toString() + "}";
    }

    private FieldComparator[] adjustSorts(Bucket[] _buckets, FieldComparator[] _sorts) throws IOException {
        if (_buckets.length == _sorts.length) {
            return _sorts;
        }
        if (_sorts.length == 1) {
            FieldComparator[] adjustedSorts = new FieldComparator[_buckets.length];
            if (_sorts[0].getLeftFieldName().contains("(")) {
                for (int i = 0; i < adjustedSorts.length; ++i) {
                    adjustedSorts[i] = _sorts[0];
                }
            } else {
                for (int i = 0; i < adjustedSorts.length; ++i) {
                    adjustedSorts[i] = new FieldComparator(_buckets[i].toString(), _sorts[0].getOrder());
                }
            }
            return adjustedSorts;
        }
        throw new IOException("If multiple sorts are specified there must be a sort for each bucket.");
    }

    private void appendJson(StringBuilder buf, Bucket[] _buckets, Metric[] _metrics, FieldComparator[] _sorts, int _limit, int level) {
        buf.append('\"');
        buf.append(_buckets[level].toString());
        buf.append('\"');
        buf.append(":{");
        buf.append("\"type\":\"terms\"");
        buf.append(",\"field\":\"" + _buckets[level].toString() + "\"");
        buf.append(",\"limit\":" + _limit);
        buf.append(",\"sort\":{\"" + this.getFacetSort(_sorts[level].getLeftFieldName(), _metrics) + "\":\"" + (Object)((Object)_sorts[level].getOrder()) + "\"}");
        buf.append(",\"facet\":{");
        int metricCount = 0;
        for (Metric metric : _metrics) {
            String identifier = metric.getIdentifier();
            if (identifier.startsWith("count(")) continue;
            if (metricCount > 0) {
                buf.append(",");
            }
            buf.append("\"facet_" + metricCount + "\":\"" + identifier + "\"");
            ++metricCount;
        }
        if (++level < _buckets.length) {
            if (metricCount > 0) {
                buf.append(",");
            }
            this.appendJson(buf, _buckets, _metrics, _sorts, _limit, level);
        }
        buf.append("}}");
    }

    private String getFacetSort(String id, Metric[] _metrics) {
        int index = 0;
        for (Metric metric : _metrics) {
            if (metric.getIdentifier().startsWith("count(")) {
                if (!id.startsWith("count(")) continue;
                return "count";
            }
            if (id.equals(_metrics[index].getIdentifier())) {
                return "facet_" + index;
            }
            ++index;
        }
        return "index";
    }

    private void getTuples(NamedList response, Bucket[] buckets, Metric[] metrics) {
        Tuple tuple = new Tuple(new HashMap());
        NamedList facets = (NamedList)response.get("facets");
        this.fillTuples(0, this.tuples, tuple, facets, buckets, metrics);
    }

    private void fillTuples(int level, List<Tuple> tuples, Tuple currentTuple, NamedList facets, Bucket[] _buckets, Metric[] _metrics) {
        String bucketName = _buckets[level].toString();
        NamedList nl = (NamedList)facets.get(bucketName);
        List allBuckets = (List)nl.get("buckets");
        for (int b = 0; b < allBuckets.size(); ++b) {
            NamedList bucket = (NamedList)allBuckets.get(b);
            Object val = bucket.get("val");
            Tuple t = currentTuple.clone();
            t.put(bucketName, val);
            int nextLevel = level + 1;
            if (nextLevel < _buckets.length) {
                this.fillTuples(nextLevel, tuples, t.clone(), bucket, _buckets, _metrics);
                continue;
            }
            int m = 0;
            for (Metric metric : _metrics) {
                String identifier = metric.getIdentifier();
                if (!identifier.startsWith("count(")) {
                    double d = (Double)bucket.get("facet_" + m);
                    t.put(identifier, d);
                    ++m;
                    continue;
                }
                long l = (Long)bucket.get("count");
                t.put("count(*)", l);
            }
            tuples.add(t);
        }
    }

    @Override
    public int getCost() {
        return 0;
    }

    @Override
    public StreamComparator getStreamSort() {
        if (this.bucketSorts.length > 1) {
            return new MultipleFieldComparator(this.bucketSorts);
        }
        return this.bucketSorts[0];
    }
}

