/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.store.blockcache;

import com.codahale.metrics.MetricRegistry;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.metrics.MetricsMap;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricProducer;
import org.apache.solr.search.SolrCacheBase;

public class Metrics
extends SolrCacheBase
implements SolrInfoBean,
SolrMetricProducer {
    public AtomicLong blockCacheSize = new AtomicLong(0L);
    public AtomicLong blockCacheHit = new AtomicLong(0L);
    public AtomicLong blockCacheMiss = new AtomicLong(0L);
    public AtomicLong blockCacheEviction = new AtomicLong(0L);
    public AtomicLong blockCacheStoreFail = new AtomicLong(0L);
    private AtomicLong blockCacheHit_last = new AtomicLong(0L);
    private AtomicLong blockCacheMiss_last = new AtomicLong(0L);
    private AtomicLong blockCacheEviction_last = new AtomicLong(0L);
    public AtomicLong blockCacheStoreFail_last = new AtomicLong(0L);
    public AtomicLong shardBuffercacheAllocate = new AtomicLong(0L);
    public AtomicLong shardBuffercacheLost = new AtomicLong(0L);
    private MetricsMap metricsMap;
    private MetricRegistry registry;
    private Set<String> metricNames = new HashSet<String>();
    private long previous = System.nanoTime();

    @Override
    public void initializeMetrics(SolrMetricManager manager, String registryName, String scope) {
        this.registry = manager.registry(registryName);
        this.metricsMap = new MetricsMap((detailed, map) -> {
            long now = System.nanoTime();
            long delta = Math.max(now - this.previous, 1L);
            double seconds = (double)delta / 1.0E9;
            long hits_total = this.blockCacheHit.get();
            long hits_delta = hits_total - this.blockCacheHit_last.get();
            this.blockCacheHit_last.set(hits_total);
            long miss_total = this.blockCacheMiss.get();
            long miss_delta = miss_total - this.blockCacheMiss_last.get();
            this.blockCacheMiss_last.set(miss_total);
            long evict_total = this.blockCacheEviction.get();
            long evict_delta = evict_total - this.blockCacheEviction_last.get();
            this.blockCacheEviction_last.set(evict_total);
            long storeFail_total = this.blockCacheStoreFail.get();
            long storeFail_delta = storeFail_total - this.blockCacheStoreFail_last.get();
            this.blockCacheStoreFail_last.set(storeFail_total);
            long lookups_delta = hits_delta + miss_delta;
            long lookups_total = hits_total + miss_total;
            map.put("size", this.blockCacheSize.get());
            map.put("lookups", lookups_total);
            map.put("hits", hits_total);
            map.put("evictions", evict_total);
            map.put("storeFails", storeFail_total);
            map.put("hitratio_current", Float.valueOf(Metrics.calcHitRatio(lookups_delta, hits_delta)));
            map.put("lookups_persec", Float.valueOf(this.getPerSecond(lookups_delta, seconds)));
            map.put("hits_persec", Float.valueOf(this.getPerSecond(hits_delta, seconds)));
            map.put("evictions_persec", Float.valueOf(this.getPerSecond(evict_delta, seconds)));
            map.put("storeFails_persec", Float.valueOf(this.getPerSecond(storeFail_delta, seconds)));
            map.put("time_delta", seconds);
            map.put("buffercache.allocations", Float.valueOf(this.getPerSecond(this.shardBuffercacheAllocate.getAndSet(0L), seconds)));
            map.put("buffercache.lost", Float.valueOf(this.getPerSecond(this.shardBuffercacheLost.getAndSet(0L), seconds)));
            this.previous = now;
        });
        manager.registerGauge(this, registryName, this.metricsMap, true, this.getName(), this.getCategory().toString(), scope);
    }

    private float getPerSecond(long value, double seconds) {
        return (float)((double)value / seconds);
    }

    @Override
    public String getName() {
        return "hdfsBlockCache";
    }

    @Override
    public String getDescription() {
        return "Provides metrics for the HdfsDirectoryFactory BlockCache.";
    }

    @Override
    public Set<String> getMetricNames() {
        return this.metricNames;
    }

    @Override
    public MetricRegistry getMetricRegistry() {
        return this.registry;
    }
}

