/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.similarities;

import java.io.IOException;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.util.PayloadDecoder;

public class PayloadScoringSimilarityWrapper
extends Similarity {
    private Similarity delegate;
    private PayloadDecoder decoder;

    public PayloadScoringSimilarityWrapper(Similarity delegate, PayloadDecoder decoder) {
        this.delegate = delegate;
        this.decoder = decoder;
    }

    public String toString() {
        return "PayloadScoring(" + this.delegate.toString() + ", decoder=" + this.decoder.toString() + ")";
    }

    public long computeNorm(FieldInvertState state) {
        return this.delegate.computeNorm(state);
    }

    public Similarity.SimWeight computeWeight(float boost, CollectionStatistics collectionStats, TermStatistics ... termStats) {
        return this.delegate.computeWeight(boost, collectionStats, termStats);
    }

    public Similarity.SimScorer simScorer(Similarity.SimWeight weight, LeafReaderContext context) throws IOException {
        final Similarity.SimScorer simScorer = this.delegate.simScorer(weight, context);
        Similarity.SimScorer payloadSimScorer = new Similarity.SimScorer(){

            public float score(int doc, float freq) throws IOException {
                return simScorer.score(doc, freq);
            }

            public float computeSlopFactor(int distance) {
                return simScorer.computeSlopFactor(distance);
            }

            public float computePayloadFactor(int doc, int start, int end, BytesRef payload) {
                return PayloadScoringSimilarityWrapper.this.decoder.decode(doc, start, end, payload);
            }
        };
        return payloadSimScorer;
    }
}

