/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.HLLAgg;
import org.apache.solr.search.facet.UnInvertedField;
import org.apache.solr.search.facet.UniqueSlotAcc;

class UniqueMultivaluedSlotAcc
extends UniqueSlotAcc
implements UnInvertedField.Callback {
    private UnInvertedField uif;
    private UnInvertedField.DocToTerm docToTerm;
    private FixedBitSet bits;

    public UniqueMultivaluedSlotAcc(FacetContext fcontext, SchemaField field, int numSlots, HLLAgg.HLLFactory factory) throws IOException {
        super(fcontext, field, numSlots, factory);
        SolrIndexSearcher searcher = fcontext.qcontext.searcher();
        this.uif = UnInvertedField.getUnInvertedField(field.getName(), searcher);
        this.docToTerm = this.uif.new UnInvertedField.DocToTerm();
        fcontext.qcontext.addCloseHook(this);
        this.nTerms = this.uif.numTerms();
    }

    @Override
    protected BytesRef lookupOrd(int ord) throws IOException {
        return this.docToTerm.lookupOrd(ord);
    }

    @Override
    public void call(int termNum) {
        this.bits.set(termNum);
    }

    @Override
    public void collect(int doc, int slotNum) throws IOException {
        this.bits = this.arr[slotNum];
        if (this.bits == null) {
            this.arr[slotNum] = this.bits = new FixedBitSet(this.nTerms);
        }
        this.docToTerm.getBigTerms(doc + this.currentDocBase, this);
        this.docToTerm.getSmallTerms(doc + this.currentDocBase, this);
    }

    @Override
    public void close() throws IOException {
        if (this.docToTerm != null) {
            this.docToTerm.close();
            this.docToTerm = null;
        }
    }
}

