/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongValues;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.StrFieldSource;
import org.apache.solr.search.facet.DoubleFuncSlotAcc;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetDoubleMerger;
import org.apache.solr.search.facet.FacetMerger;
import org.apache.solr.search.facet.FacetRequest;
import org.apache.solr.search.facet.FacetSortableMerger;
import org.apache.solr.search.facet.FieldUtil;
import org.apache.solr.search.facet.SimpleAggValueSource;
import org.apache.solr.search.facet.SlotAcc;

public class MinMaxAgg
extends SimpleAggValueSource {
    final int minmax;

    public MinMaxAgg(String minOrMax, ValueSource vs) {
        super(minOrMax, vs);
        this.minmax = "min".equals(this.name) ? 1 : -1;
    }

    @Override
    public SlotAcc createSlotAcc(FacetContext fcontext, int numDocs, int numSlots) throws IOException {
        ValueSource vs = this.getArg();
        if (vs instanceof StrFieldSource) {
            String field = ((StrFieldSource)vs).getField();
            SchemaField sf = fcontext.qcontext.searcher().getSchema().getField(field);
            if (sf.multiValued() || sf.getType().multiValuedFieldCache()) {
                if (sf.hasDocValues()) {
                    // empty if block
                }
            } else {
                return new SingleValuedOrdAcc(fcontext, sf, numSlots);
            }
        }
        return new ValSlotAcc(vs, fcontext, numSlots);
    }

    @Override
    public FacetMerger createFacetMerger(Object prototype) {
        if (prototype instanceof Number) {
            return new NumericMerger();
        }
        if (prototype instanceof Comparable) {
            return new ComparableMerger();
        }
        throw new UnsupportedOperationException("min/max merge of " + prototype);
    }

    class SingleValuedOrdAcc
    extends OrdAcc {
        SortedDocValues topLevel;
        SortedDocValues[] subDvs;
        MultiDocValues.OrdinalMap ordMap;
        LongValues toGlobal;
        SortedDocValues subDv;

        public SingleValuedOrdAcc(FacetContext fcontext, SchemaField field, int numSlots) throws IOException {
            super(fcontext, field, numSlots);
        }

        @Override
        public void reset() throws IOException {
            super.reset();
            this.topLevel = FieldUtil.getSortedDocValues(this.fcontext.qcontext, this.field, null);
            if (this.topLevel instanceof MultiDocValues.MultiSortedDocValues) {
                this.ordMap = ((MultiDocValues.MultiSortedDocValues)this.topLevel).mapping;
                this.subDvs = ((MultiDocValues.MultiSortedDocValues)this.topLevel).values;
            } else {
                this.ordMap = null;
                this.subDvs = null;
            }
        }

        @Override
        protected BytesRef lookupOrd(int ord) throws IOException {
            return this.topLevel.lookupOrd(ord);
        }

        @Override
        public void setNextReader(LeafReaderContext readerContext) throws IOException {
            if (this.topLevel == null) {
                this.reset();
            }
            super.setNextReader(readerContext);
            if (this.subDvs != null) {
                this.subDv = this.subDvs[readerContext.ord];
                this.toGlobal = this.ordMap.getGlobalOrds(readerContext.ord);
            } else {
                assert (readerContext.ord == 0 || this.topLevel.getValueCount() == 0);
                this.subDv = this.topLevel;
            }
        }

        @Override
        public void collect(int doc, int slotNum) throws IOException {
            if (doc > this.subDv.docID()) {
                this.subDv.advance(doc);
            }
            if (doc == this.subDv.docID()) {
                int ord;
                int segOrd = this.subDv.ordValue();
                int n = ord = this.toGlobal == null ? segOrd : (int)this.toGlobal.get((long)segOrd);
                if ((ord - this.slotOrd[slotNum]) * MinMaxAgg.this.minmax < 0 || this.slotOrd[slotNum] == -1) {
                    this.slotOrd[slotNum] = ord;
                }
            }
        }
    }

    abstract class OrdAcc
    extends SlotAcc {
        static final int MISSING = -1;
        SchemaField field;
        int[] slotOrd;

        public OrdAcc(FacetContext fcontext, SchemaField field, int numSlots) throws IOException {
            super(fcontext);
            this.field = field;
            this.slotOrd = new int[numSlots];
            Arrays.fill(this.slotOrd, -1);
        }

        abstract BytesRef lookupOrd(int var1) throws IOException;

        @Override
        public int compare(int slotA, int slotB) {
            int a = this.slotOrd[slotA];
            int b = this.slotOrd[slotB];
            return a - b;
        }

        @Override
        public Object getValue(int slotNum) throws IOException {
            int globOrd = this.slotOrd[slotNum];
            if (globOrd == -1) {
                return null;
            }
            BytesRef term = this.lookupOrd(globOrd);
            return this.field.getType().toObject(this.field, term);
        }

        @Override
        public void reset() throws IOException {
            Arrays.fill(this.slotOrd, -1);
        }

        @Override
        public void resize(SlotAcc.Resizer resizer) {
            this.slotOrd = resizer.resize(this.slotOrd, -1);
        }
    }

    class ValSlotAcc
    extends DoubleFuncSlotAcc {
        public ValSlotAcc(ValueSource values, FacetContext fcontext, int numSlots) {
            super(values, fcontext, numSlots, Double.NaN);
        }

        @Override
        public void collect(int doc, int slotNum) throws IOException {
            double val = this.values.doubleVal(doc);
            if (val == 0.0 && !this.values.exists(doc)) {
                return;
            }
            double currVal = this.result[slotNum];
            if (Double.compare(val, currVal) * MinMaxAgg.this.minmax < 0 || Double.isNaN(currVal)) {
                this.result[slotNum] = val;
            }
        }
    }

    private class ComparableMerger
    extends FacetSortableMerger {
        Comparable val;

        private ComparableMerger() {
        }

        @Override
        public void merge(Object facetResult, FacetMerger.Context mcontext) {
            Comparable other = (Comparable)facetResult;
            if (this.val == null) {
                this.val = other;
            } else if (other.compareTo(this.val) * MinMaxAgg.this.minmax < 0) {
                this.val = other;
            }
        }

        @Override
        public Object getMergedResult() {
            return this.val;
        }

        @Override
        public int compareTo(FacetSortableMerger other, FacetRequest.SortDirection direction) {
            return this.val.compareTo(((ComparableMerger)other).val);
        }
    }

    private class NumericMerger
    extends FacetDoubleMerger {
        double val = Double.NaN;

        private NumericMerger() {
        }

        @Override
        public void merge(Object facetResult, FacetMerger.Context mcontext) {
            double result = ((Number)facetResult).doubleValue();
            if (Double.compare(result, this.val) * MinMaxAgg.this.minmax < 0 || Double.isNaN(this.val)) {
                this.val = result;
            }
        }

        @Override
        protected double getDouble() {
            return this.val;
        }
    }
}

