/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.solr.common.SolrException;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.Filter;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetField;
import org.apache.solr.search.facet.FacetFieldProcessorByArray;
import org.apache.solr.search.facet.FieldUtil;
import org.apache.solr.uninverting.FieldCacheImpl;

class FacetFieldProcessorByArrayDV
extends FacetFieldProcessorByArray {
    static boolean unwrap_singleValued_multiDv = true;
    boolean multiValuedField;
    SortedSetDocValues si;
    MultiDocValues.OrdinalMap ordinalMap = null;
    private int[] reuse;

    FacetFieldProcessorByArrayDV(FacetContext fcontext, FacetField freq, SchemaField sf) {
        super(fcontext, freq, sf);
        this.multiValuedField = sf.multiValued() || sf.getType().multiValuedFieldCache();
    }

    @Override
    protected void findStartAndEndOrds() throws IOException {
        if (this.multiValuedField) {
            this.si = FieldUtil.getSortedSetDocValues(this.fcontext.qcontext, this.sf, null);
            if (this.si instanceof MultiDocValues.MultiSortedSetDocValues) {
                this.ordinalMap = ((MultiDocValues.MultiSortedSetDocValues)this.si).mapping;
            }
        } else {
            SortedDocValues single = FieldUtil.getSortedDocValues(this.fcontext.qcontext, this.sf, null);
            this.si = DocValues.singleton((SortedDocValues)single);
            if (single instanceof MultiDocValues.MultiSortedDocValues) {
                this.ordinalMap = ((MultiDocValues.MultiSortedDocValues)single).mapping;
            }
        }
        if (this.si.getValueCount() >= Integer.MAX_VALUE) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Field has too many unique values. field=" + this.sf + " nterms= " + this.si.getValueCount());
        }
        if (this.prefixRef != null) {
            this.startTermIndex = (int)this.si.lookupTerm(this.prefixRef.get());
            if (this.startTermIndex < 0) {
                this.startTermIndex = -this.startTermIndex - 1;
            }
            this.prefixRef.append(UnicodeUtil.BIG_TERM);
            this.endTermIndex = (int)this.si.lookupTerm(this.prefixRef.get());
            assert (this.endTermIndex < 0);
            this.endTermIndex = -this.endTermIndex - 1;
        } else {
            this.startTermIndex = 0;
            this.endTermIndex = (int)this.si.getValueCount();
        }
        this.nTerms = this.endTermIndex - this.startTermIndex;
    }

    @Override
    protected void collectDocs() throws IOException {
        boolean accumSeg;
        int domainSize = this.fcontext.base.size();
        if (this.nTerms <= 0 || domainSize < this.effectiveMincount) {
            return;
        }
        boolean countOnly = this.collectAcc == null && this.allBucketsAcc == null;
        boolean fullRange = this.startTermIndex == 0 && (long)this.endTermIndex == this.si.getValueCount();
        long domainMultiplier = this.multiValuedField ? 4L : 2L;
        boolean manyHitsPerBucket = (long)domainSize * domainMultiplier > this.si.getValueCount() + 3L;
        boolean canDoPerSeg = countOnly && fullRange;
        boolean bl = accumSeg = manyHitsPerBucket && canDoPerSeg;
        if (((FacetField)this.freq).perSeg != null) {
            accumSeg = canDoPerSeg && ((FacetField)this.freq).perSeg != false;
        }
        List leaves = this.fcontext.searcher.getIndexReader().leaves();
        Filter filter = this.fcontext.base.getTopFilter();
        for (int subIdx = 0; subIdx < leaves.size(); ++subIdx) {
            LongValues toGlobal;
            LeafReaderContext subCtx = (LeafReaderContext)leaves.get(subIdx);
            this.setNextReaderFirstPhase(subCtx);
            DocIdSet dis = filter.getDocIdSet(subCtx, null);
            DocIdSetIterator disi = dis.iterator();
            SortedDocValues singleDv = null;
            SortedSetDocValues multiDv = null;
            if (this.multiValuedField) {
                multiDv = subCtx.reader().getSortedSetDocValues(this.sf.getName());
                if (multiDv == null) {
                    multiDv = DocValues.emptySortedSet();
                }
                if (unwrap_singleValued_multiDv) {
                    singleDv = DocValues.unwrapSingleton((SortedSetDocValues)multiDv);
                }
            } else {
                singleDv = subCtx.reader().getSortedDocValues(this.sf.getName());
                if (singleDv == null) {
                    singleDv = DocValues.emptySorted();
                }
            }
            LongValues longValues = toGlobal = this.ordinalMap == null ? null : this.ordinalMap.getGlobalOrds(subIdx);
            if (singleDv != null) {
                if (accumSeg) {
                    this.collectPerSeg(singleDv, disi, toGlobal);
                    continue;
                }
                if (canDoPerSeg && toGlobal != null) {
                    this.collectCounts(singleDv, disi, toGlobal);
                    continue;
                }
                this.collectDocs(singleDv, disi, toGlobal);
                continue;
            }
            if (accumSeg) {
                this.collectPerSeg(multiDv, disi, toGlobal);
                continue;
            }
            if (canDoPerSeg && toGlobal != null) {
                this.collectCounts(multiDv, disi, toGlobal);
                continue;
            }
            this.collectDocs(multiDv, disi, toGlobal);
        }
        this.reuse = null;
    }

    @Override
    protected BytesRef lookupOrd(int ord) throws IOException {
        return this.si.lookupOrd((long)ord);
    }

    private void collectPerSeg(SortedDocValues singleDv, DocIdSetIterator disi, LongValues toGlobal) throws IOException {
        int doc;
        int segMax = singleDv.getValueCount() + 1;
        int[] counts = this.getCountArr(segMax);
        if (singleDv instanceof FieldCacheImpl.SortedDocValuesImpl.Iter) {
            FieldCacheImpl.SortedDocValuesImpl.Iter fc = (FieldCacheImpl.SortedDocValuesImpl.Iter)singleDv;
            while ((doc = disi.nextDoc()) != Integer.MAX_VALUE) {
                int n = fc.getOrd(doc) + 1;
                counts[n] = counts[n] + 1;
            }
        } else {
            while ((doc = disi.nextDoc()) != Integer.MAX_VALUE) {
                if (!singleDv.advanceExact(doc)) continue;
                int n = singleDv.ordValue() + 1;
                counts[n] = counts[n] + 1;
            }
        }
        for (int i = 1; i < segMax; ++i) {
            int segCount = counts[i];
            if (segCount <= 0) continue;
            int slot = toGlobal == null ? i - 1 : (int)toGlobal.get((long)(i - 1));
            this.countAcc.incrementCount(slot, segCount);
        }
    }

    private void collectPerSeg(SortedSetDocValues multiDv, DocIdSetIterator disi, LongValues toGlobal) throws IOException {
        int doc;
        int segMax = (int)multiDv.getValueCount();
        int[] counts = this.getCountArr(segMax);
        while ((doc = disi.nextDoc()) != Integer.MAX_VALUE) {
            int segOrd;
            if (!multiDv.advanceExact(doc)) continue;
            while ((segOrd = (int)multiDv.nextOrd()) >= 0) {
                int n = segOrd;
                counts[n] = counts[n] + 1;
            }
        }
        for (int i = 0; i < segMax; ++i) {
            int segCount = counts[i];
            if (segCount <= 0) continue;
            int slot = toGlobal == null ? i : (int)toGlobal.get((long)i);
            this.countAcc.incrementCount(slot, segCount);
        }
    }

    private int[] getCountArr(int maxNeeded) {
        if (this.reuse == null) {
            this.reuse = new int[(int)this.si.getValueCount() + 1];
        } else {
            Arrays.fill(this.reuse, 0, maxNeeded, 0);
        }
        return this.reuse;
    }

    private void collectDocs(SortedDocValues singleDv, DocIdSetIterator disi, LongValues toGlobal) throws IOException {
        int doc;
        while ((doc = disi.nextDoc()) != Integer.MAX_VALUE) {
            if (!singleDv.advanceExact(doc)) continue;
            int segOrd = singleDv.ordValue();
            this.collect(doc, segOrd, toGlobal);
        }
    }

    private void collectCounts(SortedDocValues singleDv, DocIdSetIterator disi, LongValues toGlobal) throws IOException {
        if (singleDv instanceof FieldCacheImpl.SortedDocValuesImpl.Iter) {
            int doc;
            FieldCacheImpl.SortedDocValuesImpl.Iter fc = (FieldCacheImpl.SortedDocValuesImpl.Iter)singleDv;
            while ((doc = disi.nextDoc()) != Integer.MAX_VALUE) {
                int segOrd = fc.getOrd(doc);
                if (segOrd < 0) continue;
                int ord = (int)toGlobal.get((long)segOrd);
                this.countAcc.incrementCount(ord, 1);
            }
        } else {
            int doc;
            while ((doc = disi.nextDoc()) != Integer.MAX_VALUE) {
                if (!singleDv.advanceExact(doc)) continue;
                int segOrd = singleDv.ordValue();
                int ord = (int)toGlobal.get((long)segOrd);
                this.countAcc.incrementCount(ord, 1);
            }
        }
    }

    private void collectDocs(SortedSetDocValues multiDv, DocIdSetIterator disi, LongValues toGlobal) throws IOException {
        int doc;
        while ((doc = disi.nextDoc()) != Integer.MAX_VALUE) {
            int segOrd;
            if (!multiDv.advanceExact(doc)) continue;
            while ((segOrd = (int)multiDv.nextOrd()) >= 0) {
                this.collect(doc, segOrd, toGlobal);
            }
        }
    }

    private void collectCounts(SortedSetDocValues multiDv, DocIdSetIterator disi, LongValues toGlobal) throws IOException {
        int doc;
        while ((doc = disi.nextDoc()) != Integer.MAX_VALUE) {
            int segOrd;
            if (!multiDv.advanceExact(doc)) continue;
            while ((segOrd = (int)multiDv.nextOrd()) >= 0) {
                int ord = (int)toGlobal.get((long)segOrd);
                this.countAcc.incrementCount(ord, 1);
            }
        }
    }

    private void collect(int doc, int segOrd, LongValues toGlobal) throws IOException {
        int ord = toGlobal != null && segOrd >= 0 ? (int)toGlobal.get((long)segOrd) : segOrd;
        int arrIdx = ord - this.startTermIndex;
        if (arrIdx >= 0 && arrIdx < this.nTerms) {
            this.countAcc.incrementCount(arrIdx, 1);
            if (this.collectAcc != null) {
                this.collectAcc.collect(doc, arrIdx);
            }
            if (this.allBucketsAcc != null) {
                this.allBucketsAcc.collect(doc, arrIdx);
            }
        }
    }
}

