/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.DoubleFieldSource;
import org.apache.lucene.queries.function.valuesource.FloatFieldSource;
import org.apache.lucene.queries.function.valuesource.IntFieldSource;
import org.apache.lucene.queries.function.valuesource.LongFieldSource;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedSetSelector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.NumericUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.legacy.LegacyDoubleField;
import org.apache.solr.legacy.LegacyField;
import org.apache.solr.legacy.LegacyFieldType;
import org.apache.solr.legacy.LegacyFloatField;
import org.apache.solr.legacy.LegacyIntField;
import org.apache.solr.legacy.LegacyLongField;
import org.apache.solr.legacy.LegacyNumericRangeQuery;
import org.apache.solr.legacy.LegacyNumericType;
import org.apache.solr.legacy.LegacyNumericUtils;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.NumberType;
import org.apache.solr.schema.NumericFieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TrieDateFieldSource;
import org.apache.solr.search.QParser;
import org.apache.solr.uninverting.UninvertingReader;
import org.apache.solr.util.DateMathParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class TrieField
extends NumericFieldType {
    public static final int DEFAULT_PRECISION_STEP = 8;
    protected int precisionStepArg = 8;
    protected int precisionStep;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final String INT_PREFIX = new String(new char[]{'`'});
    static final String LONG_PREFIX = new String(new char[]{' '});

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        String t;
        super.init(schema, args);
        String p = args.remove("precisionStep");
        if (p != null) {
            this.precisionStepArg = Integer.parseInt(p);
        }
        this.precisionStep = this.precisionStepArg;
        if (this.precisionStep <= 0 || this.precisionStep >= 64) {
            this.precisionStep = Integer.MAX_VALUE;
        }
        if ((t = args.remove("type")) != null) {
            try {
                this.type = NumberType.valueOf(t.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid type specified in schema.xml for field: " + args.get("name"), (Throwable)e);
            }
        }
    }

    @Override
    public Object toObject(IndexableField f) {
        Number val = f.numericValue();
        if (val != null) {
            if (!f.fieldType().stored() && f.fieldType().docValuesType() == DocValuesType.NUMERIC) {
                long bits = val.longValue();
                switch (this.type) {
                    case INTEGER: {
                        return (int)bits;
                    }
                    case FLOAT: {
                        return Float.valueOf(Float.intBitsToFloat((int)bits));
                    }
                    case LONG: {
                        return bits;
                    }
                    case DOUBLE: {
                        return Double.longBitsToDouble(bits);
                    }
                    case DATE: {
                        return new Date(bits);
                    }
                }
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + f.name());
            }
            return this.type == NumberType.DATE ? new Date(val.longValue()) : val;
        }
        BytesRef term = f.binaryValue();
        switch (this.type) {
            case INTEGER: {
                return LegacyNumericUtils.prefixCodedToInt(term);
            }
            case FLOAT: {
                return Float.valueOf(NumericUtils.sortableIntToFloat((int)LegacyNumericUtils.prefixCodedToInt(term)));
            }
            case LONG: {
                return LegacyNumericUtils.prefixCodedToLong(term);
            }
            case DOUBLE: {
                return NumericUtils.sortableLongToDouble((long)LegacyNumericUtils.prefixCodedToLong(term));
            }
            case DATE: {
                return new Date(LegacyNumericUtils.prefixCodedToLong(term));
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + f.name());
    }

    @Override
    public SortField getSortField(SchemaField field, boolean top) {
        field.checkSortability();
        Number missingValue = null;
        boolean sortMissingLast = field.sortMissingLast();
        boolean sortMissingFirst = field.sortMissingFirst();
        switch (this.type) {
            case INTEGER: {
                if (sortMissingLast) {
                    missingValue = top ? Integer.MIN_VALUE : Integer.MAX_VALUE;
                } else if (sortMissingFirst) {
                    missingValue = top ? Integer.MAX_VALUE : Integer.MIN_VALUE;
                }
                SortField sf = new SortField(field.getName(), SortField.Type.INT, top);
                sf.setMissingValue((Object)missingValue);
                return sf;
            }
            case FLOAT: {
                if (sortMissingLast) {
                    missingValue = Float.valueOf(top ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY);
                } else if (sortMissingFirst) {
                    missingValue = Float.valueOf(top ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY);
                }
                SortField sf = new SortField(field.getName(), SortField.Type.FLOAT, top);
                sf.setMissingValue((Object)missingValue);
                return sf;
            }
            case LONG: 
            case DATE: {
                if (sortMissingLast) {
                    missingValue = top ? Long.MIN_VALUE : Long.MAX_VALUE;
                } else if (sortMissingFirst) {
                    missingValue = top ? Long.MAX_VALUE : Long.MIN_VALUE;
                }
                SortField sf = new SortField(field.getName(), SortField.Type.LONG, top);
                sf.setMissingValue((Object)missingValue);
                return sf;
            }
            case DOUBLE: {
                if (sortMissingLast) {
                    missingValue = top ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                } else if (sortMissingFirst) {
                    missingValue = top ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
                }
                SortField sf = new SortField(field.getName(), SortField.Type.DOUBLE, top);
                sf.setMissingValue((Object)missingValue);
                return sf;
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + field.name);
    }

    @Override
    public UninvertingReader.Type getUninversionType(SchemaField sf) {
        if (sf.multiValued()) {
            switch (this.type) {
                case INTEGER: {
                    return UninvertingReader.Type.SORTED_SET_INTEGER;
                }
                case LONG: 
                case DATE: {
                    return UninvertingReader.Type.SORTED_SET_LONG;
                }
                case FLOAT: {
                    return UninvertingReader.Type.SORTED_SET_FLOAT;
                }
                case DOUBLE: {
                    return UninvertingReader.Type.SORTED_SET_DOUBLE;
                }
            }
            throw new AssertionError();
        }
        switch (this.type) {
            case INTEGER: {
                return UninvertingReader.Type.LEGACY_INTEGER;
            }
            case LONG: 
            case DATE: {
                return UninvertingReader.Type.LEGACY_LONG;
            }
            case FLOAT: {
                return UninvertingReader.Type.LEGACY_FLOAT;
            }
            case DOUBLE: {
                return UninvertingReader.Type.LEGACY_DOUBLE;
            }
        }
        throw new AssertionError();
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser qparser) {
        field.checkFieldCacheSource();
        switch (this.type) {
            case INTEGER: {
                return new IntFieldSource(field.getName());
            }
            case FLOAT: {
                return new FloatFieldSource(field.getName());
            }
            case DATE: {
                return new TrieDateFieldSource(field.getName());
            }
            case LONG: {
                return new LongFieldSource(field.getName());
            }
            case DOUBLE: {
                return new DoubleFieldSource(field.getName());
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + field.name);
    }

    @Override
    public final ValueSource getSingleValueSource(FieldType.MultiValueSelector choice, SchemaField field, QParser parser) {
        if (!field.multiValued()) {
            return this.getValueSource(field, parser);
        }
        if (!field.hasDocValues()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "docValues='true' is required to select '" + choice.toString() + "' value from multivalued field (" + field.getName() + ") at query time");
        }
        SortedSetSelector.Type selectorType = choice.getSortedSetSelectorType();
        if (null == selectorType) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, choice.toString() + " is not a supported option for picking a single value" + " from the multivalued field: " + field.getName() + " (type: " + this.getTypeName() + ")");
        }
        return this.getSingleValueSource(selectorType, field);
    }

    protected ValueSource getSingleValueSource(SortedSetSelector.Type choice, SchemaField field) {
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not select a single value for multivalued field: " + field.getName() + " (single valued field selection not supported for type: " + this.getTypeName() + ")");
    }

    @Override
    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
        writer.writeVal(name, this.toObject(f));
    }

    @Override
    public boolean isTokenized() {
        return false;
    }

    @Override
    public boolean multiValuedFieldCache() {
        return false;
    }

    public int getPrecisionStep() {
        return this.precisionStepArg;
    }

    @Override
    public Query getRangeQuery(QParser parser, SchemaField field, String min, String max, boolean minInclusive, boolean maxInclusive) {
        LegacyNumericRangeQuery<Number> query;
        if (field.multiValued() && field.hasDocValues() && !field.indexed()) {
            return super.getRangeQuery(parser, field, min, max, minInclusive, maxInclusive);
        }
        int ps = this.precisionStep;
        if (field.hasDocValues() && !field.indexed()) {
            return this.getDocValuesRangeQuery(parser, field, min, max, minInclusive, maxInclusive);
        }
        switch (this.type) {
            case INTEGER: {
                query = LegacyNumericRangeQuery.newIntRange(field.getName(), ps, min == null ? null : Integer.valueOf(TrieField.parseIntFromUser(field.getName(), min)), max == null ? null : Integer.valueOf(TrieField.parseIntFromUser(field.getName(), max)), minInclusive, maxInclusive);
                break;
            }
            case FLOAT: {
                query = LegacyNumericRangeQuery.newFloatRange(field.getName(), ps, min == null ? null : Float.valueOf(TrieField.parseFloatFromUser(field.getName(), min)), max == null ? null : Float.valueOf(TrieField.parseFloatFromUser(field.getName(), max)), minInclusive, maxInclusive);
                break;
            }
            case LONG: {
                query = LegacyNumericRangeQuery.newLongRange(field.getName(), ps, min == null ? null : Long.valueOf(TrieField.parseLongFromUser(field.getName(), min)), max == null ? null : Long.valueOf(TrieField.parseLongFromUser(field.getName(), max)), minInclusive, maxInclusive);
                break;
            }
            case DOUBLE: {
                query = LegacyNumericRangeQuery.newDoubleRange(field.getName(), ps, min == null ? null : Double.valueOf(TrieField.parseDoubleFromUser(field.getName(), min)), max == null ? null : Double.valueOf(TrieField.parseDoubleFromUser(field.getName(), max)), minInclusive, maxInclusive);
                break;
            }
            case DATE: {
                query = LegacyNumericRangeQuery.newLongRange(field.getName(), ps, min == null ? null : Long.valueOf(DateMathParser.parseMath(null, min).getTime()), max == null ? null : Long.valueOf(DateMathParser.parseMath(null, max).getTime()), minInclusive, maxInclusive);
                break;
            }
            default: {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field");
            }
        }
        return query;
    }

    @Override
    public Query getFieldQuery(QParser parser, SchemaField field, String externalVal) {
        if (!field.indexed() && field.hasDocValues()) {
            return this.getRangeQuery(parser, field, externalVal, externalVal, true, true);
        }
        return super.getFieldQuery(parser, field, externalVal);
    }

    @Override
    public String storedToReadable(IndexableField f) {
        return this.toExternal(f);
    }

    @Override
    public String readableToIndexed(String val) {
        BytesRefBuilder bytes = new BytesRefBuilder();
        this.readableToIndexed(val, bytes);
        return bytes.get().utf8ToString();
    }

    @Override
    public void readableToIndexed(CharSequence val, BytesRefBuilder result) {
        String s = val.toString();
        switch (this.type) {
            case INTEGER: {
                LegacyNumericUtils.intToPrefixCoded(TrieField.parseIntFromUser(null, s), 0, result);
                break;
            }
            case FLOAT: {
                LegacyNumericUtils.intToPrefixCoded(NumericUtils.floatToSortableInt((float)TrieField.parseFloatFromUser(null, s)), 0, result);
                break;
            }
            case LONG: {
                LegacyNumericUtils.longToPrefixCoded(TrieField.parseLongFromUser(null, s), 0, result);
                break;
            }
            case DOUBLE: {
                LegacyNumericUtils.longToPrefixCoded(NumericUtils.doubleToSortableLong((double)TrieField.parseDoubleFromUser(null, s)), 0, result);
                break;
            }
            case DATE: {
                LegacyNumericUtils.longToPrefixCoded(DateMathParser.parseMath(null, s).getTime(), 0, result);
                break;
            }
            default: {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + (Object)((Object)this.type));
            }
        }
    }

    @Override
    public String toInternal(String val) {
        return this.readableToIndexed(val);
    }

    static String badFieldString(IndexableField f) {
        String s = f.stringValue();
        return "ERROR:SCHEMA-INDEX-MISMATCH,stringValue=" + s;
    }

    @Override
    public String toExternal(IndexableField f) {
        return this.type == NumberType.DATE ? ((Date)this.toObject(f)).toInstant().toString() : this.toObject(f).toString();
    }

    @Override
    public String indexedToReadable(String _indexedForm) {
        BytesRef indexedForm = new BytesRef((CharSequence)_indexedForm);
        switch (this.type) {
            case INTEGER: {
                return Integer.toString(LegacyNumericUtils.prefixCodedToInt(indexedForm));
            }
            case FLOAT: {
                return Float.toString(NumericUtils.sortableIntToFloat((int)LegacyNumericUtils.prefixCodedToInt(indexedForm)));
            }
            case LONG: {
                return Long.toString(LegacyNumericUtils.prefixCodedToLong(indexedForm));
            }
            case DOUBLE: {
                return Double.toString(NumericUtils.sortableLongToDouble((long)LegacyNumericUtils.prefixCodedToLong(indexedForm)));
            }
            case DATE: {
                return Instant.ofEpochMilli(LegacyNumericUtils.prefixCodedToLong(indexedForm)).toString();
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + (Object)((Object)this.type));
    }

    @Override
    public CharsRef indexedToReadable(BytesRef indexedForm, CharsRefBuilder charsRef) {
        String value;
        switch (this.type) {
            case INTEGER: {
                value = Integer.toString(LegacyNumericUtils.prefixCodedToInt(indexedForm));
                break;
            }
            case FLOAT: {
                value = Float.toString(NumericUtils.sortableIntToFloat((int)LegacyNumericUtils.prefixCodedToInt(indexedForm)));
                break;
            }
            case LONG: {
                value = Long.toString(LegacyNumericUtils.prefixCodedToLong(indexedForm));
                break;
            }
            case DOUBLE: {
                value = Double.toString(NumericUtils.sortableLongToDouble((long)LegacyNumericUtils.prefixCodedToLong(indexedForm)));
                break;
            }
            case DATE: {
                value = Instant.ofEpochMilli(LegacyNumericUtils.prefixCodedToLong(indexedForm)).toString();
                break;
            }
            default: {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + (Object)((Object)this.type));
            }
        }
        charsRef.grow(value.length());
        charsRef.setLength(value.length());
        value.getChars(0, charsRef.length(), charsRef.chars(), 0);
        return charsRef.get();
    }

    @Override
    public Object toObject(SchemaField sf, BytesRef term) {
        switch (this.type) {
            case INTEGER: {
                return LegacyNumericUtils.prefixCodedToInt(term);
            }
            case FLOAT: {
                return Float.valueOf(NumericUtils.sortableIntToFloat((int)LegacyNumericUtils.prefixCodedToInt(term)));
            }
            case LONG: {
                return LegacyNumericUtils.prefixCodedToLong(term);
            }
            case DOUBLE: {
                return NumericUtils.sortableLongToDouble((long)LegacyNumericUtils.prefixCodedToLong(term));
            }
            case DATE: {
                return new Date(LegacyNumericUtils.prefixCodedToLong(term));
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + (Object)((Object)this.type));
    }

    @Override
    public String storedToIndexed(IndexableField f) {
        BytesRefBuilder bytes = new BytesRefBuilder();
        this.storedToIndexed(f, bytes);
        return bytes.get().utf8ToString();
    }

    private void storedToIndexed(IndexableField f, BytesRefBuilder bytes) {
        block7: {
            block6: {
                Number val = f.numericValue();
                if (val == null) break block6;
                switch (this.type) {
                    case INTEGER: {
                        LegacyNumericUtils.intToPrefixCoded(val.intValue(), 0, bytes);
                        break block7;
                    }
                    case FLOAT: {
                        LegacyNumericUtils.intToPrefixCoded(NumericUtils.floatToSortableInt((float)val.floatValue()), 0, bytes);
                        break block7;
                    }
                    case LONG: 
                    case DATE: {
                        LegacyNumericUtils.longToPrefixCoded(val.longValue(), 0, bytes);
                        break block7;
                    }
                    case DOUBLE: {
                        LegacyNumericUtils.longToPrefixCoded(NumericUtils.doubleToSortableLong((double)val.doubleValue()), 0, bytes);
                        break block7;
                    }
                    default: {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + f.name());
                    }
                }
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid field contents: " + f.name());
        }
    }

    @Override
    public IndexableField createField(SchemaField field, Object value) {
        LegacyField f;
        boolean indexed = field.indexed();
        boolean stored = field.stored();
        boolean docValues = field.hasDocValues();
        if (!(indexed || stored || docValues)) {
            if (log.isTraceEnabled()) {
                log.trace("Ignoring unindexed/unstored field: " + field);
            }
            return null;
        }
        LegacyFieldType ft = new LegacyFieldType();
        ft.setStored(stored);
        ft.setTokenized(true);
        ft.setOmitNorms(field.omitNorms());
        ft.setIndexOptions(field.indexOptions());
        switch (this.type) {
            case INTEGER: {
                ft.setNumericType(LegacyNumericType.INT);
                break;
            }
            case FLOAT: {
                ft.setNumericType(LegacyNumericType.FLOAT);
                break;
            }
            case LONG: {
                ft.setNumericType(LegacyNumericType.LONG);
                break;
            }
            case DOUBLE: {
                ft.setNumericType(LegacyNumericType.DOUBLE);
                break;
            }
            case DATE: {
                ft.setNumericType(LegacyNumericType.LONG);
                break;
            }
            default: {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + (Object)((Object)this.type));
            }
        }
        ft.setNumericPrecisionStep(this.precisionStep);
        switch (this.type) {
            case INTEGER: {
                int i = value instanceof Number ? ((Number)value).intValue() : Integer.parseInt(value.toString());
                f = new LegacyIntField(field.getName(), i, ft);
                break;
            }
            case FLOAT: {
                float fl = value instanceof Number ? ((Number)value).floatValue() : Float.parseFloat(value.toString());
                f = new LegacyFloatField(field.getName(), fl, ft);
                break;
            }
            case LONG: {
                long l = value instanceof Number ? ((Number)value).longValue() : Long.parseLong(value.toString());
                f = new LegacyLongField(field.getName(), l, ft);
                break;
            }
            case DOUBLE: {
                double d = value instanceof Number ? ((Number)value).doubleValue() : Double.parseDouble(value.toString());
                f = new LegacyDoubleField(field.getName(), d, ft);
                break;
            }
            case DATE: {
                Date date = value instanceof Date ? (Date)value : DateMathParser.parseMath(null, value.toString());
                f = new LegacyLongField(field.getName(), date.getTime(), ft);
                break;
            }
            default: {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + (Object)((Object)this.type));
            }
        }
        return f;
    }

    @Override
    public List<IndexableField> createFields(SchemaField sf, Object value) {
        if (sf.hasDocValues()) {
            ArrayList<IndexableField> fields = new ArrayList<IndexableField>();
            IndexableField field = this.createField(sf, value);
            fields.add(field);
            if (sf.multiValued()) {
                BytesRefBuilder bytes = new BytesRefBuilder();
                this.storedToIndexed(field, bytes);
                fields.add((IndexableField)new SortedSetDocValuesField(sf.getName(), bytes.get()));
            } else {
                long bits;
                if (field.numericValue() instanceof Integer || field.numericValue() instanceof Long) {
                    bits = field.numericValue().longValue();
                } else if (field.numericValue() instanceof Float) {
                    bits = Float.floatToIntBits(field.numericValue().floatValue());
                } else {
                    assert (field.numericValue() instanceof Double);
                    bits = Double.doubleToLongBits(field.numericValue().doubleValue());
                }
                fields.add((IndexableField)new NumericDocValuesField(sf.getName(), bits));
            }
            return fields;
        }
        return Collections.singletonList(this.createField(sf, value));
    }

    public static String getMainValuePrefix(FieldType ft) {
        if (ft instanceof TrieField) {
            TrieField trie = (TrieField)ft;
            if (trie.precisionStep == Integer.MAX_VALUE) {
                return null;
            }
            switch (trie.type) {
                case INTEGER: 
                case FLOAT: {
                    return INT_PREFIX;
                }
                case LONG: 
                case DOUBLE: 
                case DATE: {
                    return LONG_PREFIX;
                }
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + (Object)((Object)trie.type));
        }
        return null;
    }
}

