/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.spatial.ShapeValues;
import org.apache.lucene.spatial.ShapeValuesSource;
import org.apache.lucene.spatial.composite.CompositeSpatialStrategy;
import org.apache.lucene.spatial.prefix.RecursivePrefixTreeStrategy;
import org.apache.lucene.spatial.serialized.SerializedDVStrategy;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.schema.AbstractSpatialFieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SpatialRecursivePrefixTreeFieldType;
import org.apache.solr.search.SolrCache;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;

public class RptWithGeometrySpatialField
extends AbstractSpatialFieldType<CompositeSpatialStrategy> {
    public static final String DEFAULT_DIST_ERR_PCT = "0.15";
    private SpatialRecursivePrefixTreeFieldType rptFieldType;
    private SolrCore core;
    public static final String CACHE_KEY_PREFIX = "perSegSpatialFieldCache_";

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        HashMap<String, String> origArgs = new HashMap<String, String>(args);
        super.init(schema, origArgs);
        if (this.isMultiValued()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Not capable of multiValued: " + this.getTypeName());
        }
        if (!args.containsKey("distErrPct")) {
            args.put("distErrPct", DEFAULT_DIST_ERR_PCT);
        }
        this.rptFieldType = new SpatialRecursivePrefixTreeFieldType();
        this.rptFieldType.setTypeName(this.getTypeName());
        this.rptFieldType.properties = this.properties;
        this.rptFieldType.init(schema, args);
        this.rptFieldType.argsParser = this.argsParser = this.newSpatialArgsParser();
        this.ctx = this.rptFieldType.ctx;
        this.distanceUnits = this.rptFieldType.distanceUnits;
    }

    @Override
    protected CompositeSpatialStrategy newSpatialStrategy(String fieldName) {
        RecursivePrefixTreeStrategy rptStrategy = (RecursivePrefixTreeStrategy)this.rptFieldType.newSpatialStrategy(fieldName);
        CachingSerializedDVStrategy geomStrategy = new CachingSerializedDVStrategy(this.ctx, fieldName);
        return new CompositeSpatialStrategy(fieldName, rptStrategy, (SerializedDVStrategy)geomStrategy);
    }

    @Override
    public Analyzer getQueryAnalyzer() {
        return this.rptFieldType.getQueryAnalyzer();
    }

    @Override
    public Analyzer getIndexAnalyzer() {
        return this.rptFieldType.getIndexAnalyzer();
    }

    private static class PerSegCacheKey {
        final WeakReference<Object> segCoreKeyRef;
        final int docId;
        final int hashCode;

        private PerSegCacheKey(Object segCoreKey, int docId) {
            this.segCoreKeyRef = new WeakReference<Object>(segCoreKey);
            this.docId = docId;
            this.hashCode = segCoreKey.hashCode() * 31 + docId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PerSegCacheKey that = (PerSegCacheKey)o;
            if (this.docId != that.docId) {
                return false;
            }
            Object segCoreKey = this.segCoreKeyRef.get();
            if (segCoreKey == null) {
                return false;
            }
            return segCoreKey.equals(that.segCoreKeyRef.get());
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return "Key{seg=" + this.segCoreKeyRef.get() + ", docId=" + this.docId + '}';
        }
    }

    private static class CachingShapeValuesource
    extends ShapeValuesSource {
        private final ShapeValuesSource targetValueSource;
        private final String fieldName;

        private CachingShapeValuesource(ShapeValuesSource targetValueSource, String fieldName) {
            this.targetValueSource = targetValueSource;
            this.fieldName = fieldName;
        }

        public String toString() {
            return "cache(" + this.targetValueSource.toString() + ")";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            CachingShapeValuesource that = (CachingShapeValuesource)((Object)o);
            if (!this.targetValueSource.equals(that.targetValueSource)) {
                return false;
            }
            return this.fieldName.equals(that.fieldName);
        }

        public int hashCode() {
            int result = this.targetValueSource.hashCode();
            result = 31 * result + this.fieldName.hashCode();
            return result;
        }

        public ShapeValues getValues(final LeafReaderContext readerContext) throws IOException {
            final ShapeValues targetFuncValues = this.targetValueSource.getValues(readerContext);
            final SolrCache cache = SolrRequestInfo.getRequestInfo().getReq().getSearcher().getCache(RptWithGeometrySpatialField.CACHE_KEY_PREFIX + this.fieldName);
            if (cache == null) {
                return targetFuncValues;
            }
            return new ShapeValues(){
                int docId = -1;

                public Shape value() throws IOException {
                    IndexReader.CacheHelper cacheHelper = readerContext.reader().getCoreCacheHelper();
                    if (cacheHelper == null) {
                        throw new IllegalStateException("Leaf " + readerContext.reader() + " is not suited for caching");
                    }
                    PerSegCacheKey key = new PerSegCacheKey(cacheHelper.getKey(), this.docId);
                    Shape shape = (Shape)cache.get(key);
                    if (shape == null) {
                        shape = targetFuncValues.value();
                        if (shape != null) {
                            cache.put(key, shape);
                        }
                    } else if (shape instanceof JtsGeometry) {
                        ((JtsGeometry)shape).index();
                    }
                    return shape;
                }

                public boolean advanceExact(int doc) throws IOException {
                    this.docId = doc;
                    return targetFuncValues.advanceExact(doc);
                }
            };
        }
    }

    private static class CachingSerializedDVStrategy
    extends SerializedDVStrategy {
        public CachingSerializedDVStrategy(SpatialContext ctx, String fieldName) {
            super(ctx, fieldName);
        }

        public ShapeValuesSource makeShapeValueSource() {
            return new CachingShapeValuesource(super.makeShapeValueSource(), this.getFieldName());
        }
    }
}

