/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.util.Collection;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.LongFieldSource;
import org.apache.lucene.queries.function.valuesource.MultiValuedLongFieldSource;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSelector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.solr.schema.LongValueFieldType;
import org.apache.solr.schema.NumberType;
import org.apache.solr.schema.PointField;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.uninverting.UninvertingReader;

public class LongPointField
extends PointField
implements LongValueFieldType {
    public LongPointField() {
        this.type = NumberType.LONG;
    }

    @Override
    public Object toNativeType(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        try {
            if (val instanceof String) {
                return Long.parseLong((String)val);
            }
        }
        catch (NumberFormatException e) {
            Double v = Double.parseDouble((String)val);
            return v.longValue();
        }
        return super.toNativeType(val);
    }

    @Override
    public Query getPointRangeQuery(QParser parser, SchemaField field, String min, String max, boolean minInclusive, boolean maxInclusive) {
        long actualMax;
        long actualMin;
        if (min == null) {
            actualMin = Long.MIN_VALUE;
        } else {
            actualMin = LongPointField.parseLongFromUser(field.getName(), min);
            if (!minInclusive) {
                if (actualMin == Long.MAX_VALUE) {
                    return new MatchNoDocsQuery();
                }
                ++actualMin;
            }
        }
        if (max == null) {
            actualMax = Long.MAX_VALUE;
        } else {
            actualMax = LongPointField.parseLongFromUser(field.getName(), max);
            if (!maxInclusive) {
                if (actualMax == Long.MIN_VALUE) {
                    return new MatchNoDocsQuery();
                }
                --actualMax;
            }
        }
        return LongPoint.newRangeQuery((String)field.getName(), (long)actualMin, (long)actualMax);
    }

    @Override
    public Object toObject(SchemaField sf, BytesRef term) {
        return LongPoint.decodeDimension((byte[])term.bytes, (int)term.offset);
    }

    @Override
    public Object toObject(IndexableField f) {
        Number val = f.numericValue();
        if (val != null) {
            return val;
        }
        throw new AssertionError((Object)("Unexpected state. Field: '" + f + "'"));
    }

    @Override
    protected Query getExactQuery(SchemaField field, String externalVal) {
        return LongPoint.newExactQuery((String)field.getName(), (long)LongPointField.parseLongFromUser(field.getName(), externalVal));
    }

    @Override
    public Query getSetQuery(QParser parser, SchemaField field, Collection<String> externalVal) {
        assert (externalVal.size() > 0);
        if (!field.indexed()) {
            return super.getSetQuery(parser, field, externalVal);
        }
        long[] values = new long[externalVal.size()];
        int i = 0;
        for (String val : externalVal) {
            values[i] = LongPointField.parseLongFromUser(field.getName(), val);
            ++i;
        }
        return LongPoint.newSetQuery((String)field.getName(), (long[])values);
    }

    @Override
    protected String indexedToReadable(BytesRef indexedForm) {
        return Long.toString(LongPoint.decodeDimension((byte[])indexedForm.bytes, (int)indexedForm.offset));
    }

    @Override
    public void readableToIndexed(CharSequence val, BytesRefBuilder result) {
        result.grow(8);
        result.setLength(8);
        LongPoint.encodeDimension((long)LongPointField.parseLongFromUser(null, val.toString()), (byte[])result.bytes(), (int)0);
    }

    @Override
    public SortField getSortField(SchemaField field, boolean top) {
        field.checkSortability();
        Long missingValue = null;
        boolean sortMissingLast = field.sortMissingLast();
        boolean sortMissingFirst = field.sortMissingFirst();
        if (sortMissingLast) {
            missingValue = top ? Long.MIN_VALUE : Long.MAX_VALUE;
        } else if (sortMissingFirst) {
            missingValue = top ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
        SortField sf = new SortField(field.getName(), SortField.Type.LONG, top);
        sf.setMissingValue((Object)missingValue);
        return sf;
    }

    @Override
    public UninvertingReader.Type getUninversionType(SchemaField sf) {
        if (sf.multiValued()) {
            return null;
        }
        return UninvertingReader.Type.LONG_POINT;
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser qparser) {
        field.checkFieldCacheSource();
        return new LongFieldSource(field.getName());
    }

    @Override
    protected ValueSource getSingleValueSource(SortedNumericSelector.Type choice, SchemaField field) {
        return new MultiValuedLongFieldSource(field.getName(), choice);
    }

    @Override
    public IndexableField createField(SchemaField field, Object value) {
        long longValue = value instanceof Number ? ((Number)value).longValue() : Long.parseLong(value.toString());
        return new LongPoint(field.getName(), new long[]{longValue});
    }

    @Override
    protected StoredField getStoredField(SchemaField sf, Object value) {
        return new StoredField(sf.getName(), ((Long)this.toNativeType(value)).longValue());
    }
}

