/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.apache.solr.client.solrj.io.graph.Traversal;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.GraphHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphMLResponseWriter
implements QueryResponseWriter {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public void init(NamedList args) {
    }

    @Override
    public String getContentType(SolrQueryRequest req, SolrQueryResponse res) {
        return "application/xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void write(Writer writer, SolrQueryRequest req, SolrQueryResponse res) throws IOException {
        e1 = res.getException();
        if (e1 != null) {
            e1.printStackTrace(new PrintWriter(writer));
            return;
        }
        stream = (TupleStream)req.getContext().get("stream");
        if (stream instanceof GraphHandler.DummyErrorStream) {
            d = (GraphHandler.DummyErrorStream)stream;
            e = d.getException();
            e.printStackTrace(new PrintWriter(writer));
            return;
        }
        traversal = (Traversal)req.getContext().get("traversal");
        printWriter = new PrintWriter(writer);
        try {
            stream.open();
            tuple = null;
            edgeCount = 0;
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            printWriter.println("<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns\" ");
            printWriter.println("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ");
            printWriter.print("xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns ");
            printWriter.println("http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd\">");
            printWriter.println("<graph id=\"G\" edgedefault=\"directed\">");
            block3: while (true) {
                tuple = stream.read();
                if (tuple.EOF) break;
                id = tuple.getString((Object)"node");
                if (traversal.isMultiCollection()) {
                    id = tuple.getString((Object)"collection") + "." + id;
                }
                writer.write("<node id=\"" + this.replace(id) + "\"");
                outfields = new ArrayList<Object>();
                for (Object key : tuple.fields.keySet()) {
                    if (key.equals("node") || key.equals("ancestors") || key.equals("collection")) continue;
                    outfields.add(key);
                }
                if (outfields.size() > 0) {
                    printWriter.println(">");
                    key = outfields.iterator();
                    while (key.hasNext()) {
                        nodeAttribute = (String)key.next();
                        o = tuple.get((Object)nodeAttribute);
                        if (o == null) continue;
                        printWriter.println("<data key=\"" + nodeAttribute + "\">" + o.toString() + "</data>");
                    }
                    printWriter.println("</node>");
                } else {
                    printWriter.println("/>");
                }
                if ((ancestors = tuple.getStrings((Object)"ancestors")) == null) continue;
                var14_16 = ancestors.iterator();
                while (true) {
                    if (var14_16.hasNext()) ** break;
                    continue block3;
                    ancestor = (String)var14_16.next();
                    writer.write("<edge id=\"" + ++edgeCount + "\" ");
                    writer.write(" source=\"" + this.replace(ancestor) + "\" ");
                    printWriter.println(" target=\"" + this.replace(id) + "\"/>");
                }
                break;
            }
            writer.write("</graph></graphml>");
        }
        finally {
            stream.close();
        }
    }

    private String replace(String s) {
        if (s.indexOf(">") > -1) {
            s = s.replace(">", "&gt;");
        }
        if (s.indexOf("<") > -1) {
            s = s.replace("<", "&lt;");
        }
        if (s.indexOf("\"") > -1) {
            s = s.replace("\"", "&quot;");
        }
        if (s.indexOf("'") > -1) {
            s = s.replace("'", "&apos;");
        }
        if (s.indexOf("&") > -1) {
            s = s.replace("&", "&amp;");
        }
        return s;
    }
}

