/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics.reporters;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrSlf4jReporter
extends SolrMetricReporter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String instancePrefix = null;
    private String logger = null;
    private List<String> filters = new ArrayList<String>();
    private Slf4jReporter reporter;

    public SolrSlf4jReporter(SolrMetricManager metricManager, String registryName) {
        super(metricManager, registryName);
    }

    public void setPrefix(String prefix) {
        this.instancePrefix = prefix;
    }

    public void setFilter(List<String> filters) {
        if (filters == null || filters.isEmpty()) {
            return;
        }
        this.filters.addAll(filters);
    }

    public void setFilter(String filter) {
        if (filter != null && !filter.isEmpty()) {
            this.filters.add(filter);
        }
    }

    public void setLogger(String logger) {
        this.logger = logger;
    }

    @Override
    protected void doInit() {
        this.instancePrefix = this.instancePrefix == null ? this.registryName : this.instancePrefix + "." + this.registryName;
        Slf4jReporter.Builder builder = Slf4jReporter.forRegistry((MetricRegistry)this.metricManager.registry(this.registryName)).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS);
        MetricFilter filter = !this.filters.isEmpty() ? new SolrMetricManager.PrefixFilter(this.filters) : MetricFilter.ALL;
        builder = builder.filter(filter);
        if (this.logger == null || this.logger.isEmpty()) {
            if (this.pluginInfo.attributes.containsKey("group")) {
                this.logger = SolrMetricManager.overridableRegistryName(this.pluginInfo.attributes.get("group"));
            } else if (this.pluginInfo.attributes.containsKey("registry")) {
                String reg = SolrMetricManager.overridableRegistryName(this.pluginInfo.attributes.get("registry"));
                String[] names = reg.split("\\.");
                this.logger = names.length < 2 ? reg : names[0] + "." + names[1];
            }
        }
        builder = builder.outputTo(LoggerFactory.getLogger((String)this.logger));
        this.reporter = builder.build();
        this.reporter.start((long)this.period, TimeUnit.SECONDS);
    }

    @Override
    protected void validate() throws IllegalStateException {
        if (this.period < 1) {
            throw new IllegalStateException("Init argument 'period' is in time unit 'seconds' and must be at least 1.");
        }
    }

    @Override
    public void close() throws IOException {
        if (this.reporter != null) {
            this.reporter.close();
        }
    }
}

