/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics.reporters;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ganglia.GangliaReporter;
import info.ganglia.gmetric4j.gmetric.GMetric;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricReporter;
import org.apache.solr.metrics.reporters.ReporterClientCache;

public class SolrGangliaReporter
extends SolrMetricReporter {
    private String host = null;
    private int port = -1;
    private boolean multicast;
    private String instancePrefix = null;
    private List<String> filters = new ArrayList<String>();
    private boolean testing;
    private GangliaReporter reporter;
    private static final ReporterClientCache<GMetric> serviceRegistry = new ReporterClientCache();
    GMetric ganglia = null;

    public SolrGangliaReporter(SolrMetricManager metricManager, String registryName) {
        super(metricManager, registryName);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setPrefix(String prefix) {
        this.instancePrefix = prefix;
    }

    public void setFilter(List<String> filters) {
        if (filters == null || filters.isEmpty()) {
            return;
        }
        this.filters.addAll(filters);
    }

    public void setFilter(String filter) {
        if (filter != null && !filter.isEmpty()) {
            this.filters.add(filter);
        }
    }

    public void setMulticast(boolean multicast) {
        this.multicast = multicast;
    }

    public void setTesting(boolean testing) {
        this.testing = testing;
    }

    void setGMetric(GMetric ganglia) {
        this.ganglia = ganglia;
    }

    @Override
    protected void doInit() {
        if (!this.testing) {
            this.start();
        }
    }

    @Override
    protected void validate() throws IllegalStateException {
        if (this.host == null) {
            throw new IllegalStateException("Init argument 'host' must be set to a valid Ganglia server name.");
        }
        if (this.port == -1) {
            throw new IllegalStateException("Init argument 'port' must be set to a valid Ganglia server port.");
        }
        if (this.period < 1) {
            throw new IllegalStateException("Init argument 'period' is in time unit 'seconds' and must be at least 1.");
        }
    }

    void start() {
        if (!this.testing) {
            String id = this.host + ":" + this.port + ":" + this.multicast;
            this.ganglia = serviceRegistry.getOrCreate(id, () -> new GMetric(this.host, this.port, this.multicast ? GMetric.UDPAddressingMode.MULTICAST : GMetric.UDPAddressingMode.UNICAST, 1));
            if (this.ganglia == null) {
                return;
            }
        }
        this.instancePrefix = this.instancePrefix == null ? this.registryName : this.instancePrefix + "." + this.registryName;
        GangliaReporter.Builder builder = GangliaReporter.forRegistry((MetricRegistry)this.metricManager.registry(this.registryName)).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).prefixedWith(this.instancePrefix);
        MetricFilter filter = !this.filters.isEmpty() ? new SolrMetricManager.PrefixFilter(this.filters) : MetricFilter.ALL;
        builder = builder.filter(filter);
        this.reporter = builder.build(this.ganglia);
        this.reporter.start((long)this.period, TimeUnit.SECONDS);
    }

    @Override
    public void close() throws IOException {
        if (this.reporter != null) {
            this.reporter.close();
        }
    }
}

