/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics;

import com.codahale.metrics.MetricRegistry;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.core.NodeConfig;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrCoreMetricManager
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SolrCore core;
    private final String tag;
    private final SolrMetricManager metricManager;
    private String registryName;
    private String collectionName;
    private String shardName;
    private String replicaName;
    private String leaderRegistryName;
    private boolean cloudMode;

    public SolrCoreMetricManager(SolrCore core) {
        this.core = core;
        this.tag = String.valueOf(core.hashCode());
        this.metricManager = core.getCoreContainer().getMetricManager();
        this.initCloudMode();
        this.registryName = SolrCoreMetricManager.createRegistryName(this.cloudMode, this.collectionName, this.shardName, this.replicaName, core.getName());
        this.leaderRegistryName = SolrCoreMetricManager.createLeaderRegistryName(this.cloudMode, this.collectionName, this.shardName);
    }

    private void initCloudMode() {
        CloudDescriptor cd = this.core.getCoreDescriptor().getCloudDescriptor();
        if (cd != null) {
            this.cloudMode = true;
            this.collectionName = this.core.getCoreDescriptor().getCollectionName();
            this.shardName = cd.getShardId();
            String coreName = this.core.getName();
            this.replicaName = SolrCoreMetricManager.parseReplicaName(this.collectionName, coreName);
            if (this.replicaName == null) {
                this.replicaName = cd.getCoreNodeName();
            }
        }
    }

    public void loadReporters() {
        NodeConfig nodeConfig = this.core.getCoreContainer().getConfig();
        PluginInfo[] pluginInfos = nodeConfig.getMetricsConfig().getMetricReporters();
        this.metricManager.loadReporters(pluginInfos, this.core.getResourceLoader(), this.tag, SolrInfoBean.Group.core, this.registryName);
        if (this.cloudMode) {
            this.metricManager.loadShardReporters(pluginInfos, this.core);
        }
    }

    public void afterCoreSetName() {
        String oldRegistryName = this.registryName;
        String oldLeaderRegistryName = this.leaderRegistryName;
        this.initCloudMode();
        this.registryName = SolrCoreMetricManager.createRegistryName(this.cloudMode, this.collectionName, this.shardName, this.replicaName, this.core.getName());
        this.leaderRegistryName = SolrCoreMetricManager.createLeaderRegistryName(this.cloudMode, this.collectionName, this.shardName);
        if (oldRegistryName.equals(this.registryName)) {
            return;
        }
        this.metricManager.closeReporters(oldRegistryName, this.tag);
        if (oldLeaderRegistryName != null) {
            this.metricManager.closeReporters(oldLeaderRegistryName, this.tag);
        }
        this.loadReporters();
    }

    public void registerMetricProducer(String scope, SolrMetricProducer producer) {
        if (scope == null || producer == null) {
            throw new IllegalArgumentException("registerMetricProducer() called with illegal arguments: scope = " + scope + ", producer = " + producer);
        }
        producer.initializeMetrics(this.metricManager, this.getRegistryName(), scope);
    }

    public MetricRegistry getRegistry() {
        if (this.registryName != null) {
            return this.metricManager.registry(this.registryName);
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.metricManager.closeReporters(this.getRegistryName(), this.tag);
        if (this.getLeaderRegistryName() != null) {
            this.metricManager.closeReporters(this.getLeaderRegistryName(), this.tag);
        }
    }

    public SolrCore getCore() {
        return this.core;
    }

    public String getRegistryName() {
        return this.registryName;
    }

    public String getLeaderRegistryName() {
        return this.leaderRegistryName;
    }

    public String getTag() {
        return this.tag;
    }

    public static String createRegistryName(boolean cloud, String collectionName, String shardName, String replicaName, String coreName) {
        if (cloud) {
            return SolrMetricManager.getRegistryName(SolrInfoBean.Group.core, collectionName, shardName, replicaName);
        }
        return SolrMetricManager.getRegistryName(SolrInfoBean.Group.core, coreName);
    }

    public static String createRegistryName(SolrCore aCore, String coreName) {
        CloudDescriptor cd = aCore.getCoreDescriptor().getCloudDescriptor();
        String replicaName = null;
        if (cd != null) {
            replicaName = SolrCoreMetricManager.parseReplicaName(cd.getCollectionName(), coreName);
        }
        return SolrCoreMetricManager.createRegistryName(cd != null, cd != null ? cd.getCollectionName() : null, cd != null ? cd.getShardId() : null, replicaName, coreName);
    }

    public static String parseReplicaName(String collectionName, String coreName) {
        if (collectionName == null || !coreName.startsWith(collectionName)) {
            return null;
        }
        if (coreName.length() > collectionName.length()) {
            String str = coreName.substring(collectionName.length() + 1);
            int pos = str.lastIndexOf("_replica");
            if (pos == -1) {
                return str;
            }
            return str.substring(pos + 1);
        }
        return null;
    }

    public static String createLeaderRegistryName(boolean cloud, String collectionName, String shardName) {
        if (cloud) {
            return SolrMetricManager.getRegistryName(SolrInfoBean.Group.collection, collectionName, shardName, "leader");
        }
        return null;
    }
}

