/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.legacy;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.solr.legacy.PointVectorStrategy;
import org.locationtech.spatial4j.distance.DistanceCalculator;
import org.locationtech.spatial4j.shape.Point;

public class DistanceValueSource
extends DoubleValuesSource {
    private PointVectorStrategy strategy;
    private final Point from;
    private final double multiplier;
    private final double nullValue;

    public DistanceValueSource(PointVectorStrategy strategy, Point from, double multiplier) {
        this.strategy = strategy;
        this.from = from;
        this.multiplier = multiplier;
        this.nullValue = strategy.getSpatialContext().isGeo() ? 180.0 * multiplier : Double.MAX_VALUE;
    }

    public String toString() {
        return "DistanceValueSource(" + (Object)((Object)this.strategy) + ", " + this.from + ")";
    }

    public DoubleValues getValues(LeafReaderContext readerContext, DoubleValues scores) throws IOException {
        final DoubleValues ptX = DoubleValuesSource.fromDoubleField((String)this.strategy.getFieldNameX()).getValues(readerContext, null);
        final DoubleValues ptY = DoubleValuesSource.fromDoubleField((String)this.strategy.getFieldNameY()).getValues(readerContext, null);
        final DistanceCalculator calculator = this.strategy.getSpatialContext().getDistCalc();
        return DoubleValues.withDefault((DoubleValues)new DoubleValues(){

            public double doubleValue() throws IOException {
                return calculator.distance(DistanceValueSource.this.from, ptX.doubleValue(), ptY.doubleValue()) * DistanceValueSource.this.multiplier;
            }

            public boolean advanceExact(int doc) throws IOException {
                return ptX.advanceExact(doc) && ptY.advanceExact(doc);
            }
        }, (double)this.nullValue);
    }

    public boolean needsScores() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DistanceValueSource that = (DistanceValueSource)((Object)o);
        if (!this.from.equals(that.from)) {
            return false;
        }
        if (!((Object)((Object)this.strategy)).equals((Object)that.strategy)) {
            return false;
        }
        return this.multiplier == that.multiplier;
    }

    public int hashCode() {
        return this.from.hashCode();
    }
}

