/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.legacy;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.spatial.ShapeValues;
import org.apache.lucene.spatial.ShapeValuesSource;
import org.apache.solr.legacy.BBoxStrategy;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;

class BBoxValueSource
extends ShapeValuesSource {
    private final BBoxStrategy strategy;

    public BBoxValueSource(BBoxStrategy strategy) {
        this.strategy = strategy;
    }

    public String toString() {
        return "bboxShape(" + this.strategy.getFieldName() + ")";
    }

    public ShapeValues getValues(LeafReaderContext readerContext) throws IOException {
        final DoubleValues minX = DoubleValuesSource.fromDoubleField((String)this.strategy.field_minX).getValues(readerContext, null);
        final DoubleValues minY = DoubleValuesSource.fromDoubleField((String)this.strategy.field_minY).getValues(readerContext, null);
        final DoubleValues maxX = DoubleValuesSource.fromDoubleField((String)this.strategy.field_maxX).getValues(readerContext, null);
        final DoubleValues maxY = DoubleValuesSource.fromDoubleField((String)this.strategy.field_maxY).getValues(readerContext, null);
        final Rectangle rect = this.strategy.getSpatialContext().makeRectangle(0.0, 0.0, 0.0, 0.0);
        return new ShapeValues(){

            public boolean advanceExact(int doc) throws IOException {
                return minX.advanceExact(doc) && maxX.advanceExact(doc) && minY.advanceExact(doc) && maxY.advanceExact(doc);
            }

            public Shape value() throws IOException {
                rect.reset(minX.doubleValue(), maxX.doubleValue(), minY.doubleValue(), maxY.doubleValue());
                return rect;
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BBoxValueSource that = (BBoxValueSource)((Object)o);
        return ((Object)((Object)this.strategy)).equals((Object)that.strategy);
    }

    public int hashCode() {
        return ((Object)((Object)this.strategy)).hashCode();
    }
}

