/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.highlight;

import java.io.IOException;
import java.text.BreakIterator;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.uhighlight.CustomSeparatorBreakIterator;
import org.apache.lucene.search.uhighlight.DefaultPassageFormatter;
import org.apache.lucene.search.uhighlight.LengthGoalBreakIterator;
import org.apache.lucene.search.uhighlight.PassageFormatter;
import org.apache.lucene.search.uhighlight.PassageScorer;
import org.apache.lucene.search.uhighlight.UnifiedHighlighter;
import org.apache.lucene.search.uhighlight.WholeBreakIterator;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.highlight.SolrHighlighter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.RTimerTree;
import org.apache.solr.util.plugin.PluginInfoInitialized;

public class UnifiedSolrHighlighter
extends SolrHighlighter
implements PluginInfoInitialized {
    protected static final String SNIPPET_SEPARATOR = "\u0000";
    private static final String[] ZERO_LEN_STR_ARRAY = new String[0];

    @Override
    public void init(PluginInfo info) {
    }

    @Override
    public NamedList<Object> doHighlighting(DocList docs, Query query, SolrQueryRequest req, String[] defaultFields) throws IOException {
        SolrParams params = req.getParams();
        if (!this.isHighlightingEnabled(params)) {
            return null;
        }
        int[] docIDs = this.toDocIDs(docs);
        String[] keys = this.getUniqueKeys(req.getSearcher(), docIDs);
        String[] fieldNames = this.getHighlightFields(query, req, defaultFields);
        int[] maxPassages = new int[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            maxPassages[i] = params.getFieldInt(fieldNames[i], "hl.snippets", 1);
        }
        UnifiedHighlighter highlighter = this.getHighlighter(req);
        Map snippets = highlighter.highlightFields(fieldNames, query, docIDs, maxPassages);
        return this.encodeSnippets(keys, fieldNames, snippets);
    }

    protected UnifiedHighlighter getHighlighter(SolrQueryRequest req) {
        return new SolrExtendedUnifiedHighlighter(req);
    }

    protected NamedList<Object> encodeSnippets(String[] keys, String[] fieldNames, Map<String, String[]> snippets) {
        SimpleOrderedMap list = new SimpleOrderedMap();
        for (int i = 0; i < keys.length; ++i) {
            SimpleOrderedMap summary = new SimpleOrderedMap();
            for (String field : fieldNames) {
                String snippet = snippets.get(field)[i];
                if (snippet == null) {
                    summary.add(field, (Object)ZERO_LEN_STR_ARRAY);
                    continue;
                }
                summary.add(field, (Object)snippet.split(SNIPPET_SEPARATOR));
            }
            list.add(keys[i], (Object)summary);
        }
        return list;
    }

    protected int[] toDocIDs(DocList docs) {
        int[] docIDs = new int[docs.size()];
        DocIterator iterator = docs.iterator();
        for (int i = 0; i < docIDs.length; ++i) {
            if (!iterator.hasNext()) {
                throw new AssertionError();
            }
            docIDs[i] = iterator.nextDoc();
        }
        if (iterator.hasNext()) {
            throw new AssertionError();
        }
        return docIDs;
    }

    protected String[] getUniqueKeys(SolrIndexSearcher searcher, int[] docIDs) throws IOException {
        IndexSchema schema = searcher.getSchema();
        SchemaField keyField = schema.getUniqueKeyField();
        if (keyField != null) {
            Set<String> selector = Collections.singleton(keyField.getName());
            String[] uniqueKeys = new String[docIDs.length];
            for (int i = 0; i < docIDs.length; ++i) {
                String id;
                int docid = docIDs[i];
                Document doc = searcher.doc(docid, selector);
                uniqueKeys[i] = id = schema.printableUniqueKey(doc);
            }
            return uniqueKeys;
        }
        return new String[docIDs.length];
    }

    protected static class SolrExtendedUnifiedHighlighter
    extends UnifiedHighlighter {
        protected static final Predicate<String> NOT_REQUIRED_FIELD_MATCH_PREDICATE = s -> true;
        protected final SolrParams params;
        protected final IndexSchema schema;
        protected final RTimerTree loadFieldValuesTimer;

        public SolrExtendedUnifiedHighlighter(SolrQueryRequest req) {
            super((IndexSearcher)req.getSearcher(), req.getSchema().getIndexAnalyzer());
            this.params = req.getParams();
            this.schema = req.getSchema();
            this.setMaxLength(this.params.getInt("hl.maxAnalyzedChars", SolrHighlighter.DEFAULT_MAX_CHARS));
            this.setCacheFieldValCharsThreshold(this.params.getInt("hl.cacheFieldValCharsThreshold", 524288));
            SolrQueryRequest request = SolrRequestInfo.getRequestInfo().getReq();
            RTimerTree timerTree = request.getRequestTimer() != null ? request.getRequestTimer() : new RTimerTree();
            this.loadFieldValuesTimer = timerTree.sub("loadFieldValues");
            this.loadFieldValuesTimer.pause();
        }

        protected UnifiedHighlighter.OffsetSource getOffsetSource(String field) {
            String sourceStr = this.params.getFieldParam(field, "hl.offsetSource");
            if (sourceStr != null) {
                return UnifiedHighlighter.OffsetSource.valueOf((String)sourceStr.toUpperCase(Locale.ROOT));
            }
            return super.getOffsetSource(field);
        }

        protected FieldInfo getFieldInfo(String field) {
            return ((SolrIndexSearcher)this.searcher).getFieldInfos().fieldInfo(field);
        }

        public int getMaxNoHighlightPassages(String field) {
            boolean defaultSummary = this.params.getFieldBool(field, "hl.defaultSummary", false);
            if (defaultSummary) {
                return -1;
            }
            return 0;
        }

        protected PassageFormatter getFormatter(String fieldName) {
            String preTag = this.params.getFieldParam(fieldName, "hl.tag.pre", this.params.getFieldParam(fieldName, "hl.simple.pre", "<em>"));
            String postTag = this.params.getFieldParam(fieldName, "hl.tag.post", this.params.getFieldParam(fieldName, "hl.simple.post", "</em>"));
            String ellipsis = this.params.getFieldParam(fieldName, "hl.tag.ellipsis", UnifiedSolrHighlighter.SNIPPET_SEPARATOR);
            String encoder = this.params.getFieldParam(fieldName, "hl.encoder", "simple");
            return new DefaultPassageFormatter(preTag, postTag, ellipsis, "html".equals(encoder));
        }

        protected PassageScorer getScorer(String fieldName) {
            float k1 = this.params.getFieldFloat(fieldName, "hl.score.k1", 1.2f);
            float b = this.params.getFieldFloat(fieldName, "hl.score.b", 0.75f);
            float pivot = this.params.getFieldFloat(fieldName, "hl.score.pivot", 87.0f);
            return new PassageScorer(k1, b, pivot);
        }

        protected BreakIterator getBreakIterator(String field) {
            int fragsize = this.params.getFieldInt(field, "hl.fragsize", 70);
            String type = this.params.getFieldParam(field, "hl.bs.type");
            if (fragsize == 0 || "WHOLE".equals(type)) {
                return new WholeBreakIterator();
            }
            if ("SEPARATOR".equals(type)) {
                char customSep = this.parseBiSepChar(this.params.getFieldParam(field, "hl.bs.separator"));
                return new CustomSeparatorBreakIterator(customSep);
            }
            String language = this.params.getFieldParam(field, "hl.bs.language");
            String country = this.params.getFieldParam(field, "hl.bs.country");
            String variant = this.params.getFieldParam(field, "hl.bs.variant");
            Locale locale = this.parseLocale(language, country, variant);
            BreakIterator baseBI = this.parseBreakIterator(type, locale);
            if (fragsize <= 1) {
                return baseBI;
            }
            return LengthGoalBreakIterator.createMinLength((BreakIterator)baseBI, (int)fragsize);
        }

        protected char parseBiSepChar(String sepChar) {
            if (sepChar == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "hl.bs.separator not passed");
            }
            if (sepChar.length() != 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "hl.bs.separator must be a single char but got: '" + sepChar + "'");
            }
            return sepChar.charAt(0);
        }

        protected BreakIterator parseBreakIterator(String type, Locale locale) {
            if (type == null || "SENTENCE".equals(type)) {
                return BreakIterator.getSentenceInstance(locale);
            }
            if ("LINE".equals(type)) {
                return BreakIterator.getLineInstance(locale);
            }
            if ("WORD".equals(type)) {
                return BreakIterator.getWordInstance(locale);
            }
            if ("CHARACTER".equals(type)) {
                return BreakIterator.getCharacterInstance(locale);
            }
            throw new IllegalArgumentException("Unknown hl.bs.type: " + type);
        }

        protected Locale parseLocale(String language, String country, String variant) {
            if (language == null && country == null && variant == null) {
                return Locale.ROOT;
            }
            if (language == null) {
                throw new IllegalArgumentException("language is required if country or variant is specified");
            }
            if (country == null && variant != null) {
                throw new IllegalArgumentException("To specify variant, country is required");
            }
            if (country != null && variant != null) {
                return new Locale(language, country, variant);
            }
            if (country != null) {
                return new Locale(language, country);
            }
            return new Locale(language);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List<CharSequence[]> loadFieldValues(String[] fields, DocIdSetIterator docIter, int cacheCharsThreshold) throws IOException {
            this.loadFieldValuesTimer.resume();
            try {
                List list = super.loadFieldValues(fields, docIter, cacheCharsThreshold);
                return list;
            }
            finally {
                this.loadFieldValuesTimer.pause();
            }
        }

        protected boolean shouldHandleMultiTermQuery(String field) {
            return this.params.getFieldBool(field, "hl.highlightMultiTerm", true);
        }

        protected boolean shouldHighlightPhrasesStrictly(String field) {
            return this.params.getFieldBool(field, "hl.usePhraseHighlighter", true);
        }

        protected Predicate<String> getFieldMatcher(String field) {
            if (this.params.getFieldBool(field, "hl.requireFieldMatch", false)) {
                return field::equals;
            }
            return NOT_REQUIRED_FIELD_MATCH_PREDICATE;
        }
    }
}

