/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.api.Api;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.response.RequestStatusState;
import org.apache.solr.client.solrj.util.SolrIdentifierValidator;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.OverseerCollectionMessageHandler;
import org.apache.solr.cloud.OverseerSolrResponse;
import org.apache.solr.cloud.OverseerTaskQueue;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.overseer.SliceMutator;
import org.apache.solr.cloud.rule.ReplicaAssigner;
import org.apache.solr.cloud.rule.Rule;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterProperties;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCmdExecutor;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionAdminParams;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CloudConfig;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.apache.solr.core.snapshots.CollectionSnapshotMetaData;
import org.apache.solr.core.snapshots.SolrSnapshotManager;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.ClusterStatus;
import org.apache.solr.handler.admin.CollectionHandlerApi;
import org.apache.solr.handler.admin.RebalanceLeaders;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionsHandler
extends RequestHandlerBase
implements PermissionNameProvider {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final CoreContainer coreContainer;
    private final CollectionHandlerApi v2Handler;
    static final Set<String> KNOWN_ROLES = ImmutableSet.of((Object)"overseer");
    public static long DEFAULT_COLLECTION_OP_TIMEOUT = 180000L;
    public static final String SYSTEM_COLL = ".system";
    public static final List<String> MODIFIABLE_COLL_PROPS = Arrays.asList("rule", "snitch", "replicationFactor", "maxShardsPerNode", "autoAddReplicas", "collection.configName");

    public CollectionsHandler() {
        this.coreContainer = null;
        this.v2Handler = new CollectionHandlerApi(this);
    }

    public CollectionsHandler(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
        this.v2Handler = new CollectionHandlerApi(this);
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext ctx) {
        String action = ctx.getParams().get("action");
        if (action == null) {
            return PermissionNameProvider.Name.COLL_READ_PERM;
        }
        CollectionParams.CollectionAction collectionAction = CollectionParams.CollectionAction.get((String)action);
        if (collectionAction == null) {
            return null;
        }
        return collectionAction.isWrite ? PermissionNameProvider.Name.COLL_EDIT_PERM : PermissionNameProvider.Name.COLL_READ_PERM;
    }

    @Override
    public final void init(NamedList args) {
    }

    public CoreContainer getCoreContainer() {
        return this.coreContainer;
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        CollectionParams.CollectionAction action;
        CoreContainer cores = this.getCoreContainer();
        if (cores == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core container instance missing");
        }
        if (!cores.isZooKeeperAware()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Solr instance is not running in SolrCloud mode.");
        }
        SolrParams params = req.getParams();
        String a = params.get("action");
        if (a != null) {
            action = CollectionParams.CollectionAction.get((String)a);
            if (action == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown action: " + a);
            }
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "action is a required param");
        }
        CollectionOperation operation = CollectionOperation.get(action);
        log.info("Invoked Collection Action :{} with params {} and sendToOCPQueue={}", new Object[]{action.toLower(), req.getParamString(), operation.sendToOCPQueue});
        this.invokeAction(req, rsp, cores, action, operation);
        rsp.setHttpCaching(false);
    }

    void invokeAction(SolrQueryRequest req, SolrQueryResponse rsp, CoreContainer cores, CollectionParams.CollectionAction action, CollectionOperation operation) throws Exception {
        if (!this.coreContainer.isZooKeeperAware()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid request. collections can be accessed only in SolrCloud mode");
        }
        SolrResponse response = null;
        Map<String, Object> props = operation.execute(req, rsp, this);
        String asyncId = req.getParams().get("async");
        if (props != null) {
            if (asyncId != null) {
                props.put("async", asyncId);
            }
            props.put("operation", operation.action.toLower());
            ZkNodeProps zkProps = new ZkNodeProps(props);
            if (operation.sendToOCPQueue) {
                response = this.handleResponse(operation.action.toLower(), zkProps, rsp, operation.timeOut);
            } else {
                Overseer.getStateUpdateQueue(this.coreContainer.getZkController().getZkClient()).offer(Utils.toJSON(props));
            }
            String collectionName = zkProps.getStr("name");
            if (action.equals((Object)CollectionParams.CollectionAction.CREATE) && asyncId == null && rsp.getException() == null) {
                CollectionsHandler.waitForActiveCollection(collectionName, zkProps, cores, response);
            }
        }
    }

    void handleResponse(String operation, ZkNodeProps m, SolrQueryResponse rsp) throws KeeperException, InterruptedException {
        this.handleResponse(operation, m, rsp, DEFAULT_COLLECTION_OP_TIMEOUT);
    }

    private SolrResponse handleResponse(String operation, ZkNodeProps m, SolrQueryResponse rsp, long timeout) throws KeeperException, InterruptedException {
        long time = System.nanoTime();
        if (m.containsKey("async") && m.get("async") != null) {
            String asyncId = m.getStr("async");
            if (asyncId.equals("-1")) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "requestid can not be -1. It is reserved for cleanup purposes.");
            }
            NamedList r = new NamedList();
            if (this.coreContainer.getZkController().getOverseerCompletedMap().contains(asyncId) || this.coreContainer.getZkController().getOverseerFailureMap().contains(asyncId) || this.coreContainer.getZkController().getOverseerRunningMap().contains(asyncId) || this.overseerCollectionQueueContains(asyncId)) {
                r.add("error", (Object)"Task with the same requestid already exists.");
            } else {
                this.coreContainer.getZkController().getOverseerCollectionQueue().offer(Utils.toJSON((Object)m));
            }
            r.add("requestid", (Object)((String)m.get("async")));
            OverseerSolrResponse response = new OverseerSolrResponse(r);
            rsp.getValues().addAll(response.getResponse());
            return response;
        }
        OverseerTaskQueue.QueueEvent event = this.coreContainer.getZkController().getOverseerCollectionQueue().offer(Utils.toJSON((Object)m), timeout);
        if (event.getBytes() != null) {
            SolrResponse response = SolrResponse.deserialize((byte[])event.getBytes());
            rsp.getValues().addAll(response.getResponse());
            SimpleOrderedMap exp = (SimpleOrderedMap)response.getResponse().get("exception");
            if (exp != null) {
                Integer code = (Integer)exp.get("rspCode");
                rsp.setException((Exception)((Object)new SolrException(code != null && code != -1 ? SolrException.ErrorCode.getErrorCode((int)code) : SolrException.ErrorCode.SERVER_ERROR, (String)exp.get("msg"))));
            }
            return response;
        }
        if (System.nanoTime() - time >= TimeUnit.NANOSECONDS.convert(timeout, TimeUnit.MILLISECONDS)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, operation + " the collection time out:" + timeout / 1000L + "s");
        }
        if (event.getWatchedEvent() != null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, operation + " the collection error [Watcher fired on path: " + event.getWatchedEvent().getPath() + " state: " + event.getWatchedEvent().getState() + " type " + event.getWatchedEvent().getType() + "]");
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, operation + " the collection unknown case");
    }

    private boolean overseerCollectionQueueContains(String asyncId) throws KeeperException, InterruptedException {
        OverseerTaskQueue collectionQueue = this.coreContainer.getZkController().getOverseerCollectionQueue();
        return collectionQueue.containsTaskWithRequestId("async", asyncId);
    }

    private static Map<String, Object> copyPropertiesWithPrefix(SolrParams params, Map<String, Object> props, String prefix) {
        Iterator iter = params.getParameterNamesIterator();
        while (iter.hasNext()) {
            String param = (String)iter.next();
            if (!param.startsWith(prefix)) continue;
            props.put(param, params.get(param));
        }
        return props;
    }

    public static ModifiableSolrParams params(String ... params) {
        ModifiableSolrParams msp = new ModifiableSolrParams();
        for (int i = 0; i < params.length; i += 2) {
            msp.add(params[i], new String[]{params[i + 1]});
        }
        return msp;
    }

    @Override
    public String getDescription() {
        return "Manage SolrCloud Collections";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.ADMIN;
    }

    private static void createSysConfigSet(CoreContainer coreContainer) throws KeeperException, InterruptedException {
        SolrZkClient zk = coreContainer.getZkController().getZkStateReader().getZkClient();
        ZkCmdExecutor cmdExecutor = new ZkCmdExecutor(zk.getZkClientTimeout());
        cmdExecutor.ensureExists("/configs", zk);
        cmdExecutor.ensureExists("/configs/.system", zk);
        try {
            String path = "/configs/.system/schema.xml";
            byte[] data = IOUtils.toByteArray((InputStream)CollectionsHandler.class.getResourceAsStream("/SystemCollectionSchema.xml"));
            assert (data != null && data.length > 0);
            cmdExecutor.ensureExists(path, data, CreateMode.PERSISTENT, zk);
            path = "/configs/.system/solrconfig.xml";
            data = IOUtils.toByteArray((InputStream)CollectionsHandler.class.getResourceAsStream("/SystemCollectionSolrConfig.xml"));
            assert (data != null && data.length > 0);
            cmdExecutor.ensureExists(path, data, CreateMode.PERSISTENT, zk);
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    private static void addStatusToResponse(NamedList<Object> results, RequestStatusState state, String msg) {
        SimpleOrderedMap status = new SimpleOrderedMap();
        status.add("state", (Object)state.getKey());
        status.add("msg", (Object)msg);
        results.add("status", (Object)status);
    }

    private static void forceLeaderElection(SolrQueryRequest req, CollectionsHandler handler) {
        ClusterState clusterState = handler.coreContainer.getZkController().getClusterState();
        String collectionName = req.getParams().required().get("collection");
        String sliceId = req.getParams().required().get("shard");
        log.info("Force leader invoked, state: {}", (Object)clusterState);
        DocCollection collection = clusterState.getCollection(collectionName);
        Slice slice = collection.getSlice(sliceId);
        if (slice == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No shard with name " + sliceId + " exists for collection " + collectionName);
        }
        try {
            Replica leader = slice.getLeader();
            if (leader != null && leader.getState() == Replica.State.ACTIVE) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "The shard already has an active leader. Force leader is not applicable. State: " + slice);
            }
            String lirPath = handler.coreContainer.getZkController().getLeaderInitiatedRecoveryZnodePath(collectionName, sliceId);
            if (handler.coreContainer.getZkController().getZkClient().exists(lirPath, true).booleanValue()) {
                StringBuilder sb = new StringBuilder();
                handler.coreContainer.getZkController().getZkClient().printLayout(lirPath, 4, sb);
                log.info("Cleaning out LIR data, which was: {}", (Object)sb);
                handler.coreContainer.getZkController().getZkClient().clean(lirPath);
            }
            for (Replica rep : slice.getReplicas()) {
                if (!clusterState.getLiveNodes().contains(rep.getNodeName())) continue;
                ShardHandler shardHandler = handler.coreContainer.getShardHandlerFactory().getShardHandler();
                ModifiableSolrParams params = new ModifiableSolrParams();
                params.set("action", new String[]{CoreAdminParams.CoreAdminAction.FORCEPREPAREFORLEADERSHIP.toString()});
                params.set("core", new String[]{rep.getStr("core")});
                String nodeName = rep.getNodeName();
                OverseerCollectionMessageHandler.sendShardRequest(nodeName, params, shardHandler, null, null, "/admin/cores", handler.coreContainer.getZkController().getZkStateReader());
            }
            boolean success = false;
            for (int i = 0; i < 9; ++i) {
                Thread.sleep(5000L);
                clusterState = handler.coreContainer.getZkController().getClusterState();
                collection = clusterState.getCollection(collectionName);
                slice = collection.getSlice(sliceId);
                if (slice.getLeader() != null && slice.getLeader().getState() == Replica.State.ACTIVE) {
                    success = true;
                    break;
                }
                log.warn("Force leader attempt {}. Waiting 5 secs for an active leader. State of the slice: {}", (Object)(i + 1), (Object)slice);
            }
            if (success) {
                log.info("Successfully issued FORCELEADER command for collection: {}, shard: {}", (Object)collectionName, (Object)sliceId);
            } else {
                log.info("Couldn't successfully force leader, collection: {}, shard: {}. Cluster state: {}", new Object[]{collectionName, sliceId, clusterState});
            }
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error executing FORCELEADER operation for collection: " + collectionName + " shard: " + sliceId, (Throwable)e);
        }
    }

    private static void waitForActiveCollection(String collectionName, ZkNodeProps message, CoreContainer cc, SolrResponse response) throws KeeperException, InterruptedException {
        if (response.getResponse().get("exception") != null) {
            log.info("Not waiting for active collection due to exception: " + response.getResponse().get("exception"));
            return;
        }
        if (response.getResponse().get("failure") != null) {
            // empty if block
        }
        String replicaNotAlive = null;
        String replicaState = null;
        String nodeNotLive = null;
        CloudConfig ccfg = cc.getConfig().getCloudConfig();
        Integer numRetries = ccfg.getCreateCollectionWaitTimeTillActive();
        Boolean checkLeaderOnly = ccfg.isCreateCollectionCheckLeaderActive();
        log.info("Wait for new collection to be active for at most " + numRetries + " seconds. Check all shard " + (checkLeaderOnly != false ? "leaders" : "replicas"));
        ZkStateReader zkStateReader = cc.getZkController().getZkStateReader();
        for (int i = 0; i < numRetries; ++i) {
            ClusterState clusterState = zkStateReader.getClusterState();
            DocCollection docCollection = clusterState.getCollectionOrNull(collectionName);
            if (docCollection != null && docCollection.getSlices() != null) {
                Collection shards = docCollection.getSlices();
                replicaNotAlive = null;
                for (Slice shard : shards) {
                    ArrayList<Replica> replicas;
                    if (!checkLeaderOnly.booleanValue()) {
                        replicas = shard.getReplicas();
                    } else {
                        replicas = new ArrayList<Replica>();
                        replicas.add(shard.getLeader());
                    }
                    for (Replica replica : replicas) {
                        String state = replica.getStr("state");
                        log.debug("Checking replica status, collection={} replica={} state={}", new Object[]{collectionName, replica.getCoreUrl(), state});
                        if (clusterState.liveNodesContain(replica.getNodeName()) && state.equals(Replica.State.ACTIVE.toString())) continue;
                        replicaNotAlive = replica.getCoreUrl();
                        nodeNotLive = replica.getNodeName();
                        replicaState = state;
                        break;
                    }
                    if (replicaNotAlive == null) continue;
                    break;
                }
                if (replicaNotAlive == null) {
                    return;
                }
            }
            Thread.sleep(1000L);
        }
        if (nodeNotLive != null && replicaState != null) {
            log.error("Timed out waiting for new collection's replicas to become ACTIVE " + (replicaState.equals(Replica.State.ACTIVE.toString()) ? "node " + nodeNotLive + " is not live" : "replica " + replicaNotAlive + " is in state of " + replicaState.toString()) + " with timeout=" + numRetries);
        } else {
            log.error("Timed out waiting for new collection's replicas to become ACTIVE with timeout=" + numRetries);
        }
    }

    public static void verifyRuleParams(CoreContainer cc, Map<String, Object> m) {
        List l = (List)m.get("rule");
        if (l != null) {
            for (Object o : l) {
                Map map = (Map)o;
                try {
                    new Rule(map);
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error in rule " + m, (Throwable)e);
                }
            }
        }
        ReplicaAssigner.verifySnitchConf(cc, (List)m.get("snitch"));
    }

    private static Map<String, Object> addMapObject(Map<String, Object> props, String key) {
        Object v = props.get(key);
        if (v == null) {
            return props;
        }
        ArrayList<String> val = new ArrayList<String>();
        if (v instanceof String[]) {
            val.addAll(Arrays.asList((String[])v));
        } else {
            val.add(v.toString());
        }
        if (val.size() > 0) {
            ArrayList<Map> l = new ArrayList<Map>();
            for (String rule : val) {
                l.add(Rule.parseRule(rule));
            }
            props.put(key, l);
        }
        return props;
    }

    private static void verifyShardsParam(String shardsParam) {
        for (String shard : shardsParam.split(",")) {
            SolrIdentifierValidator.validateShardName((String)shard);
        }
    }

    @Override
    public Collection<Api> getApis() {
        return this.v2Handler.getApis();
    }

    @Override
    public Boolean registerV2() {
        return Boolean.TRUE;
    }

    static interface CollectionOp {
        public Map<String, Object> execute(SolrQueryRequest var1, SolrQueryResponse var2, CollectionsHandler var3) throws Exception;
    }

    static enum CollectionOperation implements CollectionOp
    {
        CREATE_OP(CollectionParams.CollectionAction.CREATE, (req, rsp, h) -> {
            Map props = req.getParams().required().getAll(null, new String[]{"name"});
            props.put("fromApi", "true");
            req.getParams().getAll(props, new String[]{"replicationFactor", "collection.configName", "numShards", "maxShardsPerNode", "createNodeSet", "createNodeSet.shuffle", "shards", "stateFormat", "autoAddReplicas", "rule", "snitch", "pullReplicas", "tlogReplicas", "nrtReplicas", "policy"});
            if (props.get("stateFormat") == null) {
                props.put("stateFormat", "2");
            }
            CollectionsHandler.addMapObject(props, "rule");
            CollectionsHandler.addMapObject(props, "snitch");
            CollectionsHandler.verifyRuleParams(h.coreContainer, props);
            String collectionName = SolrIdentifierValidator.validateCollectionName((String)((String)props.get("name")));
            String shardsParam = (String)props.get("shards");
            if (StringUtils.isNotEmpty((String)shardsParam)) {
                CollectionsHandler.verifyShardsParam(shardsParam);
            }
            if (CollectionsHandler.SYSTEM_COLL.equals(collectionName)) {
                props.put("numShards", 1);
                props.remove("shards");
                CollectionsHandler.createSysConfigSet(h.coreContainer);
            }
            CollectionsHandler.copyPropertiesWithPrefix(req.getParams(), props, "property.");
            return CollectionsHandler.copyPropertiesWithPrefix(req.getParams(), props, "router.");
        }),
        DELETE_OP(CollectionParams.CollectionAction.DELETE, (req, rsp, h) -> req.getParams().required().getAll(null, new String[]{"name"})),
        RELOAD_OP(CollectionParams.CollectionAction.RELOAD, (req, rsp, h) -> req.getParams().required().getAll(null, new String[]{"name"})),
        SYNCSHARD_OP(CollectionParams.CollectionAction.SYNCSHARD, (req, rsp, h) -> {
            String collection = req.getParams().required().get("collection");
            String shard = req.getParams().required().get("shard");
            ClusterState clusterState = h.coreContainer.getZkController().getClusterState();
            DocCollection docCollection = clusterState.getCollection(collection);
            Replica leaderProps = docCollection.getLeader(shard);
            ZkCoreNodeProps nodeProps = new ZkCoreNodeProps((ZkNodeProps)leaderProps);
            try (HttpSolrClient client = ((HttpSolrClient.Builder)((HttpSolrClient.Builder)new HttpSolrClient.Builder(nodeProps.getBaseUrl()).withConnectionTimeout(15000)).withSocketTimeout(60000)).build();){
                CoreAdminRequest.RequestSyncShard reqSyncShard = new CoreAdminRequest.RequestSyncShard();
                reqSyncShard.setCollection(collection);
                reqSyncShard.setShard(shard);
                reqSyncShard.setCoreName(nodeProps.getCoreName());
                client.request((SolrRequest)reqSyncShard);
            }
            return null;
        }),
        CREATEALIAS_OP(CollectionParams.CollectionAction.CREATEALIAS, (req, rsp, h) -> {
            SolrIdentifierValidator.validateAliasName((String)req.getParams().get("name"));
            return req.getParams().required().getAll(null, new String[]{"name", "collections"});
        }),
        DELETEALIAS_OP(CollectionParams.CollectionAction.DELETEALIAS, (req, rsp, h) -> req.getParams().required().getAll(null, new String[]{"name"})),
        LISTALIASES_OP(CollectionParams.CollectionAction.LISTALIASES, (req, rsp, h) -> {
            ZkStateReader zkStateReader = h.coreContainer.getZkController().getZkStateReader();
            Aliases aliases = zkStateReader.getAliases();
            if (aliases != null) {
                rsp.getValues().add("aliases", (Object)aliases.getCollectionAliasMap());
            }
            return null;
        }),
        SPLITSHARD_OP(CollectionParams.CollectionAction.SPLITSHARD, DEFAULT_COLLECTION_OP_TIMEOUT * 5L, true, (req, rsp, h) -> {
            String name = req.getParams().required().get("collection");
            String shard = req.getParams().get("shard");
            String rangesStr = req.getParams().get("ranges");
            String splitKey = req.getParams().get("split.key");
            if (splitKey == null && shard == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "At least one of shard, or split.key should be specified.");
            }
            if (splitKey != null && shard != null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Only one of 'shard' or 'split.key' should be specified");
            }
            if (splitKey != null && rangesStr != null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Only one of 'ranges' or 'split.key' should be specified");
            }
            Map map = req.getParams().getAll(null, new String[]{"collection", "shard", "split.key", "ranges"});
            return CollectionsHandler.copyPropertiesWithPrefix(req.getParams(), map, "property.");
        }),
        DELETESHARD_OP(CollectionParams.CollectionAction.DELETESHARD, (req, rsp, h) -> {
            Map map = req.getParams().required().getAll(null, new String[]{"collection", "shard"});
            req.getParams().getAll(map, new String[]{"deleteIndex", "deleteDataDir", "deleteInstanceDir"});
            return map;
        }),
        FORCELEADER_OP(CollectionParams.CollectionAction.FORCELEADER, (req, rsp, h) -> {
            CollectionsHandler.forceLeaderElection(req, h);
            return null;
        }),
        CREATESHARD_OP(CollectionParams.CollectionAction.CREATESHARD, (req, rsp, h) -> {
            Map map = req.getParams().required().getAll(null, new String[]{"collection", "shard"});
            ClusterState clusterState = h.coreContainer.getZkController().getClusterState();
            String newShardName = SolrIdentifierValidator.validateShardName((String)req.getParams().get("shard"));
            if (!"implicit".equals(((Map)clusterState.getCollection(req.getParams().get("collection")).get("router")).get("name"))) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "shards can be added only to 'implicit' collections");
            }
            req.getParams().getAll(map, new String[]{"replicationFactor", "createNodeSet"});
            return CollectionsHandler.copyPropertiesWithPrefix(req.getParams(), map, "property.");
        }),
        DELETEREPLICA_OP(CollectionParams.CollectionAction.DELETEREPLICA, (req, rsp, h) -> {
            Map map = req.getParams().required().getAll(null, new String[]{"collection"});
            return req.getParams().getAll(map, new String[]{"deleteIndex", "deleteDataDir", "deleteInstanceDir", "count", "replica", "shard", "onlyIfDown"});
        }),
        MIGRATE_OP(CollectionParams.CollectionAction.MIGRATE, (req, rsp, h) -> {
            Map map = req.getParams().required().getAll(null, new String[]{"collection", "split.key", "target.collection"});
            return req.getParams().getAll(map, new String[]{"forward.timeout"});
        }),
        ADDROLE_OP(CollectionParams.CollectionAction.ADDROLE, (req, rsp, h) -> {
            Map map = req.getParams().required().getAll(null, new String[]{"role", "node"});
            if (!KNOWN_ROLES.contains(map.get("role"))) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown role. Supported roles are ," + KNOWN_ROLES);
            }
            return map;
        }),
        REMOVEROLE_OP(CollectionParams.CollectionAction.REMOVEROLE, (req, rsp, h) -> {
            Map map = req.getParams().required().getAll(null, new String[]{"role", "node"});
            if (!KNOWN_ROLES.contains(map.get("role"))) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown role. Supported roles are ," + KNOWN_ROLES);
            }
            return map;
        }),
        CLUSTERPROP_OP(CollectionParams.CollectionAction.CLUSTERPROP, (req, rsp, h) -> {
            String name = req.getParams().required().get("name");
            String val = req.getParams().get("val");
            ClusterProperties cp = new ClusterProperties(h.coreContainer.getZkController().getZkClient());
            cp.setClusterProperty(name, val);
            return null;
        }),
        REQUESTSTATUS_OP(CollectionParams.CollectionAction.REQUESTSTATUS, (req, rsp, h) -> {
            byte[] mapEntry;
            req.getParams().required().check(new String[]{"requestid"});
            CoreContainer coreContainer1 = h.coreContainer;
            String requestId = req.getParams().get("requestid");
            ZkController zkController = coreContainer1.getZkController();
            NamedList results = new NamedList();
            if (zkController.getOverseerCompletedMap().contains(requestId)) {
                mapEntry = zkController.getOverseerCompletedMap().get(requestId);
                rsp.getValues().addAll(SolrResponse.deserialize((byte[])mapEntry).getResponse());
                CollectionsHandler.addStatusToResponse((NamedList<Object>)results, RequestStatusState.COMPLETED, "found [" + requestId + "] in completed tasks");
            } else if (zkController.getOverseerFailureMap().contains(requestId)) {
                mapEntry = zkController.getOverseerFailureMap().get(requestId);
                rsp.getValues().addAll(SolrResponse.deserialize((byte[])mapEntry).getResponse());
                CollectionsHandler.addStatusToResponse((NamedList<Object>)results, RequestStatusState.FAILED, "found [" + requestId + "] in failed tasks");
            } else if (zkController.getOverseerRunningMap().contains(requestId)) {
                CollectionsHandler.addStatusToResponse((NamedList<Object>)results, RequestStatusState.RUNNING, "found [" + requestId + "] in running tasks");
            } else if (h.overseerCollectionQueueContains(requestId)) {
                CollectionsHandler.addStatusToResponse((NamedList<Object>)results, RequestStatusState.SUBMITTED, "found [" + requestId + "] in submitted tasks");
            } else {
                CollectionsHandler.addStatusToResponse((NamedList<Object>)results, RequestStatusState.NOT_FOUND, "Did not find [" + requestId + "] in any tasks queue");
            }
            OverseerSolrResponse response = new OverseerSolrResponse(results);
            rsp.getValues().addAll(response.getResponse());
            return null;
        }),
        DELETESTATUS_OP(CollectionParams.CollectionAction.DELETESTATUS, new CollectionOp(){

            @Override
            public Map<String, Object> execute(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                CoreContainer coreContainer = h.coreContainer;
                String requestId = req.getParams().get("requestid");
                ZkController zkController = coreContainer.getZkController();
                Boolean flush = req.getParams().getBool("flush", false);
                if (requestId == null && !flush.booleanValue()) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Either requestid or flush parameter must be specified.");
                }
                if (requestId != null && flush.booleanValue()) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Both requestid and flush parameters can not be specified together.");
                }
                if (flush.booleanValue()) {
                    zkController.getOverseerCompletedMap().clear();
                    zkController.getOverseerFailureMap().clear();
                    rsp.getValues().add("status", (Object)"successfully cleared stored collection api responses");
                    return null;
                }
                if (zkController.getOverseerCompletedMap().remove(requestId)) {
                    rsp.getValues().add("status", (Object)("successfully removed stored response for [" + requestId + "]"));
                } else if (zkController.getOverseerFailureMap().remove(requestId)) {
                    rsp.getValues().add("status", (Object)("successfully removed stored response for [" + requestId + "]"));
                } else {
                    rsp.getValues().add("status", (Object)("[" + requestId + "] not found in stored responses"));
                }
                return null;
            }
        }),
        ADDREPLICA_OP(CollectionParams.CollectionAction.ADDREPLICA, (req, rsp, h) -> {
            Map props = req.getParams().getAll(null, new String[]{"collection", "node", "shard", "_route_", "name", "instanceDir", "dataDir", "ulogDir", "type"});
            return CollectionsHandler.copyPropertiesWithPrefix(req.getParams(), props, "property.");
        }),
        OVERSEERSTATUS_OP(CollectionParams.CollectionAction.OVERSEERSTATUS, (req, rsp, h) -> new LinkedHashMap()),
        LIST_OP(CollectionParams.CollectionAction.LIST, (req, rsp, h) -> {
            NamedList results = new NamedList();
            Map collections = h.coreContainer.getZkController().getZkStateReader().getClusterState().getCollectionsMap();
            ArrayList collectionList = new ArrayList(collections.keySet());
            results.add("collections", collectionList);
            OverseerSolrResponse response = new OverseerSolrResponse(results);
            rsp.getValues().addAll(response.getResponse());
            return null;
        }),
        CLUSTERSTATUS_OP(CollectionParams.CollectionAction.CLUSTERSTATUS, (req, rsp, h) -> {
            Map all = req.getParams().getAll(null, new String[]{"collection", "shard", "_route_"});
            new ClusterStatus(h.coreContainer.getZkController().getZkStateReader(), new ZkNodeProps(all)).getClusterStatus(rsp.getValues());
            return null;
        }),
        ADDREPLICAPROP_OP(CollectionParams.CollectionAction.ADDREPLICAPROP, (req, rsp, h) -> {
            Map map = req.getParams().required().getAll(null, new String[]{"collection", "property", "shard", "replica", "property.value"});
            req.getParams().getAll(map, new String[]{"shardUnique"});
            String property = (String)map.get("property");
            if (!property.startsWith("property.")) {
                property = "property." + property;
            }
            boolean uniquePerSlice = Boolean.parseBoolean((String)map.get("shardUnique"));
            if (StringUtils.isNotBlank((String)((String)map.get("shardUnique"))) && SliceMutator.SLICE_UNIQUE_BOOLEAN_PROPERTIES.contains(property.toLowerCase(Locale.ROOT)) && !uniquePerSlice) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Overseer replica property command received for property " + property + " with the " + "shardUnique" + " parameter set to something other than 'true'. No action taken.");
            }
            return map;
        }),
        DELETEREPLICAPROP_OP(CollectionParams.CollectionAction.DELETEREPLICAPROP, (req, rsp, h) -> {
            Map map = req.getParams().required().getAll(null, new String[]{"collection", "property", "shard", "replica"});
            return req.getParams().getAll(map, new String[]{"property"});
        }),
        BALANCESHARDUNIQUE_OP(CollectionParams.CollectionAction.BALANCESHARDUNIQUE, (req, rsp, h) -> {
            Map map = req.getParams().required().getAll(null, new String[]{"collection", "property"});
            Boolean shardUnique = Boolean.parseBoolean(req.getParams().get("shardUnique"));
            String prop = req.getParams().get("property").toLowerCase(Locale.ROOT);
            if (!StringUtils.startsWith((String)prop, (String)"property.")) {
                prop = "property." + prop;
            }
            if (!shardUnique.booleanValue() && !SliceMutator.SLICE_UNIQUE_BOOLEAN_PROPERTIES.contains(prop)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Balancing properties amongst replicas in a slice requires that the property be pre-defined as a unique property (e.g. 'preferredLeader') or that 'shardUnique' be set to 'true'.  Property: " + prop + " shardUnique: " + Boolean.toString(shardUnique));
            }
            return req.getParams().getAll(map, new String[]{"onlyactivenodes", "shardUnique"});
        }),
        REBALANCELEADERS_OP(CollectionParams.CollectionAction.REBALANCELEADERS, (req, rsp, h) -> {
            new RebalanceLeaders(req, rsp, h).execute();
            return null;
        }),
        MODIFYCOLLECTION_OP(CollectionParams.CollectionAction.MODIFYCOLLECTION, (req, rsp, h) -> {
            Map m = req.getParams().getAll(null, MODIFIABLE_COLL_PROPS);
            if (m.isEmpty()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, StrUtils.formatString((String)"no supported values provided rule, snitch, maxShardsPerNode, replicationFactor, collection.configName", (Object[])new Object[0]));
            }
            req.getParams().required().getAll(m, new String[]{"collection"});
            CollectionsHandler.addMapObject(m, "rule");
            CollectionsHandler.addMapObject(m, "snitch");
            for (String prop : MODIFIABLE_COLL_PROPS) {
                DocCollection.verifyProp((Map)m, (String)prop);
            }
            CollectionsHandler.verifyRuleParams(h.coreContainer, m);
            return m;
        }),
        MIGRATESTATEFORMAT_OP(CollectionParams.CollectionAction.MIGRATESTATEFORMAT, (req, rsp, h) -> req.getParams().required().getAll(null, new String[]{"collection"})),
        BACKUP_OP(CollectionParams.CollectionAction.BACKUP, (req, rsp, h) -> {
            req.getParams().required().check(new String[]{"name", "collection"});
            String collectionName = req.getParams().get("collection");
            ClusterState clusterState = h.coreContainer.getZkController().getClusterState();
            if (!clusterState.hasCollection(collectionName)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection '" + collectionName + "' does not exist, no action taken.");
            }
            CoreContainer cc = h.coreContainer;
            String repo = req.getParams().get("repository");
            BackupRepository repository = cc.newBackupRepository(Optional.ofNullable(repo));
            String location = repository.getBackupLocation(req.getParams().get("location"));
            if (location == null && (location = (String)new ClusterProperties(h.coreContainer.getZkController().getZkClient()).getClusterProperty("location", null)) == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'location' is not specified as a query parameter or as a default repository property or as a cluster property.");
            }
            URI uri = repository.createURI(location);
            try {
                if (!repository.exists(uri)) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "specified location " + uri + " does not exist.");
                }
            }
            catch (IOException ex) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to check the existance of " + uri + ". Is it valid?", (Throwable)ex);
            }
            String strategy = req.getParams().get("indexBackup", "copy-files");
            if (!CollectionAdminParams.INDEX_BACKUP_STRATEGIES.contains(strategy)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown index backup strategy " + strategy);
            }
            Map params = req.getParams().getAll(null, new String[]{"name", "collection", "commitName"});
            params.put("location", location);
            params.put("indexBackup", strategy);
            return params;
        }),
        RESTORE_OP(CollectionParams.CollectionAction.RESTORE, (req, rsp, h) -> {
            req.getParams().required().check(new String[]{"name", "collection"});
            String collectionName = SolrIdentifierValidator.validateCollectionName((String)req.getParams().get("collection"));
            ClusterState clusterState = h.coreContainer.getZkController().getClusterState();
            if (clusterState.hasCollection(collectionName)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection '" + collectionName + "' exists, no action taken.");
            }
            CoreContainer cc = h.coreContainer;
            String repo = req.getParams().get("repository");
            BackupRepository repository = cc.newBackupRepository(Optional.ofNullable(repo));
            String location = repository.getBackupLocation(req.getParams().get("location"));
            if (location == null && (location = (String)new ClusterProperties(h.coreContainer.getZkController().getZkClient()).getClusterProperty("location", null)) == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'location' is not specified as a query parameter or as a default repository property or as a cluster property.");
            }
            URI uri = repository.createURI(location);
            try {
                if (!repository.exists(uri)) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "specified location " + uri + " does not exist.");
                }
            }
            catch (IOException ex) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to check the existance of " + uri + ". Is it valid?", (Throwable)ex);
            }
            String createNodeArg = req.getParams().get("createNodeSet");
            if ("EMPTY".equals(createNodeArg)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot restore with a CREATE_NODE_SET of CREATE_NODE_SET_EMPTY.");
            }
            Map params = req.getParams().getAll(null, new String[]{"name", "collection"});
            params.put("location", location);
            req.getParams().getAll(params, new String[]{"collection.configName", "replicationFactor", "maxShardsPerNode", "stateFormat", "autoAddReplicas", "createNodeSet", "createNodeSet.shuffle"});
            CollectionsHandler.copyPropertiesWithPrefix(req.getParams(), params, "property.");
            return params;
        }),
        CREATESNAPSHOT_OP(CollectionParams.CollectionAction.CREATESNAPSHOT, (req, rsp, h) -> {
            req.getParams().required().check(new String[]{"collection", "commitName"});
            String collectionName = req.getParams().get("collection");
            String commitName = req.getParams().get("commitName");
            ClusterState clusterState = h.coreContainer.getZkController().getClusterState();
            if (!clusterState.hasCollection(collectionName)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection '" + collectionName + "' does not exist, no action taken.");
            }
            SolrZkClient client = h.coreContainer.getZkController().getZkClient();
            if (SolrSnapshotManager.snapshotExists(client, collectionName, commitName)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Snapshot with name '" + commitName + "' already exists for collection '" + collectionName + "', no action taken.");
            }
            Map params = req.getParams().getAll(null, new String[]{"collection", "commitName"});
            return params;
        }),
        DELETESNAPSHOT_OP(CollectionParams.CollectionAction.DELETESNAPSHOT, (req, rsp, h) -> {
            req.getParams().required().check(new String[]{"collection", "commitName"});
            String collectionName = req.getParams().get("collection");
            ClusterState clusterState = h.coreContainer.getZkController().getClusterState();
            if (!clusterState.hasCollection(collectionName)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection '" + collectionName + "' does not exist, no action taken.");
            }
            Map params = req.getParams().getAll(null, new String[]{"collection", "commitName"});
            return params;
        }),
        LISTSNAPSHOTS_OP(CollectionParams.CollectionAction.LISTSNAPSHOTS, (req, rsp, h) -> {
            req.getParams().required().check(new String[]{"collection"});
            String collectionName = req.getParams().get("collection");
            ClusterState clusterState = h.coreContainer.getZkController().getClusterState();
            if (!clusterState.hasCollection(collectionName)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection '" + collectionName + "' does not exist, no action taken.");
            }
            NamedList snapshots = new NamedList();
            SolrZkClient client = h.coreContainer.getZkController().getZkClient();
            Collection<CollectionSnapshotMetaData> m = SolrSnapshotManager.listSnapshots(client, collectionName);
            for (CollectionSnapshotMetaData meta : m) {
                snapshots.add(meta.getName(), (Object)meta.toNamedList());
            }
            rsp.add("snapshots", snapshots);
            return null;
        }),
        REPLACENODE_OP(CollectionParams.CollectionAction.REPLACENODE, (req, rsp, h) -> {
            SolrParams params = req.getParams();
            String sourceNode = params.get("sourceNode", params.get("source"));
            if (sourceNode == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "sourceNode is a require parameter");
            }
            String targetNode = params.get("targetNode", params.get("target"));
            if (targetNode == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "targetNode is a require parameter");
            }
            return params.getAll(null, new String[]{"source", "target", "sourceNode", "targetNode"});
        }),
        MOVEREPLICA_OP(CollectionParams.CollectionAction.MOVEREPLICA, (req, rsp, h) -> {
            Map map = req.getParams().required().getAll(null, new String[]{"collection"});
            return req.getParams().getAll(map, new String[]{"fromNode", "sourceNode", "targetNode", "replica", "shard"});
        }),
        DELETENODE_OP(CollectionParams.CollectionAction.DELETENODE, (req, rsp, h) -> req.getParams().required().getAll(null, new String[]{"node"}));

        public final CollectionOp fun;
        CollectionParams.CollectionAction action;
        long timeOut;
        boolean sendToOCPQueue;

        private CollectionOperation(CollectionParams.CollectionAction action, CollectionOp fun) {
            this(action, DEFAULT_COLLECTION_OP_TIMEOUT, true, fun);
        }

        private CollectionOperation(CollectionParams.CollectionAction action, long timeOut, boolean sendToOCPQueue, CollectionOp fun) {
            this.action = action;
            this.timeOut = timeOut;
            this.sendToOCPQueue = sendToOCPQueue;
            this.fun = fun;
        }

        public static CollectionOperation get(CollectionParams.CollectionAction action) {
            for (CollectionOperation op : CollectionOperation.values()) {
                if (op.action != action) continue;
                return op;
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No such action " + action);
        }

        @Override
        public Map<String, Object> execute(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
            return this.fun.execute(req, rsp, h);
        }
    }
}

