/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.rule;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Map;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.BinaryResponseParser;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.client.solrj.response.SimpleSolrResponse;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.rule.RemoteCallback;
import org.apache.solr.common.cloud.rule.SnitchContext;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.update.UpdateShardHandler;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSnitchContext
extends SnitchContext {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    final CoreContainer coreContainer;

    public ServerSnitchContext(SnitchContext.SnitchInfo perSnitch, String node, Map<String, Object> session, CoreContainer coreContainer) {
        super(perSnitch, node, session);
        this.coreContainer = coreContainer;
    }

    public Map getZkJson(String path) throws KeeperException, InterruptedException {
        if (this.coreContainer.isZooKeeperAware()) {
            return Utils.getJson((SolrZkClient)this.coreContainer.getZkController().getZkClient(), (String)path, (boolean)true);
        }
        return Collections.emptyMap();
    }

    public void invokeRemote(String node, ModifiableSolrParams params, String klas, RemoteCallback callback) {
        if (callback == null) {
            callback = this;
        }
        params.add("class", new String[]{klas});
        params.add("action", new String[]{CoreAdminParams.CoreAdminAction.INVOKE.toString()});
        try {
            SimpleSolrResponse rsp = this.invoke(node, "/admin/cores", (SolrParams)params);
            Map returnedVal = (Map)rsp.getResponse().get(klas);
            if (this.exception != null) {
                callback.remoteCallback((SnitchContext)this, returnedVal);
            }
            callback.remoteCallback((SnitchContext)this, returnedVal);
        }
        catch (Exception e) {
            log.error("Unable to invoke snitch counterpart", (Throwable)e);
            this.exception = e;
        }
    }

    public SimpleSolrResponse invoke(String solrNode, String path, SolrParams params) throws IOException, SolrServerException {
        String url = this.coreContainer.getZkController().getZkStateReader().getBaseUrlForNodeName(solrNode);
        UpdateShardHandler shardHandler = this.coreContainer.getUpdateShardHandler();
        GenericSolrRequest request = new GenericSolrRequest(SolrRequest.METHOD.GET, path, params);
        try (HttpSolrClient client = ((HttpSolrClient.Builder)((HttpSolrClient.Builder)new HttpSolrClient.Builder(url).withHttpClient(shardHandler.getHttpClient())).withResponseParser((ResponseParser)new BinaryResponseParser())).build();){
            NamedList rsp;
            request.response.nl = rsp = client.request((SolrRequest)request);
            SimpleSolrResponse simpleSolrResponse = request.response;
            return simpleSolrResponse;
        }
    }
}

