/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.api.Api;
import org.apache.solr.api.ApiBag;
import org.apache.solr.client.solrj.cloud.autoscaling.Cell;
import org.apache.solr.client.solrj.cloud.autoscaling.ClusterDataProvider;
import org.apache.solr.client.solrj.cloud.autoscaling.Policy;
import org.apache.solr.client.solrj.cloud.autoscaling.Preference;
import org.apache.solr.client.solrj.cloud.autoscaling.Row;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.SolrClientDataProvider;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.CommandOperation;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.RequestHandlerUtils;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoScalingHandler
extends RequestHandlerBase
implements PermissionNameProvider {
    public static final String HANDLER_PATH = "/admin/autoscaling";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static ImmutableSet<String> singletonCommands = ImmutableSet.of((Object)"set-cluster-preferences", (Object)"set-cluster-policy");
    protected final CoreContainer container;
    private final List<Map<String, String>> DEFAULT_ACTIONS = new ArrayList<Map<String, String>>(3);

    public AutoScalingHandler(CoreContainer container) {
        this.container = container;
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        try {
            String httpMethod = (String)req.getContext().get("httpMethod");
            RequestHandlerUtils.setWt(req, "json");
            if ("GET".equals(httpMethod)) {
                List parts;
                String path = (String)req.getContext().get("path");
                if (path == null) {
                    path = "/cluster/autoscaling";
                }
                if (((String)(parts = StrUtils.splitSmart((String)path, (char)'/')).get(0)).isEmpty()) {
                    parts.remove(0);
                }
                if (parts.size() < 2 || parts.size() > 3) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown path: " + path);
                }
                Map<String, Object> map = this.zkReadAutoScalingConf(this.container.getZkController().getZkStateReader());
                if (parts.size() == 2) {
                    rsp.getValues().addAll(map);
                } else if (parts.size() == 3 && "diagnostics".equals(parts.get(2))) {
                    this.handleDiagnostics(rsp, map);
                }
            } else {
                if (req.getContentStreams() == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No commands specified for autoscaling");
                }
                List ops = CommandOperation.readCommands(req.getContentStreams(), (NamedList)rsp.getValues(), singletonCommands);
                if (ops == null) {
                    return;
                }
                block18: for (CommandOperation op : ops) {
                    switch (op.name) {
                        case "set-policy": {
                            this.handleSetPolicies(req, rsp, op);
                            continue block18;
                        }
                        case "remove-policy": {
                            this.handleRemovePolicy(req, rsp, op);
                            continue block18;
                        }
                        case "set-cluster-preferences": {
                            this.handleSetClusterPreferences(req, rsp, op);
                            continue block18;
                        }
                        case "set-cluster-policy": {
                            this.handleSetClusterPolicy(req, rsp, op);
                            continue block18;
                        }
                    }
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown command: " + op.name);
                }
            }
        }
        catch (Exception e) {
            rsp.getValues().add("result", (Object)"failure");
            throw e;
        }
        finally {
            RequestHandlerUtils.addExperimentalFormatWarning(rsp);
        }
    }

    private void handleDiagnostics(SolrQueryResponse rsp, Map<String, Object> autoScalingConf) throws IOException {
        Policy policy = new Policy(autoScalingConf);
        try (CloudSolrClient build = ((CloudSolrClient.Builder)new CloudSolrClient.Builder().withHttpClient(this.container.getUpdateShardHandler().getHttpClient())).withZkHost(this.container.getZkController().getZkServerAddress()).build();){
            Policy.Session session = policy.createSession((ClusterDataProvider)new SolrClientDataProvider(build));
            List sorted = session.getSorted();
            List violations = session.getViolations();
            List clusterPreferences = policy.getClusterPreferences();
            ArrayList<Map> sortedNodes = new ArrayList<Map>(sorted.size());
            for (Row row : sorted) {
                Map map = Utils.makeMap((Object[])new Object[]{"node", row.node});
                block10: for (Cell cell : row.getCells()) {
                    for (Preference clusterPreference : clusterPreferences) {
                        Policy.SortParam name = clusterPreference.getName();
                        if (!cell.getName().equalsIgnoreCase(name.name())) continue;
                        map.put(name.name(), cell.getValue());
                        continue block10;
                    }
                }
                sortedNodes.add(map);
            }
            HashMap<String, List> map = new HashMap<String, List>(2);
            map.put("sortedNodes", sortedNodes);
            map.put("violations", violations);
            rsp.getValues().add("diagnostics", map);
        }
    }

    private void handleSetClusterPolicy(SolrQueryRequest req, SolrQueryResponse rsp, CommandOperation op) throws KeeperException, InterruptedException, IOException {
        List clusterPolicy = (List)op.getCommandData();
        if (clusterPolicy == null || !(clusterPolicy instanceof List)) {
            op.addError("A list of cluster policies was not found");
            this.checkErr(op);
        }
        try {
            this.zkSetClusterPolicy(this.container.getZkController().getZkStateReader(), clusterPolicy);
        }
        catch (Exception e) {
            log.warn("error persisting policies");
            op.addError(e.getMessage());
            this.checkErr(op);
        }
        rsp.getValues().add("result", (Object)"success");
    }

    private void checkErr(CommandOperation op) {
        if (!op.hasError()) {
            return;
        }
        throw new ApiBag.ExceptionWithErrObject(SolrException.ErrorCode.BAD_REQUEST, "Error in command payload", CommandOperation.captureErrors(Collections.singletonList(op)));
    }

    private void handleSetClusterPreferences(SolrQueryRequest req, SolrQueryResponse rsp, CommandOperation op) throws KeeperException, InterruptedException, IOException {
        List preferences = (List)op.getCommandData();
        if (preferences == null || !(preferences instanceof List)) {
            op.addError("A list of cluster preferences not found");
            this.checkErr(op);
        }
        this.zkSetPreferences(this.container.getZkController().getZkStateReader(), preferences);
        rsp.getValues().add("result", (Object)"success");
    }

    private void handleRemovePolicy(SolrQueryRequest req, SolrQueryResponse rsp, CommandOperation op) throws KeeperException, InterruptedException, IOException {
        Map<String, Object> autoScalingConf;
        Map policies;
        String policyName = (String)op.getCommandData();
        if (op.hasError()) {
            this.checkErr(op);
        }
        if ((policies = (Map)(autoScalingConf = this.zkReadAutoScalingConf(this.container.getZkController().getZkStateReader())).get("policies")) == null || !policies.containsKey(policyName)) {
            op.addError("No policy exists with name: " + policyName);
        }
        this.checkErr(op);
        this.zkSetPolicies(this.container.getZkController().getZkStateReader(), policyName, null);
        rsp.getValues().add("result", (Object)"success");
    }

    private void handleSetPolicies(SolrQueryRequest req, SolrQueryResponse rsp, CommandOperation op) throws KeeperException, InterruptedException, IOException {
        Map policies = op.getDataMap();
        for (Map.Entry policy : policies.entrySet()) {
            String policyName = (String)policy.getKey();
            if (policyName != null && policyName.trim().length() != 0) continue;
            op.addError("The policy name cannot be null or empty");
        }
        this.checkErr(op);
        try {
            this.zkSetPolicies(this.container.getZkController().getZkStateReader(), null, policies);
        }
        catch (Exception e) {
            log.warn("error persisting policies", (Throwable)e);
            op.addError(e.getMessage());
            this.checkErr(op);
        }
        rsp.getValues().add("result", (Object)"success");
    }

    private void zkSetPolicies(ZkStateReader reader, String policyBeRemoved, Map<String, Object> newPolicies) throws KeeperException, InterruptedException, IOException {
        while (true) {
            Stat stat = new Stat();
            ZkNodeProps loaded = null;
            byte[] data = reader.getZkClient().getData("/autoscaling.json", null, stat, true);
            loaded = ZkNodeProps.load((byte[])data);
            HashMap<String, Object> policies = (HashMap<String, Object>)loaded.get("policies");
            if (policies == null) {
                policies = new HashMap<String, Object>(1);
            }
            if (newPolicies != null) {
                policies.putAll(newPolicies);
            } else {
                policies.remove(policyBeRemoved);
            }
            loaded = loaded.plus("policies", policies);
            this.verifyAutoScalingConf(loaded.getProperties());
            try {
                reader.getZkClient().setData("/autoscaling.json", Utils.toJSON((Object)loaded), stat.getVersion(), true);
            }
            catch (KeeperException.BadVersionException bve) {
                continue;
            }
            break;
        }
    }

    private void zkSetPreferences(ZkStateReader reader, List preferences) throws KeeperException, InterruptedException, IOException {
        while (true) {
            Stat stat = new Stat();
            ZkNodeProps loaded = null;
            byte[] data = reader.getZkClient().getData("/autoscaling.json", null, stat, true);
            loaded = ZkNodeProps.load((byte[])data);
            loaded = loaded.plus("cluster-preferences", (Object)preferences);
            this.verifyAutoScalingConf(loaded.getProperties());
            try {
                reader.getZkClient().setData("/autoscaling.json", Utils.toJSON((Object)loaded), stat.getVersion(), true);
            }
            catch (KeeperException.BadVersionException bve) {
                continue;
            }
            break;
        }
    }

    private void zkSetClusterPolicy(ZkStateReader reader, List clusterPolicy) throws KeeperException, InterruptedException, IOException {
        while (true) {
            Stat stat = new Stat();
            ZkNodeProps loaded = null;
            byte[] data = reader.getZkClient().getData("/autoscaling.json", null, stat, true);
            loaded = ZkNodeProps.load((byte[])data);
            loaded = loaded.plus("cluster-policy", (Object)clusterPolicy);
            this.verifyAutoScalingConf(loaded.getProperties());
            try {
                reader.getZkClient().setData("/autoscaling.json", Utils.toJSON((Object)loaded), stat.getVersion(), true);
            }
            catch (KeeperException.BadVersionException bve) {
                continue;
            }
            break;
        }
    }

    private void verifyAutoScalingConf(Map<String, Object> autoScalingConf) throws IOException {
        try (CloudSolrClient build = ((CloudSolrClient.Builder)new CloudSolrClient.Builder().withHttpClient(this.container.getUpdateShardHandler().getHttpClient())).withZkHost(this.container.getZkController().getZkServerAddress()).build();){
            Policy policy = new Policy(autoScalingConf);
            Policy.Session session = policy.createSession((ClusterDataProvider)new SolrClientDataProvider(build));
            log.debug("Verified autoscaling configuration");
        }
    }

    private Map<String, Object> zkReadAutoScalingConf(ZkStateReader reader) throws KeeperException, InterruptedException {
        byte[] data = reader.getZkClient().getData("/autoscaling.json", null, null, true);
        ZkNodeProps loaded = ZkNodeProps.load((byte[])data);
        return loaded.getProperties();
    }

    @Override
    public String getDescription() {
        return "A handler for autoscaling configuration";
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        switch (request.getHttpMethod()) {
            case "GET": {
                return PermissionNameProvider.Name.AUTOSCALING_READ_PERM;
            }
            case "POST": {
                return PermissionNameProvider.Name.AUTOSCALING_WRITE_PERM;
            }
        }
        return null;
    }

    @Override
    public Collection<Api> getApis() {
        return ApiBag.wrapRequestHandlers(this, "autoscaling.Commands");
    }

    @Override
    public Boolean registerV2() {
        return Boolean.TRUE;
    }

    @Override
    public SolrRequestHandler getSubHandler(String path) {
        if (path.equals("/diagnostics")) {
            return this;
        }
        return null;
    }
}

