/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import com.google.common.base.Strings;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.CloudUtil;
import org.apache.solr.cloud.CurrentCoreDescriptorProvider;
import org.apache.solr.cloud.DistributedMap;
import org.apache.solr.cloud.DistributedQueue;
import org.apache.solr.cloud.ElectionContext;
import org.apache.solr.cloud.LeaderElector;
import org.apache.solr.cloud.LeaderInitiatedRecoveryThread;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.OverseerElectionContext;
import org.apache.solr.cloud.OverseerTaskQueue;
import org.apache.solr.cloud.ReplicateFromLeader;
import org.apache.solr.cloud.ShardLeaderElectionContext;
import org.apache.solr.cloud.ShardLeaderElectionContextBase;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.cloud.overseer.OverseerAction;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.BeforeReconnect;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DefaultConnectionStrategy;
import org.apache.solr.common.cloud.DefaultZkACLProvider;
import org.apache.solr.common.cloud.DefaultZkCredentialsProvider;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.OnReconnect;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkACLProvider;
import org.apache.solr.common.cloud.ZkClientConnectionStrategy;
import org.apache.solr.common.cloud.ZkCmdExecutor;
import org.apache.solr.common.cloud.ZkConfigManager;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkCredentialsProvider;
import org.apache.solr.common.cloud.ZkMaintenanceUtils;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.ObjectReleaseTracker;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.URLUtil;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CloseHook;
import org.apache.solr.core.CloudConfig;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrCoreInitializationException;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.solr.update.UpdateLog;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ZkController {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final int WAIT_DOWN_STATES_TIMEOUT_SECONDS = 60;
    private final boolean SKIP_AUTO_RECOVERY = Boolean.getBoolean("solrcloud.skip.autorecovery");
    private final DistributedQueue overseerJobQueue;
    private final OverseerTaskQueue overseerCollectionQueue;
    private final OverseerTaskQueue overseerConfigSetQueue;
    private final DistributedMap overseerRunningMap;
    private final DistributedMap overseerCompletedMap;
    private final DistributedMap overseerFailureMap;
    public static final String COLLECTION_PARAM_PREFIX = "collection.";
    public static final String CONFIGNAME_PROP = "configName";
    private final Map<ContextKey, ElectionContext> electionContexts = Collections.synchronizedMap(new HashMap());
    private final SolrZkClient zkClient;
    private final ZkCmdExecutor cmdExecutor;
    private final ZkStateReader zkStateReader;
    private final String zkServerAddress;
    private final int localHostPort;
    private final String hostName;
    private final String nodeName;
    private String baseURL;
    private final CloudConfig cloudConfig;
    private LeaderElector overseerElector;
    private Map<String, ReplicateFromLeader> replicateFromLeaders = new ConcurrentHashMap<String, ReplicateFromLeader>();
    private CoreContainer cc;
    protected volatile Overseer overseer;
    private int leaderVoteWait;
    private int leaderConflictResolveWait;
    private boolean genericCoreNodeNames;
    private int clientTimeout;
    private volatile boolean isClosed;
    private final Map<String, String> replicasInLeaderInitiatedRecovery = new HashMap<String, String>();
    private boolean zkRunOnly = Boolean.getBoolean("zkRunOnly");
    private HashSet<OnReconnect> reconnectListeners = new HashSet();
    private final Map<String, Set<Runnable>> confDirectoryListeners = new HashMap<String, Set<Runnable>>();

    public ZkController(final CoreContainer cc, String zkServerAddress, int zkClientConnectTimeout, CloudConfig cloudConfig, final CurrentCoreDescriptorProvider registerOnReconnect) throws InterruptedException, TimeoutException, IOException {
        if (cc == null) {
            throw new IllegalArgumentException("CoreContainer cannot be null.");
        }
        this.cc = cc;
        this.cloudConfig = cloudConfig;
        this.genericCoreNodeNames = cloudConfig.getGenericCoreNodeNames();
        String localHostContext = ZkController.trimLeadingAndTrailingSlashes(cloudConfig.getSolrHostContext());
        this.zkServerAddress = zkServerAddress;
        this.localHostPort = cloudConfig.getSolrHostPort();
        this.hostName = this.normalizeHostName(cloudConfig.getHost());
        this.nodeName = ZkController.generateNodeName(this.hostName, Integer.toString(this.localHostPort), localHostContext);
        MDCLoggingContext.setNode(this.nodeName);
        this.leaderVoteWait = cloudConfig.getLeaderVoteWait();
        this.leaderConflictResolveWait = cloudConfig.getLeaderConflictResolveWait();
        this.clientTimeout = cloudConfig.getZkClientTimeout();
        DefaultConnectionStrategy strat = new DefaultConnectionStrategy();
        String zkACLProviderClass = cloudConfig.getZkACLProviderClass();
        Object zkACLProvider = null;
        zkACLProvider = zkACLProviderClass != null && zkACLProviderClass.trim().length() > 0 ? cc.getResourceLoader().newInstance(zkACLProviderClass, ZkACLProvider.class) : new DefaultZkACLProvider();
        String zkCredentialsProviderClass = cloudConfig.getZkCredentialsProviderClass();
        if (zkCredentialsProviderClass != null && zkCredentialsProviderClass.trim().length() > 0) {
            strat.setZkCredentialsToAddAutomatically(cc.getResourceLoader().newInstance(zkCredentialsProviderClass, ZkCredentialsProvider.class));
        } else {
            strat.setZkCredentialsToAddAutomatically((ZkCredentialsProvider)new DefaultZkCredentialsProvider());
        }
        this.addOnReconnectListener(this.getConfigDirListener());
        this.zkClient = new SolrZkClient(zkServerAddress, this.clientTimeout, zkClientConnectTimeout, (ZkClientConnectionStrategy)strat, new OnReconnect(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void command() {
                log.info("ZooKeeper session re-connected ... refreshing core states after session expiration.");
                try {
                    HashSet clonedListeners;
                    ExecutorService executorService;
                    ZkController.this.zkStateReader.createClusterStateWatchersAndUpdate();
                    if (!ZkController.this.zkRunOnly) {
                        OverseerElectionContext context = new OverseerElectionContext(ZkController.this.zkClient, ZkController.this.overseer, ZkController.this.getNodeName());
                        ElectionContext prevContext = ZkController.this.overseerElector.getContext();
                        if (prevContext != null) {
                            prevContext.cancelElection();
                            prevContext.close();
                        }
                        ZkController.this.overseerElector.setup(context);
                        ZkController.this.overseerElector.joinElection(context, true);
                    }
                    cc.cancelCoreRecoveries();
                    ZkController.this.registerAllCoresAsDown(registerOnReconnect, false);
                    ZkController.this.createEphemeralLiveNode();
                    List<CoreDescriptor> descriptors = registerOnReconnect.getCurrentDescriptors();
                    ExecutorService executorService2 = executorService = cc != null ? cc.getCoreZkRegisterExecutorService() : null;
                    if (descriptors != null) {
                        for (CoreDescriptor descriptor : descriptors) {
                            try {
                                ZkController.this.throwErrorIfReplicaReplaced(descriptor);
                                if (executorService != null) {
                                    executorService.submit(new RegisterCoreAsync(descriptor, true, true));
                                    continue;
                                }
                                ZkController.this.register(descriptor.getName(), descriptor, true, true, false);
                            }
                            catch (Exception e) {
                                SolrException.log((Logger)log, (String)"Error registering SolrCore", (Throwable)e);
                            }
                        }
                    }
                    HashSet hashSet = ZkController.this.reconnectListeners;
                    synchronized (hashSet) {
                        clonedListeners = (HashSet)ZkController.this.reconnectListeners.clone();
                    }
                    for (OnReconnect listener : clonedListeners) {
                        try {
                            if (executorService != null) {
                                executorService.submit(new OnReconnectNotifyAsync(listener));
                                continue;
                            }
                            listener.command();
                        }
                        catch (Exception exc) {
                            log.warn("Error when notifying OnReconnect listener " + listener + " after session re-connected.", (Throwable)exc);
                        }
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                }
                catch (Exception e) {
                    SolrException.log((Logger)log, (String)"", (Throwable)e);
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                }
            }
        }, new BeforeReconnect(){

            public void command() {
                try {
                    ZkController.this.overseer.close();
                }
                catch (Exception e) {
                    log.error("Error trying to stop any Overseer threads", (Throwable)e);
                }
                ZkController.this.closeOutstandingElections(registerOnReconnect);
                ZkController.this.markAllAsNotLeader(registerOnReconnect);
            }
        }, (ZkACLProvider)zkACLProvider);
        this.overseerJobQueue = Overseer.getStateUpdateQueue(this.zkClient);
        this.overseerCollectionQueue = Overseer.getCollectionQueue(this.zkClient);
        this.overseerConfigSetQueue = Overseer.getConfigSetQueue(this.zkClient);
        this.overseerRunningMap = Overseer.getRunningMap(this.zkClient);
        this.overseerCompletedMap = Overseer.getCompletedMap(this.zkClient);
        this.overseerFailureMap = Overseer.getFailureMap(this.zkClient);
        this.cmdExecutor = new ZkCmdExecutor(this.clientTimeout);
        this.zkStateReader = new ZkStateReader(this.zkClient, () -> {
            if (cc != null) {
                cc.securityNodeChanged();
            }
        });
        this.init(registerOnReconnect);
        assert (ObjectReleaseTracker.track((Object)this));
    }

    public int getLeaderVoteWait() {
        return this.leaderVoteWait;
    }

    public int getLeaderConflictResolveWait() {
        return this.leaderConflictResolveWait;
    }

    private void registerAllCoresAsDown(CurrentCoreDescriptorProvider registerOnReconnect, boolean updateLastPublished) {
        List<CoreDescriptor> descriptors = registerOnReconnect.getCurrentDescriptors();
        if (this.isClosed) {
            return;
        }
        if (descriptors != null) {
            this.publishNodeAsDown(this.getNodeName());
            for (CoreDescriptor descriptor : descriptors) {
                CloudDescriptor cloudDesc = descriptor.getCloudDescriptor();
                String collection = cloudDesc.getCollectionName();
                String slice = cloudDesc.getShardId();
                try {
                    int children = this.zkStateReader.getZkClient().getChildren("/collections/" + collection + "/leader_elect/" + slice + "/election", null, true).size();
                    if (children == 0) {
                        log.debug("looks like we are going to be the leader for collection {} shard {}", (Object)collection, (Object)slice);
                        continue;
                    }
                }
                catch (KeeperException.NoNodeException e) {
                    log.debug("looks like we are going to be the leader for collection {} shard {}", (Object)collection, (Object)slice);
                    continue;
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                }
                catch (KeeperException e) {
                    log.warn("", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                String coreZkNodeName = descriptor.getCloudDescriptor().getCoreNodeName();
                try {
                    log.debug("calling waitForLeaderToSeeDownState for coreZkNodeName={} collection={} shard={}", new Object[]{coreZkNodeName, collection, slice});
                    this.waitForLeaderToSeeDownState(descriptor, coreZkNodeName);
                }
                catch (Exception e) {
                    SolrException.log((Logger)log, (String)"", (Throwable)e);
                    if (!this.isClosed) continue;
                    return;
                }
            }
        }
    }

    private void closeOutstandingElections(CurrentCoreDescriptorProvider registerOnReconnect) {
        List<CoreDescriptor> descriptors = registerOnReconnect.getCurrentDescriptors();
        if (descriptors != null) {
            for (CoreDescriptor descriptor : descriptors) {
                this.closeExistingElectionContext(descriptor);
            }
        }
    }

    private ContextKey closeExistingElectionContext(CoreDescriptor cd) {
        String coreNodeName;
        String collection = cd.getCloudDescriptor().getCollectionName();
        ContextKey contextKey = new ContextKey(collection, coreNodeName = cd.getCloudDescriptor().getCoreNodeName());
        ElectionContext prevContext = this.electionContexts.get(contextKey);
        if (prevContext != null) {
            prevContext.close();
            this.electionContexts.remove(contextKey);
        }
        return contextKey;
    }

    private void markAllAsNotLeader(CurrentCoreDescriptorProvider registerOnReconnect) {
        List<CoreDescriptor> descriptors = registerOnReconnect.getCurrentDescriptors();
        if (descriptors != null) {
            for (CoreDescriptor descriptor : descriptors) {
                descriptor.getCloudDescriptor().setLeader(false);
                descriptor.getCloudDescriptor().setHasRegistered(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.isClosed = true;
        try {
            for (ElectionContext context : this.electionContexts.values()) {
                try {
                    context.close();
                }
                catch (Exception e) {
                    log.error("Error closing overseer", (Throwable)e);
                }
            }
        }
        finally {
            try {
                IOUtils.closeQuietly((Closeable)this.overseerElector.getContext());
                IOUtils.closeQuietly((Closeable)this.overseer);
            }
            finally {
                try {
                    try {
                        this.zkStateReader.close();
                    }
                    catch (Exception e) {
                        log.error("Error closing zkStateReader", (Throwable)e);
                    }
                }
                finally {
                    try {
                        this.zkClient.close();
                    }
                    catch (Exception e) {
                        log.error("Error closing zkClient", (Throwable)e);
                    }
                }
            }
        }
        assert (ObjectReleaseTracker.release((Object)this));
    }

    public boolean configFileExists(String collection, String fileName) throws KeeperException, InterruptedException {
        Stat stat = this.zkClient.exists("/configs/" + collection + "/" + fileName, null, true);
        return stat != null;
    }

    public ClusterState getClusterState() {
        return this.zkStateReader.getClusterState();
    }

    public byte[] getConfigFileData(String zkConfigName, String fileName) throws KeeperException, InterruptedException {
        String zkPath = "/configs/" + zkConfigName + "/" + fileName;
        byte[] bytes = this.zkClient.getData(zkPath, null, null, true);
        if (bytes == null) {
            log.error("Config file contains no data:" + zkPath);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "Config file contains no data:" + zkPath);
        }
        return bytes;
    }

    private String normalizeHostName(String host) throws IOException {
        if (host == null || host.length() == 0) {
            String hostaddress;
            try {
                hostaddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                hostaddress = "127.0.0.1";
            }
            if ("127.0.0.1".equals(hostaddress)) {
                Enumeration<NetworkInterface> netInterfaces = null;
                try {
                    netInterfaces = NetworkInterface.getNetworkInterfaces();
                    while (netInterfaces.hasMoreElements()) {
                        NetworkInterface ni = netInterfaces.nextElement();
                        Enumeration<InetAddress> ips = ni.getInetAddresses();
                        while (ips.hasMoreElements()) {
                            InetAddress ip = ips.nextElement();
                            if (!ip.isSiteLocalAddress()) continue;
                            hostaddress = ip.getHostAddress();
                        }
                    }
                }
                catch (Exception e) {
                    SolrException.log((Logger)log, (String)"Error while looking for a better host name than 127.0.0.1", (Throwable)e);
                }
            }
            host = hostaddress;
        } else if (URLUtil.hasScheme((String)host)) {
            host = URLUtil.removeScheme((String)host);
        }
        return host;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getHostPort() {
        return this.localHostPort;
    }

    public SolrZkClient getZkClient() {
        return this.zkClient;
    }

    public String getZkServerAddress() {
        return this.zkServerAddress;
    }

    public static void createClusterZkNodes(SolrZkClient zkClient) throws KeeperException, InterruptedException, IOException {
        ZkCmdExecutor cmdExecutor = new ZkCmdExecutor(zkClient.getZkClientTimeout());
        cmdExecutor.ensureExists("/live_nodes", zkClient);
        cmdExecutor.ensureExists("/collections", zkClient);
        cmdExecutor.ensureExists("/aliases.json", zkClient);
        byte[] emptyJson = "{}".getBytes(StandardCharsets.UTF_8);
        cmdExecutor.ensureExists("/clusterstate.json", emptyJson, CreateMode.PERSISTENT, zkClient);
        cmdExecutor.ensureExists("/security.json", emptyJson, CreateMode.PERSISTENT, zkClient);
        cmdExecutor.ensureExists("/autoscaling.json", emptyJson, CreateMode.PERSISTENT, zkClient);
        ZkController.bootstrapDefaultConfigSet(zkClient);
    }

    private static void bootstrapDefaultConfigSet(SolrZkClient zkClient) throws KeeperException, InterruptedException, IOException {
        if (!zkClient.exists("/configs/_default", true).booleanValue()) {
            String configDirPath = ZkController.getDefaultConfigDirPath();
            if (configDirPath == null) {
                log.warn("The _default configset could not be uploaded. Please provide 'solr.default.confdir' parameter that points to a configset intended to be the default. Current 'solr.default.confdir' value: {}", (Object)System.getProperty("solr.default.confdir"));
            } else {
                ZkMaintenanceUtils.upConfig((SolrZkClient)zkClient, (Path)Paths.get(configDirPath, new String[0]), (String)"_default");
            }
        }
    }

    private static String getDefaultConfigDirPath() {
        String configDirPath = null;
        String serverSubPath = "solr" + File.separator + "configsets" + File.separator + "_default" + File.separator + "conf";
        String subPath = File.separator + "server" + File.separator + serverSubPath;
        configDirPath = System.getProperty("solr.default.confdir") != null && new File(System.getProperty("solr.default.confdir")).exists() ? new File(System.getProperty("solr.default.confdir")).getAbsolutePath() : (System.getProperty("solr.install.dir") != null && new File(System.getProperty("solr.install.dir") + subPath).exists() ? new File(System.getProperty("solr.install.dir") + subPath).getAbsolutePath() : ZkController.getDefaultConfigDirFromClasspath(serverSubPath));
        return configDirPath;
    }

    private static String getDefaultConfigDirFromClasspath(String serverSubPath) {
        URL classpathUrl = ZkController.class.getClassLoader().getResource(serverSubPath);
        try {
            if (classpathUrl != null && new File(classpathUrl.toURI()).exists()) {
                return new File(classpathUrl.toURI()).getAbsolutePath();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    private void init(CurrentCoreDescriptorProvider registerOnReconnect) {
        try {
            Stat stat;
            ZkController.createClusterZkNodes(this.zkClient);
            this.zkStateReader.createClusterStateWatchersAndUpdate();
            this.baseURL = this.zkStateReader.getBaseUrlForNodeName(this.nodeName);
            this.checkForExistingEphemeralNode();
            if (!this.zkRunOnly) {
                this.overseerElector = new LeaderElector(this.zkClient);
                this.overseer = new Overseer(this.cc.getShardHandlerFactory().getShardHandler(), this.cc.getUpdateShardHandler(), "/admin/cores", this.zkStateReader, this, this.cloudConfig);
                OverseerElectionContext context = new OverseerElectionContext(this.zkClient, this.overseer, this.getNodeName());
                this.overseerElector.setup(context);
                this.overseerElector.joinElection(context, false);
            }
            if ((stat = this.zkClient.exists("/live_nodes", null, true)) != null && stat.getNumChildren() > 0) {
                this.publishAndWaitForDownStates();
            }
            this.createEphemeralLiveNode();
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can't create ZooKeeperController", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("", (Throwable)e);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
        catch (KeeperException e) {
            log.error("", (Throwable)e);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
    }

    private void checkForExistingEphemeralNode() throws KeeperException, InterruptedException {
        if (this.zkRunOnly) {
            return;
        }
        String nodeName = this.getNodeName();
        String nodePath = "/live_nodes/" + nodeName;
        if (!this.zkClient.exists(nodePath, true).booleanValue()) {
            return;
        }
        CountDownLatch deletedLatch = new CountDownLatch(1);
        Stat stat = this.zkClient.exists(nodePath, event -> {
            if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                return;
            }
            if (Watcher.Event.EventType.NodeDeleted.equals((Object)event.getType())) {
                deletedLatch.countDown();
            }
        }, true);
        if (stat == null) {
            return;
        }
        boolean deleted = deletedLatch.await(this.zkClient.getSolrZooKeeper().getSessionTimeout() * 2, TimeUnit.MILLISECONDS);
        if (!deleted) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "A previous ephemeral live node still exists. Solr cannot continue. Please ensure that no other Solr process using the same port is running already.");
        }
    }

    public void publishAndWaitForDownStates() throws KeeperException, InterruptedException {
        this.publishNodeAsDown(this.getNodeName());
        ConcurrentHashMap.KeySetView collectionsWithLocalReplica = ConcurrentHashMap.newKeySet();
        for (SolrCore solrCore : this.cc.getCores()) {
            collectionsWithLocalReplica.add(solrCore.getCoreDescriptor().getCloudDescriptor().getCollectionName());
        }
        CountDownLatch latch = new CountDownLatch(collectionsWithLocalReplica.size());
        for (String collectionWithLocalReplica : collectionsWithLocalReplica) {
            this.zkStateReader.registerCollectionStateWatcher(collectionWithLocalReplica, (liveNodes, collectionState) -> {
                boolean foundStates = true;
                for (SolrCore core : this.cc.getCores()) {
                    Replica replica;
                    if (!core.getCoreDescriptor().getCloudDescriptor().getCollectionName().equals(collectionWithLocalReplica) || (replica = collectionState.getReplica(core.getCoreDescriptor().getCloudDescriptor().getCoreNodeName())).getState() == Replica.State.DOWN) continue;
                    foundStates = false;
                }
                if (foundStates && collectionsWithLocalReplica.remove(collectionWithLocalReplica)) {
                    latch.countDown();
                }
                return foundStates;
            });
        }
        boolean bl = latch.await(60L, TimeUnit.SECONDS);
        if (!bl) {
            log.warn("Timed out waiting to see all nodes published as DOWN in our cluster state.");
        }
    }

    public static boolean checkChrootPath(String zkHost, boolean create) throws KeeperException, InterruptedException {
        if (!SolrZkClient.containsChroot((String)zkHost)) {
            return true;
        }
        log.trace("zkHost includes chroot");
        String chrootPath = zkHost.substring(zkHost.indexOf("/"), zkHost.length());
        SolrZkClient tmpClient = new SolrZkClient(zkHost.substring(0, zkHost.indexOf("/")), 60000, 30000, null, null, null);
        boolean exists = tmpClient.exists(chrootPath, true);
        if (!exists && create) {
            tmpClient.makePath(chrootPath, false, true);
            exists = true;
        }
        tmpClient.close();
        return exists;
    }

    public boolean isConnected() {
        return this.zkClient.isConnected();
    }

    private void createEphemeralLiveNode() throws KeeperException, InterruptedException {
        if (this.zkRunOnly) {
            return;
        }
        String nodeName = this.getNodeName();
        String nodePath = "/live_nodes/" + nodeName;
        log.info("Register node as live in ZooKeeper:" + nodePath);
        this.zkClient.makePath(nodePath, CreateMode.EPHEMERAL, true);
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public boolean pathExists(String path) throws KeeperException, InterruptedException {
        return this.zkClient.exists(path, true);
    }

    public String register(String coreName, CoreDescriptor desc, boolean skipRecovery) throws Exception {
        return this.register(coreName, desc, false, false, skipRecovery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String register(String coreName, CoreDescriptor desc, boolean recoverReloadedCores, boolean afterExpiration, boolean skipRecovery) throws Exception {
        try (SolrCore core = this.cc.getCore(desc.getName());){
            MDCLoggingContext.setCore(core);
        }
        try {
            String baseUrl = this.getBaseUrl();
            CloudDescriptor cloudDesc = desc.getCloudDescriptor();
            String collection = cloudDesc.getCollectionName();
            String coreZkNodeName = desc.getCloudDescriptor().getCoreNodeName();
            assert (coreZkNodeName != null) : "we should have a coreNodeName by now";
            String shardId = cloudDesc.getShardId();
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("base_url", baseUrl);
            props.put("core", coreName);
            props.put("node_name", this.getNodeName());
            log.debug("Register replica - core:{} address:{} collection:{} shard:{}", new Object[]{coreName, baseUrl, cloudDesc.getCollectionName(), shardId});
            ZkNodeProps leaderProps = new ZkNodeProps(props);
            try {
                Replica replica;
                boolean joinAtHead = false;
                DocCollection docCollection = this.zkStateReader.getClusterState().getCollectionOrNull(collection);
                Replica replica2 = replica = docCollection == null ? null : docCollection.getReplica(coreZkNodeName);
                if (replica != null) {
                    joinAtHead = replica.getBool("property.preferredleader", false);
                }
                if (replica == null || replica.getType() != Replica.Type.PULL) {
                    this.joinElection(desc, afterExpiration, joinAtHead);
                } else if (replica.getType() == Replica.Type.PULL) {
                    if (joinAtHead) {
                        log.warn("Replica {} was designated as preferred leader but it's type is {}, It won't join election", (Object)coreZkNodeName, (Object)Replica.Type.PULL);
                    }
                    log.debug("Replica {} skipping election because it's type is {}", (Object)coreZkNodeName, (Object)Replica.Type.PULL);
                    this.startReplicationFromLeader(coreName, false);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
            catch (IOException | KeeperException e) {
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", e);
            }
            String leaderUrl = this.getLeader(cloudDesc, this.leaderVoteWait + 600000);
            String ourUrl = ZkCoreNodeProps.getCoreUrl((String)baseUrl, (String)coreName);
            log.debug("We are " + ourUrl + " and leader is " + leaderUrl);
            boolean isLeader = leaderUrl.equals(ourUrl);
            Replica.Type replicaType = this.zkStateReader.getClusterState().getCollection(collection).getReplica(coreZkNodeName).getType();
            assert (!isLeader || replicaType != Replica.Type.PULL) : "Pull replica became leader!";
            try (SolrCore core = this.cc.getCore(desc.getName());){
                boolean didRecovery;
                Slice slice;
                String commitVersion;
                boolean isTlogReplicaAndNotLeader;
                UpdateLog ulog = core.getUpdateHandler().getUpdateLog();
                boolean bl = isTlogReplicaAndNotLeader = replicaType == Replica.Type.TLOG && !isLeader;
                if (isTlogReplicaAndNotLeader && (commitVersion = ReplicateFromLeader.getCommitVersion(core)) != null) {
                    ulog.copyOverOldUpdates(Long.parseLong(commitVersion));
                }
                if (!(afterExpiration || core.isReloaded() || ulog == null || isTlogReplicaAndNotLeader || (slice = this.getClusterState().getCollection(collection).getSlice(shardId)).getState() == Slice.State.CONSTRUCTION && isLeader)) {
                    Future<UpdateLog.RecoveryInfo> recoveryFuture = core.getUpdateHandler().getUpdateLog().recoverFromLog();
                    if (recoveryFuture != null) {
                        log.info("Replaying tlog for " + ourUrl + " during startup... NOTE: This can take a while.");
                        recoveryFuture.get();
                    } else {
                        log.debug("No LogReplay needed for core={} baseURL={}", (Object)core.getName(), (Object)baseUrl);
                    }
                }
                if (!(didRecovery = this.checkRecovery(recoverReloadedCores, isLeader, skipRecovery, collection, coreZkNodeName, core, this.cc, afterExpiration))) {
                    if (isTlogReplicaAndNotLeader) {
                        this.startReplicationFromLeader(coreName, true);
                    }
                    this.publish(desc, Replica.State.ACTIVE);
                }
                core.getCoreDescriptor().getCloudDescriptor().setHasRegistered(true);
            }
            this.zkStateReader.forceUpdateCollection(collection);
            String string = shardId;
            return string;
        }
        finally {
            MDCLoggingContext.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startReplicationFromLeader(String coreName, boolean switchTransactionLog) throws InterruptedException {
        ReplicateFromLeader replicateFromLeader;
        log.info("{} starting background replication from leader", (Object)coreName);
        ReplicateFromLeader replicateFromLeader2 = replicateFromLeader = new ReplicateFromLeader(this.cc, coreName);
        synchronized (replicateFromLeader2) {
            if (this.replicateFromLeaders.putIfAbsent(coreName, replicateFromLeader) == null) {
                replicateFromLeader.startReplication(switchTransactionLog);
            } else {
                log.warn("A replicate from leader instance already exists for core {}", (Object)coreName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopReplicationFromLeader(String coreName) {
        log.info("{} stopping background replication from leader", (Object)coreName);
        ReplicateFromLeader replicateFromLeader = this.replicateFromLeaders.remove(coreName);
        if (replicateFromLeader != null) {
            ReplicateFromLeader replicateFromLeader2 = replicateFromLeader;
            synchronized (replicateFromLeader2) {
                replicateFromLeader.stopReplication();
            }
        }
    }

    private String getLeader(CloudDescriptor cloudDesc, int timeoutms) {
        String leaderUrl;
        String collection = cloudDesc.getCollectionName();
        String shardId = cloudDesc.getShardId();
        try {
            leaderUrl = this.getLeaderProps(collection, cloudDesc.getShardId(), timeoutms).getCoreUrl();
            String clusterStateLeaderUrl = this.zkStateReader.getLeaderUrl(collection, shardId, timeoutms * 2);
            int tries = 0;
            long msInSec = 1000L;
            int maxTries = (int)Math.floor((long)this.leaderConflictResolveWait / 1000L);
            while (!leaderUrl.equals(clusterStateLeaderUrl)) {
                if (tries > maxTries) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "There is conflicting information about the leader of shard: " + cloudDesc.getShardId() + " our state says:" + clusterStateLeaderUrl + " but zookeeper says:" + leaderUrl);
                }
                if (++tries % 30 == 0) {
                    String warnMsg = String.format(Locale.ENGLISH, "Still seeing conflicting information about the leader of shard %s for collection %s after %d seconds; our state says %s, but ZooKeeper says %s", cloudDesc.getShardId(), collection, tries, clusterStateLeaderUrl, leaderUrl);
                    log.warn(warnMsg);
                }
                Thread.sleep(1000L);
                clusterStateLeaderUrl = this.zkStateReader.getLeaderUrl(collection, shardId, timeoutms);
                leaderUrl = this.getLeaderProps(collection, cloudDesc.getShardId(), timeoutms).getCoreUrl();
            }
        }
        catch (Exception e) {
            log.error("Error getting leader from zk", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error getting leader from zk for shard " + shardId, (Throwable)e);
        }
        return leaderUrl;
    }

    public ZkCoreNodeProps getLeaderProps(String collection, String slice, int timeoutms) throws InterruptedException {
        return this.getLeaderProps(collection, slice, timeoutms, false);
    }

    public ZkCoreNodeProps getLeaderProps(String collection, String slice, int timeoutms, boolean failImmediatelyOnExpiration) throws InterruptedException {
        int iterCount = timeoutms / 1000;
        Throwable exp = null;
        while (iterCount-- > 0) {
            try {
                byte[] data = this.zkClient.getData(ZkStateReader.getShardLeadersPath((String)collection, (String)slice), null, null, true);
                ZkCoreNodeProps leaderProps = new ZkCoreNodeProps(ZkNodeProps.load((byte[])data));
                return leaderProps;
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (KeeperException.SessionExpiredException e) {
                if (failImmediatelyOnExpiration) {
                    throw new RuntimeException("Session has expired - could not get leader props", exp);
                }
                exp = e;
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                exp = e;
                Thread.sleep(1000L);
            }
            if (!this.cc.isShutDown()) continue;
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "CoreContainer is closed");
        }
        throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Could not get leader props", exp);
    }

    private void joinElection(CoreDescriptor cd, boolean afterExpiration, boolean joinAtHead) throws InterruptedException, KeeperException, IOException {
        String coreNodeName;
        String collection = cd.getCloudDescriptor().getCollectionName();
        ContextKey contextKey = new ContextKey(collection, coreNodeName = cd.getCloudDescriptor().getCoreNodeName());
        ElectionContext prevContext = this.electionContexts.get(contextKey);
        if (prevContext != null) {
            prevContext.cancelElection();
        }
        String shardId = cd.getCloudDescriptor().getShardId();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("base_url", this.getBaseUrl());
        props.put("core", cd.getName());
        props.put("node_name", this.getNodeName());
        props.put("core_node_name", coreNodeName);
        ZkNodeProps ourProps = new ZkNodeProps(props);
        LeaderElector leaderElector = new LeaderElector(this.zkClient, contextKey, this.electionContexts);
        ShardLeaderElectionContext context = new ShardLeaderElectionContext(leaderElector, shardId, collection, coreNodeName, ourProps, this, this.cc);
        leaderElector.setup(context);
        this.electionContexts.put(contextKey, context);
        leaderElector.joinElection(context, false, joinAtHead);
    }

    private boolean checkRecovery(boolean recoverReloadedCores, boolean isLeader, boolean skipRecovery, String collection, String shardId, SolrCore core, CoreContainer cc, boolean afterExpiration) {
        if (this.SKIP_AUTO_RECOVERY) {
            log.warn("Skipping recovery according to sys prop solrcloud.skip.autorecovery");
            return false;
        }
        boolean doRecovery = true;
        if (!isLeader) {
            if (skipRecovery || !afterExpiration && core.isReloaded() && !recoverReloadedCores) {
                doRecovery = false;
            }
            if (doRecovery) {
                log.info("Core needs to recover:" + core.getName());
                core.getUpdateHandler().getSolrCoreState().doRecovery(cc, core.getCoreDescriptor());
                return true;
            }
            Replica.State lirState = this.getLeaderInitiatedRecoveryState(collection, shardId, core.getCoreDescriptor().getCloudDescriptor().getCoreNodeName());
            if (lirState == Replica.State.DOWN) {
                log.info("Leader marked core " + core.getName() + " down; starting recovery process");
                core.getUpdateHandler().getSolrCoreState().doRecovery(cc, core.getCoreDescriptor());
                return true;
            }
        } else {
            log.info("I am the leader, no recovery necessary");
        }
        return false;
    }

    public String getBaseUrl() {
        return this.baseURL;
    }

    public void publish(CoreDescriptor cd, Replica.State state) throws KeeperException, InterruptedException {
        this.publish(cd, state, true);
    }

    public void publish(CoreDescriptor cd, Replica.State state, boolean updateLastState) throws KeeperException, InterruptedException {
        this.publish(cd, state, updateLastState, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(CoreDescriptor cd, Replica.State state, boolean updateLastState, boolean forcePublish) throws KeeperException, InterruptedException {
        if (!forcePublish) {
            try (SolrCore core = this.cc.getCore(cd.getName());){
                if (core == null || core.isClosed()) {
                    return;
                }
                MDCLoggingContext.setCore(core);
            }
        } else {
            MDCLoggingContext.setCoreDescriptor(this.cc, cd);
        }
        try {
            Replica.State lirState;
            String collection = cd.getCloudDescriptor().getCollectionName();
            log.debug("publishing state={}", (Object)state.toString());
            Integer numShards = cd.getCloudDescriptor().getNumShards();
            if (numShards == null) {
                log.debug("numShards not found on descriptor - reading it from system property");
                numShards = Integer.getInteger("numShards");
            }
            assert (collection != null && collection.length() > 0);
            String shardId = cd.getCloudDescriptor().getShardId();
            String coreNodeName = cd.getCloudDescriptor().getCoreNodeName();
            if (state != Replica.State.DOWN && (lirState = this.getLeaderInitiatedRecoveryState(collection, shardId, coreNodeName)) != null) {
                assert (cd.getCloudDescriptor().getReplicaType() != Replica.Type.PULL) : "LIR should not happen for pull replicas!";
                if (state == Replica.State.ACTIVE) {
                    if (lirState == Replica.State.RECOVERING) {
                        this.updateLeaderInitiatedRecoveryState(collection, shardId, coreNodeName, Replica.State.ACTIVE, cd, true);
                    } else if (lirState == Replica.State.DOWN) {
                        throw new SolrException(SolrException.ErrorCode.INVALID_STATE, "Cannot publish state of core '" + cd.getName() + "' as active without recovering first!");
                    }
                } else if (state == Replica.State.RECOVERING && lirState == Replica.State.DOWN) {
                    this.updateLeaderInitiatedRecoveryState(collection, shardId, coreNodeName, Replica.State.RECOVERING, cd, true);
                }
            }
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("operation", "state");
            props.put("state", state.toString());
            props.put("base_url", this.getBaseUrl());
            props.put("core", cd.getName());
            props.put("roles", cd.getCloudDescriptor().getRoles());
            props.put("node_name", this.getNodeName());
            props.put("shard", cd.getCloudDescriptor().getShardId());
            props.put("collection", collection);
            props.put("type", cd.getCloudDescriptor().getReplicaType().toString());
            if (numShards != null) {
                props.put("numShards", numShards.toString());
            }
            if (coreNodeName != null) {
                props.put("core_node_name", coreNodeName);
            }
            try (SolrCore core = this.cc.getCore(cd.getName());){
                if (core != null && core.getDirectoryFactory().isSharedStorage() && core != null && core.getDirectoryFactory().isSharedStorage()) {
                    props.put("dataDir", core.getDataDir());
                    UpdateLog ulog = core.getUpdateHandler().getUpdateLog();
                    if (ulog != null) {
                        props.put("ulogDir", ulog.getLogDir());
                    }
                }
            }
            catch (SolrCoreInitializationException ex) {
                log.info("The core '{}' had failed to initialize before.", (Object)cd.getName());
            }
            ZkNodeProps m = new ZkNodeProps(props);
            if (updateLastState) {
                cd.getCloudDescriptor().lastPublished = state;
            }
            this.overseerJobQueue.offer(Utils.toJSON((Object)m));
        }
        finally {
            MDCLoggingContext.clear();
        }
    }

    private boolean needsToBeAssignedShardId(CoreDescriptor desc, ClusterState state, String coreNodeName) {
        CloudDescriptor cloudDesc = desc.getCloudDescriptor();
        String shardId = state.getShardId(this.getNodeName(), desc.getName());
        if (shardId != null) {
            cloudDesc.setShardId(shardId);
            return false;
        }
        return true;
    }

    public void unregister(String coreName, CoreDescriptor cd) throws InterruptedException, KeeperException {
        ElectionContext context;
        Replica replica;
        String coreNodeName = cd.getCloudDescriptor().getCoreNodeName();
        String collection = cd.getCloudDescriptor().getCollectionName();
        if (Strings.isNullOrEmpty((String)collection)) {
            log.error("No collection was specified.");
            assert (false) : "No collection was specified [" + collection + "]";
            return;
        }
        DocCollection docCollection = this.zkStateReader.getClusterState().getCollectionOrNull(collection);
        Replica replica2 = replica = docCollection == null ? null : docCollection.getReplica(coreNodeName);
        if ((replica == null || replica.getType() != Replica.Type.PULL) && (context = this.electionContexts.remove(new ContextKey(collection, coreNodeName))) != null) {
            context.cancelElection();
        }
        CloudDescriptor cloudDescriptor = cd.getCloudDescriptor();
        this.zkStateReader.unregisterCore(cloudDescriptor.getCollectionName());
        ZkNodeProps m = new ZkNodeProps(new String[]{"operation", OverseerAction.DELETECORE.toLower(), "core", coreName, "node_name", this.getNodeName(), "collection", cloudDescriptor.getCollectionName(), "base_url", this.getBaseUrl(), "core_node_name", coreNodeName});
        this.overseerJobQueue.offer(Utils.toJSON((Object)m));
    }

    public void createCollection(String collection) throws KeeperException, InterruptedException {
        ZkNodeProps m = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.CREATE.toLower(), "node_name", this.getNodeName(), "collection", collection});
        this.overseerJobQueue.offer(Utils.toJSON((Object)m));
    }

    void printLayoutToStdOut() throws KeeperException, InterruptedException {
        this.zkClient.printLayoutToStdOut();
    }

    public ZkStateReader getZkStateReader() {
        return this.zkStateReader;
    }

    private void doGetShardIdAndNodeNameProcess(CoreDescriptor cd) {
        String coreNodeName = cd.getCloudDescriptor().getCoreNodeName();
        if (coreNodeName != null) {
            this.waitForShardId(cd);
        } else {
            this.waitForCoreNodeName(cd);
            this.waitForShardId(cd);
        }
    }

    private void waitForCoreNodeName(CoreDescriptor descriptor) {
        int retryCount = 320;
        log.debug("look for our core node name");
        while (retryCount-- > 0) {
            DocCollection docCollection = this.zkStateReader.getClusterState().getCollectionOrNull(descriptor.getCloudDescriptor().getCollectionName());
            if (docCollection != null && docCollection.getSlicesMap() != null) {
                Map slicesMap = docCollection.getSlicesMap();
                for (Slice slice : slicesMap.values()) {
                    for (Replica replica : slice.getReplicas()) {
                        String nodeName = replica.getStr("node_name");
                        String core = replica.getStr("core");
                        String msgNodeName = this.getNodeName();
                        String msgCore = descriptor.getName();
                        if (!msgNodeName.equals(nodeName) || !core.equals(msgCore)) continue;
                        descriptor.getCloudDescriptor().setCoreNodeName(replica.getName());
                        return;
                    }
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void waitForShardId(CoreDescriptor cd) {
        log.debug("waiting to find shard id in clusterstate for " + cd.getName());
        int retryCount = 320;
        while (retryCount-- > 0) {
            String shardId = this.zkStateReader.getClusterState().getShardId(cd.getCollectionName(), this.getNodeName(), cd.getName());
            if (shardId != null) {
                cd.getCloudDescriptor().setShardId(shardId);
                return;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not get shard id for core: " + cd.getName());
    }

    public String getCoreNodeName(CoreDescriptor descriptor) {
        String coreNodeName = descriptor.getCloudDescriptor().getCoreNodeName();
        if (coreNodeName == null && !this.genericCoreNodeNames) {
            return this.getNodeName() + "_" + descriptor.getName();
        }
        return coreNodeName;
    }

    public void preRegister(CoreDescriptor cd) {
        String coreNodeName = this.getCoreNodeName(cd);
        try {
            this.checkStateInZk(cd);
            CloudDescriptor cloudDesc = cd.getCloudDescriptor();
            if (cloudDesc.getCoreNodeName() == null) {
                cloudDesc.setCoreNodeName(coreNodeName);
            }
            this.publish(cd, Replica.State.DOWN, false, true);
            String collectionName = cd.getCloudDescriptor().getCollectionName();
            DocCollection collection = this.zkStateReader.getClusterState().getCollectionOrNull(collectionName);
            log.debug(collection == null ? "Collection {} not visible yet, but flagging it so a watch is registered when it becomes visible" : "Registering watch for collection {}", (Object)collectionName);
            this.zkStateReader.registerCore(collectionName);
        }
        catch (KeeperException e) {
            log.error("", (Throwable)e);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("", (Throwable)e);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
        if (cd.getCloudDescriptor().getShardId() == null && this.needsToBeAssignedShardId(cd, this.zkStateReader.getClusterState(), coreNodeName)) {
            this.doGetShardIdAndNodeNameProcess(cd);
        } else {
            this.doGetShardIdAndNodeNameProcess(cd);
        }
    }

    private void checkStateInZk(CoreDescriptor cd) throws InterruptedException {
        if (!Overseer.isLegacy(this.zkStateReader)) {
            CloudDescriptor cloudDesc = cd.getCloudDescriptor();
            String coreNodeName = cloudDesc.getCoreNodeName();
            if (coreNodeName == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No coreNodeName for " + cd);
            }
            if (cloudDesc.getShardId() == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No shard id for " + cd);
            }
            AtomicReference errorMessage = new AtomicReference();
            AtomicReference collectionState = new AtomicReference();
            try {
                this.zkStateReader.waitForState(cd.getCollectionName(), 3L, TimeUnit.SECONDS, (n, c) -> {
                    collectionState.set(c);
                    if (c == null) {
                        return false;
                    }
                    Slice slice = c.getSlice(cloudDesc.getShardId());
                    if (slice == null) {
                        errorMessage.set("Invalid shard: " + cloudDesc.getShardId());
                        return false;
                    }
                    Replica replica = slice.getReplica(coreNodeName);
                    if (replica == null) {
                        errorMessage.set("coreNodeName " + coreNodeName + " does not exist in shard " + cloudDesc.getShardId());
                        return false;
                    }
                    return true;
                });
            }
            catch (TimeoutException e) {
                String error = (String)errorMessage.get();
                if (error == null) {
                    error = "Replica " + coreNodeName + " is not present in cluster state";
                }
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, error + ": " + collectionState.get());
            }
        }
    }

    private ZkCoreNodeProps waitForLeaderToSeeDownState(CoreDescriptor descriptor, String coreZkNodeName) {
        CloudDescriptor cloudDesc = descriptor.getCloudDescriptor();
        String collection = cloudDesc.getCollectionName();
        String shard = cloudDesc.getShardId();
        ZkCoreNodeProps leaderProps = null;
        int retries = 2;
        for (int i = 0; i < retries; ++i) {
            try {
                if (this.isClosed) {
                    throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "We have been closed");
                }
                leaderProps = this.getLeaderProps(collection, shard, 5000);
                break;
            }
            catch (Exception e) {
                SolrException.log((Logger)log, (String)"There was a problem finding the leader in zk", (Throwable)e);
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
                if (i != retries - 1) continue;
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "There was a problem finding the leader in zk");
            }
        }
        String leaderBaseUrl = leaderProps.getBaseUrl();
        String leaderCoreName = leaderProps.getCoreName();
        String myCoreNodeName = cloudDesc.getCoreNodeName();
        String myCoreName = descriptor.getName();
        String ourUrl = ZkCoreNodeProps.getCoreUrl((String)this.getBaseUrl(), (String)myCoreName);
        boolean isLeader = leaderProps.getCoreUrl().equals(ourUrl);
        if (!isLeader && !this.SKIP_AUTO_RECOVERY) {
            Replica.State lirState = null;
            try {
                lirState = this.getLeaderInitiatedRecoveryState(collection, shard, myCoreNodeName);
            }
            catch (Exception exc) {
                log.error("Failed to determine if replica " + myCoreNodeName + " is in leader-initiated recovery due to: " + exc, (Throwable)exc);
            }
            if (lirState != null) {
                log.debug("Replica " + myCoreNodeName + " is already in leader-initiated recovery, so not waiting for leader to see down state.");
            } else {
                log.info("Replica " + myCoreNodeName + " NOT in leader-initiated recovery, need to wait for leader to see down state.");
                try (HttpSolrClient client = ((HttpSolrClient.Builder)((HttpSolrClient.Builder)new HttpSolrClient.Builder(leaderBaseUrl).withConnectionTimeout(15000)).withSocketTimeout(120000)).build();){
                    CoreAdminRequest.WaitForState prepCmd = new CoreAdminRequest.WaitForState();
                    prepCmd.setCoreName(leaderCoreName);
                    prepCmd.setNodeName(this.getNodeName());
                    prepCmd.setCoreNodeName(coreZkNodeName);
                    prepCmd.setState(Replica.State.DOWN);
                    retries = 2;
                    for (int i = 0; i < retries; ++i) {
                        if (this.isClosed) {
                            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "We have been closed");
                        }
                        try {
                            client.request((SolrRequest)prepCmd);
                            break;
                        }
                        catch (Exception e) {
                            if (this.cc.isShutDown()) {
                                throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Core container is shutdown.");
                            }
                            Throwable rootCause = SolrException.getRootCause((Throwable)e);
                            if (rootCause instanceof IOException && !this.zkStateReader.getClusterState().liveNodesContain(leaderProps.getNodeName())) {
                                throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Node " + leaderProps.getNodeName() + " hosting leader for " + shard + " in " + collection + " is not live!");
                            }
                            SolrException.log((Logger)log, (String)"There was a problem making a request to the leader", (Throwable)e);
                            try {
                                Thread.sleep(2000L);
                            }
                            catch (InterruptedException e1) {
                                Thread.currentThread().interrupt();
                            }
                            if (i != retries - 1) continue;
                            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "There was a problem making a request to the leader");
                        }
                    }
                }
                catch (IOException e) {
                    SolrException.log((Logger)log, (String)"Error closing HttpSolrClient", (Throwable)e);
                }
            }
        }
        return leaderProps;
    }

    public static void linkConfSet(SolrZkClient zkClient, String collection, String confSetName) throws KeeperException, InterruptedException {
        byte[] data;
        String path = "/collections/" + collection;
        log.debug("Load collection config from:" + path);
        try {
            data = zkClient.getData(path, null, null, true);
        }
        catch (KeeperException.NoNodeException e) {
            ZkNodeProps props = new ZkNodeProps(new String[]{CONFIGNAME_PROP, confSetName});
            try {
                zkClient.makePath(path, Utils.toJSON((Object)props), CreateMode.PERSISTENT, null, true);
            }
            catch (KeeperException e2) {
                if (e2.code() != KeeperException.Code.NODEEXISTS) {
                    throw e;
                }
                zkClient.setData(path, Utils.toJSON((Object)props), true);
            }
            return;
        }
        ZkNodeProps props = null;
        if (data != null) {
            props = ZkNodeProps.load((byte[])data);
            HashMap<String, String> newProps = new HashMap<String, String>();
            newProps.putAll(props.getProperties());
            newProps.put(CONFIGNAME_PROP, confSetName);
            props = new ZkNodeProps(newProps);
        } else {
            props = new ZkNodeProps(new String[]{CONFIGNAME_PROP, confSetName});
        }
        zkClient.setData(path, Utils.toJSON((Object)props), true);
    }

    public static void bootstrapConf(SolrZkClient zkClient, CoreContainer cc, String solrHome) throws IOException {
        ZkConfigManager configManager = new ZkConfigManager(zkClient);
        List<CoreDescriptor> cds = cc.getCoresLocator().discover(cc);
        log.info("bootstrapping config for " + cds.size() + " cores into ZooKeeper using solr.xml from " + solrHome);
        for (CoreDescriptor cd : cds) {
            String coreName = cd.getName();
            String confName = cd.getCollectionName();
            if (StringUtils.isEmpty((String)confName)) {
                confName = coreName;
            }
            Path udir = cd.getInstanceDir().resolve("conf");
            log.info("Uploading directory " + udir + " with name " + confName + " for SolrCore " + coreName);
            configManager.uploadConfigDir(udir, confName);
        }
    }

    public DistributedQueue getOverseerJobQueue() {
        return this.overseerJobQueue;
    }

    public OverseerTaskQueue getOverseerCollectionQueue() {
        return this.overseerCollectionQueue;
    }

    public OverseerTaskQueue getOverseerConfigSetQueue() {
        return this.overseerConfigSetQueue;
    }

    public DistributedMap getOverseerRunningMap() {
        return this.overseerRunningMap;
    }

    public DistributedMap getOverseerCompletedMap() {
        return this.overseerCompletedMap;
    }

    public DistributedMap getOverseerFailureMap() {
        return this.overseerFailureMap;
    }

    public int getClientTimeout() {
        return this.clientTimeout;
    }

    public Overseer getOverseer() {
        return this.overseer;
    }

    public LeaderElector getOverseerElector() {
        return this.overseerElector;
    }

    static String generateNodeName(String hostName, String hostPort, String hostContext) {
        try {
            return hostName + ':' + hostPort + '_' + URLEncoder.encode(ZkController.trimLeadingAndTrailingSlashes(hostContext), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("JVM Does not seem to support UTF-8", e);
        }
    }

    public static String trimLeadingAndTrailingSlashes(String in) {
        if (null == in) {
            return in;
        }
        String out = in;
        if (out.startsWith("/")) {
            out = out.substring(1);
        }
        if (out.endsWith("/")) {
            out = out.substring(0, out.length() - 1);
        }
        return out;
    }

    public void rejoinOverseerElection(String electionNode, boolean joinAtHead) {
        try {
            if (electionNode != null) {
                if (this.overseerElector.getContext() == null || this.overseerElector.getContext().leaderSeqPath == null) {
                    this.overseerElector.retryElection(new OverseerElectionContext(this.zkClient, this.overseer, this.getNodeName()), joinAtHead);
                    return;
                }
                if (!this.overseerElector.getContext().leaderSeqPath.endsWith(electionNode)) {
                    log.warn("Asked to rejoin with wrong election node : {}, current node is {}", (Object)electionNode, (Object)this.overseerElector.getContext().leaderSeqPath);
                    if (electionNode.startsWith(this.getNodeName())) {
                        try {
                            this.zkClient.delete("/overseer_elect/election/" + electionNode, -1, true);
                        }
                        catch (KeeperException.NoNodeException noNodeException) {
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        catch (Exception e) {
                            log.warn("Old election node exists , could not be removed ", (Throwable)e);
                        }
                    }
                }
            } else {
                this.overseerElector.retryElection(this.overseerElector.getContext(), joinAtHead);
            }
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to rejoin election", (Throwable)e);
        }
    }

    public void rejoinShardLeaderElection(SolrParams params) {
        try {
            String collectionName = params.get("collection");
            String shardId = params.get("shard");
            String coreNodeName = params.get("core_node_name");
            String coreName = params.get("core");
            String electionNode = params.get("election_node");
            String baseUrl = params.get("base_url");
            try (SolrCore core = this.cc.getCore(coreName);){
                MDCLoggingContext.setCore(core);
                log.info("Rejoin the shard leader election.");
                ContextKey contextKey = new ContextKey(collectionName, coreNodeName);
                ElectionContext prevContext = this.electionContexts.get(contextKey);
                if (prevContext != null) {
                    prevContext.cancelElection();
                }
                ZkNodeProps zkProps = new ZkNodeProps(new String[]{"base_url", baseUrl, "core", coreName, "node_name", this.getNodeName(), "core_node_name", coreNodeName});
                LeaderElector elect = ((ShardLeaderElectionContextBase)prevContext).getLeaderElector();
                ShardLeaderElectionContext context = new ShardLeaderElectionContext(elect, shardId, collectionName, coreNodeName, zkProps, this, this.getCoreContainer());
                context.leaderSeqPath = context.electionPath + "/election" + "/" + electionNode;
                elect.setup(context);
                this.electionContexts.put(contextKey, context);
                elect.retryElection(context, params.getBool("rejoinAtHead", false));
            }
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to rejoin election", (Throwable)e);
        }
    }

    public void checkOverseerDesignate() {
        try {
            byte[] data = this.zkClient.getData("/roles.json", null, new Stat(), true);
            if (data == null) {
                return;
            }
            Map roles = (Map)Utils.fromJSON((byte[])data);
            if (roles == null) {
                return;
            }
            List nodeList = (List)roles.get("overseer");
            if (nodeList == null) {
                return;
            }
            if (nodeList.contains(this.getNodeName())) {
                ZkNodeProps props = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.ADDROLE.toString().toLowerCase(Locale.ROOT), "node", this.getNodeName(), "role", "overseer"});
                log.info("Going to add role {} ", (Object)props);
                this.getOverseerCollectionQueue().offer(Utils.toJSON((Object)props));
            }
        }
        catch (KeeperException.NoNodeException nne) {
            return;
        }
        catch (Exception e) {
            log.warn("could not read the overseer designate ", (Throwable)e);
        }
    }

    CoreContainer getCoreContainer() {
        return this.cc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ensureReplicaInLeaderInitiatedRecovery(CoreContainer container, String collection, String shardId, ZkCoreNodeProps replicaCoreProps, CoreDescriptor leaderCd, boolean forcePublishState) throws KeeperException, InterruptedException {
        String replicaUrl = replicaCoreProps.getCoreUrl();
        if (collection == null) {
            throw new IllegalArgumentException("collection parameter cannot be null for starting leader-initiated recovery for replica: " + replicaUrl);
        }
        if (shardId == null) {
            throw new IllegalArgumentException("shard parameter cannot be null for starting leader-initiated recovery for replica: " + replicaUrl);
        }
        if (replicaUrl == null) {
            throw new IllegalArgumentException("replicaUrl parameter cannot be null for starting leader-initiated recovery");
        }
        boolean nodeIsLive = true;
        String replicaNodeName = replicaCoreProps.getNodeName();
        String replicaCoreNodeName = ((Replica)replicaCoreProps.getNodeProps()).getName();
        assert (replicaCoreNodeName != null) : "No core name for replica " + replicaNodeName;
        Map<String, String> map = this.replicasInLeaderInitiatedRecovery;
        synchronized (map) {
            if (this.replicasInLeaderInitiatedRecovery.containsKey(replicaUrl) && !forcePublishState) {
                log.debug("Replica {} already in leader-initiated recovery handling.", (Object)replicaUrl);
                return false;
            }
            if (this.getZkStateReader().getClusterState().liveNodesContain(replicaNodeName)) {
                LeaderInitiatedRecoveryThread lirThread = new LeaderInitiatedRecoveryThread(this, container, collection, shardId, replicaCoreProps, 120, leaderCd);
                ExecutorService executor = container.getUpdateShardHandler().getUpdateExecutor();
                try {
                    MDC.put((String)"DistributedUpdateProcessor.replicaUrlToRecover", (String)replicaCoreProps.getCoreUrl());
                    executor.execute(lirThread);
                }
                finally {
                    MDC.remove((String)"DistributedUpdateProcessor.replicaUrlToRecover");
                }
                this.replicasInLeaderInitiatedRecovery.put(replicaUrl, this.getLeaderInitiatedRecoveryZnodePath(collection, shardId, replicaCoreNodeName));
                log.info("Put replica core={} coreNodeName={} on " + replicaNodeName + " into leader-initiated recovery.", (Object)replicaCoreProps.getCoreName(), (Object)replicaCoreNodeName);
            } else {
                nodeIsLive = false;
                log.info("Node " + replicaNodeName + " is not live, so skipping leader-initiated recovery for replica: core={} coreNodeName={}", (Object)replicaCoreProps.getCoreName(), (Object)replicaCoreNodeName);
            }
        }
        return nodeIsLive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReplicaInRecoveryHandling(String replicaUrl) {
        boolean exists = false;
        Map<String, String> map = this.replicasInLeaderInitiatedRecovery;
        synchronized (map) {
            exists = this.replicasInLeaderInitiatedRecovery.containsKey(replicaUrl);
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReplicaFromLeaderInitiatedRecoveryHandling(String replicaUrl) {
        Map<String, String> map = this.replicasInLeaderInitiatedRecovery;
        synchronized (map) {
            this.replicasInLeaderInitiatedRecovery.remove(replicaUrl);
        }
    }

    public Replica.State getLeaderInitiatedRecoveryState(String collection, String shardId, String coreNodeName) {
        Map<String, Object> stateObj = this.getLeaderInitiatedRecoveryStateObject(collection, shardId, coreNodeName);
        if (stateObj == null) {
            return null;
        }
        String stateStr = (String)stateObj.get("state");
        return stateStr == null ? null : Replica.State.getState((String)stateStr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, Object> getLeaderInitiatedRecoveryStateObject(String collection, String shardId, String coreNodeName) {
        if (collection == null) return null;
        if (shardId == null) return null;
        if (coreNodeName == null) {
            return null;
        }
        String znodePath = this.getLeaderInitiatedRecoveryZnodePath(collection, shardId, coreNodeName);
        byte[] stateData = null;
        try {
            stateData = this.zkClient.getData(znodePath, null, new Stat(), false);
        }
        catch (KeeperException.NoNodeException noNodeException) {
        }
        catch (KeeperException.ConnectionLossException | KeeperException.SessionExpiredException cle) {
            log.warn("Unable to read " + znodePath + " due to: " + cle);
        }
        catch (Exception exc) {
            log.error("Failed to read data from znode " + znodePath + " due to: " + exc);
            if (!(exc instanceof SolrException)) throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to read data from znodePath: " + znodePath, (Throwable)exc);
            throw (SolrException)((Object)exc);
        }
        Map stateObj = null;
        if (stateData == null) return stateObj;
        if (stateData.length <= 0) return stateObj;
        if (stateData[0] != 123) return Utils.makeMap((Object[])new Object[]{"state", new String(stateData, StandardCharsets.UTF_8)});
        Object parsedJson = Utils.fromJSON((byte[])stateData);
        if (!(parsedJson instanceof Map)) throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Leader-initiated recovery state data is invalid! " + parsedJson);
        return (Map)parsedJson;
    }

    public void updateLeaderInitiatedRecoveryState(String collection, String shardId, String coreNodeName, Replica.State state, CoreDescriptor leaderCd, boolean retryOnConnLoss) {
        if (collection == null || shardId == null || coreNodeName == null) {
            log.warn("Cannot set leader-initiated recovery state znode to " + state.toString() + " using: collection=" + collection + "; shardId=" + shardId + "; coreNodeName=" + coreNodeName);
            return;
        }
        assert (leaderCd != null);
        assert (leaderCd.getCloudDescriptor() != null);
        String leaderCoreNodeName = leaderCd.getCloudDescriptor().getCoreNodeName();
        String znodePath = this.getLeaderInitiatedRecoveryZnodePath(collection, shardId, coreNodeName);
        if (state == Replica.State.ACTIVE) {
            try {
                this.zkClient.delete(znodePath, -1, retryOnConnLoss);
            }
            catch (Exception justLogIt) {
                log.warn("Failed to delete znode " + znodePath, (Throwable)justLogIt);
            }
            return;
        }
        Map stateObj = null;
        try {
            stateObj = this.getLeaderInitiatedRecoveryStateObject(collection, shardId, coreNodeName);
        }
        catch (Exception exc) {
            log.warn(exc.getMessage(), (Throwable)exc);
        }
        if (stateObj == null) {
            stateObj = Utils.makeMap((Object[])new Object[0]);
        }
        stateObj.put("state", state.toString());
        if (stateObj.get("createdByNodeName") == null) {
            stateObj.put("createdByNodeName", this.nodeName);
        }
        if (stateObj.get("createdByCoreNodeName") == null && leaderCoreNodeName != null) {
            stateObj.put("createdByCoreNodeName", leaderCoreNodeName);
        }
        byte[] znodeData = Utils.toJSON((Object)stateObj);
        try {
            if (state == Replica.State.DOWN) {
                this.markShardAsDownIfLeader(collection, shardId, leaderCd, znodePath, znodeData, retryOnConnLoss);
            } else if (this.zkClient.exists(znodePath, true).booleanValue()) {
                this.zkClient.setData(znodePath, znodeData, retryOnConnLoss);
            } else {
                this.zkClient.makePath(znodePath, znodeData, retryOnConnLoss);
            }
            log.debug("Wrote {} to {}", (Object)state.toString(), (Object)znodePath);
        }
        catch (Exception exc) {
            if (exc instanceof SolrException) {
                throw (SolrException)((Object)exc);
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to update data to " + state.toString() + " for znode: " + znodePath, (Throwable)exc);
        }
    }

    private void markShardAsDownIfLeader(String collection, String shardId, CoreDescriptor leaderCd, String znodePath, byte[] znodeData, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        if (!leaderCd.getCloudDescriptor().isLeader()) {
            log.info("No longer leader, aborting attempt to mark shard down as part of LIR");
            throw new NotLeaderException(SolrException.ErrorCode.SERVER_ERROR, "Locally, we do not think we are the leader.");
        }
        ContextKey key = new ContextKey(collection, leaderCd.getCloudDescriptor().getCoreNodeName());
        ElectionContext context = this.electionContexts.get(key);
        if (context == null || !leaderCd.getCloudDescriptor().isLeader()) {
            log.info("No longer leader, aborting attempt to mark shard down as part of LIR");
            throw new NotLeaderException(SolrException.ErrorCode.SERVER_ERROR, "Locally, we do not think we are the leader.");
        }
        Integer leaderZkNodeParentVersion = ((ShardLeaderElectionContextBase)context).getLeaderZkNodeParentVersion();
        if (this.zkClient.exists(znodePath, retryOnConnLoss).booleanValue()) {
            ArrayList<Op> ops = new ArrayList<Op>(2);
            ops.add(Op.check((String)new org.apache.hadoop.fs.Path(((ShardLeaderElectionContextBase)context).leaderPath).getParent().toString(), (int)leaderZkNodeParentVersion));
            ops.add(Op.setData((String)znodePath, (byte[])znodeData, (int)-1));
            this.zkClient.multi(ops, retryOnConnLoss);
        } else {
            String parentZNodePath = this.getLeaderInitiatedRecoveryZnodePath(collection, shardId);
            try {
                this.zkClient.makePath(parentZNodePath, (byte[])null, CreateMode.PERSISTENT, (Watcher)null, true, retryOnConnLoss, 2);
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                // empty catch block
            }
            ArrayList<Op> ops = new ArrayList<Op>(2);
            ops.add(Op.check((String)new org.apache.hadoop.fs.Path(((ShardLeaderElectionContextBase)context).leaderPath).getParent().toString(), (int)leaderZkNodeParentVersion));
            ops.add(Op.create((String)znodePath, (byte[])znodeData, (List)this.zkClient.getZkACLProvider().getACLsToAdd(znodePath), (CreateMode)CreateMode.PERSISTENT));
            this.zkClient.multi(ops, retryOnConnLoss);
        }
    }

    public String getLeaderInitiatedRecoveryZnodePath(String collection, String shardId) {
        return "/collections/" + collection + "/leader_initiated_recovery/" + shardId;
    }

    public String getLeaderInitiatedRecoveryZnodePath(String collection, String shardId, String coreNodeName) {
        return this.getLeaderInitiatedRecoveryZnodePath(collection, shardId) + "/" + coreNodeName;
    }

    public void throwErrorIfReplicaReplaced(CoreDescriptor desc) {
        DocCollection collection;
        ClusterState clusterState = this.getZkStateReader().getClusterState();
        if (clusterState != null && (collection = clusterState.getCollectionOrNull(desc.getCloudDescriptor().getCollectionName())) != null) {
            CloudUtil.checkSharedFSFailoverReplaced(this.cc, desc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnReconnectListener(OnReconnect listener) {
        if (listener != null) {
            HashSet<OnReconnect> hashSet = this.reconnectListeners;
            synchronized (hashSet) {
                this.reconnectListeners.add(listener);
                log.debug("Added new OnReconnect listener " + listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOnReconnectListener(OnReconnect listener) {
        if (listener != null) {
            boolean wasRemoved;
            HashSet<OnReconnect> hashSet = this.reconnectListeners;
            synchronized (hashSet) {
                wasRemoved = this.reconnectListeners.remove(listener);
            }
            if (wasRemoved) {
                log.debug("Removed OnReconnect listener " + listener);
            } else {
                log.warn("Was asked to remove OnReconnect listener " + listener + ", but remove operation did not find it in the list of registered listeners.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<OnReconnect> getCurrentOnReconnectListeners() {
        HashSet clonedListeners;
        HashSet<OnReconnect> hashSet = this.reconnectListeners;
        synchronized (hashSet) {
            clonedListeners = (HashSet)this.reconnectListeners.clone();
        }
        return clonedListeners;
    }

    public static int persistConfigResourceToZooKeeper(ZkSolrResourceLoader zkLoader, int znodeVersion, String resourceName, byte[] content, boolean createIfNotExists) {
        int latestVersion;
        block13: {
            latestVersion = znodeVersion;
            ZkController zkController = zkLoader.getZkController();
            SolrZkClient zkClient = zkController.getZkClient();
            String resourceLocation = zkLoader.getConfigSetZkPath() + "/" + resourceName;
            String errMsg = "Failed to persist resource at {0} - old {1}";
            try {
                try {
                    Stat stat = zkClient.setData(resourceLocation, content, znodeVersion, true);
                    latestVersion = stat.getVersion();
                    log.info("Persisted config data to node {} ", (Object)resourceLocation);
                    ZkController.touchConfDir(zkLoader);
                }
                catch (KeeperException.NoNodeException e) {
                    if (!createIfNotExists) break block13;
                    try {
                        zkClient.create(resourceLocation, content, CreateMode.PERSISTENT, true);
                        latestVersion = 0;
                        ZkController.touchConfDir(zkLoader);
                    }
                    catch (KeeperException.NodeExistsException nee) {
                        try {
                            Stat stat = zkClient.exists(resourceLocation, null, true);
                            log.debug("failed to set data version in zk is {} and expected version is {} ", (Object)stat.getVersion(), (Object)znodeVersion);
                        }
                        catch (Exception e1) {
                            log.warn("could not get stat");
                        }
                        log.info(StrUtils.formatString((String)errMsg, (Object[])new Object[]{resourceLocation, znodeVersion}));
                        throw new ResourceModifiedInZkException(SolrException.ErrorCode.CONFLICT, StrUtils.formatString((String)errMsg, (Object[])new Object[]{resourceLocation, znodeVersion}) + ", retry.");
                    }
                }
            }
            catch (KeeperException.BadVersionException bve) {
                int v = -1;
                try {
                    Stat stat = zkClient.exists(resourceLocation, null, true);
                    v = stat.getVersion();
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
                log.info(StrUtils.formatString((String)(errMsg + " zkVersion= " + v), (Object[])new Object[]{resourceLocation, znodeVersion}));
                throw new ResourceModifiedInZkException(SolrException.ErrorCode.CONFLICT, StrUtils.formatString((String)errMsg, (Object[])new Object[]{resourceLocation, znodeVersion}) + ", retry.");
            }
            catch (ResourceModifiedInZkException e) {
                throw e;
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                String msg = "Error persisting resource at " + resourceLocation;
                log.error(msg, (Throwable)e);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg, (Throwable)e);
            }
        }
        return latestVersion;
    }

    public static void touchConfDir(ZkSolrResourceLoader zkLoader) {
        SolrZkClient zkClient = zkLoader.getZkController().getZkClient();
        try {
            zkClient.setData(zkLoader.getConfigSetZkPath(), new byte[]{0}, true);
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            String msg = "Error 'touching' conf location " + zkLoader.getConfigSetZkPath();
            log.error(msg, (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterConfListener(String confDir, Runnable listener) {
        Map<String, Set<Runnable>> map = this.confDirectoryListeners;
        synchronized (map) {
            Set<Runnable> listeners = this.confDirectoryListeners.get(confDir);
            if (listeners == null) {
                log.warn(confDir + " has no more registered listeners, but a live one attempted to unregister!");
                return;
            }
            if (listeners.remove(listener)) {
                log.debug("removed listener for config directory [{}]", (Object)confDir);
            }
            if (listeners.isEmpty()) {
                log.debug("No more listeners for config directory [{}]", (Object)confDir);
                this.confDirectoryListeners.remove(confDir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConfListenerForCore(final String confDir, SolrCore core, final Runnable listener) {
        if (listener == null) {
            throw new NullPointerException("listener cannot be null");
        }
        Map<String, Set<Runnable>> map = this.confDirectoryListeners;
        synchronized (map) {
            Set<Runnable> confDirListeners = this.getConfDirListeners(confDir);
            confDirListeners.add(listener);
            core.addCloseHook(new CloseHook(){

                @Override
                public void preClose(SolrCore core) {
                    ZkController.this.unregisterConfListener(confDir, listener);
                }

                @Override
                public void postClose(SolrCore core) {
                }
            });
        }
    }

    private Set<Runnable> getConfDirListeners(String confDir) {
        assert (Thread.holdsLock(this.confDirectoryListeners)) : "confDirListeners lock not held by thread";
        Set<Runnable> confDirListeners = this.confDirectoryListeners.get(confDir);
        if (confDirListeners == null) {
            log.debug("watch zkdir {}", (Object)confDir);
            confDirListeners = new HashSet<Runnable>();
            this.confDirectoryListeners.put(confDir, confDirListeners);
            this.setConfWatcher(confDir, new WatcherImpl(confDir), null);
        }
        return confDirListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fireEventListeners(String zkDir) {
        Map<String, Set<Runnable>> map = this.confDirectoryListeners;
        synchronized (map) {
            if (!this.confDirectoryListeners.containsKey(zkDir)) {
                log.debug("Watcher on {} is removed ", (Object)zkDir);
                return false;
            }
            Set<Runnable> listeners = this.confDirectoryListeners.get(zkDir);
            if (listeners != null && !listeners.isEmpty()) {
                HashSet<Runnable> listenersCopy = new HashSet<Runnable>(listeners);
                new Thread(() -> {
                    log.debug("Running listeners for {}", (Object)zkDir);
                    for (Runnable listener : listenersCopy) {
                        try {
                            listener.run();
                        }
                        catch (Exception e) {
                            log.warn("listener throws error", (Throwable)e);
                        }
                    }
                }).start();
            }
        }
        return true;
    }

    private void setConfWatcher(String zkDir, Watcher watcher, Stat stat) {
        try {
            Stat newStat = this.zkClient.exists(zkDir, watcher, true);
            if (stat != null && newStat.getVersion() > stat.getVersion()) {
                this.fireEventListeners(zkDir);
            }
        }
        catch (KeeperException e) {
            log.error("failed to set watcher for conf dir {} ", (Object)zkDir);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("failed to set watcher for conf dir {} ", (Object)zkDir);
        }
    }

    public OnReconnect getConfigDirListener() {
        return () -> {
            Map<String, Set<Runnable>> map = this.confDirectoryListeners;
            synchronized (map) {
                for (String s : this.confDirectoryListeners.keySet()) {
                    this.setConfWatcher(s, new WatcherImpl(s), null);
                    this.fireEventListeners(s);
                }
            }
        };
    }

    public String getLeaderSeqPath(String collection, String coreNodeName) {
        ContextKey key = new ContextKey(collection, coreNodeName);
        ElectionContext context = this.electionContexts.get(key);
        return context != null ? context.leaderSeqPath : null;
    }

    public boolean checkIfCoreNodeNameAlreadyExists(CoreDescriptor dcore) {
        DocCollection collection = this.zkStateReader.getClusterState().getCollectionOrNull(dcore.getCollectionName());
        if (collection != null) {
            Collection slices = collection.getSlices();
            for (Slice slice : slices) {
                Collection replicas = slice.getReplicas();
                Replica r = slice.getReplica(dcore.getCloudDescriptor().getCoreNodeName());
                if (r == null) continue;
                return true;
            }
        }
        return false;
    }

    public void publishNodeAsDown(String nodeName) {
        log.debug("Publish node={} as DOWN", (Object)nodeName);
        ZkNodeProps m = new ZkNodeProps(new String[]{"operation", OverseerAction.DOWNNODE.toLower(), "node_name", nodeName});
        try {
            Overseer.getStateUpdateQueue(this.getZkClient()).offer(Utils.toJSON((Object)m));
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            log.debug("Publish node as down was interrupted.");
        }
        catch (Exception e) {
            log.warn("Could not publish node as down: " + e.getMessage());
        }
    }

    public static class NotLeaderException
    extends SolrException {
        public NotLeaderException(SolrException.ErrorCode code, String msg) {
            super(code, msg);
        }
    }

    private class WatcherImpl
    implements Watcher {
        private final String zkDir;

        private WatcherImpl(String dir) {
            this.zkDir = dir;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(WatchedEvent event) {
            if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                return;
            }
            Stat stat = null;
            try {
                stat = ZkController.this.zkClient.exists(this.zkDir, null, true);
            }
            catch (KeeperException keeperException) {
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            boolean resetWatcher = false;
            try {
                resetWatcher = ZkController.this.fireEventListeners(this.zkDir);
            }
            finally {
                if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                    log.debug("A node got unwatched for {}", (Object)this.zkDir);
                } else if (resetWatcher) {
                    ZkController.this.setConfWatcher(this.zkDir, this, stat);
                } else {
                    log.debug("A node got unwatched for {}", (Object)this.zkDir);
                }
            }
        }
    }

    public static class ResourceModifiedInZkException
    extends SolrException {
        public ResourceModifiedInZkException(SolrException.ErrorCode code, String msg) {
            super(code, msg);
        }
    }

    private static class OnReconnectNotifyAsync
    implements Callable {
        private final OnReconnect listener;

        OnReconnectNotifyAsync(OnReconnect listener) {
            this.listener = listener;
        }

        public Object call() throws Exception {
            this.listener.command();
            return null;
        }
    }

    private class RegisterCoreAsync
    implements Callable {
        CoreDescriptor descriptor;
        boolean recoverReloadedCores;
        boolean afterExpiration;

        RegisterCoreAsync(CoreDescriptor descriptor, boolean recoverReloadedCores, boolean afterExpiration) {
            this.descriptor = descriptor;
            this.recoverReloadedCores = recoverReloadedCores;
            this.afterExpiration = afterExpiration;
        }

        public Object call() throws Exception {
            log.info("Registering core {} afterExpiration? {}", (Object)this.descriptor.getName(), (Object)this.afterExpiration);
            ZkController.this.register(this.descriptor.getName(), this.descriptor, this.recoverReloadedCores, this.afterExpiration, false);
            return this.descriptor;
        }
    }

    static class ContextKey {
        private String collection;
        private String coreNodeName;

        public ContextKey(String collection, String coreNodeName) {
            this.collection = collection;
            this.coreNodeName = coreNodeName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.collection == null ? 0 : this.collection.hashCode());
            result = 31 * result + (this.coreNodeName == null ? 0 : this.coreNodeName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ContextKey other = (ContextKey)obj;
            if (this.collection == null ? other.collection != null : !this.collection.equals(other.collection)) {
                return false;
            }
            return !(this.coreNodeName == null ? other.coreNodeName != null : !this.coreNodeName.equals(other.coreNodeName));
        }
    }
}

