/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.solr.cloud.Assign;
import org.apache.solr.cloud.DistributedQueue;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.OverseerCollectionMessageHandler;
import org.apache.solr.cloud.overseer.OverseerAction;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.ImplicitDocRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ReplicaPosition;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.backup.BackupManager;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.apache.solr.handler.component.ShardHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OverseerCollectionMessageHandler ocmh;

    public RestoreCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
    }

    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList results) throws Exception {
        String restoreCollectionName = message.getStr("collection");
        String backupName = message.getStr("name");
        ShardHandler shardHandler = this.ocmh.shardHandlerFactory.getShardHandler();
        String asyncId = message.getStr("async");
        String repo = message.getStr("repository");
        HashMap<String, String> requestMap = new HashMap<String, String>();
        CoreContainer cc = this.ocmh.overseer.getZkController().getCoreContainer();
        BackupRepository repository = cc.newBackupRepository(Optional.ofNullable(repo));
        URI location = repository.createURI(message.getStr("location"));
        URI backupPath = repository.resolve(location, backupName);
        ZkStateReader zkStateReader = this.ocmh.zkStateReader;
        BackupManager backupMgr = new BackupManager(repository, zkStateReader);
        Properties properties = backupMgr.readBackupProperties(location, backupName);
        String backupCollection = properties.getProperty("collection");
        DocCollection backupCollectionState = backupMgr.readCollectionState(location, backupName, backupCollection);
        List<String> nodeList = Assign.getLiveOrLiveAndCreateNodeSetList(zkStateReader.getClusterState().getLiveNodes(), message, OverseerCollectionMessageHandler.RANDOM);
        int numShards = backupCollectionState.getActiveSlices().size();
        int numNrtReplicas = this.getInt(message, "nrtReplicas", backupCollectionState.getNumNrtReplicas(), 0);
        if (numNrtReplicas == 0) {
            numNrtReplicas = this.getInt(message, "replicationFactor", backupCollectionState.getReplicationFactor(), 0);
        }
        int numTlogReplicas = this.getInt(message, "tlogReplicas", backupCollectionState.getNumTlogReplicas(), 0);
        int numPullReplicas = this.getInt(message, "pullReplicas", backupCollectionState.getNumPullReplicas(), 0);
        int totalReplicasPerShard = numNrtReplicas + numTlogReplicas + numPullReplicas;
        int maxShardsPerNode = message.getInt("maxShardsPerNode", Integer.valueOf(backupCollectionState.getMaxShardsPerNode()));
        int availableNodeCount = nodeList.size();
        if (numShards * totalReplicasPerShard > availableNodeCount * maxShardsPerNode) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format(Locale.ROOT, "Solr cloud with available number of nodes:%d is insufficient for restoring a collection with %d shards, total replicas per shard %d and maxShardsPerNode %d. Consider increasing maxShardsPerNode value OR number of available nodes.", availableNodeCount, numShards, totalReplicasPerShard, maxShardsPerNode));
        }
        String configName = (String)properties.get("collection.configName");
        String restoreConfigName = message.getStr("collection.configName", configName);
        if (zkStateReader.getConfigManager().configExists(restoreConfigName).booleanValue()) {
            log.info("Using existing config {}", (Object)restoreConfigName);
        } else {
            log.info("Uploading config {}", (Object)restoreConfigName);
            backupMgr.uploadConfigDir(location, backupName, configName, restoreConfigName);
        }
        log.info("Starting restore into collection={} with backup_name={} at location={}", new Object[]{restoreCollectionName, backupName, location});
        HashMap<String, Object> propMap = new HashMap<String, Object>();
        propMap.put("operation", CollectionParams.CollectionAction.CREATE.toString());
        propMap.put("fromApi", "true");
        for (String string : OverseerCollectionMessageHandler.COLL_PROPS.keySet()) {
            Object object = message.getProperties().getOrDefault(string, backupCollectionState.get(string));
            if (object == null) continue;
            propMap.put(string, object);
        }
        propMap.put("name", restoreCollectionName);
        propMap.put("createNodeSet", "EMPTY");
        propMap.put("collection.configName", restoreConfigName);
        Map routerProps = (Map)backupCollectionState.getProperties().get("router");
        for (Map.Entry entry : routerProps.entrySet()) {
            propMap.put("router." + (String)entry.getKey(), entry.getValue());
        }
        Set set = backupCollectionState.getActiveSlicesMap().keySet();
        if (backupCollectionState.getRouter() instanceof ImplicitDocRouter) {
            propMap.put("shards", StrUtils.join(set, (char)','));
        } else {
            propMap.put("numShards", set.size());
            Collection collection = backupCollectionState.getActiveSlices();
            LinkedHashMap<String, Slice> newSlices = new LinkedHashMap<String, Slice>(collection.size());
            for (Slice backupSlice : collection) {
                newSlices.put(backupSlice.getName(), new Slice(backupSlice.getName(), Collections.emptyMap(), backupSlice.getProperties()));
            }
            propMap.put("shards", newSlices);
        }
        this.ocmh.commandMap.get(CollectionParams.CollectionAction.CREATE).call(zkStateReader.getClusterState(), new ZkNodeProps(propMap), new NamedList());
        DocCollection restoreCollection = zkStateReader.getClusterState().getCollection(restoreCollectionName);
        DistributedQueue inQueue = Overseer.getStateUpdateQueue(zkStateReader.getZkClient());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("operation", OverseerAction.UPDATESHARDSTATE.toLower());
        for (Slice shard : restoreCollection.getSlices()) {
            hashMap.put(shard.getName(), Slice.State.CONSTRUCTION.toString());
        }
        hashMap.put("collection", restoreCollectionName);
        inQueue.offer(Utils.toJSON((Object)new ZkNodeProps(hashMap)));
        ClusterState clusterState = zkStateReader.getClusterState();
        ArrayList<String> arrayList = new ArrayList<String>();
        restoreCollection.getSlices().forEach(x -> sliceNames2.add(x.getName()));
        List<ReplicaPosition> replicaPositions = Assign.identifyNodes(() -> this.ocmh.overseer.getZkController().getCoreContainer(), this.ocmh.zkStateReader, clusterState, nodeList, restoreCollectionName, message, arrayList, numNrtReplicas, numTlogReplicas, numPullReplicas);
        for (Object slice : restoreCollection.getSlices()) {
            log.debug("Adding replica for shard={} collection={} ", (Object)slice.getName(), (Object)restoreCollection);
            HashMap<String, Object> propMap3 = new HashMap<String, Object>();
            propMap3.put("operation", CollectionParams.CollectionAction.CREATESHARD);
            propMap3.put("collection", restoreCollectionName);
            propMap3.put("shard", slice.getName());
            if (numNrtReplicas >= 1) {
                propMap3.put("type", Replica.Type.NRT.name());
            } else if (numTlogReplicas >= 1) {
                propMap3.put("type", Replica.Type.TLOG.name());
            } else {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unexpected number of replicas, replicationFactor, " + Replica.Type.NRT + " or " + Replica.Type.TLOG + " must be greater than 0");
            }
            for (ReplicaPosition replicaPosition : replicaPositions) {
                if (!Objects.equals(replicaPosition.shard, slice.getName())) continue;
                String node = replicaPosition.node;
                propMap3.put("node", node);
                replicaPositions.remove(replicaPosition);
                break;
            }
            if (asyncId != null) {
                propMap3.put("async", asyncId);
            }
            this.ocmh.addPropertyParams(message, propMap3);
            this.ocmh.addReplica(clusterState, new ZkNodeProps(propMap3), new NamedList(), null);
        }
        restoreCollection = zkStateReader.getClusterState().getCollection(restoreCollectionName);
        for (Object slice : restoreCollection.getSlices()) {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", new String[]{CoreAdminParams.CoreAdminAction.RESTORECORE.toString()});
            params.set("name", new String[]{"snapshot." + slice.getName()});
            params.set("location", new String[]{backupPath.toASCIIString()});
            params.set("repository", new String[]{repo});
            this.ocmh.sliceCmd(clusterState, params, null, (Slice)slice, shardHandler, asyncId, requestMap);
        }
        this.ocmh.processResponses(new NamedList(), shardHandler, true, "Could not restore core", asyncId, requestMap);
        HashMap<String, String> propMap4 = new HashMap<String, String>();
        propMap4.put("operation", OverseerAction.UPDATESHARDSTATE.toLower());
        propMap4.put("collection", restoreCollectionName);
        for (Slice shard : restoreCollection.getSlices()) {
            propMap4.put(shard.getName(), Slice.State.ACTIVE.toString());
        }
        inQueue.offer(Utils.toJSON((Object)new ZkNodeProps(propMap4)));
        restoreCollection = zkStateReader.getClusterState().getCollection(restoreCollectionName);
        if (totalReplicasPerShard > 1) {
            log.info("Adding replicas to restored collection={}", (Object)restoreCollection);
            for (Object slice : restoreCollection.getSlices()) {
                int createdNrtReplicas = 0;
                int createdTlogReplicas = 0;
                int createdPullReplicas = 0;
                if (numNrtReplicas > 0) {
                    ++createdNrtReplicas;
                } else if (createdTlogReplicas > 0) {
                    ++createdTlogReplicas;
                }
                for (int i = 1; i < totalReplicasPerShard; ++i) {
                    Replica.Type typeToCreate;
                    if (createdNrtReplicas < numNrtReplicas) {
                        ++createdNrtReplicas;
                        typeToCreate = Replica.Type.NRT;
                    } else if (createdTlogReplicas < numTlogReplicas) {
                        ++createdTlogReplicas;
                        typeToCreate = Replica.Type.TLOG;
                    } else {
                        typeToCreate = Replica.Type.PULL;
                        assert (++createdPullReplicas <= numPullReplicas) : "Unexpected number of replicas";
                    }
                    log.debug("Adding replica for shard={} collection={} of type {} ", new Object[]{slice.getName(), restoreCollection, typeToCreate});
                    HashMap<String, Object> propMap5 = new HashMap<String, Object>();
                    propMap5.put("collection", restoreCollectionName);
                    propMap5.put("shard", slice.getName());
                    propMap5.put("type", typeToCreate.name());
                    for (ReplicaPosition replicaPosition : replicaPositions) {
                        if (!Objects.equals(replicaPosition.shard, slice.getName())) continue;
                        String node = replicaPosition.node;
                        propMap5.put("node", node);
                        replicaPositions.remove(replicaPosition);
                        break;
                    }
                    if (asyncId != null) {
                        propMap5.put("async", asyncId);
                    }
                    this.ocmh.addPropertyParams(message, propMap5);
                    this.ocmh.addReplica(zkStateReader.getClusterState(), new ZkNodeProps(propMap5), results, null);
                }
            }
        }
        log.info("Completed restoring collection={} backupName={}", (Object)restoreCollection, (Object)backupName);
    }

    private int getInt(ZkNodeProps message, String propertyName, Integer default1, int default2) {
        Integer value = message.getInt("replicationFactor", default1);
        return value != null ? value : default2;
    }
}

