/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import org.apache.lucene.index.IndexCommit;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.ReplicationHandler;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.UpdateLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicateFromLeader {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private CoreContainer cc;
    private String coreName;
    private ReplicationHandler replicationProcess;
    private long lastVersion = 0L;

    public ReplicateFromLeader(CoreContainer cc, String coreName) {
        this.cc = cc;
        this.coreName = coreName;
    }

    public void startReplication(boolean switchTransactionLog) throws InterruptedException {
        try (SolrCore core = this.cc.getCore(this.coreName);){
            if (core == null) {
                if (this.cc.isShutDown()) {
                    return;
                }
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "SolrCore not found:" + this.coreName + " in " + this.cc.getLoadedCoreNames());
            }
            SolrConfig.UpdateHandlerInfo uinfo = core.getSolrConfig().getUpdateHandlerInfo();
            String pollIntervalStr = "00:00:03";
            if (uinfo.autoCommmitMaxTime != -1) {
                pollIntervalStr = ReplicateFromLeader.toPollIntervalStr(uinfo.autoCommmitMaxTime / 2);
            } else if (uinfo.autoSoftCommmitMaxTime != -1) {
                pollIntervalStr = ReplicateFromLeader.toPollIntervalStr(uinfo.autoSoftCommmitMaxTime / 2);
            }
            LOG.info("Will start replication from leader with poll interval: {}", (Object)pollIntervalStr);
            NamedList slaveConfig = new NamedList();
            slaveConfig.add("fetchFromLeader", (Object)Boolean.TRUE);
            slaveConfig.add("pollInterval", (Object)pollIntervalStr);
            NamedList replicationConfig = new NamedList();
            replicationConfig.add("slave", (Object)slaveConfig);
            String lastCommitVersion = ReplicateFromLeader.getCommitVersion(core);
            if (lastCommitVersion != null) {
                this.lastVersion = Long.parseLong(lastCommitVersion);
            }
            this.replicationProcess = new ReplicationHandler();
            if (switchTransactionLog) {
                this.replicationProcess.setPollListener((solrCore, pollSuccess) -> {
                    if (pollSuccess) {
                        String commitVersion = ReplicateFromLeader.getCommitVersion(core);
                        if (commitVersion == null) {
                            return;
                        }
                        if (Long.parseLong(commitVersion) == this.lastVersion) {
                            return;
                        }
                        UpdateLog updateLog = solrCore.getUpdateHandler().getUpdateLog();
                        LocalSolrQueryRequest req = new LocalSolrQueryRequest(core, (SolrParams)new ModifiableSolrParams());
                        CommitUpdateCommand cuc = new CommitUpdateCommand(req, false);
                        cuc.setVersion(Long.parseLong(commitVersion));
                        updateLog.copyOverOldUpdates(cuc);
                        this.lastVersion = Long.parseLong(commitVersion);
                    }
                });
            }
            this.replicationProcess.init(replicationConfig);
            this.replicationProcess.inform(core);
        }
    }

    public static String getCommitVersion(SolrCore solrCore) {
        IndexCommit commit = solrCore.getDeletionPolicy().getLatestCommit();
        try {
            String commitVersion = (String)commit.getUserData().get("commitCommandVer");
            if (commitVersion == null) {
                return null;
            }
            return commitVersion;
        }
        catch (Exception e) {
            LOG.warn("Cannot get commit command version from index commit point ", (Throwable)e);
            return null;
        }
    }

    private static String toPollIntervalStr(int ms) {
        int sec = ms / 1000;
        int hour = sec / 3600;
        int min = (sec %= 3600) / 60;
        return hour + ":" + min + ":" + (sec %= 60);
    }

    public void stopReplication() {
        if (this.replicationProcess != null) {
            this.replicationProcess.close();
        }
    }
}

