/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.solr.cloud.DeleteNodeCmd;
import org.apache.solr.cloud.OverseerCollectionMessageHandler;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.CollectionStateWatcher;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.NamedList;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplaceNodeCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OverseerCollectionMessageHandler ocmh;

    public ReplaceNodeCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
    }

    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList results) throws Exception {
        ZkStateReader zkStateReader = this.ocmh.zkStateReader;
        String source = message.getStr("sourceNode", message.getStr("source"));
        String target = message.getStr("targetNode", message.getStr("target"));
        if (source == null || target == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "sourceNode and targetNode are required params");
        }
        String async = message.getStr("async");
        int timeout = message.getInt("timeout", Integer.valueOf(600));
        boolean parallel = message.getBool("parallel", false);
        ClusterState clusterState = zkStateReader.getClusterState();
        if (!clusterState.liveNodesContain(source)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Source Node: " + source + " is not live");
        }
        if (!clusterState.liveNodesContain(target)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Target Node: " + target + " is not live");
        }
        List<ZkNodeProps> sourceReplicas = ReplaceNodeCmd.getReplicasOfNode(source, clusterState);
        int numLeaders = 0;
        for (ZkNodeProps props : sourceReplicas) {
            if (!props.getBool("leader", false)) continue;
            ++numLeaders;
        }
        HashMap<String, RecoveryWatcher> watchers = new HashMap<String, RecoveryWatcher>();
        ArrayList<ZkNodeProps> createdReplicas = new ArrayList<ZkNodeProps>();
        AtomicBoolean anyOneFailed = new AtomicBoolean(false);
        CountDownLatch countDownLatch = new CountDownLatch(sourceReplicas.size());
        CountDownLatch replicasToRecover = new CountDownLatch(numLeaders);
        for (ZkNodeProps sourceReplica : sourceReplicas) {
            ZkNodeProps addedReplica;
            NamedList nl = new NamedList();
            log.info("Going to create replica for collection={} shard={} on node={}", new Object[]{sourceReplica.getStr("collection"), sourceReplica.getStr("shard"), target});
            ZkNodeProps msg = sourceReplica.plus("parallel", (Object)String.valueOf(parallel)).plus("node", (Object)target);
            if (async != null) {
                msg.getProperties().put("async", async);
            }
            if ((addedReplica = this.ocmh.addReplica(clusterState, msg, nl, () -> {
                countDownLatch.countDown();
                if (nl.get("failure") != null) {
                    String errorString = String.format(Locale.ROOT, "Failed to create replica for collection=%s shard=%s on node=%s", sourceReplica.getStr("collection"), sourceReplica.getStr("shard"), target);
                    log.warn(errorString);
                    NamedList namedList = results;
                    synchronized (namedList) {
                        results.add("failure", (Object)errorString);
                        anyOneFailed.set(true);
                    }
                } else {
                    log.debug("Successfully created replica for collection={} shard={} on node={}", new Object[]{sourceReplica.getStr("collection"), sourceReplica.getStr("shard"), target});
                }
            })) == null) continue;
            createdReplicas.add(addedReplica);
            if (!sourceReplica.getBool("leader", false)) continue;
            String shardName = sourceReplica.getStr("shard");
            String replicaName = sourceReplica.getStr("replica");
            String collectionName = sourceReplica.getStr("collection");
            String key = collectionName + "_" + replicaName;
            RecoveryWatcher watcher = new RecoveryWatcher(collectionName, shardName, replicaName, addedReplica.getStr("core"), replicasToRecover);
            watchers.put(key, watcher);
            zkStateReader.registerCollectionStateWatcher(collectionName, (CollectionStateWatcher)watcher);
        }
        log.debug("Waiting for replicas to be added");
        if (!countDownLatch.await(timeout, TimeUnit.SECONDS)) {
            log.info("Timed out waiting for replicas to be added");
            anyOneFailed.set(true);
        } else {
            log.debug("Finished waiting for replicas to be added");
        }
        log.debug("Waiting for " + numLeaders + " leader replicas to recover");
        if (!replicasToRecover.await(timeout, TimeUnit.SECONDS)) {
            log.info("Timed out waiting for " + replicasToRecover.getCount() + " leader replicas to recover");
            anyOneFailed.set(true);
        } else {
            log.debug("Finished waiting for leader replicas to recover");
        }
        for (RecoveryWatcher watcher : watchers.values()) {
            zkStateReader.removeCollectionStateWatcher(watcher.collectionId, (CollectionStateWatcher)watcher);
        }
        if (anyOneFailed.get()) {
            log.info("Failed to create some replicas. Cleaning up all replicas on target node");
            CountDownLatch cleanupLatch = new CountDownLatch(createdReplicas.size());
            for (ZkNodeProps createdReplica : createdReplicas) {
                NamedList deleteResult = new NamedList();
                try {
                    this.ocmh.deleteReplica(zkStateReader.getClusterState(), createdReplica.plus("parallel", (Object)"true"), deleteResult, () -> {
                        cleanupLatch.countDown();
                        if (deleteResult.get("failure") != null) {
                            NamedList namedList = results;
                            synchronized (namedList) {
                                results.add("failure", (Object)("Could not cleanup, because of : " + deleteResult.get("failure")));
                            }
                        }
                    });
                }
                catch (KeeperException e) {
                    cleanupLatch.countDown();
                    log.warn("Error deleting replica ", (Throwable)e);
                }
                catch (Exception e) {
                    log.warn("Error deleting replica ", (Throwable)e);
                    cleanupLatch.countDown();
                    throw e;
                }
            }
            cleanupLatch.await(5L, TimeUnit.MINUTES);
            return;
        }
        DeleteNodeCmd.cleanupReplicas(results, state, sourceReplicas, this.ocmh, source, async);
        results.add("success", (Object)("REPLACENODE action completed successfully from  : " + source + " to : " + target));
    }

    static List<ZkNodeProps> getReplicasOfNode(String source, ClusterState state) {
        ArrayList<ZkNodeProps> sourceReplicas = new ArrayList<ZkNodeProps>();
        for (Map.Entry e : state.getCollectionsMap().entrySet()) {
            for (Slice slice : ((DocCollection)e.getValue()).getSlices()) {
                for (Replica replica : slice.getReplicas()) {
                    if (!source.equals(replica.getNodeName())) continue;
                    ZkNodeProps props = new ZkNodeProps(new String[]{"collection", (String)e.getKey(), "shard", slice.getName(), "core", replica.getCoreName(), "replica", replica.getName(), "type", replica.getType().name(), "leader", String.valueOf(replica.equals((Object)slice.getLeader())), "node", source});
                    sourceReplicas.add(props);
                }
            }
        }
        return sourceReplicas;
    }

    static class RecoveryWatcher
    implements CollectionStateWatcher {
        String collectionId;
        String shardId;
        String replicaId;
        String targetCore;
        CountDownLatch countDownLatch;
        Replica recovered;

        RecoveryWatcher(String collectionId, String shardId, String replicaId, String targetCore, CountDownLatch countDownLatch) {
            this.collectionId = collectionId;
            this.shardId = shardId;
            this.replicaId = replicaId;
            this.targetCore = targetCore;
            this.countDownLatch = countDownLatch;
        }

        public boolean onStateChanged(Set<String> liveNodes, DocCollection collectionState) {
            if (collectionState == null) {
                this.countDownLatch.countDown();
                return true;
            }
            Slice slice = collectionState.getSlice(this.shardId);
            if (slice == null) {
                this.countDownLatch.countDown();
                return true;
            }
            for (Replica replica : slice.getReplicas()) {
                if (replica.getName().equals(this.replicaId) || replica.getType().equals((Object)Replica.Type.PULL)) continue;
                String coreName = replica.getStr("core");
                if (this.targetCore != null && !this.targetCore.equals(coreName) || !replica.isActive(liveNodes)) continue;
                this.recovered = replica;
                this.countDownLatch.countDown();
                return true;
            }
            return false;
        }

        public Replica getRecoveredReplica() {
            return this.recovered;
        }
    }
}

