/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.ReplicationHandler;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.PeerSync;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.util.RefCounted;
import org.apache.solr.util.SolrPluginUtils;
import org.apache.solr.util.plugin.NamedListInitializedPlugin;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveryStrategy
implements Runnable,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private int waitForUpdatesWithStaleStatePauseMilliSeconds = Integer.getInteger("solr.cloud.wait-for-updates-with-stale-state-pause", 2500);
    private int maxRetries = 500;
    private int startingRecoveryDelayMilliSeconds = 5000;
    private volatile boolean close = false;
    private RecoveryListener recoveryListener;
    private ZkController zkController;
    private String baseUrl;
    private String coreZkNodeName;
    private ZkStateReader zkStateReader;
    private volatile String coreName;
    private int retries;
    private boolean recoveringAfterStartup;
    private CoreContainer cc;
    private volatile HttpUriRequest prevSendPreRecoveryHttpUriRequest;
    private final Replica.Type replicaType;
    public static Runnable testing_beforeReplayBufferingUpdates;

    protected RecoveryStrategy(CoreContainer cc, CoreDescriptor cd, RecoveryListener recoveryListener) {
        this.cc = cc;
        this.coreName = cd.getName();
        this.recoveryListener = recoveryListener;
        this.zkController = cc.getZkController();
        this.zkStateReader = this.zkController.getZkStateReader();
        this.baseUrl = this.zkController.getBaseUrl();
        this.coreZkNodeName = cd.getCloudDescriptor().getCoreNodeName();
        this.replicaType = cd.getCloudDescriptor().getReplicaType();
    }

    public final int getWaitForUpdatesWithStaleStatePauseMilliSeconds() {
        return this.waitForUpdatesWithStaleStatePauseMilliSeconds;
    }

    public final void setWaitForUpdatesWithStaleStatePauseMilliSeconds(int waitForUpdatesWithStaleStatePauseMilliSeconds) {
        this.waitForUpdatesWithStaleStatePauseMilliSeconds = waitForUpdatesWithStaleStatePauseMilliSeconds;
    }

    public final int getMaxRetries() {
        return this.maxRetries;
    }

    public final void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public final int getStartingRecoveryDelayMilliSeconds() {
        return this.startingRecoveryDelayMilliSeconds;
    }

    public final void setStartingRecoveryDelayMilliSeconds(int startingRecoveryDelayMilliSeconds) {
        this.startingRecoveryDelayMilliSeconds = startingRecoveryDelayMilliSeconds;
    }

    public final boolean getRecoveringAfterStartup() {
        return this.recoveringAfterStartup;
    }

    public final void setRecoveringAfterStartup(boolean recoveringAfterStartup) {
        this.recoveringAfterStartup = recoveringAfterStartup;
    }

    @Override
    public final void close() {
        this.close = true;
        if (this.prevSendPreRecoveryHttpUriRequest != null) {
            this.prevSendPreRecoveryHttpUriRequest.abort();
        }
        LOG.warn("Stopping recovery for core=[{}] coreNodeName=[{}]", (Object)this.coreName, (Object)this.coreZkNodeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void recoveryFailed(SolrCore core, ZkController zkController, String baseUrl, String shardZkNodeName, CoreDescriptor cd) throws KeeperException, InterruptedException {
        SolrException.log((Logger)LOG, (String)"Recovery failed - I give up.");
        try {
            zkController.publish(cd, Replica.State.RECOVERY_FAILED);
        }
        finally {
            this.close();
            this.recoveryListener.failed();
        }
    }

    protected String getReplicateLeaderUrl(ZkNodeProps leaderprops) {
        return new ZkCoreNodeProps(leaderprops).getCoreUrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void replicate(String nodeName, SolrCore core, ZkNodeProps leaderprops) throws SolrServerException, IOException {
        String leaderUrl = this.getReplicateLeaderUrl(leaderprops);
        LOG.info("Attempting to replicate from [{}].", (Object)leaderUrl);
        this.commitOnLeader(leaderUrl);
        SolrRequestHandler handler = core.getRequestHandler("/replication");
        ReplicationHandler replicationHandler = (ReplicationHandler)handler;
        if (replicationHandler == null) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Skipping recovery, no /replication handler found");
        }
        ModifiableSolrParams solrParams = new ModifiableSolrParams();
        solrParams.set("masterUrl", new String[]{leaderUrl});
        if (this.isClosed()) {
            return;
        }
        boolean success = replicationHandler.doFetch((SolrParams)solrParams, false).getSuccessful();
        if (!success) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Replication for recovery failed.");
        }
        if (LOG.isDebugEnabled()) {
            try {
                RefCounted<SolrIndexSearcher> searchHolder = core.getNewestSearcher(false);
                SolrIndexSearcher searcher = searchHolder.get();
                Directory dir = core.getDirectoryFactory().get(core.getIndexDir(), DirectoryFactory.DirContext.META_DATA, null);
                try {
                    LOG.debug(core.getCoreContainer().getZkController().getNodeName() + " replicated " + searcher.count((Query)new MatchAllDocsQuery()) + " from " + leaderUrl + " gen:" + (core.getDeletionPolicy().getLatestCommit() != null ? "null" : Long.valueOf(core.getDeletionPolicy().getLatestCommit().getGeneration())) + " data:" + core.getDataDir() + " index:" + core.getIndexDir() + " newIndex:" + core.getNewIndexDir() + " files:" + Arrays.asList(dir.listAll()));
                }
                finally {
                    core.getDirectoryFactory().release(dir);
                    searchHolder.decref();
                }
            }
            catch (Exception e) {
                LOG.debug("Error in solrcloud_debug block", (Throwable)e);
            }
        }
    }

    private final void commitOnLeader(String leaderUrl) throws SolrServerException, IOException {
        try (HttpSolrClient client = ((HttpSolrClient.Builder)new HttpSolrClient.Builder(leaderUrl).withConnectionTimeout(30000)).build();){
            UpdateRequest ureq = new UpdateRequest();
            ureq.setParams(new ModifiableSolrParams());
            ureq.getParams().set("commit_end_point", true);
            ureq.getParams().set("openSearcher", false);
            ureq.setAction(AbstractUpdateRequest.ACTION.COMMIT, false, true).process((SolrClient)client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        try (SolrCore core = this.cc.getCore(this.coreName);){
            if (core == null) {
                SolrException.log((Logger)LOG, (String)("SolrCore not found - cannot recover:" + this.coreName));
                return;
            }
            MDCLoggingContext.setCore(core);
            LOG.info("Starting recovery process. recoveringAfterStartup=" + this.recoveringAfterStartup);
            try {
                this.doRecovery(core);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                SolrException.log((Logger)LOG, (String)"", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
        }
        finally {
            MDCLoggingContext.clear();
        }
    }

    public final void doRecovery(SolrCore core) throws KeeperException, InterruptedException {
        if (core.getCoreDescriptor().getCloudDescriptor().requiresTransactionLog()) {
            this.doSyncOrReplicateRecovery(core);
        } else {
            this.doReplicateOnlyRecovery(core);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doReplicateOnlyRecovery(SolrCore core) throws InterruptedException {
        boolean successfulRecovery = false;
        block29: while (!(successfulRecovery || Thread.currentThread().isInterrupted() || this.isClosed())) {
            try {
                block40: {
                    CloudDescriptor cloudDesc = core.getCoreDescriptor().getCloudDescriptor();
                    Replica leaderprops = this.zkStateReader.getLeaderRetry(cloudDesc.getCollectionName(), cloudDesc.getShardId());
                    String leaderBaseUrl = leaderprops.getStr("base_url");
                    String leaderCoreName = leaderprops.getStr("core");
                    String leaderUrl = ZkCoreNodeProps.getCoreUrl((String)leaderBaseUrl, (String)leaderCoreName);
                    String ourUrl = ZkCoreNodeProps.getCoreUrl((String)this.baseUrl, (String)this.coreName);
                    boolean isLeader = leaderUrl.equals(ourUrl);
                    if (isLeader && !cloudDesc.isLeader()) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Cloud state still says we are leader.");
                    }
                    if (cloudDesc.isLeader()) {
                        assert (cloudDesc.getReplicaType() != Replica.Type.PULL);
                        LOG.warn("We have not yet recovered - but we are now the leader!");
                        LOG.info("Finished recovery process.");
                        this.zkController.publish(core.getCoreDescriptor(), Replica.State.ACTIVE);
                        return;
                    }
                    LOG.info("Publishing state of core [{}] as recovering, leader is [{}] and I am [{}]", new Object[]{core.getName(), leaderUrl, ourUrl});
                    this.zkController.publish(core.getCoreDescriptor(), Replica.State.RECOVERING);
                    if (this.isClosed()) {
                        LOG.info("Recovery for core {} has been closed", (Object)core.getName());
                        break;
                    }
                    LOG.info("Starting Replication Recovery.");
                    LOG.info("Stopping background replicate from leader process");
                    this.zkController.stopReplicationFromLeader(this.coreName);
                    this.replicate(this.zkController.getNodeName(), core, (ZkNodeProps)leaderprops);
                    if (!this.isClosed()) break block40;
                    LOG.info("Recovery for core {} has been closed", (Object)core.getName());
                    break;
                }
                try {
                    LOG.info("Replication Recovery was successful.");
                    successfulRecovery = true;
                }
                catch (Exception e) {
                    SolrException.log((Logger)LOG, (String)"Error while trying to recover", (Throwable)e);
                }
            }
            catch (Exception e) {
                SolrException.log((Logger)LOG, (String)("Error while trying to recover. core=" + this.coreName), (Throwable)e);
            }
            finally {
                if (successfulRecovery) {
                    LOG.info("Restaring background replicate from leader process");
                    this.zkController.startReplicationFromLeader(this.coreName, false);
                    LOG.info("Registering as Active after recovery.");
                    try {
                        this.zkController.publish(core.getCoreDescriptor(), Replica.State.ACTIVE);
                    }
                    catch (Exception e) {
                        LOG.error("Could not publish as ACTIVE after succesful recovery", (Throwable)e);
                        successfulRecovery = false;
                    }
                    if (successfulRecovery) {
                        this.close = true;
                        this.recoveryListener.recovered();
                    }
                }
            }
            if (successfulRecovery) continue;
            try {
                if (this.isClosed()) {
                    LOG.info("Recovery for core {} has been closed", (Object)core.getName());
                    break;
                }
                LOG.error("Recovery failed - trying again... (" + this.retries + ")");
                ++this.retries;
                if (this.retries >= this.maxRetries) {
                    SolrException.log((Logger)LOG, (String)("Recovery failed - max retries exceeded (" + this.retries + ")."));
                    try {
                        this.recoveryFailed(core, this.zkController, this.baseUrl, this.coreZkNodeName, core.getCoreDescriptor());
                    }
                    catch (Exception e) {
                        SolrException.log((Logger)LOG, (String)"Could not publish that recovery failed", (Throwable)e);
                    }
                    break;
                }
            }
            catch (Exception e) {
                SolrException.log((Logger)LOG, (String)"An error has occurred during recovery", (Throwable)e);
            }
            try {
                double loopCount = this.retries < 4 ? Math.min(Math.pow(2.0, this.retries), 12.0) : 12.0;
                LOG.info("Wait [{}] seconds before trying to recover again (attempt={})", (Object)loopCount, (Object)this.retries);
                int i = 0;
                while ((double)i < loopCount) {
                    if (this.isClosed()) {
                        LOG.info("Recovery for core {} has been closed", (Object)core.getName());
                        continue block29;
                    }
                    Thread.sleep(this.startingRecoveryDelayMilliSeconds);
                    ++i;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.warn("Recovery was interrupted.", (Throwable)e);
                this.close = true;
            }
        }
        LOG.info("Finished recovery process, successful=[{}]", (Object)Boolean.toString(successfulRecovery));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public final void doSyncOrReplicateRecovery(SolrCore core) throws KeeperException, InterruptedException {
        replayed = false;
        successfulRecovery = false;
        ulog = core.getUpdateHandler().getUpdateLog();
        if (ulog == null) {
            SolrException.log((Logger)RecoveryStrategy.LOG, (String)"No UpdateLog found - cannot recover.");
            this.recoveryFailed(core, this.zkController, this.baseUrl, this.coreZkNodeName, core.getCoreDescriptor());
            return;
        }
        firstTime = this.replicaType != Replica.Type.TLOG;
        try {
            recentUpdates = ulog.getRecentUpdates();
            var8_8 = null;
            try {
                recentVersions = recentUpdates.getVersions(ulog.getNumRecordsToKeep());
            }
            catch (Throwable var9_15) {
                var8_8 = var9_15;
                throw var9_15;
            }
            finally {
                if (recentUpdates != null) {
                    if (var8_8 != null) {
                        try {
                            recentUpdates.close();
                        }
                        catch (Throwable var9_14) {
                            var8_8.addSuppressed(var9_14);
                        }
                    } else {
                        recentUpdates.close();
                    }
                }
            }
        }
        catch (Exception e) {
            SolrException.log((Logger)RecoveryStrategy.LOG, (String)"Corrupt tlog - ignoring.", (Throwable)e);
            recentVersions = new ArrayList<Long>(0);
        }
        startingVersions = ulog.getStartingVersions();
        if (startingVersions != null && this.recoveringAfterStartup) {
            try {
                v0 = firstStartingVersion = startingVersions.size() > 0 ? startingVersions.get(0) : 0L;
                for (oldIdx = 0; oldIdx < recentVersions.size() && recentVersions.get(oldIdx) != firstStartingVersion; ++oldIdx) {
                }
                if (oldIdx > 0) {
                    RecoveryStrategy.LOG.info("####### Found new versions added after startup: num=[{}]", (Object)oldIdx);
                    RecoveryStrategy.LOG.info("###### currentVersions=[{}]", recentVersions);
                }
                RecoveryStrategy.LOG.info("###### startupVersions=[{}]", startingVersions);
            }
            catch (Exception e) {
                SolrException.log((Logger)RecoveryStrategy.LOG, (String)"Error getting recent versions.", (Throwable)e);
                recentVersions = new ArrayList<Long>(0);
            }
        }
        if (this.recoveringAfterStartup) {
            recentVersions = startingVersions;
            try {
                if ((ulog.getStartingOperation() & 16) != 0) {
                    RecoveryStrategy.LOG.info("Looks like a previous replication recovery did not complete - skipping peer sync.");
                    firstTime = false;
                }
            }
            catch (Exception e) {
                SolrException.log((Logger)RecoveryStrategy.LOG, (String)"Error trying to get ulog starting operation.", (Throwable)e);
                firstTime = false;
            }
        }
        if (this.replicaType == Replica.Type.TLOG) {
            this.zkController.stopReplicationFromLeader(this.coreName);
        }
        replayFuture = null;
        block62: while (!(successfulRecovery || Thread.currentThread().isInterrupted() || this.isClosed())) {
            block106: {
                block107: {
                    block104: {
                        block105: {
                            block102: {
                                block103: {
                                    block100: {
                                        block101: {
                                            block98: {
                                                block99: {
                                                    block96: {
                                                        block97: {
                                                            block94: {
                                                                block95: {
                                                                    cloudDesc = core.getCoreDescriptor().getCloudDescriptor();
                                                                    leaderprops = this.zkStateReader.getLeaderRetry(cloudDesc.getCollectionName(), cloudDesc.getShardId());
                                                                    leaderBaseUrl = leaderprops.getStr("base_url");
                                                                    leaderCoreName = leaderprops.getStr("core");
                                                                    leaderUrl = ZkCoreNodeProps.getCoreUrl((String)leaderBaseUrl, (String)leaderCoreName);
                                                                    ourUrl = ZkCoreNodeProps.getCoreUrl((String)this.baseUrl, (String)this.coreName);
                                                                    isLeader = leaderUrl.equals(ourUrl);
                                                                    if (isLeader && !cloudDesc.isLeader()) {
                                                                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Cloud state still says we are leader.");
                                                                    }
                                                                    if (!cloudDesc.isLeader()) break block94;
                                                                    RecoveryStrategy.LOG.warn("We have not yet recovered - but we are now the leader!");
                                                                    RecoveryStrategy.LOG.info("Finished recovery process.");
                                                                    this.zkController.publish(core.getCoreDescriptor(), Replica.State.ACTIVE);
                                                                    if (replayed) break block95;
                                                                    RecoveryStrategy.LOG.info("Replay not started, or was not successful... still buffering updates.");
                                                                }
                                                                if (successfulRecovery) {
                                                                    RecoveryStrategy.LOG.info("Registering as Active after recovery.");
                                                                    try {
                                                                        if (this.replicaType == Replica.Type.TLOG) {
                                                                            this.zkController.startReplicationFromLeader(this.coreName, true);
                                                                        }
                                                                        this.zkController.publish(core.getCoreDescriptor(), Replica.State.ACTIVE);
                                                                    }
                                                                    catch (Exception e) {
                                                                        RecoveryStrategy.LOG.error("Could not publish as ACTIVE after succesful recovery", (Throwable)e);
                                                                        successfulRecovery = false;
                                                                    }
                                                                    if (successfulRecovery) {
                                                                        this.close = true;
                                                                        this.recoveryListener.recovered();
                                                                    }
                                                                }
                                                                return;
                                                            }
                                                            RecoveryStrategy.LOG.info("Begin buffering updates. core=[{}]", (Object)this.coreName);
                                                            ulog.bufferUpdates();
                                                            replayed = false;
                                                            RecoveryStrategy.LOG.info("Publishing state of core [{}] as recovering, leader is [{}] and I am [{}]", new Object[]{core.getName(), leaderUrl, ourUrl});
                                                            this.zkController.publish(core.getCoreDescriptor(), Replica.State.RECOVERING);
                                                            slice = this.zkStateReader.getClusterState().getCollection(cloudDesc.getCollectionName()).getSlice(cloudDesc.getShardId());
                                                            try {
                                                                this.prevSendPreRecoveryHttpUriRequest.abort();
                                                            }
                                                            catch (NullPointerException var17_37) {
                                                                // empty catch block
                                                            }
                                                            if (!this.isClosed()) break block96;
                                                            RecoveryStrategy.LOG.info("RecoveryStrategy has been closed");
                                                            if (replayed) break block97;
                                                            RecoveryStrategy.LOG.info("Replay not started, or was not successful... still buffering updates.");
                                                        }
                                                        if (!successfulRecovery) break;
                                                        RecoveryStrategy.LOG.info("Registering as Active after recovery.");
                                                        try {
                                                            if (this.replicaType == Replica.Type.TLOG) {
                                                                this.zkController.startReplicationFromLeader(this.coreName, true);
                                                            }
                                                            this.zkController.publish(core.getCoreDescriptor(), Replica.State.ACTIVE);
                                                        }
                                                        catch (Exception e) {
                                                            RecoveryStrategy.LOG.error("Could not publish as ACTIVE after succesful recovery", (Throwable)e);
                                                            successfulRecovery = false;
                                                        }
                                                        if (!successfulRecovery) break;
                                                        this.close = true;
                                                        this.recoveryListener.recovered();
                                                        break;
                                                    }
                                                    this.sendPrepRecoveryCmd(leaderBaseUrl, leaderCoreName, slice);
                                                    if (!this.isClosed()) break block98;
                                                    RecoveryStrategy.LOG.info("RecoveryStrategy has been closed");
                                                    if (replayed) break block99;
                                                    RecoveryStrategy.LOG.info("Replay not started, or was not successful... still buffering updates.");
                                                }
                                                if (!successfulRecovery) break;
                                                RecoveryStrategy.LOG.info("Registering as Active after recovery.");
                                                try {
                                                    if (this.replicaType == Replica.Type.TLOG) {
                                                        this.zkController.startReplicationFromLeader(this.coreName, true);
                                                    }
                                                    this.zkController.publish(core.getCoreDescriptor(), Replica.State.ACTIVE);
                                                }
                                                catch (Exception e) {
                                                    RecoveryStrategy.LOG.error("Could not publish as ACTIVE after succesful recovery", (Throwable)e);
                                                    successfulRecovery = false;
                                                }
                                                if (!successfulRecovery) break;
                                                this.close = true;
                                                this.recoveryListener.recovered();
                                                break;
                                            }
                                            try {
                                                Thread.sleep(this.waitForUpdatesWithStaleStatePauseMilliSeconds);
                                            }
                                            catch (InterruptedException e) {
                                                Thread.currentThread().interrupt();
                                            }
                                            if (!firstTime) ** GOTO lbl189
                                            firstTime = false;
                                            RecoveryStrategy.LOG.info("Attempting to PeerSync from [{}] - recoveringAfterStartup=[{}]", (Object)leaderUrl, (Object)this.recoveringAfterStartup);
                                            peerSync = new PeerSync(core, Collections.singletonList(leaderUrl), ulog.getNumRecordsToKeep(), false, false);
                                            peerSync.setStartingVersions(recentVersions);
                                            syncSuccess = peerSync.sync().isSuccess();
                                            if (!syncSuccess) break block100;
                                            req = new LocalSolrQueryRequest(core, (SolrParams)new ModifiableSolrParams());
                                            core.getUpdateHandler().commit(new CommitUpdateCommand(req, false));
                                            RecoveryStrategy.LOG.info("PeerSync stage of recovery was successful.");
                                            this.cloudDebugLog(core, "synced");
                                            RecoveryStrategy.LOG.info("Replaying updates buffered during PeerSync.");
                                            this.replay(core);
                                            replayed = true;
                                            successfulRecovery = true;
                                            if (replayed) break block101;
                                            RecoveryStrategy.LOG.info("Replay not started, or was not successful... still buffering updates.");
                                        }
                                        if (successfulRecovery) {
                                            RecoveryStrategy.LOG.info("Registering as Active after recovery.");
                                            try {
                                                if (this.replicaType == Replica.Type.TLOG) {
                                                    this.zkController.startReplicationFromLeader(this.coreName, true);
                                                }
                                                this.zkController.publish(core.getCoreDescriptor(), Replica.State.ACTIVE);
                                            }
                                            catch (Exception e) {
                                                RecoveryStrategy.LOG.error("Could not publish as ACTIVE after succesful recovery", (Throwable)e);
                                                successfulRecovery = false;
                                            }
                                            if (successfulRecovery) {
                                                this.close = true;
                                                this.recoveryListener.recovered();
                                            }
                                        }
                                        return;
                                    }
                                    RecoveryStrategy.LOG.info("PeerSync Recovery was not successful - trying replication.");
lbl189:
                                    // 2 sources

                                    if (!this.isClosed()) break block102;
                                    RecoveryStrategy.LOG.info("RecoveryStrategy has been closed");
                                    if (replayed) break block103;
                                    RecoveryStrategy.LOG.info("Replay not started, or was not successful... still buffering updates.");
                                }
                                if (!successfulRecovery) break;
                                RecoveryStrategy.LOG.info("Registering as Active after recovery.");
                                try {
                                    if (this.replicaType == Replica.Type.TLOG) {
                                        this.zkController.startReplicationFromLeader(this.coreName, true);
                                    }
                                    this.zkController.publish(core.getCoreDescriptor(), Replica.State.ACTIVE);
                                }
                                catch (Exception e) {
                                    RecoveryStrategy.LOG.error("Could not publish as ACTIVE after succesful recovery", (Throwable)e);
                                    successfulRecovery = false;
                                }
                                if (!successfulRecovery) break;
                                this.close = true;
                                this.recoveryListener.recovered();
                                break;
                            }
                            RecoveryStrategy.LOG.info("Starting Replication Recovery.");
                            this.replicate(this.zkController.getNodeName(), core, (ZkNodeProps)leaderprops);
                            if (!this.isClosed()) break block104;
                            RecoveryStrategy.LOG.info("RecoveryStrategy has been closed");
                            if (replayed) break block105;
                            RecoveryStrategy.LOG.info("Replay not started, or was not successful... still buffering updates.");
                        }
                        if (!successfulRecovery) break;
                        RecoveryStrategy.LOG.info("Registering as Active after recovery.");
                        try {
                            if (this.replicaType == Replica.Type.TLOG) {
                                this.zkController.startReplicationFromLeader(this.coreName, true);
                            }
                            this.zkController.publish(core.getCoreDescriptor(), Replica.State.ACTIVE);
                        }
                        catch (Exception e) {
                            RecoveryStrategy.LOG.error("Could not publish as ACTIVE after succesful recovery", (Throwable)e);
                            successfulRecovery = false;
                        }
                        if (!successfulRecovery) break;
                        this.close = true;
                        this.recoveryListener.recovered();
                        break;
                    }
                    replayFuture = this.replay(core);
                    replayed = true;
                    if (!this.isClosed()) break block106;
                    RecoveryStrategy.LOG.info("RecoveryStrategy has been closed");
                    if (replayed) break block107;
                    RecoveryStrategy.LOG.info("Replay not started, or was not successful... still buffering updates.");
                }
                if (!successfulRecovery) break;
                RecoveryStrategy.LOG.info("Registering as Active after recovery.");
                try {
                    if (this.replicaType == Replica.Type.TLOG) {
                        this.zkController.startReplicationFromLeader(this.coreName, true);
                    }
                    this.zkController.publish(core.getCoreDescriptor(), Replica.State.ACTIVE);
                }
                catch (Exception e) {
                    RecoveryStrategy.LOG.error("Could not publish as ACTIVE after succesful recovery", (Throwable)e);
                    successfulRecovery = false;
                }
                if (!successfulRecovery) break;
                this.close = true;
                this.recoveryListener.recovered();
                break;
            }
            try {
                RecoveryStrategy.LOG.info("Replication Recovery was successful.");
                successfulRecovery = true;
                {
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        RecoveryStrategy.LOG.warn("Recovery was interrupted", (Throwable)e);
                        this.close = true;
                    }
                    catch (Exception e) {
                        SolrException.log((Logger)RecoveryStrategy.LOG, (String)"Error while trying to recover", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                SolrException.log((Logger)RecoveryStrategy.LOG, (String)("Error while trying to recover. core=" + this.coreName), (Throwable)e);
            }
            catch (Throwable var21_49) {
                throw var21_49;
            }
            finally {
                if (!replayed) {
                    RecoveryStrategy.LOG.info("Replay not started, or was not successful... still buffering updates.");
                }
                if (successfulRecovery) {
                    RecoveryStrategy.LOG.info("Registering as Active after recovery.");
                    try {
                        if (this.replicaType == Replica.Type.TLOG) {
                            this.zkController.startReplicationFromLeader(this.coreName, true);
                        }
                        this.zkController.publish(core.getCoreDescriptor(), Replica.State.ACTIVE);
                    }
                    catch (Exception e) {
                        RecoveryStrategy.LOG.error("Could not publish as ACTIVE after succesful recovery", (Throwable)e);
                        successfulRecovery = false;
                    }
                    if (successfulRecovery) {
                        this.close = true;
                        this.recoveryListener.recovered();
                    }
                }
            }
            if (successfulRecovery) continue;
            try {
                if (this.isClosed()) {
                    RecoveryStrategy.LOG.info("RecoveryStrategy has been closed");
                    break;
                }
                RecoveryStrategy.LOG.error("Recovery failed - trying again... (" + this.retries + ")");
                ++this.retries;
                if (this.retries >= this.maxRetries) {
                    SolrException.log((Logger)RecoveryStrategy.LOG, (String)("Recovery failed - max retries exceeded (" + this.retries + ")."));
                    try {
                        this.recoveryFailed(core, this.zkController, this.baseUrl, this.coreZkNodeName, core.getCoreDescriptor());
                    }
                    catch (Exception e) {
                        SolrException.log((Logger)RecoveryStrategy.LOG, (String)"Could not publish that recovery failed", (Throwable)e);
                    }
                    break;
                }
            }
            catch (Exception e) {
                SolrException.log((Logger)RecoveryStrategy.LOG, (String)"An error has occurred during recovery", (Throwable)e);
            }
            try {
                loopCount = this.retries < 4 ? Math.min(Math.pow(2.0, this.retries), 12.0) : 12.0;
                RecoveryStrategy.LOG.info("Wait [{}] seconds before trying to recover again (attempt={})", (Object)loopCount, (Object)this.retries);
                i = 0;
                while ((double)i < loopCount) {
                    if (this.isClosed()) {
                        RecoveryStrategy.LOG.info("RecoveryStrategy has been closed");
                        continue block62;
                    }
                    Thread.sleep(this.startingRecoveryDelayMilliSeconds);
                    ++i;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                RecoveryStrategy.LOG.warn("Recovery was interrupted.", (Throwable)e);
                this.close = true;
            }
        }
        if (successfulRecovery && replayFuture == null) {
            RecoveryStrategy.LOG.info("Updating version bucket highest from index after successful recovery.");
            core.seedVersionBuckets();
        }
        RecoveryStrategy.LOG.info("Finished recovery process, successful=[{}]", (Object)Boolean.toString(successfulRecovery));
    }

    private final Future<UpdateLog.RecoveryInfo> replay(SolrCore core) throws InterruptedException, ExecutionException {
        if (testing_beforeReplayBufferingUpdates != null) {
            testing_beforeReplayBufferingUpdates.run();
        }
        if (this.replicaType == Replica.Type.TLOG) {
            LocalSolrQueryRequest req = new LocalSolrQueryRequest(core, (SolrParams)new ModifiableSolrParams());
            core.getUpdateHandler().getUpdateLog().copyOverBufferingUpdates(new CommitUpdateCommand(req, false));
            return null;
        }
        Future<UpdateLog.RecoveryInfo> future = core.getUpdateHandler().getUpdateLog().applyBufferedUpdates();
        if (future == null) {
            LOG.info("No replay needed.");
        } else {
            LOG.info("Replaying buffered documents.");
            UpdateLog.RecoveryInfo report = future.get();
            if (report.failed) {
                SolrException.log((Logger)LOG, (String)"Replay failed");
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Replay failed");
            }
        }
        this.cloudDebugLog(core, "replayed");
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cloudDebugLog(SolrCore core, String op) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        try {
            RefCounted<SolrIndexSearcher> searchHolder = core.getNewestSearcher(false);
            SolrIndexSearcher searcher = searchHolder.get();
            try {
                int totalHits = searcher.count((Query)new MatchAllDocsQuery());
                String nodeName = core.getCoreContainer().getZkController().getNodeName();
                LOG.debug("[{}] {} [{} total hits]", new Object[]{nodeName, op, totalHits});
            }
            finally {
                searchHolder.decref();
            }
        }
        catch (Exception e) {
            LOG.debug("Error in solrcloud_debug block", (Throwable)e);
        }
    }

    public final boolean isClosed() {
        return this.close;
    }

    private final void sendPrepRecoveryCmd(String leaderBaseUrl, String leaderCoreName, Slice slice) throws SolrServerException, IOException, InterruptedException, ExecutionException {
        CoreAdminRequest.WaitForState prepCmd = new CoreAdminRequest.WaitForState();
        prepCmd.setCoreName(leaderCoreName);
        prepCmd.setNodeName(this.zkController.getNodeName());
        prepCmd.setCoreNodeName(this.coreZkNodeName);
        prepCmd.setState(Replica.State.RECOVERING);
        prepCmd.setCheckLive(Boolean.valueOf(true));
        prepCmd.setOnlyIfLeader(true);
        Slice.State state = slice.getState();
        if (state != Slice.State.CONSTRUCTION && state != Slice.State.RECOVERY && state != Slice.State.RECOVERY_FAILED) {
            prepCmd.setOnlyIfLeaderActive(true);
        }
        int conflictWaitMs = this.zkController.getLeaderConflictResolveWait();
        int readTimeout = conflictWaitMs + 8000;
        try (HttpSolrClient client = new HttpSolrClient.Builder(leaderBaseUrl).build();){
            client.setConnectionTimeout(10000);
            client.setSoTimeout(readTimeout);
            HttpSolrClient.HttpUriRequestResponse mrr = client.httpUriRequest((SolrRequest)prepCmd);
            this.prevSendPreRecoveryHttpUriRequest = mrr.httpUriRequest;
            LOG.info("Sending prep recovery command to [{}]; [{}]", (Object)leaderBaseUrl, (Object)prepCmd.toString());
            mrr.future.get();
        }
    }

    public static interface RecoveryListener {
        public void recovered();

        public void failed();
    }

    public static class Builder
    implements NamedListInitializedPlugin {
        private NamedList args;

        @Override
        public void init(NamedList args) {
            this.args = args;
        }

        public RecoveryStrategy create(CoreContainer cc, CoreDescriptor cd, RecoveryListener recoveryListener) {
            RecoveryStrategy recoveryStrategy = this.newRecoveryStrategy(cc, cd, recoveryListener);
            SolrPluginUtils.invokeSetters(recoveryStrategy, (Iterable<Map.Entry<String, Object>>)this.args);
            return recoveryStrategy;
        }

        protected RecoveryStrategy newRecoveryStrategy(CoreContainer cc, CoreDescriptor cd, RecoveryListener recoveryListener) {
            return new RecoveryStrategy(cc, cd, recoveryListener);
        }
    }
}

